/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.toml;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CommonUtil {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String SCHEMA_FILE_NAME = "c2c-schema-tooling.json";

    public static CodeAction createQuickFixCodeAction(String commandTitle, List<TextEdit> edits, String uri) {
        CodeAction action = new CodeAction(commandTitle);
        action.setKind("quickfix");
        action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits)))));
        action.setDiagnostics(new ArrayList());
        return action;
    }

    public static Optional<Path> getPathFromURI(String uri) {
        try {
            return Optional.of(Paths.get(new URL(uri).toURI()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return Optional.empty();
        }
    }
}

