/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.toml;

import io.ballerina.c2c.tooling.toml.Probe;
import io.ballerina.c2c.tooling.toml.ProbeStore;
import io.ballerina.c2c.tooling.toml.ProbeValue;
import io.ballerina.c2c.tooling.toml.TomlSyntaxTreeUtil;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Optional;

public class TomlProbesVisitor
extends NodeVisitor {
    private ProbeStore store = new ProbeStore();

    @Override
    public void visit(TableNode tableNode) {
        if (TomlSyntaxTreeUtil.toDottedString(tableNode.identifier().value()).equals("cloud.deployment.probes.liveness")) {
            Probe livenessProbe = this.extractProbeInfo(tableNode);
            this.store.setLiveness(livenessProbe);
        }
        if (TomlSyntaxTreeUtil.toDottedString(tableNode.identifier().value()).equals("cloud.deployment.probes.readiness")) {
            Probe readinessProbe = this.extractProbeInfo(tableNode);
            this.store.setReadiness(readinessProbe);
        }
    }

    private Probe extractProbeInfo(TableNode tableNode) {
        Probe probe = new Probe();
        for (KeyValueNode keyValueNode : tableNode.fields()) {
            ValueNode value;
            String key = TomlSyntaxTreeUtil.toDottedString(keyValueNode.identifier().value());
            if (key.equals("port") && (value = keyValueNode.value()).kind() == SyntaxKind.DEC_INT) {
                NumericLiteralNode numericLiteralNode = (NumericLiteralNode)value;
                String port = numericLiteralNode.value().text();
                probe.setPort(new ProbeValue<Integer>(Integer.parseInt(port), numericLiteralNode.value()));
            }
            if (!key.equals("path") || (value = keyValueNode.value()).kind() != SyntaxKind.STRING_LITERAL) continue;
            StringLiteralNode stringLiteralNode = (StringLiteralNode)value;
            Optional<Token> content = stringLiteralNode.content();
            String path = "";
            if (!content.isPresent()) continue;
            path = content.get().text();
            probe.setPath(new ProbeValue<String>(path, content.get()));
        }
        return probe;
    }

    public ProbeStore getStore() {
        return this.store;
    }
}

