/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.diagnostics.DiagnosticWarningCode;
import io.ballerina.compiler.internal.parser.AbstractParser;
import io.ballerina.compiler.internal.parser.AbstractParserErrorHandler;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.BallerinaParserErrorHandler;
import io.ballerina.compiler.internal.parser.DocumentationLexer;
import io.ballerina.compiler.internal.parser.DocumentationParser;
import io.ballerina.compiler.internal.parser.OperatorPrecedence;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.RegExpLexer;
import io.ballerina.compiler.internal.parser.RegExpParser;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.TokenReader;
import io.ballerina.compiler.internal.parser.TypePrecedence;
import io.ballerina.compiler.internal.parser.XMLLexer;
import io.ballerina.compiler.internal.parser.XMLParser;
import io.ballerina.compiler.internal.parser.tree.STAbstractNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STAmbiguousCollectionNode;
import io.ballerina.compiler.internal.parser.tree.STAnnotAccessExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STArrayTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STAsyncSendActionNode;
import io.ballerina.compiler.internal.parser.tree.STBinaryExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STBracedExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STConditionalExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STDefaultableParameterNode;
import io.ballerina.compiler.internal.parser.tree.STErrorConstructorExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STFieldAccessExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionCallExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionSignatureNode;
import io.ballerina.compiler.internal.parser.tree.STFunctionTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STIndexedExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STIntersectionTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STListConstructorExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STMappingConstructorExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STMetadataNode;
import io.ballerina.compiler.internal.parser.tree.STMissingToken;
import io.ballerina.compiler.internal.parser.tree.STNamedArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STNilLiteralNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.parser.tree.STObjectTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STOptionalFieldAccessExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STOptionalTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.tree.STPositionalArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STQualifiedNameReferenceNode;
import io.ballerina.compiler.internal.parser.tree.STRemoteMethodCallActionNode;
import io.ballerina.compiler.internal.parser.tree.STRequiredParameterNode;
import io.ballerina.compiler.internal.parser.tree.STRestArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STRestBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STRestParameterNode;
import io.ballerina.compiler.internal.parser.tree.STSimpleNameReferenceNode;
import io.ballerina.compiler.internal.parser.tree.STSpecificFieldNode;
import io.ballerina.compiler.internal.parser.tree.STSyncSendActionNode;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.parser.tree.STTypeReferenceTypeDescNode;
import io.ballerina.compiler.internal.parser.tree.STTypeTestExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STTypedBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STUnaryExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STUnionTypeDescriptorNode;
import io.ballerina.compiler.internal.parser.utils.ConditionalExprResolver;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BallerinaParser
extends AbstractParser {
    private static final OperatorPrecedence DEFAULT_OP_PRECEDENCE = OperatorPrecedence.DEFAULT;

    protected BallerinaParser(AbstractTokenReader tokenReader) {
        super(tokenReader, new BallerinaParserErrorHandler(tokenReader));
    }

    @Override
    public STNode parse() {
        return this.parseCompUnit();
    }

    public STNode parseAsStatement() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.FUNC_DEF);
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        STNode stmt = this.parseStatement();
        if (stmt == null || this.validateStatement(stmt)) {
            stmt = this.createMissingSimpleVarDecl(false);
            stmt = this.invalidateRestAndAddToTrailingMinutiae(stmt);
            return stmt;
        }
        if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
            this.addInvalidNodeToNextToken(stmt, DiagnosticErrorCode.ERROR_NAMED_WORKER_NOT_ALLOWED_HERE, new Object[0]);
            stmt = this.createMissingSimpleVarDecl(false);
            stmt = this.invalidateRestAndAddToTrailingMinutiae(stmt);
            return stmt;
        }
        stmt = this.invalidateRestAndAddToTrailingMinutiae(stmt);
        return stmt;
    }

    public STNode parseAsBlockStatement() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.FUNC_DEF);
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        this.startContext(ParserRuleContext.WHILE_BLOCK);
        STNode blockStmtNode = this.parseBlockNode();
        blockStmtNode = this.invalidateRestAndAddToTrailingMinutiae(blockStmtNode);
        return blockStmtNode;
    }

    public STNode parseAsStatements() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        STNode stmtsNode = this.parseStatements();
        STNodeList stmtNodeList = (STNodeList)stmtsNode;
        ArrayList<STNode> stmts = new ArrayList<STNode>(stmtNodeList.size() + 1);
        for (int i = 0; i < stmtNodeList.size() - 1; ++i) {
            stmts.add(stmtNodeList.get(i));
        }
        STNode lastStmt = stmtNodeList.isEmpty() ? this.createMissingSimpleVarDecl(false) : stmtNodeList.get(stmtNodeList.size() - 1);
        lastStmt = this.invalidateRestAndAddToTrailingMinutiae(lastStmt);
        stmts.add(lastStmt);
        return STNodeFactory.createNodeList(stmts);
    }

    public STNode parseAsExpression() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        STNode expr = this.parseExpression();
        expr = this.invalidateRestAndAddToTrailingMinutiae(expr);
        return expr;
    }

    public STNode parseAsActionOrExpression() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.FUNC_DEF);
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        STNode actionOrExpr = this.parseActionOrExpression();
        actionOrExpr = this.invalidateRestAndAddToTrailingMinutiae(actionOrExpr);
        return actionOrExpr;
    }

    public STNode parseAsModuleMemberDeclaration() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        STNode topLevelNode = this.parseTopLevelNode();
        if (topLevelNode == null) {
            topLevelNode = this.createMissingSimpleVarDecl(true);
        }
        if (topLevelNode.kind == SyntaxKind.IMPORT_DECLARATION) {
            STNode temp = topLevelNode;
            topLevelNode = this.createMissingSimpleVarDecl(true);
            topLevelNode = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(topLevelNode, temp);
        }
        topLevelNode = this.invalidateRestAndAddToTrailingMinutiae(topLevelNode);
        return topLevelNode;
    }

    public STNode parseAsImportDeclaration() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        STNode importDecl = this.parseImportDecl();
        importDecl = this.invalidateRestAndAddToTrailingMinutiae(importDecl);
        return importDecl;
    }

    public STNode parseAsTypeDescriptor() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.MODULE_TYPE_DEFINITION);
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_DEF);
        typeDesc = this.invalidateRestAndAddToTrailingMinutiae(typeDesc);
        return typeDesc;
    }

    public STNode parseAsBindingPattern() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        STNode bindingPattern = this.parseBindingPattern();
        bindingPattern = this.invalidateRestAndAddToTrailingMinutiae(bindingPattern);
        return bindingPattern;
    }

    public STNode parseAsFunctionBodyBlock() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.FUNC_DEF);
        STNode funcBodyBlock = this.parseFunctionBodyBlock(false);
        funcBodyBlock = this.invalidateRestAndAddToTrailingMinutiae(funcBodyBlock);
        return funcBodyBlock;
    }

    public STNode parseAsObjectMember() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.SERVICE_DECL);
        this.startContext(ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER);
        STNode objectMember = this.parseObjectMember(ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER);
        if (objectMember == null) {
            objectMember = this.createMissingSimpleObjectField();
        }
        objectMember = this.invalidateRestAndAddToTrailingMinutiae(objectMember);
        return objectMember;
    }

    public STNode parseAsIntermediateClause(boolean allowActions) {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.FUNC_DEF);
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        this.startContext(ParserRuleContext.QUERY_EXPRESSION);
        STNode intermediateClause = null;
        if (!this.isEndOfIntermediateClause(this.peek().kind)) {
            intermediateClause = this.parseIntermediateClause(true, allowActions);
        }
        if (intermediateClause == null) {
            intermediateClause = this.createMissingWhereClause();
        }
        if (intermediateClause.kind == SyntaxKind.SELECT_CLAUSE) {
            STNode temp = intermediateClause;
            intermediateClause = this.createMissingWhereClause();
            intermediateClause = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(intermediateClause, temp);
        }
        intermediateClause = this.invalidateRestAndAddToTrailingMinutiae(intermediateClause);
        return intermediateClause;
    }

    public STNode parseAsLetVarDeclaration(boolean allowActions) {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        this.switchContext(ParserRuleContext.QUERY_EXPRESSION);
        this.switchContext(ParserRuleContext.LET_CLAUSE_LET_VAR_DECL);
        STNode letVarDeclaration = this.parseLetVarDecl(ParserRuleContext.LET_CLAUSE_LET_VAR_DECL, true, allowActions);
        letVarDeclaration = this.invalidateRestAndAddToTrailingMinutiae(letVarDeclaration);
        return letVarDeclaration;
    }

    public STNode parseAsAnnotation() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        this.startContext(ParserRuleContext.ANNOTATIONS);
        STNode annotation = this.parseAnnotation();
        annotation = this.invalidateRestAndAddToTrailingMinutiae(annotation);
        return annotation;
    }

    public STNode parseAsMarkdownDocumentation() {
        this.startContext(ParserRuleContext.COMP_UNIT);
        STNode markdownDoc = this.parseMarkdownDocumentation();
        if (markdownDoc.toSourceCode().isEmpty()) {
            STToken missingHash = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.HASH_TOKEN, DiagnosticWarningCode.WARNING_MISSING_HASH_TOKEN);
            STNode docLine = STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, missingHash, STNodeFactory.createEmptyNodeList());
            markdownDoc = STNodeFactory.createMarkdownDocumentationNode(STNodeFactory.createNodeList(docLine));
        }
        markdownDoc = this.invalidateRestAndAddToTrailingMinutiae(markdownDoc);
        return markdownDoc;
    }

    public STNode parse(ParserRuleContext context) {
        switch (context) {
            case COMP_UNIT: {
                return this.parseCompUnit();
            }
            case TOP_LEVEL_NODE: {
                this.startContext(ParserRuleContext.COMP_UNIT);
                return this.parseTopLevelNode();
            }
            case STATEMENT: {
                this.startContext(ParserRuleContext.COMP_UNIT);
                this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
                return this.parseStatement();
            }
            case EXPRESSION: {
                this.startContext(ParserRuleContext.COMP_UNIT);
                this.startContext(ParserRuleContext.VAR_DECL_STMT);
                return this.parseExpression();
            }
        }
        throw new UnsupportedOperationException("Cannot start parsing from: " + String.valueOf((Object)context));
    }

    private STNode parseCompUnit() {
        STNode decl;
        this.startContext(ParserRuleContext.COMP_UNIT);
        ArrayList<STNode> otherDecls = new ArrayList<STNode>();
        ArrayList<STNode> importDecls = new ArrayList<STNode>();
        boolean processImports = true;
        STToken token = this.peek();
        while (token.kind != SyntaxKind.EOF_TOKEN && (decl = this.parseTopLevelNode()) != null) {
            if (decl.kind == SyntaxKind.IMPORT_DECLARATION) {
                if (processImports) {
                    importDecls.add(decl);
                } else {
                    this.updateLastNodeInListWithInvalidNode(otherDecls, decl, DiagnosticErrorCode.ERROR_IMPORT_DECLARATION_AFTER_OTHER_DECLARATIONS, new Object[0]);
                }
            } else {
                if (processImports) {
                    processImports = false;
                }
                otherDecls.add(decl);
            }
            token = this.peek();
        }
        STToken eof = this.consume();
        this.endContext();
        return STNodeFactory.createModulePartNode(STNodeFactory.createNodeList(importDecls), STNodeFactory.createNodeList(otherDecls), eof);
    }

    protected STNode parseTopLevelNode() {
        STNode metadata;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                return null;
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                STNode metadata2 = this.parseMetaData();
                return this.parseTopLevelNode(metadata2);
            }
            case IMPORT_KEYWORD: 
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case XMLNS_KEYWORD: 
            case ENUM_KEYWORD: 
            case CLASS_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case READONLY_KEYWORD: 
            case CONFIGURABLE_KEYWORD: 
            case SERVICE_KEYWORD: {
                metadata = STNodeFactory.createEmptyNode();
                break;
            }
            case RESOURCE_KEYWORD: 
            case REMOTE_KEYWORD: {
                this.reportInvalidQualifier(this.consume());
                return this.parseTopLevelNode();
            }
            case IDENTIFIER_TOKEN: {
                if (this.isModuleVarDeclStart(1) || nextToken.isMissing()) {
                    return this.parseModuleVarDecl(STNodeFactory.createEmptyNode());
                }
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) {
                    metadata = STNodeFactory.createEmptyNode();
                    break;
                }
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.TOP_LEVEL_NODE);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    metadata = STNodeFactory.createEmptyNode();
                    break;
                }
                return this.parseTopLevelNode();
            }
        }
        return this.parseTopLevelNode(metadata);
    }

    private STNode parseTopLevelNode(STNode metadata) {
        STToken nextToken = this.peek();
        STNode publicQualifier = null;
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                if (metadata != null) {
                    metadata = this.addMetadataNotAttachedDiagnostic((STMetadataNode)metadata);
                    return this.createMissingSimpleVarDecl(metadata, true);
                }
                return null;
            }
            case PUBLIC_KEYWORD: {
                publicQualifier = this.consume();
                break;
            }
            case IMPORT_KEYWORD: 
            case FINAL_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case XMLNS_KEYWORD: 
            case ENUM_KEYWORD: 
            case CLASS_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case READONLY_KEYWORD: 
            case CONFIGURABLE_KEYWORD: 
            case SERVICE_KEYWORD: {
                break;
            }
            case RESOURCE_KEYWORD: 
            case REMOTE_KEYWORD: {
                this.reportInvalidQualifier(this.consume());
                return this.parseTopLevelNode(metadata);
            }
            case IDENTIFIER_TOKEN: {
                if (this.isModuleVarDeclStart(1)) {
                    return this.parseModuleVarDecl(metadata);
                }
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) break;
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.TOP_LEVEL_NODE_WITHOUT_METADATA);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    publicQualifier = STNodeFactory.createEmptyNode();
                    break;
                }
                return this.parseTopLevelNode(metadata);
            }
        }
        return this.parseTopLevelNode(metadata, publicQualifier);
    }

    private STNode addMetadataNotAttachedDiagnostic(STMetadataNode metadata) {
        STNode docString = metadata.documentationString;
        if (docString != null) {
            docString = SyntaxErrors.addDiagnostic(docString, DiagnosticErrorCode.ERROR_DOCUMENTATION_NOT_ATTACHED_TO_A_CONSTRUCT, new Object[0]);
        }
        STNodeList annotList = (STNodeList)metadata.annotations;
        STNode annotations = this.addAnnotNotAttachedDiagnostic(annotList);
        return STNodeFactory.createMetadataNode(docString, annotations);
    }

    private STNode addAnnotNotAttachedDiagnostic(STNodeList annotList) {
        STNode annotations = SyntaxErrors.updateAllNodesInNodeListWithDiagnostic(annotList, DiagnosticErrorCode.ERROR_ANNOTATION_NOT_ATTACHED_TO_A_CONSTRUCT);
        return annotations;
    }

    private boolean isModuleVarDeclStart(int lookahead) {
        STToken nextToken = this.peek(lookahead + 1);
        return switch (nextToken.kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.EQUAL_TOKEN, SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.QUESTION_MARK_TOKEN, SyntaxKind.PIPE_TOKEN, SyntaxKind.BITWISE_AND_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.ERROR_KEYWORD -> true;
            case SyntaxKind.IDENTIFIER_TOKEN -> {
                switch (this.peek((int)(lookahead + 2)).kind) {
                    case EOF_TOKEN: 
                    case EQUAL_TOKEN: 
                    case SEMICOLON_TOKEN: {
                        yield true;
                    }
                }
                yield false;
            }
            case SyntaxKind.COLON_TOKEN -> {
                if (lookahead > 1) {
                    yield false;
                }
                switch (this.peek((int)(lookahead + 2)).kind) {
                    case IDENTIFIER_TOKEN: {
                        yield this.isModuleVarDeclStart(lookahead + 2);
                    }
                    case EOF_TOKEN: {
                        yield true;
                    }
                }
                yield false;
            }
            default -> false;
        };
    }

    private STNode parseImportDecl() {
        this.startContext(ParserRuleContext.IMPORT_DECL);
        this.tokenReader.startMode(ParserMode.IMPORT);
        STNode importKeyword = this.parseImportKeyword();
        STNode identifier = this.parseIdentifier(ParserRuleContext.IMPORT_ORG_OR_MODULE_NAME);
        STNode importDecl = this.parseImportDecl(importKeyword, identifier);
        this.tokenReader.endMode();
        this.endContext();
        return importDecl;
    }

    private STNode parseImportKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IMPORT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IMPORT_KEYWORD);
        return this.parseImportKeyword();
    }

    private STNode parseIdentifier(ParserRuleContext currentCtx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        if (token.kind == SyntaxKind.MAP_KEYWORD) {
            STToken mapKeyword = this.consume();
            return STNodeFactory.createIdentifierToken(mapKeyword.text(), mapKeyword.leadingMinutiae(), mapKeyword.trailingMinutiae(), mapKeyword.diagnostics());
        }
        this.recover(token, currentCtx);
        return this.parseIdentifier(currentCtx);
    }

    private STNode parseImportDecl(STNode importKeyword, STNode identifier) {
        STNode alias;
        STNode moduleName;
        STNode orgName;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SLASH_TOKEN: {
                STNode slash = this.parseSlashToken();
                orgName = STNodeFactory.createImportOrgNameNode(identifier, slash);
                moduleName = this.parseModuleName();
                alias = this.parseImportPrefixDecl();
                break;
            }
            case DOT_TOKEN: 
            case AS_KEYWORD: {
                orgName = STNodeFactory.createEmptyNode();
                moduleName = this.parseModuleName(identifier);
                alias = this.parseImportPrefixDecl();
                break;
            }
            case SEMICOLON_TOKEN: {
                orgName = STNodeFactory.createEmptyNode();
                moduleName = this.parseModuleName(identifier);
                alias = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.IMPORT_DECL_ORG_OR_MODULE_NAME_RHS);
                return this.parseImportDecl(importKeyword, identifier);
            }
        }
        STNode semicolon = this.parseSemicolon();
        return STNodeFactory.createImportDeclarationNode(importKeyword, orgName, moduleName, alias, semicolon);
    }

    private STNode parseSlashToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SLASH_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SLASH);
        return this.parseSlashToken();
    }

    private STNode parseDotToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DOT_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.DOT);
        return this.parseDotToken();
    }

    private STNode parseModuleName() {
        STNode moduleNameStart = this.parseIdentifier(ParserRuleContext.IMPORT_MODULE_NAME);
        return this.parseModuleName(moduleNameStart);
    }

    private STNode parseModuleName(STNode moduleNameStart) {
        STNode moduleNameSeparator;
        ArrayList<STNode> moduleNameParts = new ArrayList<STNode>();
        moduleNameParts.add(moduleNameStart);
        STToken nextToken = this.peek();
        while (!this.isEndOfImportDecl(nextToken) && (moduleNameSeparator = this.parseModuleNameRhs()) != null) {
            moduleNameParts.add(moduleNameSeparator);
            moduleNameParts.add(this.parseIdentifier(ParserRuleContext.IMPORT_MODULE_NAME));
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(moduleNameParts);
    }

    private STNode parseModuleNameRhs() {
        return switch (this.peek().kind) {
            case SyntaxKind.DOT_TOKEN -> this.consume();
            case SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.AS_KEYWORD -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.AFTER_IMPORT_MODULE_NAME);
                yield this.parseModuleNameRhs();
            }
        };
    }

    private boolean isEndOfImportDecl(STToken nextToken) {
        return switch (nextToken.kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.IMPORT_KEYWORD, SyntaxKind.FINAL_KEYWORD, SyntaxKind.PUBLIC_KEYWORD, SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.TYPE_KEYWORD, SyntaxKind.CONST_KEYWORD, SyntaxKind.TRANSACTIONAL_KEYWORD, SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.SERVICE_KEYWORD, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.ABSTRACT_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseDecimalIntLiteral(ParserRuleContext context) {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), context);
        return this.parseDecimalIntLiteral(context);
    }

    private STNode parseImportPrefixDecl() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case AS_KEYWORD: {
                STNode asKeyword = this.parseAsKeyword();
                STNode prefix = this.parseImportPrefix();
                return STNodeFactory.createImportPrefixNode(asKeyword, prefix);
            }
            case SEMICOLON_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
        }
        if (this.isEndOfImportDecl(nextToken)) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(this.peek(), ParserRuleContext.IMPORT_PREFIX_DECL);
        return this.parseImportPrefixDecl();
    }

    private STNode parseAsKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.AS_KEYWORD) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.AS_KEYWORD);
        return this.parseAsKeyword();
    }

    private STNode parseImportPrefix() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STToken identifier = this.consume();
            if (this.isUnderscoreToken(identifier)) {
                return this.getUnderscoreKeyword(identifier);
            }
            return identifier;
        }
        if (BallerinaParser.isPredeclaredPrefix(nextToken.kind)) {
            STToken preDeclaredPrefix = this.consume();
            return STNodeFactory.createIdentifierToken(preDeclaredPrefix.text(), preDeclaredPrefix.leadingMinutiae(), preDeclaredPrefix.trailingMinutiae());
        }
        this.recover(this.peek(), ParserRuleContext.IMPORT_PREFIX);
        return this.parseImportPrefix();
    }

    private STNode parseTopLevelNode(STNode metadata, STNode publicQualifier) {
        ArrayList<STNode> topLevelQualifiers = new ArrayList<STNode>();
        return this.parseTopLevelNode(metadata, publicQualifier, topLevelQualifiers);
    }

    private STNode parseTopLevelNode(STNode metadata, STNode publicQualifier, List<STNode> qualifiers) {
        this.parseTopLevelQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                return this.createMissingSimpleVarDecl(metadata, publicQualifier, qualifiers, true);
            }
            case FUNCTION_KEYWORD: {
                return this.parseFuncDefOrFuncTypeDesc(metadata, publicQualifier, qualifiers, false, false);
            }
            case TYPE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseModuleTypeDefinition(metadata, publicQualifier);
            }
            case CLASS_KEYWORD: {
                return this.parseClassDefinition(metadata, publicQualifier, qualifiers);
            }
            case LISTENER_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseListenerDeclaration(metadata, publicQualifier);
            }
            case CONST_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseConstantDeclaration(metadata, publicQualifier);
            }
            case ANNOTATION_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STNode constKeyword = STNodeFactory.createEmptyNode();
                return this.parseAnnotationDeclaration(metadata, publicQualifier, constKeyword);
            }
            case IMPORT_KEYWORD: {
                this.reportInvalidMetaData(metadata, "import declaration");
                this.reportInvalidQualifier(publicQualifier);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseImportDecl();
            }
            case XMLNS_KEYWORD: {
                this.reportInvalidMetaData(metadata, "XML namespace declaration");
                this.reportInvalidQualifier(publicQualifier);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseXMLNamespaceDeclaration(true);
            }
            case ENUM_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseEnumDeclaration(metadata, publicQualifier);
            }
            case RESOURCE_KEYWORD: 
            case REMOTE_KEYWORD: {
                this.reportInvalidQualifier(this.consume());
                return this.parseTopLevelNode(metadata, publicQualifier, qualifiers);
            }
            case IDENTIFIER_TOKEN: {
                if (!this.isModuleVarDeclStart(1)) break;
                return this.parseModuleVarDecl(metadata, publicQualifier, qualifiers);
            }
        }
        if (this.isPossibleServiceDecl(qualifiers)) {
            return this.parseServiceDeclOrVarDecl(metadata, publicQualifier, qualifiers);
        }
        if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) {
            return this.parseModuleVarDecl(metadata, publicQualifier, qualifiers);
        }
        STToken token = this.peek();
        AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.TOP_LEVEL_NODE_WITHOUT_MODIFIER);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            return this.parseModuleVarDecl(metadata, publicQualifier, qualifiers);
        }
        return this.parseTopLevelNode(metadata, publicQualifier, qualifiers);
    }

    private STNode parseModuleVarDecl(STNode metadata) {
        ArrayList<STNode> emptyList = new ArrayList<STNode>();
        STNode publicQualifier = STNodeFactory.createEmptyNode();
        return this.parseVariableDecl(metadata, publicQualifier, emptyList, emptyList, true);
    }

    private STNode parseModuleVarDecl(STNode metadata, STNode publicQualifier, List<STNode> topLevelQualifiers) {
        List<STNode> varDeclQuals = this.extractVarDeclQualifiers(topLevelQualifiers, true);
        return this.parseVariableDecl(metadata, publicQualifier, varDeclQuals, topLevelQualifiers, true);
    }

    private List<STNode> extractVarDeclQualifiers(List<STNode> qualifiers, boolean isModuleVar) {
        SyntaxKind qualifierKind;
        ArrayList<STNode> varDeclQualList = new ArrayList<STNode>();
        int initialListSize = qualifiers.size();
        int configurableQualIndex = -1;
        for (int i = 0; i < 2 && i < initialListSize && !this.isSyntaxKindInList(varDeclQualList, qualifierKind = qualifiers.get((int)0).kind) && this.isModuleVarDeclQualifier(qualifierKind); ++i) {
            varDeclQualList.add(qualifiers.remove(0));
            if (qualifierKind != SyntaxKind.CONFIGURABLE_KEYWORD) continue;
            configurableQualIndex = i;
        }
        if (isModuleVar && configurableQualIndex > -1) {
            STNode configurableQual = (STNode)varDeclQualList.get(configurableQualIndex);
            for (int i = 0; i < varDeclQualList.size(); ++i) {
                STNode invalidQual;
                if (i < configurableQualIndex) {
                    invalidQual = (STNode)varDeclQualList.get(i);
                    configurableQual = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(configurableQual, invalidQual, (DiagnosticCode)this.getInvalidQualifierError(invalidQual.kind), ((STToken)invalidQual).text());
                    continue;
                }
                if (i <= configurableQualIndex) continue;
                invalidQual = (STNode)varDeclQualList.get(i);
                configurableQual = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(configurableQual, invalidQual, (DiagnosticCode)this.getInvalidQualifierError(invalidQual.kind), ((STToken)invalidQual).text());
            }
            varDeclQualList = new ArrayList<STNode>(Collections.singletonList(configurableQual));
        }
        return varDeclQualList;
    }

    private DiagnosticErrorCode getInvalidQualifierError(SyntaxKind qualifierKind) {
        return qualifierKind == SyntaxKind.FINAL_KEYWORD ? DiagnosticErrorCode.ERROR_CONFIGURABLE_VAR_IMPLICITLY_FINAL : DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED;
    }

    boolean isModuleVarDeclQualifier(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.FINAL_KEYWORD, SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.CONFIGURABLE_KEYWORD -> true;
            default -> false;
        };
    }

    private void reportInvalidQualifier(STNode qualifier) {
        if (qualifier != null && qualifier.kind != SyntaxKind.NONE) {
            this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_INVALID_QUALIFIER, ((STToken)qualifier).text());
        }
    }

    private void reportInvalidMetaData(STNode metadata, String constructName) {
        if (metadata != null && metadata.kind != SyntaxKind.NONE) {
            this.addInvalidNodeToNextToken(metadata, DiagnosticErrorCode.ERROR_INVALID_METADATA, constructName);
        }
    }

    private void reportInvalidQualifierList(List<STNode> qualifiers) {
        for (STNode qual : qualifiers) {
            this.addInvalidNodeToNextToken(qual, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qual).text());
        }
    }

    private void reportInvalidStatementAnnots(STNode annots, List<STNode> qualifiers) {
        DiagnosticErrorCode diagnosticErrorCode = DiagnosticErrorCode.ERROR_ANNOTATIONS_ATTACHED_TO_STATEMENT;
        this.reportInvalidAnnotations(annots, qualifiers, diagnosticErrorCode);
    }

    private void reportInvalidExpressionAnnots(STNode annots, List<STNode> qualifiers) {
        DiagnosticErrorCode diagnosticErrorCode = DiagnosticErrorCode.ERROR_ANNOTATIONS_ATTACHED_TO_EXPRESSION;
        this.reportInvalidAnnotations(annots, qualifiers, diagnosticErrorCode);
    }

    private void reportInvalidAnnotations(STNode annots, List<STNode> qualifiers, DiagnosticErrorCode errorCode) {
        if (this.isNodeListEmpty(annots)) {
            return;
        }
        if (qualifiers.isEmpty()) {
            this.addInvalidNodeToNextToken(annots, errorCode, new Object[0]);
        } else {
            this.updateFirstNodeInListWithLeadingInvalidNode(qualifiers, annots, errorCode, new Object[0]);
        }
    }

    private boolean isTopLevelQualifier(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.FINAL_KEYWORD, SyntaxKind.CONFIGURABLE_KEYWORD -> true;
            case SyntaxKind.READONLY_KEYWORD -> {
                STToken nextNextToken = this.getNextNextToken();
                switch (nextNextToken.kind) {
                    case CLASS_KEYWORD: 
                    case ISOLATED_KEYWORD: 
                    case DISTINCT_KEYWORD: 
                    case CLIENT_KEYWORD: 
                    case SERVICE_KEYWORD: {
                        yield true;
                    }
                }
                yield false;
            }
            case SyntaxKind.DISTINCT_KEYWORD -> {
                STToken nextNextToken = this.getNextNextToken();
                switch (nextNextToken.kind) {
                    case CLASS_KEYWORD: 
                    case ISOLATED_KEYWORD: 
                    case CLIENT_KEYWORD: 
                    case READONLY_KEYWORD: 
                    case SERVICE_KEYWORD: {
                        yield true;
                    }
                }
                yield false;
            }
            default -> this.isTypeDescQualifier(tokenKind);
        };
    }

    private boolean isTypeDescQualifier(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.TRANSACTIONAL_KEYWORD, SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.CLIENT_KEYWORD, SyntaxKind.SERVICE_KEYWORD, SyntaxKind.ABSTRACT_KEYWORD -> true;
            default -> false;
        };
    }

    private boolean isObjectMemberQualifier(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.FINAL_KEYWORD, SyntaxKind.RESOURCE_KEYWORD, SyntaxKind.REMOTE_KEYWORD -> true;
            default -> this.isTypeDescQualifier(tokenKind);
        };
    }

    private boolean isExprQualifier(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.TRANSACTIONAL_KEYWORD -> {
                STToken nextNextToken = this.getNextNextToken();
                switch (nextNextToken.kind) {
                    case FUNCTION_KEYWORD: 
                    case ISOLATED_KEYWORD: 
                    case CLIENT_KEYWORD: 
                    case ABSTRACT_KEYWORD: 
                    case OBJECT_KEYWORD: {
                        yield true;
                    }
                }
                yield false;
            }
            default -> this.isTypeDescQualifier(tokenKind);
        };
    }

    private void parseTopLevelQualifiers(List<STNode> qualifiers) {
        while (this.isTopLevelQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private void parseTypeDescQualifiers(List<STNode> qualifiers) {
        while (this.isTypeDescQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private void parseObjectMemberQualifiers(List<STNode> qualifiers) {
        while (this.isObjectMemberQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private void parseExprQualifiers(List<STNode> qualifiers) {
        while (this.isExprQualifier(this.peek().kind)) {
            STToken qualifier = this.consume();
            qualifiers.add(qualifier);
        }
    }

    private STNode parseOptionalRelativePath(boolean isObjectMember) {
        STNode resourcePath;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case DOT_TOKEN: {
                resourcePath = this.parseRelativeResourcePath();
                break;
            }
            case OPEN_PAREN_TOKEN: {
                return STNodeFactory.createEmptyNodeList();
            }
            default: {
                this.recover(nextToken, ParserRuleContext.OPTIONAL_RELATIVE_PATH);
                return this.parseOptionalRelativePath(isObjectMember);
            }
        }
        if (!isObjectMember) {
            this.addInvalidNodeToNextToken(resourcePath, DiagnosticErrorCode.ERROR_RESOURCE_PATH_IN_FUNCTION_DEFINITION, new Object[0]);
            return STNodeFactory.createEmptyNodeList();
        }
        return resourcePath;
    }

    private STNode parseFuncDefOrFuncTypeDesc(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectMember, boolean isObjectTypeDesc) {
        this.startContext(ParserRuleContext.FUNC_DEF_OR_FUNC_TYPE);
        STNode functionKeyword = this.parseFunctionKeyword();
        STNode funcDefOrType = this.parseFunctionKeywordRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, isObjectMember, isObjectTypeDesc);
        return funcDefOrType;
    }

    private STNode parseFunctionDefinition(STNode metadata, STNode visibilityQualifier, STNode resourcePath, List<STNode> qualifiers, STNode functionKeyword, STNode name, boolean isObjectMember, boolean isObjectTypeDesc) {
        this.switchContext(ParserRuleContext.FUNC_DEF);
        STNode funcSignature = this.parseFuncSignature(false);
        STNode funcDef = this.parseFuncDefOrMethodDeclEnd(metadata, visibilityQualifier, qualifiers, functionKeyword, name, resourcePath, funcSignature, isObjectMember, isObjectTypeDesc);
        this.endContext();
        return funcDef;
    }

    private STNode parseFuncDefOrFuncTypeDescRhs(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, STNode functionKeyword, STNode name, boolean isObjectMember, boolean isObjectTypeDesc) {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case DOT_TOKEN: 
            case OPEN_PAREN_TOKEN: {
                STNode resourcePath = this.parseOptionalRelativePath(isObjectMember);
                return this.parseFunctionDefinition(metadata, visibilityQualifier, resourcePath, qualifiers, functionKeyword, name, isObjectMember, isObjectTypeDesc);
            }
            case EQUAL_TOKEN: 
            case SEMICOLON_TOKEN: {
                this.endContext();
                List<STNode> extractQualifiersList = this.extractVarDeclOrObjectFieldQualifiers(qualifiers, isObjectMember, isObjectTypeDesc);
                STNode typeDesc = this.createFunctionTypeDescriptor(qualifiers, functionKeyword, STNodeFactory.createEmptyNode(), false);
                if (isObjectMember) {
                    STNode objectFieldQualNodeList = STNodeFactory.createNodeList(extractQualifiersList);
                    return this.parseObjectFieldRhs(metadata, visibilityQualifier, objectFieldQualNodeList, typeDesc, name, isObjectTypeDesc);
                }
                this.startContext(ParserRuleContext.VAR_DECL_STMT);
                STNode funcTypeName = STNodeFactory.createSimpleNameReferenceNode(name);
                STNode bindingPattern = this.createCaptureOrWildcardBP(((STSimpleNameReferenceNode)funcTypeName).name);
                STNode typedBindingPattern = STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
                return this.parseVarDeclRhs(metadata, visibilityQualifier, extractQualifiersList, typedBindingPattern, true);
            }
        }
        STToken token = this.peek();
        this.recover(token, ParserRuleContext.FUNC_DEF_OR_TYPE_DESC_RHS);
        return this.parseFuncDefOrFuncTypeDescRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, name, isObjectMember, isObjectTypeDesc);
    }

    private STNode parseFunctionKeywordRhs(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, STNode functionKeyword, boolean isObjectMember, boolean isObjectTypeDesc) {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STToken name = this.consume();
                return this.parseFuncDefOrFuncTypeDescRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, name, isObjectMember, isObjectTypeDesc);
            }
            case OPEN_PAREN_TOKEN: {
                this.switchContext(ParserRuleContext.VAR_DECL_STMT);
                this.startContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
                this.startContext(ParserRuleContext.FUNC_TYPE_DESC);
                STNode funcSignature = this.parseFuncSignature(true);
                this.endContext();
                this.endContext();
                return this.parseFunctionTypeDescRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, funcSignature, isObjectMember, isObjectTypeDesc);
            }
        }
        STToken token = this.peek();
        if (this.isValidTypeContinuationToken(token) || this.isBindingPatternsStartToken(token.kind)) {
            return this.parseVarDeclWithFunctionType(metadata, visibilityQualifier, qualifiers, functionKeyword, STNodeFactory.createEmptyNode(), isObjectMember, isObjectTypeDesc, false);
        }
        this.recover(token, ParserRuleContext.FUNCTION_KEYWORD_RHS);
        return this.parseFunctionKeywordRhs(metadata, visibilityQualifier, qualifiers, functionKeyword, isObjectMember, isObjectTypeDesc);
    }

    private boolean isBindingPatternsStartToken(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.IDENTIFIER_TOKEN, SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.ERROR_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseFuncDefOrMethodDeclEnd(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode name, STNode resourcePath, STNode funcSignature, boolean isObjectMember, boolean isObjectTypeDesc) {
        if (!isObjectMember) {
            return this.createFunctionDefinition(metadata, visibilityQualifier, qualifierList, functionKeyword, name, funcSignature);
        }
        boolean hasResourcePath = !this.isNodeListEmpty(resourcePath);
        boolean hasResourceQual = this.isSyntaxKindInList(qualifierList, SyntaxKind.RESOURCE_KEYWORD);
        if (hasResourceQual && !hasResourcePath) {
            ArrayList<STNode> relativePath = new ArrayList<STNode>();
            relativePath.add(STNodeFactory.createMissingToken(SyntaxKind.DOT_TOKEN));
            resourcePath = STNodeFactory.createNodeList(relativePath);
            DiagnosticErrorCode errorCode = isObjectTypeDesc ? DiagnosticErrorCode.ERROR_MISSING_RESOURCE_PATH_IN_RESOURCE_ACCESSOR_DECLARATION : DiagnosticErrorCode.ERROR_MISSING_RESOURCE_PATH_IN_RESOURCE_ACCESSOR_DEFINITION;
            name = SyntaxErrors.addDiagnostic(name, errorCode, new Object[0]);
            hasResourcePath = true;
        }
        if (hasResourcePath) {
            return this.createResourceAccessorDefnOrDecl(metadata, visibilityQualifier, qualifierList, functionKeyword, name, resourcePath, funcSignature, isObjectTypeDesc);
        }
        if (isObjectTypeDesc) {
            return this.createMethodDeclaration(metadata, visibilityQualifier, qualifierList, functionKeyword, name, funcSignature);
        }
        return this.createMethodDefinition(metadata, visibilityQualifier, qualifierList, functionKeyword, name, funcSignature);
    }

    private STNode createFunctionDefinition(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode name, STNode funcSignature) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isRegularFuncQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, qualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        if (visibilityQualifier != null) {
            validatedList.add(0, visibilityQualifier);
        }
        STNode qualifiers = STNodeFactory.createNodeList(validatedList);
        STNode resourcePath = STNodeFactory.createEmptyNodeList();
        STNode body = this.parseFunctionBody();
        return STNodeFactory.createFunctionDefinitionNode(SyntaxKind.FUNCTION_DEFINITION, metadata, qualifiers, functionKeyword, name, resourcePath, funcSignature, body);
    }

    private STNode createMethodDefinition(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode name, STNode funcSignature) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        boolean hasRemoteQual = false;
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.REMOTE_KEYWORD) {
                hasRemoteQual = true;
                validatedList.add(qualifier);
                continue;
            }
            if (this.isRegularFuncQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, qualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        if (visibilityQualifier != null) {
            if (hasRemoteQual) {
                this.updateFirstNodeInListWithLeadingInvalidNode(validatedList, visibilityQualifier, DiagnosticErrorCode.ERROR_REMOTE_METHOD_HAS_A_VISIBILITY_QUALIFIER, new Object[0]);
            } else {
                validatedList.add(0, visibilityQualifier);
            }
        }
        STNode qualifiers = STNodeFactory.createNodeList(validatedList);
        STNode resourcePath = STNodeFactory.createEmptyNodeList();
        STNode body = this.parseFunctionBody();
        return STNodeFactory.createFunctionDefinitionNode(SyntaxKind.OBJECT_METHOD_DEFINITION, metadata, qualifiers, functionKeyword, name, resourcePath, funcSignature, body);
    }

    private STNode createMethodDeclaration(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode name, STNode funcSignature) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        boolean hasRemoteQual = false;
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.REMOTE_KEYWORD) {
                hasRemoteQual = true;
                validatedList.add(qualifier);
                continue;
            }
            if (this.isRegularFuncQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, qualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        if (visibilityQualifier != null) {
            if (hasRemoteQual) {
                this.updateFirstNodeInListWithLeadingInvalidNode(validatedList, visibilityQualifier, DiagnosticErrorCode.ERROR_REMOTE_METHOD_HAS_A_VISIBILITY_QUALIFIER, new Object[0]);
            } else {
                validatedList.add(0, visibilityQualifier);
            }
        }
        STNode qualifiers = STNodeFactory.createNodeList(validatedList);
        STNode resourcePath = STNodeFactory.createEmptyNodeList();
        STNode semicolon = this.parseSemicolon();
        return STNodeFactory.createMethodDeclarationNode(SyntaxKind.METHOD_DECLARATION, metadata, qualifiers, functionKeyword, name, resourcePath, funcSignature, semicolon);
    }

    private STNode createResourceAccessorDefnOrDecl(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode name, STNode resourcePath, STNode funcSignature, boolean isObjectTypeDesc) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        boolean hasResourceQual = false;
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.RESOURCE_KEYWORD) {
                hasResourceQual = true;
                validatedList.add(qualifier);
                continue;
            }
            if (this.isRegularFuncQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, qualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        if (!hasResourceQual) {
            validatedList.add(STNodeFactory.createMissingToken(SyntaxKind.RESOURCE_KEYWORD));
            functionKeyword = SyntaxErrors.addDiagnostic(functionKeyword, DiagnosticErrorCode.ERROR_MISSING_RESOURCE_KEYWORD, new Object[0]);
        }
        if (visibilityQualifier != null) {
            this.updateFirstNodeInListWithLeadingInvalidNode(validatedList, visibilityQualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)visibilityQualifier).text());
        }
        STNode qualifiers = STNodeFactory.createNodeList(validatedList);
        if (isObjectTypeDesc) {
            STNode semicolon = this.parseSemicolon();
            return STNodeFactory.createMethodDeclarationNode(SyntaxKind.RESOURCE_ACCESSOR_DECLARATION, metadata, qualifiers, functionKeyword, name, resourcePath, funcSignature, semicolon);
        }
        STNode body = this.parseFunctionBody();
        return STNodeFactory.createFunctionDefinitionNode(SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, metadata, qualifiers, functionKeyword, name, resourcePath, funcSignature, body);
    }

    private STNode parseFuncSignature(boolean isParamNameOptional) {
        STNode openParenthesis = this.parseOpenParenthesis();
        STNode parameters = this.parseParamList(isParamNameOptional);
        STNode closeParenthesis = this.parseCloseParenthesis();
        this.endContext();
        STNode returnTypeDesc = this.parseFuncReturnTypeDescriptor(isParamNameOptional);
        return STNodeFactory.createFunctionSignatureNode(openParenthesis, parameters, closeParenthesis, returnTypeDesc);
    }

    private STNode parseFunctionTypeDescRhs(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, STNode functionKeyword, STNode funcSignature, boolean isObjectMember, boolean isObjectTypeDesc) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                break;
            }
            default: {
                return this.parseVarDeclWithFunctionType(metadata, visibilityQualifier, qualifiers, functionKeyword, funcSignature, isObjectMember, isObjectTypeDesc, true);
            }
        }
        this.switchContext(ParserRuleContext.FUNC_DEF);
        STToken name = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_FUNCTION_NAME);
        funcSignature = this.validateAndGetFuncParams((STFunctionSignatureNode)funcSignature);
        STNode resourcePath = STNodeFactory.createEmptyNodeList();
        STNode funcDef = this.parseFuncDefOrMethodDeclEnd(metadata, visibilityQualifier, qualifiers, functionKeyword, name, resourcePath, funcSignature, isObjectMember, isObjectTypeDesc);
        this.endContext();
        return funcDef;
    }

    private List<STNode> extractVarDeclOrObjectFieldQualifiers(List<STNode> qualifierList, boolean isObjectMember, boolean isObjectTypeDesc) {
        if (isObjectMember) {
            return this.extractObjectFieldQualifiers(qualifierList, isObjectTypeDesc);
        }
        return this.extractVarDeclQualifiers(qualifierList, false);
    }

    private STNode createFunctionTypeDescriptor(List<STNode> qualifierList, STNode functionKeyword, STNode funcSignature, boolean hasFuncSignature) {
        STNode[] nodes = this.createFuncTypeQualNodeList(qualifierList, functionKeyword, hasFuncSignature);
        STNode qualifierNodeList = nodes[0];
        functionKeyword = nodes[1];
        return STNodeFactory.createFunctionTypeDescriptorNode(qualifierNodeList, functionKeyword, funcSignature);
    }

    private STNode parseVarDeclWithFunctionType(STNode metadata, STNode visibilityQualifier, List<STNode> qualifierList, STNode functionKeyword, STNode funcSignature, boolean isObjectMember, boolean isObjectTypeDesc, boolean hasFuncSignature) {
        this.switchContext(ParserRuleContext.VAR_DECL_STMT);
        List<STNode> extractQualifiersList = this.extractVarDeclOrObjectFieldQualifiers(qualifierList, isObjectMember, isObjectTypeDesc);
        STNode typeDesc = this.createFunctionTypeDescriptor(qualifierList, functionKeyword, funcSignature, hasFuncSignature);
        typeDesc = this.parseComplexTypeDescriptor(typeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        if (isObjectMember) {
            this.endContext();
            STNode objectFieldQualNodeList = STNodeFactory.createNodeList(extractQualifiersList);
            STNode fieldName = this.parseVariableName();
            return this.parseObjectFieldRhs(metadata, visibilityQualifier, objectFieldQualNodeList, typeDesc, fieldName, isObjectTypeDesc);
        }
        STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(metadata, visibilityQualifier, extractQualifiersList, typedBindingPattern, true);
    }

    private STNode validateAndGetFuncParams(STFunctionSignatureNode signature) {
        int index;
        STNode parameters = signature.parameters;
        int paramCount = parameters.bucketCount();
        block5: for (index = 0; index < paramCount; ++index) {
            STNode param = parameters.childInBucket(index);
            switch (param.kind) {
                case REQUIRED_PARAM: {
                    STRequiredParameterNode requiredParam = (STRequiredParameterNode)param;
                    if (!this.isEmpty(requiredParam.paramName)) continue block5;
                    break block5;
                }
                case DEFAULTABLE_PARAM: {
                    STDefaultableParameterNode defaultableParam = (STDefaultableParameterNode)param;
                    if (!this.isEmpty(defaultableParam.paramName)) continue block5;
                    break block5;
                }
                case REST_PARAM: {
                    STRestParameterNode restParam = (STRestParameterNode)param;
                    if (!this.isEmpty(restParam.paramName)) continue block5;
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        if (index == paramCount) {
            return signature;
        }
        STNode updatedParams = this.getUpdatedParamList(parameters, index);
        return STNodeFactory.createFunctionSignatureNode(signature.openParenToken, updatedParams, signature.closeParenToken, signature.returnTypeDesc);
    }

    private STNode getUpdatedParamList(STNode parameters, int index) {
        int newIndex;
        int paramCount = parameters.bucketCount();
        ArrayList<STNode> newParams = new ArrayList<STNode>();
        for (newIndex = 0; newIndex < index; ++newIndex) {
            newParams.add(parameters.childInBucket(index));
        }
        while (newIndex < paramCount) {
            STNode param = parameters.childInBucket(newIndex);
            STToken paramName = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            switch (param.kind) {
                case REQUIRED_PARAM: {
                    STRequiredParameterNode requiredParam = (STRequiredParameterNode)param;
                    if (!this.isEmpty(requiredParam.paramName)) break;
                    param = STNodeFactory.createRequiredParameterNode(requiredParam.annotations, requiredParam.typeName, paramName);
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    STDefaultableParameterNode defaultableParam = (STDefaultableParameterNode)param;
                    if (!this.isEmpty(defaultableParam.paramName)) break;
                    param = STNodeFactory.createDefaultableParameterNode(defaultableParam.annotations, defaultableParam.typeName, paramName, defaultableParam.equalsToken, defaultableParam.expression);
                    break;
                }
                case REST_PARAM: {
                    STRestParameterNode restParam = (STRestParameterNode)param;
                    if (!this.isEmpty(restParam.paramName)) break;
                    param = STNodeFactory.createRestParameterNode(restParam.annotations, restParam.typeName, restParam.ellipsisToken, paramName);
                    break;
                }
            }
            newParams.add(param);
            ++newIndex;
        }
        return STNodeFactory.createNodeList(newParams);
    }

    private boolean isEmpty(STNode node) {
        return !SyntaxUtils.isSTNodePresent(node);
    }

    private STNode parseFunctionKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FUNCTION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FUNCTION_KEYWORD);
        return this.parseFunctionKeyword();
    }

    private STNode parseFunctionName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FUNC_NAME);
        return this.parseFunctionName();
    }

    private STNode parseArgListOpenParenthesis() {
        return this.parseOpenParenthesis(ParserRuleContext.ARG_LIST_OPEN_PAREN);
    }

    private STNode parseOpenParenthesis() {
        return this.parseOpenParenthesis(ParserRuleContext.OPEN_PARENTHESIS);
    }

    private STNode parseOpenParenthesis(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx);
        return this.parseOpenParenthesis(ctx);
    }

    private STNode parseArgListCloseParenthesis() {
        return this.parseCloseParenthesis(ParserRuleContext.ARG_LIST_CLOSE_PAREN);
    }

    private STNode parseCloseParenthesis() {
        return this.parseCloseParenthesis(ParserRuleContext.CLOSE_PARENTHESIS);
    }

    private STNode parseCloseParenthesis(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx);
        return this.parseCloseParenthesis(ctx);
    }

    private STNode parseParamList(boolean isParamNameOptional) {
        STNode paramEnd;
        this.startContext(ParserRuleContext.PARAM_LIST);
        STToken token = this.peek();
        if (this.isEndOfParametersList(token.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> paramsList = new ArrayList<STNode>();
        this.startContext(ParserRuleContext.REQUIRED_PARAM);
        STNode firstParam = this.parseParameter(SyntaxKind.REQUIRED_PARAM, isParamNameOptional);
        SyntaxKind prevParamKind = firstParam.kind;
        paramsList.add(firstParam);
        boolean paramOrderErrorPresent = false;
        token = this.peek();
        while (!this.isEndOfParametersList(token.kind) && (paramEnd = this.parseParameterRhs()) != null) {
            this.endContext();
            if (prevParamKind == SyntaxKind.DEFAULTABLE_PARAM) {
                this.startContext(ParserRuleContext.DEFAULTABLE_PARAM);
            } else {
                this.startContext(ParserRuleContext.REQUIRED_PARAM);
            }
            STNode param = this.parseParameter(prevParamKind, isParamNameOptional);
            if (paramOrderErrorPresent) {
                this.updateLastNodeInListWithInvalidNode(paramsList, paramEnd, null, new Object[0]);
                this.updateLastNodeInListWithInvalidNode(paramsList, param, null, new Object[0]);
            } else {
                DiagnosticCode paramOrderError = this.validateParamOrder(param, prevParamKind);
                if (paramOrderError == null) {
                    paramsList.add(paramEnd);
                    paramsList.add(param);
                } else {
                    paramOrderErrorPresent = true;
                    this.updateLastNodeInListWithInvalidNode(paramsList, paramEnd, null, new Object[0]);
                    this.updateLastNodeInListWithInvalidNode(paramsList, param, paramOrderError, new Object[0]);
                }
            }
            prevParamKind = param.kind;
            token = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(paramsList);
    }

    private DiagnosticCode validateParamOrder(STNode param, SyntaxKind prevParamKind) {
        if (prevParamKind == SyntaxKind.REST_PARAM) {
            return DiagnosticErrorCode.ERROR_PARAMETER_AFTER_THE_REST_PARAMETER;
        }
        if (prevParamKind == SyntaxKind.DEFAULTABLE_PARAM && param.kind == SyntaxKind.REQUIRED_PARAM) {
            return DiagnosticErrorCode.ERROR_REQUIRED_PARAMETER_AFTER_THE_DEFAULTABLE_PARAMETER;
        }
        return null;
    }

    private boolean isSyntaxKindInList(List<STNode> nodeList, SyntaxKind kind) {
        for (STNode node : nodeList) {
            if (node.kind != kind) continue;
            return true;
        }
        return false;
    }

    private boolean isPossibleServiceDecl(List<STNode> nodeList) {
        if (nodeList.isEmpty()) {
            return false;
        }
        STNode firstElement = nodeList.get(0);
        return switch (firstElement.kind) {
            case SyntaxKind.SERVICE_KEYWORD -> true;
            case SyntaxKind.ISOLATED_KEYWORD -> {
                if (nodeList.size() > 1 && nodeList.get((int)1).kind == SyntaxKind.SERVICE_KEYWORD) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private STNode parseParameterRhs() {
        return this.parseParameterRhs(this.peek().kind);
    }

    private STNode parseParameterRhs(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_PAREN_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.PARAM_END);
                yield this.parseParameterRhs();
            }
        };
    }

    private STNode parseParameter(STNode annots, SyntaxKind prevParamKind, boolean isParamNameOptional) {
        STNode inclusionSymbol;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ASTERISK_TOKEN: {
                inclusionSymbol = this.consume();
                break;
            }
            case IDENTIFIER_TOKEN: {
                inclusionSymbol = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind)) {
                    inclusionSymbol = STNodeFactory.createEmptyNode();
                    break;
                }
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.PARAMETER_START_WITHOUT_ANNOTATION);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    inclusionSymbol = STNodeFactory.createEmptyNodeList();
                    break;
                }
                return this.parseParameter(annots, prevParamKind, isParamNameOptional);
            }
        }
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        return this.parseAfterParamType(prevParamKind, annots, inclusionSymbol, type, isParamNameOptional);
    }

    private STNode parseParameter(SyntaxKind prevParamKind, boolean isParamNameOptional) {
        STNode annots;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case AT_TOKEN: {
                annots = this.parseOptionalAnnotations();
                break;
            }
            case IDENTIFIER_TOKEN: 
            case ASTERISK_TOKEN: {
                annots = STNodeFactory.createEmptyNodeList();
                break;
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind)) {
                    annots = STNodeFactory.createEmptyNodeList();
                    break;
                }
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.PARAMETER_START);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    annots = STNodeFactory.createEmptyNodeList();
                    break;
                }
                return this.parseParameter(prevParamKind, isParamNameOptional);
            }
        }
        return this.parseParameter(annots, prevParamKind, isParamNameOptional);
    }

    private STNode parseAfterParamType(SyntaxKind prevParamKind, STNode annots, STNode inclusionSymbol, STNode type, boolean isParamNameOptional) {
        STToken token = this.peek();
        switch (token.kind) {
            case ELLIPSIS_TOKEN: {
                if (inclusionSymbol != null) {
                    type = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(type, inclusionSymbol, (DiagnosticCode)DiagnosticErrorCode.REST_PARAMETER_CANNOT_BE_INCLUDED_RECORD_PARAMETER, new Object[0]);
                }
                this.switchContext(ParserRuleContext.REST_PARAM);
                STNode ellipsis = this.parseEllipsis();
                STNode paramName = isParamNameOptional && this.peek().kind != SyntaxKind.IDENTIFIER_TOKEN ? STNodeFactory.createEmptyNode() : this.parseVariableName();
                return STNodeFactory.createRestParameterNode(annots, type, ellipsis, paramName);
            }
            case IDENTIFIER_TOKEN: {
                STNode paramName = this.parseVariableName();
                return this.parseParameterRhs(prevParamKind, annots, inclusionSymbol, type, paramName);
            }
            case EQUAL_TOKEN: {
                if (!isParamNameOptional) break;
                STNode paramName = STNodeFactory.createEmptyNode();
                return this.parseParameterRhs(prevParamKind, annots, inclusionSymbol, type, paramName);
            }
            default: {
                if (!isParamNameOptional) break;
                STNode paramName = STNodeFactory.createEmptyNode();
                return this.parseParameterRhs(prevParamKind, annots, inclusionSymbol, type, paramName);
            }
        }
        this.recover(token, ParserRuleContext.AFTER_PARAMETER_TYPE);
        return this.parseAfterParamType(prevParamKind, annots, inclusionSymbol, type, false);
    }

    private STNode parseEllipsis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ELLIPSIS_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ELLIPSIS);
        return this.parseEllipsis();
    }

    private STNode parseParameterRhs(SyntaxKind prevParamKind, STNode annots, STNode inclusionSymbol, STNode type, STNode paramName) {
        STToken nextToken = this.peek();
        if (this.isEndOfParameter(nextToken.kind)) {
            if (inclusionSymbol != null) {
                return STNodeFactory.createIncludedRecordParameterNode(annots, inclusionSymbol, type, paramName);
            }
            return STNodeFactory.createRequiredParameterNode(annots, type, paramName);
        }
        if (nextToken.kind == SyntaxKind.EQUAL_TOKEN) {
            if (prevParamKind == SyntaxKind.REQUIRED_PARAM) {
                this.switchContext(ParserRuleContext.DEFAULTABLE_PARAM);
            }
            STNode equal = this.parseAssignOp();
            STNode expr = this.parseInferredTypeDescDefaultOrExpression();
            if (inclusionSymbol != null) {
                type = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(type, inclusionSymbol, (DiagnosticCode)DiagnosticErrorCode.ERROR_DEFAULTABLE_PARAMETER_CANNOT_BE_INCLUDED_RECORD_PARAMETER, new Object[0]);
            }
            return STNodeFactory.createDefaultableParameterNode(annots, type, paramName, equal, expr);
        }
        this.recover(nextToken, ParserRuleContext.PARAMETER_NAME_RHS);
        return this.parseParameterRhs(prevParamKind, annots, inclusionSymbol, type, paramName);
    }

    private STNode parseComma() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COMMA_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COMMA);
        return this.parseComma();
    }

    private STNode parseFuncReturnTypeDescriptor(boolean isFuncTypeDesc) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
            case RETURNS_KEYWORD: {
                break;
            }
            case IDENTIFIER_TOKEN: {
                if (!isFuncTypeDesc || this.isSafeMissingReturnsParse()) break;
            }
            default: {
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.RETURNS_KEYWORD) break;
                return STNodeFactory.createEmptyNode();
            }
        }
        STNode returnsKeyword = this.parseReturnsKeyword();
        STNode annot = this.parseOptionalAnnotations();
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RETURN_TYPE_DESC);
        return STNodeFactory.createReturnTypeDescriptorNode(returnsKeyword, annot, type);
    }

    private boolean isSafeMissingReturnsParse() {
        for (ParserRuleContext context : this.errorHandler.getContextStack()) {
            if (this.isSafeMissingReturnsParseCtx(context)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeMissingReturnsParseCtx(ParserRuleContext ctx) {
        return switch (ctx) {
            case ParserRuleContext.TYPE_DESC_IN_ANNOTATION_DECL, ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER, ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER_IN_GROUPING_KEY, ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD, ParserRuleContext.TYPE_DESC_IN_PARAM, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, ParserRuleContext.VAR_DECL_STARTED_WITH_DENTIFIER, ParserRuleContext.TYPE_DESC_IN_PATH_PARAM, ParserRuleContext.AMBIGUOUS_STMT -> false;
            default -> true;
        };
    }

    private STNode parseReturnsKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RETURNS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RETURNS_KEYWORD);
        return this.parseReturnsKeyword();
    }

    private STNode parseTypeDescriptor(ParserRuleContext context) {
        return this.parseTypeDescriptor(context, false, false, TypePrecedence.DEFAULT);
    }

    private STNode parseTypeDescriptor(ParserRuleContext context, TypePrecedence precedence) {
        return this.parseTypeDescriptor(context, false, false, precedence);
    }

    private STNode parseTypeDescriptor(List<STNode> qualifiers, ParserRuleContext context) {
        return this.parseTypeDescriptor(qualifiers, context, false, false, TypePrecedence.DEFAULT);
    }

    private STNode parseTypeDescriptorInExpression(boolean isInConditionalExpr) {
        return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_EXPRESSION, false, isInConditionalExpr, TypePrecedence.DEFAULT);
    }

    private STNode parseTypeDescriptor(ParserRuleContext context, boolean isTypedBindingPattern, boolean isInConditionalExpr, TypePrecedence precedence) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypeDescriptor(typeDescQualifiers, context, isTypedBindingPattern, isInConditionalExpr, precedence);
    }

    private STNode parseTypeDescriptor(List<STNode> qualifiers, ParserRuleContext context, boolean isTypedBindingPattern, boolean isInConditionalExpr, TypePrecedence precedence) {
        this.startContext(context);
        STNode typeDesc = this.parseTypeDescriptorInternal(qualifiers, context, isTypedBindingPattern, isInConditionalExpr, precedence);
        this.endContext();
        return typeDesc;
    }

    private STNode parseTypeDescriptorInternal(List<STNode> qualifiers, ParserRuleContext context, boolean isTypedBindingPattern, boolean isInConditionalExpr, TypePrecedence precedence) {
        STNode typeDesc = this.parseTypeDescriptorInternal(qualifiers, context, isInConditionalExpr);
        if (typeDesc.kind == SyntaxKind.VAR_TYPE_DESC && context != ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN && context != ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER_IN_GROUPING_KEY) {
            STToken missingToken = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            missingToken = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(missingToken, typeDesc, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_USAGE_OF_VAR, new Object[0]);
            typeDesc = STNodeFactory.createSimpleNameReferenceNode(missingToken);
        }
        return this.parseComplexTypeDescriptorInternal(typeDesc, context, isTypedBindingPattern, precedence);
    }

    private STNode parseComplexTypeDescriptor(STNode typeDesc, ParserRuleContext context, boolean isTypedBindingPattern) {
        this.startContext(context);
        STNode complexTypeDesc = this.parseComplexTypeDescriptorInternal(typeDesc, context, isTypedBindingPattern, TypePrecedence.DEFAULT);
        this.endContext();
        return complexTypeDesc;
    }

    private STNode parseComplexTypeDescriptorInternal(STNode typeDesc, ParserRuleContext context, boolean isTypedBindingPattern, TypePrecedence precedence) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case QUESTION_MARK_TOKEN: {
                if (precedence.isHigherThanOrEqual(TypePrecedence.ARRAY_OR_OPTIONAL)) {
                    return typeDesc;
                }
                boolean isPossibleOptionalType = true;
                STToken nextNextToken = this.getNextNextToken();
                if (context == ParserRuleContext.TYPE_DESC_IN_EXPRESSION && !this.isValidTypeContinuationToken(nextNextToken) && this.isValidExprStart(nextNextToken.kind)) {
                    ParserRuleContext grandParentCtx;
                    isPossibleOptionalType = nextNextToken.kind == SyntaxKind.OPEN_BRACE_TOKEN ? (grandParentCtx = this.errorHandler.getGrandParentContext()) == ParserRuleContext.IF_BLOCK || grandParentCtx == ParserRuleContext.WHILE_BLOCK : false;
                }
                if (!isPossibleOptionalType) {
                    return typeDesc;
                }
                STNode optionalTypeDes = this.parseOptionalTypeDescriptor(typeDesc);
                return this.parseComplexTypeDescriptorInternal(optionalTypeDes, context, isTypedBindingPattern, precedence);
            }
            case OPEN_BRACKET_TOKEN: {
                if (isTypedBindingPattern) {
                    return typeDesc;
                }
                if (precedence.isHigherThanOrEqual(TypePrecedence.ARRAY_OR_OPTIONAL)) {
                    return typeDesc;
                }
                STNode arrayTypeDesc = this.parseArrayTypeDescriptor(typeDesc);
                return this.parseComplexTypeDescriptorInternal(arrayTypeDesc, context, false, precedence);
            }
            case PIPE_TOKEN: {
                if (precedence.isHigherThanOrEqual(TypePrecedence.UNION)) {
                    return typeDesc;
                }
                STNode newTypeDesc = this.parseUnionTypeDescriptor(typeDesc, context, isTypedBindingPattern);
                return this.parseComplexTypeDescriptorInternal(newTypeDesc, context, isTypedBindingPattern, precedence);
            }
            case BITWISE_AND_TOKEN: {
                if (precedence.isHigherThanOrEqual(TypePrecedence.INTERSECTION)) {
                    return typeDesc;
                }
                STNode newTypeDesc = this.parseIntersectionTypeDescriptor(typeDesc, context, isTypedBindingPattern);
                return this.parseComplexTypeDescriptorInternal(newTypeDesc, context, isTypedBindingPattern, precedence);
            }
        }
        return typeDesc;
    }

    private boolean isValidTypeContinuationToken(STToken token) {
        return switch (token.kind) {
            case SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.QUESTION_MARK_TOKEN, SyntaxKind.PIPE_TOKEN, SyntaxKind.BITWISE_AND_TOKEN -> true;
            default -> false;
        };
    }

    private STNode validateForUsageOfVar(STNode typeDesc) {
        if (typeDesc.kind != SyntaxKind.VAR_TYPE_DESC) {
            return typeDesc;
        }
        STToken missingToken = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
        missingToken = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(missingToken, typeDesc, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_USAGE_OF_VAR, new Object[0]);
        return STNodeFactory.createSimpleNameReferenceNode(missingToken);
    }

    private STNode parseTypeDescriptorInternal(List<STNode> qualifiers, ParserRuleContext context, boolean isInConditionalExpr) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        if (this.isQualifiedIdentifierPredeclaredPrefix(nextToken.kind)) {
            return this.parseQualifiedTypeRefOrTypeDesc(qualifiers, isInConditionalExpr);
        }
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTypeReference(isInConditionalExpr);
            }
            case RECORD_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRecordTypeDescriptor();
            }
            case OBJECT_KEYWORD: {
                STNode objectTypeQualifiers = this.createObjectTypeQualNodeList(qualifiers);
                return this.parseObjectTypeDescriptor(this.consume(), objectTypeQualifiers);
            }
            case OPEN_PAREN_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseNilOrParenthesisedTypeDesc();
            }
            case MAP_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMapTypeDescriptor(this.consume());
            }
            case STREAM_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseStreamTypeDescriptor(this.consume());
            }
            case TABLE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTableTypeDescriptor(this.consume());
            }
            case FUNCTION_KEYWORD: {
                return this.parseFunctionTypeDesc(qualifiers);
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTupleTypeDesc();
            }
            case DISTINCT_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STToken distinctKeyword = this.consume();
                return this.parseDistinctTypeDesc(distinctKeyword, context);
            }
            case TRANSACTION_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseQualifiedIdentWithTransactionPrefix(context);
            }
        }
        if (BallerinaParser.isParameterizedTypeToken(nextToken.kind)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseParameterizedTypeDescriptor(this.consume());
        }
        if (BallerinaParser.isSingletonTypeDescStart(nextToken.kind, this.getNextNextToken())) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseSingletonTypeDesc();
        }
        if (BallerinaParser.isSimpleType(nextToken.kind)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseSimpleTypeDescriptor();
        }
        ParserRuleContext recoveryCtx = this.getTypeDescRecoveryCtx(qualifiers);
        AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), recoveryCtx);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseSingletonTypeDesc();
        }
        return this.parseTypeDescriptorInternal(qualifiers, context, isInConditionalExpr);
    }

    private ParserRuleContext getTypeDescRecoveryCtx(List<STNode> qualifiers) {
        if (qualifiers.isEmpty()) {
            return ParserRuleContext.TYPE_DESCRIPTOR;
        }
        STNode lastQualifier = this.getLastNodeInList(qualifiers);
        return switch (lastQualifier.kind) {
            case SyntaxKind.ISOLATED_KEYWORD -> ParserRuleContext.TYPE_DESC_WITHOUT_ISOLATED;
            case SyntaxKind.TRANSACTIONAL_KEYWORD -> ParserRuleContext.FUNC_TYPE_DESC;
            default -> ParserRuleContext.OBJECT_TYPE_DESCRIPTOR;
        };
    }

    static boolean isParameterizedTypeToken(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.ERROR_KEYWORD, SyntaxKind.TYPEDESC_KEYWORD, SyntaxKind.FUTURE_KEYWORD, SyntaxKind.XML_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseQualifiedIdentWithTransactionPrefix(ParserRuleContext context) {
        STToken transactionKeyword = this.consume();
        STToken identifier = STNodeFactory.createIdentifierToken(transactionKeyword.text(), transactionKeyword.leadingMinutiae(), transactionKeyword.trailingMinutiae());
        STToken colon = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.COLON_TOKEN, DiagnosticErrorCode.ERROR_MISSING_COLON_TOKEN);
        STNode varOrFuncName = this.parseIdentifier(context);
        return this.createQualifiedNameReferenceNode(identifier, colon, varOrFuncName);
    }

    private STNode parseQualifiedTypeRefOrTypeDesc(List<STNode> qualifiers, boolean isInConditionalExpr) {
        STToken preDeclaredPrefix = this.consume();
        STToken nextNextToken = this.getNextNextToken();
        if (preDeclaredPrefix.kind == SyntaxKind.TRANSACTION_KEYWORD || nextNextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseQualifiedIdentifierWithPredeclPrefix(preDeclaredPrefix, isInConditionalExpr);
        }
        AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), switch (preDeclaredPrefix.kind) {
            case SyntaxKind.MAP_KEYWORD -> ParserRuleContext.MAP_TYPE_OR_TYPE_REF;
            case SyntaxKind.OBJECT_KEYWORD -> ParserRuleContext.OBJECT_TYPE_OR_TYPE_REF;
            case SyntaxKind.STREAM_KEYWORD -> ParserRuleContext.STREAM_TYPE_OR_TYPE_REF;
            case SyntaxKind.TABLE_KEYWORD -> ParserRuleContext.TABLE_TYPE_OR_TYPE_REF;
            default -> BallerinaParser.isParameterizedTypeToken(preDeclaredPrefix.kind) ? ParserRuleContext.PARAMETERIZED_TYPE_OR_TYPE_REF : ParserRuleContext.TYPE_DESC_RHS_OR_TYPE_REF;
        });
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseQualifiedIdentifierWithPredeclPrefix(preDeclaredPrefix, isInConditionalExpr);
        }
        return this.parseTypeDescStartWithPredeclPrefix(preDeclaredPrefix, qualifiers);
    }

    private STNode parseTypeDescStartWithPredeclPrefix(STToken preDeclaredPrefix, List<STNode> qualifiers) {
        return switch (preDeclaredPrefix.kind) {
            case SyntaxKind.MAP_KEYWORD -> {
                this.reportInvalidQualifierList(qualifiers);
                yield this.parseMapTypeDescriptor(preDeclaredPrefix);
            }
            case SyntaxKind.OBJECT_KEYWORD -> {
                STNode objectTypeQualifiers = this.createObjectTypeQualNodeList(qualifiers);
                yield this.parseObjectTypeDescriptor(preDeclaredPrefix, objectTypeQualifiers);
            }
            case SyntaxKind.STREAM_KEYWORD -> {
                this.reportInvalidQualifierList(qualifiers);
                yield this.parseStreamTypeDescriptor(preDeclaredPrefix);
            }
            case SyntaxKind.TABLE_KEYWORD -> {
                this.reportInvalidQualifierList(qualifiers);
                yield this.parseTableTypeDescriptor(preDeclaredPrefix);
            }
            default -> {
                if (BallerinaParser.isParameterizedTypeToken(preDeclaredPrefix.kind)) {
                    this.reportInvalidQualifierList(qualifiers);
                    yield this.parseParameterizedTypeDescriptor(preDeclaredPrefix);
                }
                yield BallerinaParser.createBuiltinSimpleNameReference(preDeclaredPrefix);
            }
        };
    }

    private STNode parseQualifiedIdentifierWithPredeclPrefix(STToken preDeclaredPrefix, boolean isInConditionalExpr) {
        STToken identifier = STNodeFactory.createIdentifierToken(preDeclaredPrefix.text(), preDeclaredPrefix.leadingMinutiae(), preDeclaredPrefix.trailingMinutiae());
        return this.parseQualifiedIdentifier(identifier, isInConditionalExpr);
    }

    private STNode parseDistinctTypeDesc(STNode distinctKeyword, ParserRuleContext context) {
        STNode typeDesc = this.parseTypeDescriptor(context, TypePrecedence.DISTINCT);
        return STNodeFactory.createDistinctTypeDescriptorNode(distinctKeyword, typeDesc);
    }

    private STNode parseNilOrParenthesisedTypeDesc() {
        STNode openParen = this.parseOpenParenthesis();
        return this.parseNilOrParenthesisedTypeDescRhs(openParen);
    }

    private STNode parseNilOrParenthesisedTypeDescRhs(STNode openParen) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case CLOSE_PAREN_TOKEN: {
                STNode closeParen = this.parseCloseParenthesis();
                return STNodeFactory.createNilTypeDescriptorNode(openParen, closeParen);
            }
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            STNode typedesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_PARENTHESIS);
            STNode closeParen = this.parseCloseParenthesis();
            return STNodeFactory.createParenthesisedTypeDescriptorNode(openParen, typedesc, closeParen);
        }
        this.recover(this.peek(), ParserRuleContext.NIL_OR_PARENTHESISED_TYPE_DESC_RHS);
        return this.parseNilOrParenthesisedTypeDescRhs(openParen);
    }

    private STNode parseSimpleTypeInTerminalExpr() {
        this.startContext(ParserRuleContext.TYPE_DESC_IN_EXPRESSION);
        STNode simpleTypeDescriptor = this.parseSimpleTypeDescriptor();
        this.endContext();
        return simpleTypeDescriptor;
    }

    private STNode parseSimpleTypeDescriptor() {
        STToken nextToken = this.peek();
        if (BallerinaParser.isSimpleType(nextToken.kind)) {
            STToken token = this.consume();
            return BallerinaParser.createBuiltinSimpleNameReference(token);
        }
        this.recover(nextToken, ParserRuleContext.SIMPLE_TYPE_DESCRIPTOR);
        return this.parseSimpleTypeDescriptor();
    }

    public static STNode createBuiltinSimpleNameReference(STNode token) {
        SyntaxKind typeKind = BallerinaParser.getBuiltinTypeSyntaxKind(token.kind);
        return STNodeFactory.createBuiltinSimpleNameReferenceNode(typeKind, token);
    }

    protected STNode parseFunctionBody() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.EQUAL_TOKEN -> this.parseExternalFunctionBody();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseFunctionBodyBlock(false);
            case SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN -> this.parseExpressionFuncBody(false, false);
            default -> {
                this.recover(token, ParserRuleContext.FUNC_BODY);
                yield this.parseFunctionBody();
            }
        };
    }

    private STNode parseFunctionBodyBlock(boolean isAnonFunc) {
        STNode statements;
        STNode namedWorkersList;
        STNode stmt;
        this.startContext(ParserRuleContext.FUNC_BODY_BLOCK);
        STNode openBrace = this.parseOpenBrace();
        STToken token = this.peek();
        ArrayList<STNode> firstStmtList = new ArrayList<STNode>();
        ArrayList<STNode> workers = new ArrayList<STNode>();
        ArrayList<STNode> secondStmtList = new ArrayList<STNode>();
        ParserRuleContext currentCtx = ParserRuleContext.DEFAULT_WORKER_INIT;
        boolean hasNamedWorkers = false;
        while (!this.isEndOfFuncBodyBlock(token.kind, isAnonFunc) && (stmt = this.parseStatement()) != null) {
            if (this.validateStatement(stmt)) continue;
            switch (currentCtx) {
                case DEFAULT_WORKER_INIT: {
                    if (stmt.kind != SyntaxKind.NAMED_WORKER_DECLARATION) {
                        firstStmtList.add(stmt);
                        break;
                    }
                    currentCtx = ParserRuleContext.NAMED_WORKERS;
                    hasNamedWorkers = true;
                }
                case NAMED_WORKERS: {
                    if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
                        workers.add(stmt);
                        break;
                    }
                    currentCtx = ParserRuleContext.DEFAULT_WORKER;
                }
                default: {
                    if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
                        this.updateLastNodeInListWithInvalidNode(secondStmtList, stmt, DiagnosticErrorCode.ERROR_NAMED_WORKER_NOT_ALLOWED_HERE, new Object[0]);
                        break;
                    }
                    secondStmtList.add(stmt);
                }
            }
            token = this.peek();
        }
        if (hasNamedWorkers) {
            STNode workerInitStatements = STNodeFactory.createNodeList(firstStmtList);
            STNode namedWorkers = STNodeFactory.createNodeList(workers);
            namedWorkersList = STNodeFactory.createNamedWorkerDeclarator(workerInitStatements, namedWorkers);
            statements = STNodeFactory.createNodeList(secondStmtList);
        } else {
            namedWorkersList = STNodeFactory.createEmptyNode();
            statements = STNodeFactory.createNodeList(firstStmtList);
        }
        STNode closeBrace = this.parseCloseBrace();
        STNode semicolon = isAnonFunc ? STNodeFactory.createEmptyNode() : this.parseOptionalSemicolon();
        this.endContext();
        return STNodeFactory.createFunctionBodyBlockNode(openBrace, namedWorkersList, statements, closeBrace, semicolon);
    }

    private boolean isEndOfFuncBodyBlock(SyntaxKind nextTokenKind, boolean isAnonFunc) {
        if (isAnonFunc) {
            switch (nextTokenKind) {
                case EOF_TOKEN: 
                case PUBLIC_KEYWORD: 
                case EQUAL_TOKEN: 
                case SEMICOLON_TOKEN: 
                case OPEN_BRACE_TOKEN: 
                case COMMA_TOKEN: 
                case CLOSE_PAREN_TOKEN: 
                case CLOSE_BRACE_TOKEN: 
                case CLOSE_BRACKET_TOKEN: 
                case BACKTICK_TOKEN: {
                    return true;
                }
            }
        }
        return this.isEndOfStatements();
    }

    private boolean isEndOfRecordTypeNode(SyntaxKind nextTokenKind) {
        return this.isEndOfModuleLevelNode(1);
    }

    private boolean isEndOfObjectTypeNode() {
        return this.isEndOfModuleLevelNode(1, true);
    }

    private boolean isEndOfStatements() {
        return switch (this.peek().kind) {
            case SyntaxKind.RESOURCE_KEYWORD -> true;
            default -> this.isEndOfModuleLevelNode(1);
        };
    }

    private boolean isEndOfModuleLevelNode(int peekIndex) {
        return this.isEndOfModuleLevelNode(peekIndex, false);
    }

    private boolean isEndOfModuleLevelNode(int peekIndex, boolean isObject) {
        return switch (this.peek((int)peekIndex).kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.IMPORT_KEYWORD, SyntaxKind.LISTENER_KEYWORD, SyntaxKind.ANNOTATION_KEYWORD, SyntaxKind.CLASS_KEYWORD, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACE_PIPE_TOKEN -> true;
            case SyntaxKind.SERVICE_KEYWORD -> this.isServiceDeclStart(ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER, 1);
            case SyntaxKind.PUBLIC_KEYWORD -> {
                if (!isObject && this.isEndOfModuleLevelNode(peekIndex + 1, false)) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.FUNCTION_KEYWORD -> {
                if (isObject) {
                    yield false;
                }
                if (this.peek((int)(peekIndex + 1)).kind == SyntaxKind.IDENTIFIER_TOKEN && this.peek((int)(peekIndex + 2)).kind == SyntaxKind.OPEN_PAREN_TOKEN) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isEndOfParameter(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.AT_TOKEN, SyntaxKind.TYPE_KEYWORD, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.COMMA_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.RETURNS_KEYWORD, SyntaxKind.CLOSE_BRACKET_TOKEN, SyntaxKind.IF_KEYWORD, SyntaxKind.WHILE_KEYWORD, SyntaxKind.DO_KEYWORD -> true;
            default -> this.isEndOfModuleLevelNode(1);
        };
    }

    private boolean isEndOfParametersList(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.TYPE_KEYWORD, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.RETURNS_KEYWORD, SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, SyntaxKind.IF_KEYWORD, SyntaxKind.WHILE_KEYWORD, SyntaxKind.DO_KEYWORD -> true;
            default -> this.isEndOfModuleLevelNode(1);
        };
    }

    private STNode parseStatementStartIdentifier() {
        return this.parseQualifiedIdentifier(ParserRuleContext.TYPE_NAME_OR_VAR_NAME);
    }

    private STNode parseVariableName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.VARIABLE_NAME);
        return this.parseVariableName();
    }

    private STNode parseOpenBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OPEN_BRACE);
        return this.parseOpenBrace();
    }

    private STNode parseCloseBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSE_BRACE);
        return this.parseCloseBrace();
    }

    private STNode parseExternalFunctionBody() {
        this.startContext(ParserRuleContext.EXTERNAL_FUNC_BODY);
        STNode assign = this.parseAssignOp();
        return this.parseExternalFuncBodyRhs(assign);
    }

    private STNode parseExternalFuncBodyRhs(STNode assign) {
        STNode annotation;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case AT_TOKEN: {
                annotation = this.parseAnnotations();
                break;
            }
            case EXTERNAL_KEYWORD: {
                annotation = STNodeFactory.createEmptyNodeList();
                break;
            }
            default: {
                this.recover(nextToken, ParserRuleContext.EXTERNAL_FUNC_BODY_OPTIONAL_ANNOTS);
                return this.parseExternalFuncBodyRhs(assign);
            }
        }
        STNode externalKeyword = this.parseExternalKeyword();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createExternalFunctionBodyNode(assign, annotation, externalKeyword, semicolon);
    }

    private STNode parseSemicolon() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SEMICOLON_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SEMICOLON);
        return this.parseSemicolon();
    }

    private STNode parseOptionalSemicolon() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SEMICOLON_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createEmptyNode();
    }

    private STNode parseExternalKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EXTERNAL_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.EXTERNAL_KEYWORD);
        return this.parseExternalKeyword();
    }

    private STNode parseAssignOp() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EQUAL_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ASSIGN_OP);
        return this.parseAssignOp();
    }

    private STNode parseBinaryOperator() {
        STToken token = this.peek();
        if (this.isBinaryOperator(token.kind)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BINARY_OPERATOR);
        return this.parseBinaryOperator();
    }

    private boolean isBinaryOperator(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.PIPE_TOKEN, SyntaxKind.BITWISE_AND_TOKEN, SyntaxKind.SLASH_TOKEN, SyntaxKind.ASTERISK_TOKEN, SyntaxKind.ELLIPSIS_TOKEN, SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN, SyntaxKind.GT_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.DOUBLE_EQUAL_TOKEN, SyntaxKind.TRIPPLE_EQUAL_TOKEN, SyntaxKind.LT_EQUAL_TOKEN, SyntaxKind.GT_EQUAL_TOKEN, SyntaxKind.NOT_EQUAL_TOKEN, SyntaxKind.NOT_DOUBLE_EQUAL_TOKEN, SyntaxKind.BITWISE_XOR_TOKEN, SyntaxKind.LOGICAL_AND_TOKEN, SyntaxKind.LOGICAL_OR_TOKEN, SyntaxKind.PERCENT_TOKEN, SyntaxKind.DOUBLE_LT_TOKEN, SyntaxKind.DOUBLE_GT_TOKEN, SyntaxKind.TRIPPLE_GT_TOKEN, SyntaxKind.DOUBLE_DOT_LT_TOKEN, SyntaxKind.ELVIS_TOKEN -> true;
            default -> false;
        };
    }

    private OperatorPrecedence getOpPrecedence(SyntaxKind binaryOpKind) {
        return switch (binaryOpKind) {
            case SyntaxKind.SLASH_TOKEN, SyntaxKind.ASTERISK_TOKEN, SyntaxKind.PERCENT_TOKEN -> OperatorPrecedence.MULTIPLICATIVE;
            case SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN -> OperatorPrecedence.ADDITIVE;
            case SyntaxKind.GT_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.LT_EQUAL_TOKEN, SyntaxKind.GT_EQUAL_TOKEN, SyntaxKind.IS_KEYWORD, SyntaxKind.NOT_IS_KEYWORD -> OperatorPrecedence.BINARY_COMPARE;
            case SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.DOT_TOKEN, SyntaxKind.OPEN_PAREN_TOKEN, SyntaxKind.ANNOT_CHAINING_TOKEN, SyntaxKind.OPTIONAL_CHAINING_TOKEN, SyntaxKind.DOT_LT_TOKEN, SyntaxKind.SLASH_LT_TOKEN, SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN, SyntaxKind.SLASH_ASTERISK_TOKEN -> OperatorPrecedence.MEMBER_ACCESS;
            case SyntaxKind.DOUBLE_EQUAL_TOKEN, SyntaxKind.TRIPPLE_EQUAL_TOKEN, SyntaxKind.NOT_EQUAL_TOKEN, SyntaxKind.NOT_DOUBLE_EQUAL_TOKEN -> OperatorPrecedence.EQUALITY;
            case SyntaxKind.BITWISE_AND_TOKEN -> OperatorPrecedence.BITWISE_AND;
            case SyntaxKind.BITWISE_XOR_TOKEN -> OperatorPrecedence.BITWISE_XOR;
            case SyntaxKind.PIPE_TOKEN -> OperatorPrecedence.BITWISE_OR;
            case SyntaxKind.LOGICAL_AND_TOKEN -> OperatorPrecedence.LOGICAL_AND;
            case SyntaxKind.LOGICAL_OR_TOKEN -> OperatorPrecedence.LOGICAL_OR;
            case SyntaxKind.RIGHT_ARROW_TOKEN -> OperatorPrecedence.REMOTE_CALL_ACTION;
            case SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN -> OperatorPrecedence.ANON_FUNC_OR_LET;
            case SyntaxKind.SYNC_SEND_TOKEN -> OperatorPrecedence.ACTION;
            case SyntaxKind.DOUBLE_LT_TOKEN, SyntaxKind.DOUBLE_GT_TOKEN, SyntaxKind.TRIPPLE_GT_TOKEN -> OperatorPrecedence.SHIFT;
            case SyntaxKind.ELLIPSIS_TOKEN, SyntaxKind.DOUBLE_DOT_LT_TOKEN -> OperatorPrecedence.RANGE;
            case SyntaxKind.ELVIS_TOKEN -> OperatorPrecedence.ELVIS_CONDITIONAL;
            case SyntaxKind.QUESTION_MARK_TOKEN, SyntaxKind.COLON_TOKEN -> OperatorPrecedence.CONDITIONAL;
            default -> throw new UnsupportedOperationException("Unsupported binary operator '" + String.valueOf((Object)binaryOpKind) + "'");
        };
    }

    private SyntaxKind getBinaryOperatorKindToInsert(OperatorPrecedence opPrecedenceLevel) {
        return switch (opPrecedenceLevel) {
            case OperatorPrecedence.MULTIPLICATIVE -> SyntaxKind.ASTERISK_TOKEN;
            case OperatorPrecedence.DEFAULT, OperatorPrecedence.UNARY, OperatorPrecedence.ACTION, OperatorPrecedence.EXPRESSION_ACTION, OperatorPrecedence.REMOTE_CALL_ACTION, OperatorPrecedence.ANON_FUNC_OR_LET, OperatorPrecedence.QUERY, OperatorPrecedence.TRAP, OperatorPrecedence.ADDITIVE -> SyntaxKind.PLUS_TOKEN;
            case OperatorPrecedence.SHIFT -> SyntaxKind.DOUBLE_LT_TOKEN;
            case OperatorPrecedence.RANGE -> SyntaxKind.ELLIPSIS_TOKEN;
            case OperatorPrecedence.BINARY_COMPARE -> SyntaxKind.LT_TOKEN;
            case OperatorPrecedence.EQUALITY -> SyntaxKind.DOUBLE_EQUAL_TOKEN;
            case OperatorPrecedence.BITWISE_AND -> SyntaxKind.BITWISE_AND_TOKEN;
            case OperatorPrecedence.BITWISE_XOR -> SyntaxKind.BITWISE_XOR_TOKEN;
            case OperatorPrecedence.BITWISE_OR -> SyntaxKind.PIPE_TOKEN;
            case OperatorPrecedence.LOGICAL_AND -> SyntaxKind.LOGICAL_AND_TOKEN;
            case OperatorPrecedence.LOGICAL_OR -> SyntaxKind.LOGICAL_OR_TOKEN;
            case OperatorPrecedence.ELVIS_CONDITIONAL -> SyntaxKind.ELVIS_TOKEN;
            default -> throw new UnsupportedOperationException("Unsupported operator precedence level'" + String.valueOf((Object)opPrecedenceLevel) + "'");
        };
    }

    private ParserRuleContext getMissingBinaryOperatorContext(OperatorPrecedence opPrecedenceLevel) {
        return switch (opPrecedenceLevel) {
            case OperatorPrecedence.MULTIPLICATIVE -> ParserRuleContext.ASTERISK;
            case OperatorPrecedence.DEFAULT, OperatorPrecedence.UNARY, OperatorPrecedence.ACTION, OperatorPrecedence.EXPRESSION_ACTION, OperatorPrecedence.REMOTE_CALL_ACTION, OperatorPrecedence.ANON_FUNC_OR_LET, OperatorPrecedence.QUERY, OperatorPrecedence.TRAP, OperatorPrecedence.ADDITIVE -> ParserRuleContext.PLUS_TOKEN;
            case OperatorPrecedence.SHIFT -> ParserRuleContext.DOUBLE_LT;
            case OperatorPrecedence.RANGE -> ParserRuleContext.ELLIPSIS;
            case OperatorPrecedence.BINARY_COMPARE -> ParserRuleContext.LT_TOKEN;
            case OperatorPrecedence.EQUALITY -> ParserRuleContext.DOUBLE_EQUAL;
            case OperatorPrecedence.BITWISE_AND -> ParserRuleContext.BITWISE_AND_OPERATOR;
            case OperatorPrecedence.BITWISE_XOR -> ParserRuleContext.BITWISE_XOR;
            case OperatorPrecedence.BITWISE_OR -> ParserRuleContext.PIPE;
            case OperatorPrecedence.LOGICAL_AND -> ParserRuleContext.LOGICAL_AND;
            case OperatorPrecedence.LOGICAL_OR -> ParserRuleContext.LOGICAL_OR;
            case OperatorPrecedence.ELVIS_CONDITIONAL -> ParserRuleContext.ELVIS;
            default -> throw new UnsupportedOperationException("Unsupported operator precedence level'" + String.valueOf((Object)opPrecedenceLevel) + "'");
        };
    }

    private STNode parseModuleTypeDefinition(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.MODULE_TYPE_DEFINITION);
        STNode typeKeyword = this.parseTypeKeyword();
        STNode typeName = this.parseTypeName();
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_DEF);
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createTypeDefinitionNode(metadata, qualifier, typeKeyword, typeName, typeDescriptor, semicolon);
    }

    private STNode parseClassDefinition(STNode metadata, STNode qualifier, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.MODULE_CLASS_DEFINITION);
        STNode classTypeQualifiers = this.createClassTypeQualNodeList(qualifiers);
        STNode classKeyword = this.parseClassKeyword();
        STNode className = this.parseClassName();
        STNode openBrace = this.parseOpenBrace();
        STNode classMembers = this.parseObjectMembers(ParserRuleContext.CLASS_MEMBER);
        STNode closeBrace = this.parseCloseBrace();
        STNode semicolon = this.parseOptionalSemicolon();
        this.endContext();
        return STNodeFactory.createClassDefinitionNode(metadata, qualifier, classTypeQualifiers, classKeyword, className, openBrace, classMembers, closeBrace, semicolon);
    }

    private boolean isClassTypeQual(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.DISTINCT_KEYWORD, SyntaxKind.READONLY_KEYWORD -> true;
            default -> this.isObjectNetworkQual(tokenKind);
        };
    }

    private boolean isObjectTypeQual(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.ISOLATED_KEYWORD -> true;
            default -> this.isObjectNetworkQual(tokenKind);
        };
    }

    private boolean isObjectNetworkQual(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.CLIENT_KEYWORD, SyntaxKind.SERVICE_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode createClassTypeQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        boolean hasNetworkQual = false;
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isObjectNetworkQual(qualifier.kind)) {
                if (hasNetworkQual) {
                    this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_MORE_THAN_ONE_OBJECT_NETWORK_QUALIFIERS, new Object[0]);
                    continue;
                }
                validatedList.add(qualifier);
                hasNetworkQual = true;
                continue;
            }
            if (this.isClassTypeQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode createObjectTypeQualNodeList(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        boolean hasNetworkQual = false;
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (this.isObjectNetworkQual(qualifier.kind)) {
                if (hasNetworkQual) {
                    this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_MORE_THAN_ONE_OBJECT_NETWORK_QUALIFIERS, new Object[0]);
                    continue;
                }
                validatedList.add(qualifier);
                hasNetworkQual = true;
                continue;
            }
            if (this.isObjectTypeQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode parseClassKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLASS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLASS_KEYWORD);
        return this.parseClassKeyword();
    }

    private STNode parseTypeKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TYPE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPE_KEYWORD);
        return this.parseTypeKeyword();
    }

    private STNode parseTypeName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPE_NAME);
        return this.parseTypeName();
    }

    private STNode parseClassName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLASS_NAME);
        return this.parseClassName();
    }

    private STNode parseRecordTypeDescriptor() {
        STNode field;
        this.startContext(ParserRuleContext.RECORD_TYPE_DESCRIPTOR);
        STNode recordKeyword = this.parseRecordKeyword();
        STNode bodyStartDelimiter = this.parseRecordBodyStartDelimiter();
        ArrayList<STNode> recordFields = new ArrayList<STNode>();
        STToken token = this.peek();
        STNode recordRestDescriptor = STNodeFactory.createEmptyNode();
        while (!this.isEndOfRecordTypeNode(token.kind) && (field = this.parseFieldOrRestDescriptor()) != null) {
            token = this.peek();
            if (field.kind == SyntaxKind.RECORD_REST_TYPE && bodyStartDelimiter.kind == SyntaxKind.OPEN_BRACE_TOKEN) {
                if (recordFields.isEmpty()) {
                    bodyStartDelimiter = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(bodyStartDelimiter, field, (DiagnosticCode)DiagnosticErrorCode.ERROR_INCLUSIVE_RECORD_TYPE_CANNOT_CONTAIN_REST_FIELD, new Object[0]);
                    continue;
                }
                this.updateLastNodeInListWithInvalidNode(recordFields, field, DiagnosticErrorCode.ERROR_INCLUSIVE_RECORD_TYPE_CANNOT_CONTAIN_REST_FIELD, new Object[0]);
                continue;
            }
            if (field.kind == SyntaxKind.RECORD_REST_TYPE) {
                STNode invalidField;
                recordRestDescriptor = field;
                while (!this.isEndOfRecordTypeNode(token.kind) && (invalidField = this.parseFieldOrRestDescriptor()) != null) {
                    recordRestDescriptor = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(recordRestDescriptor, invalidField, (DiagnosticCode)DiagnosticErrorCode.ERROR_MORE_RECORD_FIELDS_AFTER_REST_FIELD, new Object[0]);
                    token = this.peek();
                }
                break;
            }
            recordFields.add(field);
        }
        STNode fields = STNodeFactory.createNodeList(recordFields);
        STNode bodyEndDelimiter = this.parseRecordBodyCloseDelimiter(bodyStartDelimiter.kind);
        this.endContext();
        return STNodeFactory.createRecordTypeDescriptorNode(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter);
    }

    private STNode parseRecordBodyStartDelimiter() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.OPEN_BRACE_PIPE_TOKEN -> this.parseClosedRecordBodyStart();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseOpenBrace();
            default -> {
                this.recover(nextToken, ParserRuleContext.RECORD_BODY_START);
                yield this.parseRecordBodyStartDelimiter();
            }
        };
    }

    private STNode parseClosedRecordBodyStart() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACE_PIPE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSED_RECORD_BODY_START);
        return this.parseClosedRecordBodyStart();
    }

    private STNode parseRecordBodyCloseDelimiter(SyntaxKind startingDelimeter) {
        if (startingDelimeter == SyntaxKind.OPEN_BRACE_PIPE_TOKEN) {
            return this.parseClosedRecordBodyEnd();
        }
        return this.parseCloseBrace();
    }

    private STNode parseClosedRecordBodyEnd() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACE_PIPE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSED_RECORD_BODY_END);
        return this.parseClosedRecordBodyEnd();
    }

    private STNode parseRecordKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RECORD_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RECORD_KEYWORD);
        return this.parseRecordKeyword();
    }

    private STNode parseFieldOrRestDescriptor() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACE_PIPE_TOKEN: {
                return null;
            }
            case ASTERISK_TOKEN: {
                this.startContext(ParserRuleContext.RECORD_FIELD);
                STToken asterisk = this.consume();
                STNode type = this.parseTypeReferenceInTypeInclusion();
                STNode semicolonToken = this.parseSemicolon();
                this.endContext();
                return STNodeFactory.createTypeReferenceNode(asterisk, type, semicolonToken);
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                return this.parseRecordField();
            }
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseRecordField();
        }
        this.recover(this.peek(), ParserRuleContext.RECORD_FIELD_OR_RECORD_END);
        return this.parseFieldOrRestDescriptor();
    }

    private STNode parseRecordField() {
        this.startContext(ParserRuleContext.RECORD_FIELD);
        STNode metadata = this.parseMetaData();
        STNode fieldOrRestDesc = this.parseRecordField(this.peek(), metadata);
        this.endContext();
        return fieldOrRestDesc;
    }

    private STNode parseRecordField(STToken nextToken, STNode metadata) {
        STNode type;
        if (nextToken.kind != SyntaxKind.READONLY_KEYWORD) {
            STNode type2 = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD);
            return this.parseFieldOrRestDescriptorRhs(metadata, type2);
        }
        STNode readOnlyQualifier = this.parseReadonlyKeyword();
        nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STNode fieldNameOrTypeDesc = this.parseQualifiedIdentifier(ParserRuleContext.RECORD_FIELD_NAME_OR_TYPE_NAME);
            if (fieldNameOrTypeDesc.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                type = fieldNameOrTypeDesc;
            } else {
                nextToken = this.peek();
                switch (nextToken.kind) {
                    case EQUAL_TOKEN: 
                    case SEMICOLON_TOKEN: {
                        STNode type3 = BallerinaParser.createBuiltinSimpleNameReference(readOnlyQualifier);
                        readOnlyQualifier = STNodeFactory.createEmptyNode();
                        STNode fieldName = ((STSimpleNameReferenceNode)fieldNameOrTypeDesc).name;
                        return this.parseFieldDescriptorRhs(metadata, readOnlyQualifier, type3, fieldName);
                    }
                }
                type = this.parseComplexTypeDescriptor(fieldNameOrTypeDesc, ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD, false);
            }
        } else {
            if (nextToken.kind == SyntaxKind.ELLIPSIS_TOKEN) {
                STNode type4 = BallerinaParser.createBuiltinSimpleNameReference(readOnlyQualifier);
                return this.parseFieldOrRestDescriptorRhs(metadata, type4);
            }
            if (this.isTypeStartingToken(nextToken.kind)) {
                type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD);
            } else {
                readOnlyQualifier = BallerinaParser.createBuiltinSimpleNameReference(readOnlyQualifier);
                type = this.parseComplexTypeDescriptor(readOnlyQualifier, ParserRuleContext.TYPE_DESC_IN_RECORD_FIELD, false);
                readOnlyQualifier = STNodeFactory.createEmptyNode();
            }
        }
        return this.parseIndividualRecordField(metadata, readOnlyQualifier, type);
    }

    private STNode parseIndividualRecordField(STNode metadata, STNode readOnlyQualifier, STNode type) {
        STNode fieldName = this.parseVariableName();
        return this.parseFieldDescriptorRhs(metadata, readOnlyQualifier, type, fieldName);
    }

    private STNode parseTypeReferenceInTypeInclusion() {
        STNode typeReference = this.parseTypeDescriptor(ParserRuleContext.TYPE_REFERENCE_IN_TYPE_INCLUSION);
        if (typeReference.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            if (typeReference.hasDiagnostics()) {
                STNode emptyNameReference = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER));
                return emptyNameReference;
            }
            return typeReference;
        }
        if (typeReference.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return typeReference;
        }
        STNode emptyNameReference = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
        emptyNameReference = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(emptyNameReference, typeReference, (DiagnosticCode)DiagnosticErrorCode.ERROR_ONLY_TYPE_REFERENCE_ALLOWED_AS_TYPE_INCLUSIONS, new Object[0]);
        return emptyNameReference;
    }

    private STNode parseTypeReference() {
        return this.parseTypeReference(false);
    }

    private STNode parseTypeReference(boolean isInConditionalExpr) {
        return this.parseQualifiedIdentifier(ParserRuleContext.TYPE_REFERENCE, isInConditionalExpr);
    }

    private STNode parseQualifiedIdentifier(ParserRuleContext currentCtx) {
        return this.parseQualifiedIdentifier(currentCtx, false);
    }

    private STNode parseQualifiedIdentifier(ParserRuleContext currentCtx, boolean isInConditionalExpr) {
        STToken typeRefOrPkgRef;
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            typeRefOrPkgRef = this.consume();
        } else if (this.isQualifiedIdentifierPredeclaredPrefix(token.kind)) {
            STToken preDeclaredPrefix = this.consume();
            typeRefOrPkgRef = STNodeFactory.createIdentifierToken(preDeclaredPrefix.text(), preDeclaredPrefix.leadingMinutiae(), preDeclaredPrefix.trailingMinutiae());
        } else {
            this.recover(token, currentCtx);
            if (this.peek().kind != SyntaxKind.IDENTIFIER_TOKEN) {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseQualifiedIdentifier(currentCtx, isInConditionalExpr);
            }
            typeRefOrPkgRef = this.consume();
        }
        return this.parseQualifiedIdentifier(typeRefOrPkgRef, isInConditionalExpr);
    }

    private STNode parseQualifiedIdentifier(STNode identifier, boolean isInConditionalExpr) {
        STToken nextToken = this.peek(1);
        if (nextToken.kind != SyntaxKind.COLON_TOKEN) {
            return STNodeFactory.createSimpleNameReferenceNode(identifier);
        }
        if (isInConditionalExpr && (this.hasTrailingMinutiae(identifier) || this.hasTrailingMinutiae(nextToken))) {
            return ConditionalExprResolver.getSimpleNameRefNode(identifier);
        }
        STToken nextNextToken = this.peek(2);
        switch (nextNextToken.kind) {
            case IDENTIFIER_TOKEN: {
                STToken colon = this.consume();
                STToken varOrFuncName = this.consume();
                return this.createQualifiedNameReferenceNode(identifier, colon, varOrFuncName);
            }
            case COLON_TOKEN: {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseQualifiedIdentifier(identifier, isInConditionalExpr);
            }
        }
        if (nextNextToken.kind == SyntaxKind.MAP_KEYWORD && this.peek((int)3).kind != SyntaxKind.LT_TOKEN) {
            STToken colon = this.consume();
            STToken mapKeyword = this.consume();
            STToken refName = STNodeFactory.createIdentifierToken(mapKeyword.text(), mapKeyword.leadingMinutiae(), mapKeyword.trailingMinutiae(), mapKeyword.diagnostics());
            return this.createQualifiedNameReferenceNode(identifier, colon, refName);
        }
        if (isInConditionalExpr) {
            return ConditionalExprResolver.getSimpleNameRefNode(identifier);
        }
        STToken colon = this.consume();
        STToken varOrFuncName = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER);
        return this.createQualifiedNameReferenceNode(identifier, colon, varOrFuncName);
    }

    private STNode createQualifiedNameReferenceNode(STNode identifier, STNode colon, STNode varOrFuncName) {
        if (this.hasTrailingMinutiae(identifier) || this.hasTrailingMinutiae(colon)) {
            colon = SyntaxErrors.addDiagnostic(colon, DiagnosticErrorCode.ERROR_INTERVENING_WHITESPACES_ARE_NOT_ALLOWED, new Object[0]);
        }
        return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, varOrFuncName);
    }

    private STNode parseFieldOrRestDescriptorRhs(STNode metadata, STNode type) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                this.reportInvalidMetaData(metadata, "record rest descriptor");
                STNode ellipsis = this.parseEllipsis();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordRestDescriptorNode(type, ellipsis, semicolonToken);
            }
            case IDENTIFIER_TOKEN: {
                STNode readonlyQualifier = STNodeFactory.createEmptyNode();
                return this.parseIndividualRecordField(metadata, readonlyQualifier, type);
            }
        }
        this.recover(nextToken, ParserRuleContext.FIELD_OR_REST_DESCIPTOR_RHS);
        return this.parseFieldOrRestDescriptorRhs(metadata, type);
    }

    private STNode parseFieldDescriptorRhs(STNode metadata, STNode readonlyQualifier, STNode type, STNode fieldName) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SEMICOLON_TOKEN: {
                STNode questionMarkToken = STNodeFactory.createEmptyNode();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordFieldNode(metadata, readonlyQualifier, type, fieldName, questionMarkToken, semicolonToken);
            }
            case QUESTION_MARK_TOKEN: {
                STNode questionMarkToken = this.parseQuestionMark();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordFieldNode(metadata, readonlyQualifier, type, fieldName, questionMarkToken, semicolonToken);
            }
            case EQUAL_TOKEN: {
                STNode equalsToken = this.parseAssignOp();
                STNode expression = this.parseExpression();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createRecordFieldWithDefaultValueNode(metadata, readonlyQualifier, type, fieldName, equalsToken, expression, semicolonToken);
            }
        }
        this.recover(nextToken, ParserRuleContext.FIELD_DESCRIPTOR_RHS);
        return this.parseFieldDescriptorRhs(metadata, readonlyQualifier, type, fieldName);
    }

    private STNode parseQuestionMark() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.QUESTION_MARK_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.QUESTION_MARK);
        return this.parseQuestionMark();
    }

    private STNode parseStatements() {
        ArrayList<STNode> stmts = new ArrayList<STNode>();
        return this.parseStatements(stmts);
    }

    private STNode parseStatements(ArrayList<STNode> stmts) {
        STNode stmt;
        while (!this.isEndOfStatements() && (stmt = this.parseStatement()) != null) {
            if (stmt.kind == SyntaxKind.NAMED_WORKER_DECLARATION) {
                this.addInvalidNodeToNextToken(stmt, DiagnosticErrorCode.ERROR_NAMED_WORKER_NOT_ALLOWED_HERE, new Object[0]);
                continue;
            }
            if (this.validateStatement(stmt)) continue;
            stmts.add(stmt);
        }
        return STNodeFactory.createNodeList(stmts);
    }

    protected STNode parseStatement() {
        STToken nextToken = this.peek();
        STNode annots = STNodeFactory.createEmptyNodeList();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
            case SEMICOLON_TOKEN: {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseStatement();
            }
            case AT_TOKEN: {
                annots = this.parseOptionalAnnotations();
                break;
            }
            default: {
                if (this.isStatementStartingToken(nextToken.kind)) break;
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.STATEMENT);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) break;
                return this.parseStatement();
            }
        }
        return this.parseStatement(annots);
    }

    boolean validateStatement(STNode statement) {
        return switch (statement.kind) {
            case SyntaxKind.LOCAL_TYPE_DEFINITION_STATEMENT -> {
                this.addInvalidNodeToNextToken(statement, DiagnosticErrorCode.ERROR_LOCAL_TYPE_DEFINITION_NOT_ALLOWED, new Object[0]);
                yield true;
            }
            case SyntaxKind.CONST_DECLARATION -> {
                this.addInvalidNodeToNextToken(statement, DiagnosticErrorCode.ERROR_LOCAL_CONST_DECL_NOT_ALLOWED, new Object[0]);
                yield true;
            }
            default -> false;
        };
    }

    private STNode getAnnotations(STNode nullbaleAnnot) {
        if (nullbaleAnnot != null) {
            return nullbaleAnnot;
        }
        return STNodeFactory.createEmptyNodeList();
    }

    private STNode parseStatement(STNode annots) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseStatement(annots, typeDescQualifiers);
    }

    private STNode parseStatement(STNode annots, List<STNode> qualifiers) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            return this.parseStmtStartsWithTypeOrExpr(this.getAnnotations(annots), qualifiers);
        }
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                STNode publicQualifier = STNodeFactory.createEmptyNode();
                return this.createMissingSimpleVarDecl(this.getAnnotations(annots), publicQualifier, qualifiers, false);
            }
            case SEMICOLON_TOKEN: {
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseStatement(annots, qualifiers);
            }
            case FINAL_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STToken finalKeyword = this.consume();
                return this.parseVariableDecl(this.getAnnotations(annots), finalKeyword);
            }
            case IF_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseIfElseBlock();
            }
            case WHILE_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseWhileStatement();
            }
            case DO_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseDoStatement();
            }
            case PANIC_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parsePanicStatement();
            }
            case CONTINUE_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseContinueStatement();
            }
            case BREAK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseBreakStatement();
            }
            case RETURN_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseReturnStatement();
            }
            case FAIL_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseFailStatement();
            }
            case TYPE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseLocalTypeDefinitionStatement(this.getAnnotations(annots));
            }
            case CONST_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseConstantDeclaration(annots, STNodeFactory.createEmptyNode());
            }
            case LOCK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseLockStatement();
            }
            case OPEN_BRACE_TOKEN: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseStatementStartsWithOpenBrace();
            }
            case WORKER_KEYWORD: {
                return this.parseNamedWorkerDeclaration(this.getAnnotations(annots), qualifiers);
            }
            case FORK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseForkStatement();
            }
            case FOREACH_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseForEachStatement();
            }
            case START_KEYWORD: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case FLUSH_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case WAIT_KEYWORD: 
            case FROM_KEYWORD: 
            case COMMIT_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseExpressionStatement(this.getAnnotations(annots));
            }
            case XMLNS_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseXMLNamespaceDeclaration(false);
            }
            case TRANSACTION_KEYWORD: {
                return this.parseTransactionStmtOrVarDecl(annots, qualifiers, this.consume());
            }
            case RETRY_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRetryStatement();
            }
            case ROLLBACK_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRollbackStatement();
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseStatementStartsWithOpenBracket(this.getAnnotations(annots), false);
            }
            case FUNCTION_KEYWORD: 
            case OPEN_PAREN_TOKEN: 
            case XML_KEYWORD: 
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: 
            case STRING_KEYWORD: {
                return this.parseStmtStartsWithTypeOrExpr(this.getAnnotations(annots), qualifiers);
            }
            case MATCH_KEYWORD: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMatchStatement();
            }
            case ERROR_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseErrorTypeDescOrErrorBP(this.getAnnotations(annots));
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseStatementStartWithExpr(this.getAnnotations(annots));
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            STNode publicQualifier = STNodeFactory.createEmptyNode();
            return this.parseVariableDecl(this.getAnnotations(annots), publicQualifier, new ArrayList<STNode>(), qualifiers, false);
        }
        STToken token = this.peek();
        AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.STATEMENT_WITHOUT_ANNOTS);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            this.reportInvalidQualifierList(qualifiers);
            STNode finalKeyword = STNodeFactory.createEmptyNode();
            return this.parseVariableDecl(this.getAnnotations(annots), finalKeyword);
        }
        return this.parseStatement(annots, qualifiers);
    }

    private STNode parseVariableDecl(STNode annots, STNode finalKeyword) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        ArrayList<STNode> varDecQualifiers = new ArrayList<STNode>();
        if (finalKeyword != null) {
            varDecQualifiers.add(finalKeyword);
        }
        STNode publicQualifier = STNodeFactory.createEmptyNode();
        return this.parseVariableDecl(annots, publicQualifier, varDecQualifiers, typeDescQualifiers, false);
    }

    private STNode parseVariableDecl(STNode annots, STNode publicQualifier, List<STNode> varDeclQuals, List<STNode> typeDescQualifiers, boolean isModuleVar) {
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        STNode typeBindingPattern = this.parseTypedBindingPattern(typeDescQualifiers, ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(annots, publicQualifier, varDeclQuals, typeBindingPattern, isModuleVar);
    }

    private STNode parseVarDeclTypeDescRhs(STNode typeDesc, STNode metadata, List<STNode> qualifiers, boolean isTypedBindingPattern, boolean isModuleVar) {
        STNode publicQualifier = STNodeFactory.createEmptyNode();
        return this.parseVarDeclTypeDescRhs(typeDesc, metadata, publicQualifier, qualifiers, isTypedBindingPattern, isModuleVar);
    }

    private STNode parseVarDeclTypeDescRhs(STNode typeDesc, STNode metadata, STNode publicQual, List<STNode> qualifiers, boolean isTypedBindingPattern, boolean isModuleVar) {
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        typeDesc = this.parseComplexTypeDescriptor(typeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, isTypedBindingPattern);
        STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(metadata, publicQual, qualifiers, typedBindingPattern, isModuleVar);
    }

    private STNode parseVarDeclRhs(STNode metadata, List<STNode> varDeclQuals, STNode typedBindingPattern, boolean isModuleVar) {
        STNode publicQualifier = STNodeFactory.createEmptyNode();
        return this.parseVarDeclRhs(metadata, publicQualifier, varDeclQuals, typedBindingPattern, isModuleVar);
    }

    private STNode parseVarDeclRhs(STNode metadata, STNode publicQualifier, List<STNode> varDeclQuals, STNode typedBindingPattern, boolean isModuleVar) {
        SyntaxKind bindingPatternKind;
        STNode semicolon;
        STNode expr;
        STNode assign;
        boolean hasVarInit = false;
        boolean isConfigurable = false;
        if (isModuleVar && this.isSyntaxKindInList(varDeclQuals, SyntaxKind.CONFIGURABLE_KEYWORD)) {
            isConfigurable = true;
        }
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: {
                assign = this.parseAssignOp();
                expr = isModuleVar ? (isConfigurable ? this.parseConfigurableVarDeclRhs() : this.parseExpression()) : this.parseActionOrExpression();
                semicolon = this.parseSemicolon();
                hasVarInit = true;
                break;
            }
            case SEMICOLON_TOKEN: {
                assign = STNodeFactory.createEmptyNode();
                expr = STNodeFactory.createEmptyNode();
                semicolon = this.parseSemicolon();
                break;
            }
            default: {
                this.recover(nextToken, ParserRuleContext.VAR_DECL_STMT_RHS);
                return this.parseVarDeclRhs(metadata, publicQualifier, varDeclQuals, typedBindingPattern, isModuleVar);
            }
        }
        this.endContext();
        if (!hasVarInit && (bindingPatternKind = ((STTypedBindingPatternNode)typedBindingPattern).bindingPattern.kind) != SyntaxKind.CAPTURE_BINDING_PATTERN) {
            assign = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.EQUAL_TOKEN, DiagnosticErrorCode.ERROR_VARIABLE_DECL_HAVING_BP_MUST_BE_INITIALIZED);
            STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            expr = STNodeFactory.createSimpleNameReferenceNode(identifier);
        }
        if (isModuleVar) {
            return this.createModuleVarDeclaration(metadata, publicQualifier, varDeclQuals, typedBindingPattern, assign, expr, semicolon, isConfigurable, hasVarInit);
        }
        STNode finalKeyword = varDeclQuals.isEmpty() ? STNodeFactory.createEmptyNode() : varDeclQuals.get(0);
        assert (metadata.kind == SyntaxKind.LIST);
        return STNodeFactory.createVariableDeclarationNode(metadata, finalKeyword, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode parseConfigurableVarDeclRhs() {
        STNode expr;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case QUESTION_MARK_TOKEN: {
                expr = STNodeFactory.createRequiredExpressionNode(this.consume());
                break;
            }
            default: {
                if (this.isValidExprStart(nextToken.kind)) {
                    expr = this.parseExpression();
                    break;
                }
                this.recover(nextToken, ParserRuleContext.CONFIG_VAR_DECL_RHS);
                return this.parseConfigurableVarDeclRhs();
            }
        }
        return expr;
    }

    private STNode createModuleVarDeclaration(STNode metadata, STNode publicQualifier, List<STNode> varDeclQuals, STNode typedBindingPattern, STNode assign, STNode expr, STNode semicolon, boolean isConfigurable, boolean hasVarInit) {
        if (hasVarInit || varDeclQuals.isEmpty()) {
            return this.createModuleVarDeclaration(metadata, publicQualifier, varDeclQuals, typedBindingPattern, assign, expr, semicolon);
        }
        if (isConfigurable) {
            return this.createConfigurableModuleVarDeclWithMissingInitializer(metadata, publicQualifier, varDeclQuals, typedBindingPattern, semicolon);
        }
        STNode lastQualifier = this.getLastNodeInList(varDeclQuals);
        if (lastQualifier.kind == SyntaxKind.ISOLATED_KEYWORD) {
            lastQualifier = varDeclQuals.remove(varDeclQuals.size() - 1);
            typedBindingPattern = this.modifyTypedBindingPatternWithIsolatedQualifier(typedBindingPattern, lastQualifier);
        }
        return this.createModuleVarDeclaration(metadata, publicQualifier, varDeclQuals, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode createConfigurableModuleVarDeclWithMissingInitializer(STNode metadata, STNode publicQualifier, List<STNode> varDeclQuals, STNode typedBindingPattern, STNode semicolon) {
        STToken assign = SyntaxErrors.createMissingToken(SyntaxKind.EQUAL_TOKEN);
        assign = SyntaxErrors.addDiagnostic(assign, DiagnosticErrorCode.ERROR_CONFIGURABLE_VARIABLE_MUST_BE_INITIALIZED_OR_REQUIRED, new Object[0]);
        STToken questionMarkToken = SyntaxErrors.createMissingToken(SyntaxKind.QUESTION_MARK_TOKEN);
        STNode expr = STNodeFactory.createRequiredExpressionNode(questionMarkToken);
        return this.createModuleVarDeclaration(metadata, publicQualifier, varDeclQuals, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode createModuleVarDeclaration(STNode metadata, STNode publicQualifier, List<STNode> varDeclQuals, STNode typedBindingPattern, STNode assign, STNode expr, STNode semicolon) {
        if (publicQualifier != null) {
            if (((STTypedBindingPatternNode)typedBindingPattern).typeDescriptor.kind == SyntaxKind.VAR_TYPE_DESC) {
                if (!varDeclQuals.isEmpty()) {
                    this.updateFirstNodeInListWithLeadingInvalidNode(varDeclQuals, publicQualifier, DiagnosticErrorCode.ERROR_VARIABLE_DECLARED_WITH_VAR_CANNOT_BE_PUBLIC, new Object[0]);
                } else {
                    typedBindingPattern = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(typedBindingPattern, publicQualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_VARIABLE_DECLARED_WITH_VAR_CANNOT_BE_PUBLIC, new Object[0]);
                }
                publicQualifier = STNodeFactory.createEmptyNode();
            } else if (this.isSyntaxKindInList(varDeclQuals, SyntaxKind.ISOLATED_KEYWORD)) {
                this.updateFirstNodeInListWithLeadingInvalidNode(varDeclQuals, publicQualifier, DiagnosticErrorCode.ERROR_ISOLATED_VAR_CANNOT_BE_DECLARED_AS_PUBLIC, new Object[0]);
                publicQualifier = STNodeFactory.createEmptyNode();
            }
        }
        STNode varDeclQualifiersNode = STNodeFactory.createNodeList(varDeclQuals);
        return STNodeFactory.createModuleVariableDeclarationNode(metadata, publicQualifier, varDeclQualifiersNode, typedBindingPattern, assign, expr, semicolon);
    }

    private STNode createMissingSimpleVarDecl(boolean isModuleVar) {
        STNode metadata = isModuleVar ? STNodeFactory.createEmptyNode() : STNodeFactory.createEmptyNodeList();
        return this.createMissingSimpleVarDecl(metadata, isModuleVar);
    }

    private STNode createMissingSimpleVarDecl(STNode metadata, boolean isModuleVar) {
        STNode publicQualifier = STNodeFactory.createEmptyNode();
        return this.createMissingSimpleVarDecl(metadata, publicQualifier, new ArrayList<STNode>(), isModuleVar);
    }

    private STNode createMissingSimpleVarDecl(STNode metadata, STNode publicQualifier, List<STNode> qualifiers, boolean isModuleVar) {
        STNode emptyNode = STNodeFactory.createEmptyNode();
        STToken simpleTypeDescIdentifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_TYPE_DESC);
        STToken identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_VARIABLE_NAME);
        STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(simpleTypeDescIdentifier);
        STToken semicolon = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.SEMICOLON_TOKEN, DiagnosticErrorCode.ERROR_MISSING_SEMICOLON_TOKEN);
        STNode captureBP = STNodeFactory.createCaptureBindingPatternNode(identifier);
        STNode typedBindingPattern = STNodeFactory.createTypedBindingPatternNode(simpleNameRef, captureBP);
        if (isModuleVar) {
            List<STNode> varDeclQuals = this.extractVarDeclQualifiers(qualifiers, true);
            typedBindingPattern = this.modifyNodeWithInvalidTokenList(qualifiers, typedBindingPattern);
            if (this.isSyntaxKindInList(varDeclQuals, SyntaxKind.CONFIGURABLE_KEYWORD)) {
                return this.createConfigurableModuleVarDeclWithMissingInitializer(metadata, publicQualifier, varDeclQuals, typedBindingPattern, semicolon);
            }
            STNode varDeclQualNodeList = STNodeFactory.createNodeList(varDeclQuals);
            return STNodeFactory.createModuleVariableDeclarationNode(metadata, publicQualifier, varDeclQualNodeList, typedBindingPattern, emptyNode, emptyNode, semicolon);
        }
        typedBindingPattern = this.modifyNodeWithInvalidTokenList(qualifiers, typedBindingPattern);
        return STNodeFactory.createVariableDeclarationNode(metadata, emptyNode, typedBindingPattern, emptyNode, emptyNode, semicolon);
    }

    private STNode createMissingWhereClause() {
        STToken whereKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.WHERE_KEYWORD, DiagnosticErrorCode.ERROR_MISSING_WHERE_KEYWORD);
        STToken missingIdentifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_EXPRESSION);
        STNode missingExpr = STNodeFactory.createSimpleNameReferenceNode(missingIdentifier);
        return STNodeFactory.createWhereClauseNode(whereKeyword, missingExpr);
    }

    private STNode createMissingSimpleObjectField(STNode metadata, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        STNode emptyNode = STNodeFactory.createEmptyNode();
        STToken simpleTypeDescIdentifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_TYPE_DESC);
        STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(simpleTypeDescIdentifier);
        STToken identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_FIELD_NAME);
        STToken semicolon = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.SEMICOLON_TOKEN, DiagnosticErrorCode.ERROR_MISSING_SEMICOLON_TOKEN);
        List<STNode> objectFieldQualifiers = this.extractObjectFieldQualifiers(qualifiers, isObjectTypeDesc);
        STNode objectFieldQualNodeList = STNodeFactory.createNodeList(objectFieldQualifiers);
        simpleNameRef = this.modifyNodeWithInvalidTokenList(qualifiers, simpleNameRef);
        if (metadata != null) {
            metadata = this.addMetadataNotAttachedDiagnostic((STMetadataNode)metadata);
        }
        return STNodeFactory.createObjectFieldNode(metadata, emptyNode, objectFieldQualNodeList, simpleNameRef, identifier, emptyNode, emptyNode, semicolon);
    }

    private STNode createMissingSimpleObjectField() {
        STNode metadata = STNodeFactory.createEmptyNode();
        ArrayList<STNode> qualifiers = new ArrayList<STNode>();
        return this.createMissingSimpleObjectField(metadata, qualifiers, false);
    }

    private STNode modifyNodeWithInvalidTokenList(List<STNode> qualifiers, STNode node) {
        for (int i = qualifiers.size() - 1; i >= 0; --i) {
            STNode qualifier = qualifiers.get(i);
            node = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(node, qualifier);
        }
        return node;
    }

    private STNode modifyTypedBindingPatternWithIsolatedQualifier(STNode typedBindingPattern, STNode isolatedQualifier) {
        STTypedBindingPatternNode typedBindingPatternNode = (STTypedBindingPatternNode)typedBindingPattern;
        STNode typeDescriptor = typedBindingPatternNode.typeDescriptor;
        STNode bindingPattern = typedBindingPatternNode.bindingPattern;
        typeDescriptor = switch (typeDescriptor.kind) {
            case SyntaxKind.OBJECT_TYPE_DESC -> this.modifyObjectTypeDescWithALeadingQualifier(typeDescriptor, isolatedQualifier);
            case SyntaxKind.FUNCTION_TYPE_DESC -> this.modifyFuncTypeDescWithALeadingQualifier(typeDescriptor, isolatedQualifier);
            default -> SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(typeDescriptor, isolatedQualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)isolatedQualifier).text());
        };
        return STNodeFactory.createTypedBindingPatternNode(typeDescriptor, bindingPattern);
    }

    private STNode modifyObjectTypeDescWithALeadingQualifier(STNode objectTypeDesc, STNode newQualifier) {
        STObjectTypeDescriptorNode objectTypeDescriptorNode = (STObjectTypeDescriptorNode)objectTypeDesc;
        STNodeList qualifierList = (STNodeList)objectTypeDescriptorNode.objectTypeQualifiers;
        STNode newObjectTypeQualifiers = this.modifyNodeListWithALeadingQualifier(qualifierList, newQualifier);
        return objectTypeDescriptorNode.modify(newObjectTypeQualifiers, objectTypeDescriptorNode.objectKeyword, objectTypeDescriptorNode.openBrace, objectTypeDescriptorNode.members, objectTypeDescriptorNode.closeBrace);
    }

    private STNode modifyFuncTypeDescWithALeadingQualifier(STNode funcTypeDesc, STNode newQualifier) {
        STFunctionTypeDescriptorNode funcTypeDescriptorNode = (STFunctionTypeDescriptorNode)funcTypeDesc;
        STNode qualifierList = funcTypeDescriptorNode.qualifierList;
        STNode newfuncTypeQualifiers = this.modifyNodeListWithALeadingQualifier(qualifierList, newQualifier);
        return funcTypeDescriptorNode.modify(newfuncTypeQualifiers, funcTypeDescriptorNode.functionKeyword, funcTypeDescriptorNode.functionSignature);
    }

    private STNode modifyNodeListWithALeadingQualifier(STNode qualifiers, STNode newQualifier) {
        ArrayList<STNode> newQualifierList = new ArrayList<STNode>();
        newQualifierList.add(newQualifier);
        STNodeList qualifierNodeList = (STNodeList)qualifiers;
        for (int i = 0; i < qualifierNodeList.size(); ++i) {
            STNode qualifier = qualifierNodeList.get(i);
            if (qualifier.kind == newQualifier.kind) {
                this.updateLastNodeInListWithInvalidNode(newQualifierList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            newQualifierList.add(qualifier);
        }
        return STNodeFactory.createNodeList(newQualifierList);
    }

    private STNode parseAssignmentStmtRhs(STNode lvExpr) {
        boolean lvExprValid;
        STNode assign = this.parseAssignOp();
        STNode expr = this.parseActionOrExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        if (lvExpr.kind == SyntaxKind.ERROR_CONSTRUCTOR && this.isPossibleErrorBindingPattern((STErrorConstructorExpressionNode)lvExpr)) {
            lvExpr = this.getBindingPattern(lvExpr, false);
        }
        if (this.isWildcardBP(lvExpr)) {
            lvExpr = this.getWildcardBindingPattern(lvExpr);
        }
        if (!(lvExprValid = this.isValidLVExpr(lvExpr))) {
            STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
            lvExpr = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(simpleNameRef, lvExpr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_EXPR_IN_ASSIGNMENT_LHS, new Object[0]);
        }
        return STNodeFactory.createAssignmentStatementNode(lvExpr, assign, expr, semicolon);
    }

    protected STNode parseExpression() {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, true, false);
    }

    private STNode parseActionOrExpression() {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, true, true);
    }

    private STNode parseActionOrExpressionInLhs(STNode annots) {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, annots, false, true, false);
    }

    private STNode parseExpression(boolean isRhsExpr) {
        return this.parseExpression(DEFAULT_OP_PRECEDENCE, isRhsExpr, false);
    }

    private boolean isValidLVExpr(STNode expression) {
        return switch (expression.kind) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.LIST_BINDING_PATTERN, SyntaxKind.MAPPING_BINDING_PATTERN, SyntaxKind.ERROR_BINDING_PATTERN, SyntaxKind.WILDCARD_BINDING_PATTERN -> true;
            case SyntaxKind.FIELD_ACCESS -> this.isValidLVMemberExpr(((STFieldAccessExpressionNode)expression).expression);
            case SyntaxKind.INDEXED_EXPRESSION -> this.isValidLVMemberExpr(((STIndexedExpressionNode)expression).containerExpression);
            default -> expression instanceof STMissingToken;
        };
    }

    private boolean isValidLVMemberExpr(STNode expression) {
        return switch (expression.kind) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.QUALIFIED_NAME_REFERENCE -> true;
            case SyntaxKind.FIELD_ACCESS -> this.isValidLVMemberExpr(((STFieldAccessExpressionNode)expression).expression);
            case SyntaxKind.INDEXED_EXPRESSION -> this.isValidLVMemberExpr(((STIndexedExpressionNode)expression).containerExpression);
            case SyntaxKind.BRACED_EXPRESSION -> this.isValidLVMemberExpr(((STBracedExpressionNode)expression).expression);
            default -> expression instanceof STMissingToken;
        };
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, boolean isRhsExpr, boolean allowActions) {
        return this.parseExpression(precedenceLevel, isRhsExpr, allowActions, false);
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        return this.parseExpression(precedenceLevel, isRhsExpr, allowActions, false, isInConditionalExpr);
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STNode expr = this.parseTerminalExpression(isRhsExpr, allowActions, isInConditionalExpr);
        return this.parseExpressionRhs(precedenceLevel, expr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
    }

    private STNode invalidateActionAndGetMissingExpr(STNode node) {
        STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
        identifier = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(identifier, node, (DiagnosticCode)DiagnosticErrorCode.ERROR_EXPRESSION_EXPECTED_ACTION_FOUND, new Object[0]);
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseExpression(OperatorPrecedence precedenceLevel, STNode annots, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode expr = this.parseTerminalExpression(annots, isRhsExpr, allowActions, isInConditionalExpr);
        return this.parseExpressionRhs(precedenceLevel, expr, isRhsExpr, allowActions, false, isInConditionalExpr);
    }

    private STNode parseTerminalExpression(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode annots = STNodeFactory.createEmptyNodeList();
        if (this.peek().kind == SyntaxKind.AT_TOKEN) {
            annots = this.parseOptionalAnnotations();
        }
        return this.parseTerminalExpression(annots, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private STNode parseTerminalExpression(STNode annots, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        ArrayList<STNode> qualifiers = new ArrayList<STNode>();
        return this.parseTerminalExpression(annots, qualifiers, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private STNode parseTerminalExpression(STNode annots, List<STNode> qualifiers, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        this.parseExprQualifiers(qualifiers);
        STToken nextToken = this.peek();
        STNodeList annotNodeList = (STNodeList)annots;
        if (!annotNodeList.isEmpty() && !this.isAnnotAllowedExprStart(nextToken)) {
            annots = this.addAnnotNotAttachedDiagnostic(annotNodeList);
            STNode qualifierNodeList = this.createObjectTypeQualNodeList(qualifiers);
            return this.createMissingObjectConstructor(annots, qualifierNodeList);
        }
        this.validateExprAnnotsAndQualifiers(nextToken, annots, qualifiers);
        if (this.isQualifiedIdentifierPredeclaredPrefix(nextToken.kind)) {
            return this.parseQualifiedIdentifierOrExpression(isInConditionalExpr, isRhsExpr, allowActions);
        }
        switch (nextToken.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case IDENTIFIER_TOKEN: {
                return this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF, isInConditionalExpr);
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseBracedExpression(isRhsExpr, allowActions);
            }
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: {
                return this.parseCheckExpression(isRhsExpr, allowActions, isInConditionalExpr);
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingConstructorExpr();
            }
            case TYPEOF_KEYWORD: {
                return this.parseTypeofExpression(isRhsExpr, isInConditionalExpr);
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case NEGATION_TOKEN: 
            case EXCLAMATION_MARK_TOKEN: {
                return this.parseUnaryExpression(isRhsExpr, isInConditionalExpr);
            }
            case TRAP_KEYWORD: {
                return this.parseTrapExpression(isRhsExpr, allowActions, isInConditionalExpr);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseListConstructorExpr();
            }
            case LT_TOKEN: {
                return this.parseTypeCastExpr(isRhsExpr, allowActions, isInConditionalExpr);
            }
            case MAP_KEYWORD: 
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: 
            case FROM_KEYWORD: {
                return this.parseTableConstructorOrQuery(isRhsExpr, allowActions);
            }
            case ERROR_KEYWORD: {
                return this.parseErrorConstructorExpr(this.consume());
            }
            case LET_KEYWORD: {
                return this.parseLetExpression(isRhsExpr, isInConditionalExpr);
            }
            case BACKTICK_TOKEN: {
                return this.parseTemplateExpression();
            }
            case OBJECT_KEYWORD: {
                return this.parseObjectConstructorExpression(annots, qualifiers);
            }
            case XML_KEYWORD: {
                return this.parseXMLTemplateExpression();
            }
            case RE_KEYWORD: {
                return this.parseRegExpTemplateExpression();
            }
            case STRING_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseStringTemplateExpression();
                }
                return this.parseSimpleTypeInTerminalExpr();
            }
            case FUNCTION_KEYWORD: {
                return this.parseExplicitFunctionExpression(annots, qualifiers, isRhsExpr);
            }
            case NEW_KEYWORD: {
                return this.parseNewExpression();
            }
            case START_KEYWORD: {
                return this.parseStartAction(annots);
            }
            case FLUSH_KEYWORD: {
                return this.parseFlushAction();
            }
            case LEFT_ARROW_TOKEN: {
                return this.parseReceiveAction();
            }
            case WAIT_KEYWORD: {
                return this.parseWaitAction();
            }
            case COMMIT_KEYWORD: {
                return this.parseCommitAction();
            }
            case TRANSACTIONAL_KEYWORD: {
                return this.parseTransactionalExpression();
            }
            case BASE16_KEYWORD: 
            case BASE64_KEYWORD: {
                return this.parseByteArrayLiteral();
            }
            case TRANSACTION_KEYWORD: {
                return this.parseQualifiedIdentWithTransactionPrefix(ParserRuleContext.VARIABLE_REF);
            }
            case NATURAL_KEYWORD: {
                return this.parseNaturalExpression();
            }
            case CONST_KEYWORD: {
                if (this.getNextNextToken().kind != SyntaxKind.NATURAL_KEYWORD) break;
                return this.parseNaturalExpression();
            }
        }
        if (this.isSimpleTypeInExpression(nextToken.kind)) {
            return this.parseSimpleTypeInTerminalExpr();
        }
        this.recover(nextToken, ParserRuleContext.TERMINAL_EXPRESSION);
        return this.parseTerminalExpression(annots, qualifiers, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private STNode parseNaturalExpression() {
        this.startContext(ParserRuleContext.NATURAL_EXPRESSION);
        STNode optionalConstKeyword = this.peek().kind == SyntaxKind.CONST_KEYWORD ? this.consume() : STNodeFactory.createEmptyNode();
        STToken naturalKeyword = this.consume();
        STNode optionalParenthesizedArgList = this.parseOptionalParenthesizedArgList();
        STNode openBrace = this.parseOpenBrace();
        if (openBrace.isMissing()) {
            this.endContext();
            return this.createMissingNaturalExpressionNode(optionalConstKeyword, naturalKeyword, optionalParenthesizedArgList);
        }
        this.tokenReader.startMode(ParserMode.PROMPT);
        STNode prompt = this.parsePromptContent();
        STNode closeBrace = this.parseCloseBrace();
        if (this.tokenReader.getCurrentMode() == ParserMode.PROMPT) {
            this.tokenReader.endMode();
        }
        this.endContext();
        return STNodeFactory.createNaturalExpressionNode(optionalConstKeyword, naturalKeyword, optionalParenthesizedArgList, openBrace, prompt, closeBrace);
    }

    private STNode createMissingNaturalExpressionNode(STNode optionalConstKeyword, STNode naturalKeyword, STNode optionalParenthesizedArgList) {
        STToken openBrace = SyntaxErrors.createMissingToken(SyntaxKind.OPEN_BRACE_TOKEN);
        STToken closeBrace = SyntaxErrors.createMissingToken(SyntaxKind.CLOSE_BRACE_TOKEN);
        STNode prompt = STAbstractNodeFactory.createEmptyNodeList();
        STNode naturalExpr = STNodeFactory.createNaturalExpressionNode(optionalConstKeyword, naturalKeyword, optionalParenthesizedArgList, openBrace, prompt, closeBrace);
        naturalExpr = SyntaxErrors.addDiagnostic(naturalExpr, DiagnosticErrorCode.ERROR_MISSING_NATURAL_PROMPT_BLOCK, new Object[0]);
        return naturalExpr;
    }

    private STNode parseOptionalParenthesizedArgList() {
        return this.peek().kind == SyntaxKind.OPEN_PAREN_TOKEN ? this.parseParenthesizedArgList() : STNodeFactory.createEmptyNode();
    }

    private STNode parsePromptContent() {
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfPromptContent(nextToken.kind)) {
            STNode contentItem = this.parsePromptItem();
            items.add(contentItem);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(items);
    }

    private boolean isEndOfPromptContent(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parsePromptItem() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            return this.parseInterpolation();
        }
        if (nextToken.kind != SyntaxKind.PROMPT_CONTENT) {
            nextToken = this.consume();
            return STNodeFactory.createLiteralValueToken(SyntaxKind.PROMPT_CONTENT, nextToken.text(), nextToken.leadingMinutiae(), nextToken.trailingMinutiae(), nextToken.diagnostics());
        }
        return this.consume();
    }

    private STNode createMissingObjectConstructor(STNode annots, STNode qualifierNodeList) {
        STToken objectKeyword = SyntaxErrors.createMissingToken(SyntaxKind.OBJECT_KEYWORD);
        STToken openBrace = SyntaxErrors.createMissingToken(SyntaxKind.OPEN_BRACE_TOKEN);
        STToken closeBrace = SyntaxErrors.createMissingToken(SyntaxKind.CLOSE_BRACE_TOKEN);
        STNode objConstructor = STNodeFactory.createObjectConstructorExpressionNode(annots, qualifierNodeList, objectKeyword, STNodeFactory.createEmptyNode(), openBrace, STNodeFactory.createEmptyNodeList(), closeBrace);
        objConstructor = SyntaxErrors.addDiagnostic(objConstructor, DiagnosticErrorCode.ERROR_MISSING_OBJECT_CONSTRUCTOR_EXPRESSION, new Object[0]);
        return objConstructor;
    }

    private STNode parseQualifiedIdentifierOrExpression(boolean isInConditionalExpr, boolean isRhsExpr, boolean allowActions) {
        STNode tableOrQuery;
        ParserRuleContext context;
        STToken preDeclaredPrefix = this.consume();
        STToken nextNextToken = this.getNextNextToken();
        if (nextNextToken.kind == SyntaxKind.IDENTIFIER_TOKEN && !BallerinaParser.isKeyKeyword(nextNextToken)) {
            return this.parseQualifiedIdentifierWithPredeclPrefix(preDeclaredPrefix, isInConditionalExpr);
        }
        switch (preDeclaredPrefix.kind) {
            case TABLE_KEYWORD: {
                context = ParserRuleContext.TABLE_CONS_OR_QUERY_EXPR_OR_VAR_REF;
                break;
            }
            case STREAM_KEYWORD: {
                context = ParserRuleContext.QUERY_EXPR_OR_VAR_REF;
                break;
            }
            case ERROR_KEYWORD: {
                context = ParserRuleContext.ERROR_CONS_EXPR_OR_VAR_REF;
                break;
            }
            default: {
                return this.parseQualifiedIdentifierWithPredeclPrefix(preDeclaredPrefix, isInConditionalExpr);
            }
        }
        AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), context);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            return this.parseQualifiedIdentifierWithPredeclPrefix(preDeclaredPrefix, isInConditionalExpr);
        }
        if (preDeclaredPrefix.kind == SyntaxKind.ERROR_KEYWORD) {
            return this.parseErrorConstructorExpr(preDeclaredPrefix);
        }
        this.startContext(ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_EXPRESSION);
        if (preDeclaredPrefix.kind == SyntaxKind.STREAM_KEYWORD) {
            STNode queryConstructType = this.parseQueryConstructType(preDeclaredPrefix, null);
            tableOrQuery = this.parseQueryExprRhs(queryConstructType, isRhsExpr, allowActions);
        } else {
            tableOrQuery = this.parseTableConstructorOrQuery(preDeclaredPrefix, isRhsExpr, allowActions);
        }
        this.endContext();
        return tableOrQuery;
    }

    private void validateExprAnnotsAndQualifiers(STToken nextToken, STNode annots, List<STNode> qualifiers) {
        switch (nextToken.kind) {
            case START_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                break;
            }
            case AT_TOKEN: 
            case FUNCTION_KEYWORD: 
            case OBJECT_KEYWORD: {
                break;
            }
            default: {
                if (!this.isValidExprStart(nextToken.kind)) break;
                this.reportInvalidExpressionAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
            }
        }
    }

    private boolean isAnnotAllowedExprStart(STToken nextToken) {
        return switch (nextToken.kind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.OBJECT_KEYWORD, SyntaxKind.START_KEYWORD -> true;
            default -> false;
        };
    }

    private boolean isValidExprStart(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.AT_TOKEN, SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.TRANSACTIONAL_KEYWORD, SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.CLIENT_KEYWORD, SyntaxKind.SERVICE_KEYWORD, SyntaxKind.IDENTIFIER_TOKEN, SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.ERROR_KEYWORD, SyntaxKind.OBJECT_KEYWORD, SyntaxKind.OPEN_PAREN_TOKEN, SyntaxKind.STREAM_KEYWORD, SyntaxKind.TABLE_KEYWORD, SyntaxKind.XML_KEYWORD, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.START_KEYWORD, SyntaxKind.CHECK_KEYWORD, SyntaxKind.CHECKPANIC_KEYWORD, SyntaxKind.TRAP_KEYWORD, SyntaxKind.FLUSH_KEYWORD, SyntaxKind.LEFT_ARROW_TOKEN, SyntaxKind.WAIT_KEYWORD, SyntaxKind.FROM_KEYWORD, SyntaxKind.COMMIT_KEYWORD, SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.STRING_LITERAL_TOKEN, SyntaxKind.NULL_KEYWORD, SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD, SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.STRING_KEYWORD, SyntaxKind.TYPEOF_KEYWORD, SyntaxKind.NEGATION_TOKEN, SyntaxKind.EXCLAMATION_MARK_TOKEN, SyntaxKind.LET_KEYWORD, SyntaxKind.RE_KEYWORD, SyntaxKind.NEW_KEYWORD, SyntaxKind.BASE16_KEYWORD, SyntaxKind.BASE64_KEYWORD, SyntaxKind.NATURAL_KEYWORD -> true;
            default -> BallerinaParser.isPredeclaredPrefix(tokenKind) ? true : this.isSimpleTypeInExpression(tokenKind);
        };
    }

    private STNode parseNewExpression() {
        STNode newKeyword = this.parseNewKeyword();
        return this.parseNewKeywordRhs(newKeyword);
    }

    private STNode parseNewKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.NEW_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.NEW_KEYWORD);
        return this.parseNewKeyword();
    }

    private STNode parseNewKeywordRhs(STNode newKeyword) {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            return this.parseImplicitNewExpr(newKeyword);
        }
        if (this.isClassDescriptorStartToken(nextToken.kind)) {
            return this.parseExplicitNewExpr(newKeyword);
        }
        return this.createImplicitNewExpr(newKeyword, STNodeFactory.createEmptyNode());
    }

    private boolean isClassDescriptorStartToken(SyntaxKind tokenKind) {
        return tokenKind == SyntaxKind.STREAM_KEYWORD || this.isPredeclaredIdentifier(tokenKind);
    }

    private STNode parseExplicitNewExpr(STNode newKeyword) {
        STNode typeDescriptor = this.parseClassDescriptor();
        STNode parenthesizedArgsList = this.parseParenthesizedArgList();
        return STNodeFactory.createExplicitNewExpressionNode(newKeyword, typeDescriptor, parenthesizedArgsList);
    }

    private STNode parseClassDescriptor() {
        STNode classDescriptor;
        this.startContext(ParserRuleContext.CLASS_DESCRIPTOR_IN_NEW_EXPR);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case STREAM_KEYWORD: {
                classDescriptor = this.parseStreamTypeDescriptor(this.consume());
                break;
            }
            default: {
                if (this.isPredeclaredIdentifier(nextToken.kind)) {
                    classDescriptor = this.parseTypeReference();
                    break;
                }
                this.recover(nextToken, ParserRuleContext.CLASS_DESCRIPTOR);
                return this.parseClassDescriptor();
            }
        }
        this.endContext();
        return classDescriptor;
    }

    private STNode parseImplicitNewExpr(STNode newKeyword) {
        STNode parenthesizedArgList = this.parseParenthesizedArgList();
        return this.createImplicitNewExpr(newKeyword, parenthesizedArgList);
    }

    private STNode createImplicitNewExpr(STNode newKeyword, STNode parenthesizedArgList) {
        return STNodeFactory.createImplicitNewExpressionNode(newKeyword, parenthesizedArgList);
    }

    private STNode parseParenthesizedArgList() {
        STNode openParan = this.parseArgListOpenParenthesis();
        STNode arguments = this.parseArgsList();
        STNode closeParan = this.parseArgListCloseParenthesis();
        return STNodeFactory.createParenthesizedArgList(openParan, arguments, closeParan);
    }

    private STNode parseExpressionRhs(OperatorPrecedence precedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions) {
        return this.parseExpressionRhs(precedenceLevel, lhsExpr, isRhsExpr, allowActions, false, false);
    }

    private STNode parseExpressionRhs(OperatorPrecedence currentPrecedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STNode actionOrExpression = this.parseExpressionRhsInternal(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        if (!allowActions && this.isAction(actionOrExpression) && actionOrExpression.kind != SyntaxKind.BRACED_ACTION) {
            actionOrExpression = this.invalidateActionAndGetMissingExpr(actionOrExpression);
        }
        return actionOrExpression;
    }

    private STNode parseExpressionRhsInternal(OperatorPrecedence currentPrecedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        OperatorPrecedence nextOperatorPrecedence;
        STToken nextToken = this.peek();
        if (this.isAction(lhsExpr) || this.isEndOfActionOrExpression(nextToken, isRhsExpr, isInMatchGuard)) {
            return lhsExpr;
        }
        SyntaxKind nextTokenKind = nextToken.kind;
        if (!this.isValidExprRhsStart(nextTokenKind, lhsExpr.kind)) {
            return this.recoverExpressionRhs(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        }
        if (nextTokenKind == SyntaxKind.GT_TOKEN && this.peek((int)2).kind == SyntaxKind.GT_TOKEN) {
            nextTokenKind = this.peek((int)3).kind == SyntaxKind.GT_TOKEN ? SyntaxKind.TRIPPLE_GT_TOKEN : SyntaxKind.DOUBLE_GT_TOKEN;
        }
        if (currentPrecedenceLevel.isHigherThanOrEqual(nextOperatorPrecedence = this.getOpPrecedence(nextTokenKind), allowActions)) {
            return lhsExpr;
        }
        return this.parseExpressionRhsInternal(currentPrecedenceLevel, switch (nextTokenKind) {
            case SyntaxKind.OPEN_PAREN_TOKEN -> this.parseFuncCall(lhsExpr);
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseMemberAccessExpr(lhsExpr, isRhsExpr);
            case SyntaxKind.DOT_TOKEN -> this.parseFieldAccessOrMethodCall(lhsExpr, isInConditionalExpr);
            case SyntaxKind.IS_KEYWORD, SyntaxKind.NOT_IS_KEYWORD -> this.parseTypeTestExpression(lhsExpr, isInConditionalExpr);
            case SyntaxKind.RIGHT_ARROW_TOKEN -> this.parseRemoteMethodCallOrClientResourceAccessOrAsyncSendAction(lhsExpr, isRhsExpr, isInMatchGuard);
            case SyntaxKind.SYNC_SEND_TOKEN -> this.parseSyncSendAction(lhsExpr);
            case SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN -> this.parseImplicitAnonFunc(lhsExpr, isRhsExpr);
            case SyntaxKind.ANNOT_CHAINING_TOKEN -> this.parseAnnotAccessExpression(lhsExpr, isInConditionalExpr);
            case SyntaxKind.OPTIONAL_CHAINING_TOKEN -> this.parseOptionalFieldAccessExpression(lhsExpr, isInConditionalExpr);
            case SyntaxKind.QUESTION_MARK_TOKEN -> this.parseConditionalExpression(lhsExpr, isInConditionalExpr);
            case SyntaxKind.DOT_LT_TOKEN -> this.parseXMLFilterExpression(lhsExpr);
            case SyntaxKind.SLASH_LT_TOKEN, SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN, SyntaxKind.SLASH_ASTERISK_TOKEN -> this.parseXMLStepExpression(lhsExpr);
            default -> {
                SyntaxKind expectedNodeType;
                if (nextTokenKind == SyntaxKind.SLASH_TOKEN && this.peek((int)2).kind == SyntaxKind.LT_TOKEN && (expectedNodeType = this.getExpectedNodeKind(3)) == SyntaxKind.XML_STEP_EXPRESSION) {
                    yield this.createXMLStepExpression(lhsExpr);
                }
                STNode operator = nextTokenKind == SyntaxKind.DOUBLE_GT_TOKEN ? this.parseSignedRightShiftToken() : (nextTokenKind == SyntaxKind.TRIPPLE_GT_TOKEN ? this.parseUnsignedRightShiftToken() : this.parseBinaryOperator());
                STNode rhsExpr = this.parseExpression(nextOperatorPrecedence, isRhsExpr, false, isInConditionalExpr);
                yield STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, lhsExpr, operator, rhsExpr);
            }
        }, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
    }

    private STNode recoverExpressionRhs(OperatorPrecedence currentPrecedenceLevel, STNode lhsExpr, boolean isRhsExpr, boolean allowActions, boolean isInMatchGuard, boolean isInConditionalExpr) {
        STToken token = this.peek();
        SyntaxKind lhsExprKind = lhsExpr.kind;
        AbstractParserErrorHandler.Solution solution = lhsExprKind == SyntaxKind.QUALIFIED_NAME_REFERENCE || lhsExprKind == SyntaxKind.SIMPLE_NAME_REFERENCE ? this.recover(token, ParserRuleContext.VARIABLE_REF_RHS) : this.recover(token, ParserRuleContext.EXPRESSION_RHS);
        if (solution.action == AbstractParserErrorHandler.Action.REMOVE) {
            return this.parseExpressionRhs(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
        }
        if (solution.ctx == ParserRuleContext.BINARY_OPERATOR) {
            SyntaxKind binaryOpKind = this.getBinaryOperatorKindToInsert(currentPrecedenceLevel);
            ParserRuleContext binaryOpContext = this.getMissingBinaryOperatorContext(currentPrecedenceLevel);
            this.insertToken(binaryOpKind, binaryOpContext);
        }
        return this.parseExpressionRhsInternal(currentPrecedenceLevel, lhsExpr, isRhsExpr, allowActions, isInMatchGuard, isInConditionalExpr);
    }

    private STNode createXMLStepExpression(STNode lhsExpr) {
        STNode slashLT;
        STNode slashToken = this.parseSlashToken();
        STNode ltToken = this.parseLTToken();
        if (this.hasTrailingMinutiae(slashToken) || this.hasLeadingMinutiae(ltToken)) {
            ArrayList<STNodeDiagnostic> diagnostics = new ArrayList<STNodeDiagnostic>();
            diagnostics.add(SyntaxErrors.createDiagnostic(DiagnosticErrorCode.ERROR_INVALID_WHITESPACE_IN_SLASH_LT_TOKEN, new Object[0]));
            slashLT = STNodeFactory.createMissingToken(SyntaxKind.SLASH_LT_TOKEN, diagnostics);
            slashLT = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(slashLT, slashToken);
            slashLT = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(slashLT, ltToken);
        } else {
            slashLT = STNodeFactory.createToken(SyntaxKind.SLASH_LT_TOKEN, slashToken.leadingMinutiae(), ltToken.trailingMinutiae());
        }
        STNode namePattern = this.parseXMLNamePatternChain(slashLT);
        STNode xmlStepExtends = this.parseXMLStepExtends();
        STNode newLhsExpr = STNodeFactory.createXMLStepExpressionNode(lhsExpr, namePattern, xmlStepExtends);
        return newLhsExpr;
    }

    private SyntaxKind getExpectedNodeKind(int lookahead) {
        STToken nextToken = this.peek(lookahead);
        block0 : switch (nextToken.kind) {
            case ASTERISK_TOKEN: {
                return SyntaxKind.XML_STEP_EXPRESSION;
            }
            case GT_TOKEN: {
                break;
            }
            case PIPE_TOKEN: {
                return this.getExpectedNodeKind(++lookahead);
            }
            case IDENTIFIER_TOKEN: {
                nextToken = this.peek(++lookahead);
                switch (nextToken.kind) {
                    case GT_TOKEN: {
                        break block0;
                    }
                    case PIPE_TOKEN: {
                        return this.getExpectedNodeKind(++lookahead);
                    }
                    case COLON_TOKEN: {
                        nextToken = this.peek(++lookahead);
                        switch (nextToken.kind) {
                            case ASTERISK_TOKEN: 
                            case GT_TOKEN: {
                                return SyntaxKind.XML_STEP_EXPRESSION;
                            }
                            case IDENTIFIER_TOKEN: {
                                nextToken = this.peek(++lookahead);
                                if (nextToken.kind != SyntaxKind.PIPE_TOKEN) break block0;
                                return this.getExpectedNodeKind(++lookahead);
                            }
                            default: {
                                return SyntaxKind.TYPE_CAST_EXPRESSION;
                            }
                        }
                    }
                    default: {
                        return SyntaxKind.TYPE_CAST_EXPRESSION;
                    }
                }
            }
            default: {
                return SyntaxKind.TYPE_CAST_EXPRESSION;
            }
        }
        nextToken = this.peek(++lookahead);
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case FROM_KEYWORD: 
            case LET_KEYWORD: {
                return SyntaxKind.XML_STEP_EXPRESSION;
            }
        }
        if (!this.isValidExpressionStart(nextToken.kind, lookahead)) {
            return SyntaxKind.XML_STEP_EXPRESSION;
        }
        return SyntaxKind.TYPE_CAST_EXPRESSION;
    }

    private boolean hasTrailingMinutiae(STNode node) {
        return node.widthWithTrailingMinutiae() > node.width();
    }

    private boolean hasLeadingMinutiae(STNode node) {
        return node.widthWithLeadingMinutiae() > node.width();
    }

    private boolean isValidExprRhsStart(SyntaxKind tokenKind, SyntaxKind precedingNodeKind) {
        return switch (tokenKind) {
            case SyntaxKind.OPEN_PAREN_TOKEN -> {
                if (precedingNodeKind == SyntaxKind.QUALIFIED_NAME_REFERENCE || precedingNodeKind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.COLON_TOKEN, SyntaxKind.DOT_TOKEN, SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, SyntaxKind.IS_KEYWORD, SyntaxKind.NOT_IS_KEYWORD, SyntaxKind.ANNOT_CHAINING_TOKEN, SyntaxKind.OPTIONAL_CHAINING_TOKEN, SyntaxKind.DOT_LT_TOKEN, SyntaxKind.SLASH_LT_TOKEN, SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN, SyntaxKind.SLASH_ASTERISK_TOKEN, SyntaxKind.RIGHT_ARROW_TOKEN, SyntaxKind.SYNC_SEND_TOKEN -> true;
            case SyntaxKind.QUESTION_MARK_TOKEN -> {
                if (this.getNextNextToken().kind != SyntaxKind.EQUAL_TOKEN && this.peek((int)3).kind != SyntaxKind.EQUAL_TOKEN) {
                    yield true;
                }
                yield false;
            }
            default -> this.isBinaryOperator(tokenKind);
        };
    }

    private STNode parseMemberAccessExpr(STNode lhsExpr, boolean isRhsExpr) {
        this.startContext(ParserRuleContext.MEMBER_ACCESS_KEY_EXPR);
        STNode openBracket = this.parseOpenBracket();
        STNode keyExpr = this.parseMemberAccessKeyExprs(isRhsExpr);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        if (isRhsExpr && ((STNodeList)keyExpr).isEmpty()) {
            STNode missingVarRef = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
            keyExpr = STNodeFactory.createNodeList(missingVarRef);
            closeBracket = SyntaxErrors.addDiagnostic(closeBracket, DiagnosticErrorCode.ERROR_MISSING_KEY_EXPR_IN_MEMBER_ACCESS_EXPR, new Object[0]);
        }
        return STNodeFactory.createIndexedExpressionNode(lhsExpr, openBracket, keyExpr, closeBracket);
    }

    private STNode parseMemberAccessKeyExprs(boolean isRhsExpr) {
        ArrayList<STNode> exprList = new ArrayList<STNode>();
        while (!this.isEndOfTypeList(this.peek().kind)) {
            STNode keyExpr = this.parseKeyExpr(isRhsExpr);
            exprList.add(keyExpr);
            STNode keyExprEnd = this.parseMemberAccessKeyExprEnd();
            if (keyExprEnd == null) break;
            exprList.add(keyExprEnd);
        }
        return STNodeFactory.createNodeList(exprList);
    }

    private STNode parseKeyExpr(boolean isRhsExpr) {
        if (!isRhsExpr && this.peek().kind == SyntaxKind.ASTERISK_TOKEN) {
            return STNodeFactory.createBasicLiteralNode(SyntaxKind.ASTERISK_LITERAL, this.consume());
        }
        return this.parseExpression(isRhsExpr);
    }

    private STNode parseMemberAccessKeyExprEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.MEMBER_ACCESS_KEY_EXPR_END);
                yield this.parseMemberAccessKeyExprEnd();
            }
        };
    }

    private STNode parseCloseBracket() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CLOSE_BRACKET);
        return this.parseCloseBracket();
    }

    private STNode parseFieldAccessOrMethodCall(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode dotToken = this.parseDotToken();
        if (this.isSpecialMethodName(this.peek())) {
            STNode methodName = this.getKeywordAsSimpleNameRef();
            STNode openParen = this.parseArgListOpenParenthesis();
            STNode args = this.parseArgsList();
            STNode closeParen = this.parseArgListCloseParenthesis();
            return STNodeFactory.createMethodCallExpressionNode(lhsExpr, dotToken, methodName, openParen, args, closeParen);
        }
        STNode fieldOrMethodName = this.parseFieldAccessIdentifier(isInConditionalExpr);
        if (fieldOrMethodName.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return STNodeFactory.createFieldAccessExpressionNode(lhsExpr, dotToken, fieldOrMethodName);
        }
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            STNode openParen = this.parseArgListOpenParenthesis();
            STNode args = this.parseArgsList();
            STNode closeParen = this.parseArgListCloseParenthesis();
            return STNodeFactory.createMethodCallExpressionNode(lhsExpr, dotToken, fieldOrMethodName, openParen, args, closeParen);
        }
        return STNodeFactory.createFieldAccessExpressionNode(lhsExpr, dotToken, fieldOrMethodName);
    }

    private STNode getKeywordAsSimpleNameRef() {
        STToken mapKeyword = this.consume();
        STNode methodName = STNodeFactory.createIdentifierToken(mapKeyword.text(), mapKeyword.leadingMinutiae(), mapKeyword.trailingMinutiae(), mapKeyword.diagnostics());
        methodName = STNodeFactory.createSimpleNameReferenceNode(methodName);
        return methodName;
    }

    private STNode parseBracedExpression(boolean isRhsExpr, boolean allowActions) {
        STNode openParen = this.parseOpenParenthesis();
        if (this.peek().kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return STNodeFactory.createNilLiteralNode(openParen, this.consume());
        }
        this.startContext(ParserRuleContext.BRACED_EXPR_OR_ANON_FUNC_PARAMS);
        STNode expr = allowActions ? this.parseExpression(DEFAULT_OP_PRECEDENCE, isRhsExpr, true) : this.parseExpression(isRhsExpr);
        return this.parseBracedExprOrAnonFuncParamRhs(openParen, expr, isRhsExpr);
    }

    private STNode parseBracedExprOrAnonFuncParamRhs(STNode openParen, STNode expr, boolean isRhsExpr) {
        STToken nextToken = this.peek();
        if (expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            switch (nextToken.kind) {
                case CLOSE_PAREN_TOKEN: {
                    break;
                }
                case COMMA_TOKEN: {
                    return this.parseImplicitAnonFunc(openParen, expr, isRhsExpr);
                }
                default: {
                    this.recover(nextToken, ParserRuleContext.BRACED_EXPR_OR_ANON_FUNC_PARAM_RHS);
                    return this.parseBracedExprOrAnonFuncParamRhs(openParen, expr, isRhsExpr);
                }
            }
        }
        STNode closeParen = this.parseCloseParenthesis();
        this.endContext();
        if (this.isAction(expr)) {
            return STNodeFactory.createBracedExpressionNode(SyntaxKind.BRACED_ACTION, openParen, expr, closeParen);
        }
        return STNodeFactory.createBracedExpressionNode(SyntaxKind.BRACED_EXPRESSION, openParen, expr, closeParen);
    }

    private boolean isAction(STNode node) {
        return switch (node.kind) {
            case SyntaxKind.REMOTE_METHOD_CALL_ACTION, SyntaxKind.BRACED_ACTION, SyntaxKind.CHECK_ACTION, SyntaxKind.START_ACTION, SyntaxKind.TRAP_ACTION, SyntaxKind.FLUSH_ACTION, SyntaxKind.ASYNC_SEND_ACTION, SyntaxKind.SYNC_SEND_ACTION, SyntaxKind.RECEIVE_ACTION, SyntaxKind.WAIT_ACTION, SyntaxKind.QUERY_ACTION, SyntaxKind.COMMIT_ACTION, SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION -> true;
            default -> false;
        };
    }

    private boolean isEndOfActionOrExpression(STToken nextToken, boolean isRhsExpr, boolean isInMatchGuard) {
        SyntaxKind tokenKind = nextToken.kind;
        if (!isRhsExpr) {
            if (this.isCompoundAssignment(tokenKind)) {
                return true;
            }
            if (isInMatchGuard && tokenKind == SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN) {
                return true;
            }
        }
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.DOCUMENTATION_STRING, SyntaxKind.AT_TOKEN, SyntaxKind.PUBLIC_KEYWORD, SyntaxKind.TYPE_KEYWORD, SyntaxKind.LISTENER_KEYWORD, SyntaxKind.CONST_KEYWORD, SyntaxKind.RESOURCE_KEYWORD, SyntaxKind.EQUAL_TOKEN, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.COLON_TOKEN, SyntaxKind.AS_KEYWORD, SyntaxKind.COMMA_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN, SyntaxKind.DO_KEYWORD, SyntaxKind.FROM_KEYWORD, SyntaxKind.LET_KEYWORD, SyntaxKind.IN_KEYWORD, SyntaxKind.WHERE_KEYWORD, SyntaxKind.SELECT_KEYWORD, SyntaxKind.ON_KEYWORD, SyntaxKind.CONFLICT_KEYWORD, SyntaxKind.LIMIT_KEYWORD, SyntaxKind.JOIN_KEYWORD, SyntaxKind.OUTER_KEYWORD, SyntaxKind.ORDER_KEYWORD, SyntaxKind.BY_KEYWORD, SyntaxKind.ASCENDING_KEYWORD, SyntaxKind.DESCENDING_KEYWORD, SyntaxKind.EQUALS_KEYWORD -> true;
            case SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN -> isInMatchGuard;
            case SyntaxKind.IDENTIFIER_TOKEN -> BallerinaParser.isGroupOrCollectKeyword(nextToken);
            default -> BallerinaParser.isSimpleType(tokenKind);
        };
    }

    private STNode parseBasicLiteral() {
        STToken literalToken = this.consume();
        return this.parseBasicLiteral(literalToken);
    }

    private STNode parseBasicLiteral(STNode literalToken) {
        SyntaxKind nodeKind = switch (literalToken.kind) {
            case SyntaxKind.NULL_KEYWORD -> SyntaxKind.NULL_LITERAL;
            case SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD -> SyntaxKind.BOOLEAN_LITERAL;
            case SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN -> SyntaxKind.NUMERIC_LITERAL;
            case SyntaxKind.STRING_LITERAL_TOKEN -> SyntaxKind.STRING_LITERAL;
            case SyntaxKind.ASTERISK_TOKEN -> SyntaxKind.ASTERISK_LITERAL;
            default -> literalToken.kind;
        };
        return STNodeFactory.createBasicLiteralNode(nodeKind, literalToken);
    }

    private STNode parseFuncCall(STNode identifier) {
        STNode openParen = this.parseArgListOpenParenthesis();
        STNode args = this.parseArgsList();
        STNode closeParen = this.parseArgListCloseParenthesis();
        return STNodeFactory.createFunctionCallExpressionNode(identifier, openParen, args, closeParen);
    }

    private STNode parseErrorBindingPatternOrErrorConstructor() {
        return this.parseErrorConstructorExpr(true);
    }

    private STNode parseErrorConstructorExpr(STNode errorKeyword) {
        this.startContext(ParserRuleContext.ERROR_CONSTRUCTOR);
        return this.parseErrorConstructorExpr(errorKeyword, false);
    }

    private STNode parseErrorConstructorExpr(boolean isAmbiguous) {
        this.startContext(ParserRuleContext.ERROR_CONSTRUCTOR);
        STNode errorKeyword = this.parseErrorKeyword();
        return this.parseErrorConstructorExpr(errorKeyword, isAmbiguous);
    }

    private STNode parseErrorConstructorExpr(STNode errorKeyword, boolean isAmbiguous) {
        STNode typeReference = this.parseErrorTypeReference();
        STNode openParen = this.parseArgListOpenParenthesis();
        STNode functionArgs = this.parseArgsList();
        STNode errorArgs = isAmbiguous ? functionArgs : this.getErrorArgList(functionArgs);
        STNode closeParen = this.parseArgListCloseParenthesis();
        this.endContext();
        openParen = this.cloneWithDiagnosticIfListEmpty(errorArgs, openParen, DiagnosticErrorCode.ERROR_MISSING_ARG_WITHIN_PARENTHESIS);
        return STNodeFactory.createErrorConstructorExpressionNode(errorKeyword, typeReference, openParen, errorArgs, closeParen);
    }

    private STNode parseErrorTypeReference() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
        }
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            return this.parseTypeReference();
        }
        this.recover(nextToken, ParserRuleContext.ERROR_CONSTRUCTOR_RHS);
        return this.parseErrorTypeReference();
    }

    private STNode getErrorArgList(STNode functionArgs) {
        STNodeList argList = (STNodeList)functionArgs;
        if (argList.isEmpty()) {
            return argList;
        }
        ArrayList<STNode> errorArgList = new ArrayList<STNode>();
        STNode arg = argList.get(0);
        switch (arg.kind) {
            case POSITIONAL_ARG: {
                errorArgList.add(arg);
                break;
            }
            case NAMED_ARG: {
                arg = SyntaxErrors.addDiagnostic(arg, DiagnosticErrorCode.ERROR_MISSING_ERROR_MESSAGE_IN_ERROR_CONSTRUCTOR, new Object[0]);
                errorArgList.add(arg);
                break;
            }
            default: {
                arg = SyntaxErrors.addDiagnostic(arg, DiagnosticErrorCode.ERROR_MISSING_ERROR_MESSAGE_IN_ERROR_CONSTRUCTOR, new Object[0]);
                arg = SyntaxErrors.addDiagnostic(arg, DiagnosticErrorCode.ERROR_REST_ARG_IN_ERROR_CONSTRUCTOR, new Object[0]);
                errorArgList.add(arg);
            }
        }
        DiagnosticErrorCode diagnosticErrorCode = DiagnosticErrorCode.ERROR_REST_ARG_IN_ERROR_CONSTRUCTOR;
        boolean hasPositionalArg = false;
        for (int i = 1; i < argList.size(); i += 2) {
            STNode leadingComma = argList.get(i);
            arg = argList.get(i + 1);
            if (arg.kind == SyntaxKind.NAMED_ARG) {
                errorArgList.add(leadingComma);
                errorArgList.add(arg);
                continue;
            }
            if (arg.kind == SyntaxKind.POSITIONAL_ARG) {
                if (!hasPositionalArg) {
                    errorArgList.add(leadingComma);
                    errorArgList.add(arg);
                    hasPositionalArg = true;
                    continue;
                }
                diagnosticErrorCode = DiagnosticErrorCode.ERROR_ADDITIONAL_POSITIONAL_ARG_IN_ERROR_CONSTRUCTOR;
            }
            this.updateLastNodeInListWithInvalidNode(errorArgList, leadingComma, null, new Object[0]);
            this.updateLastNodeInListWithInvalidNode(errorArgList, arg, diagnosticErrorCode, new Object[0]);
        }
        return STNodeFactory.createNodeList(errorArgList);
    }

    private STNode parseArgsList() {
        this.startContext(ParserRuleContext.ARG_LIST);
        STToken token = this.peek();
        if (this.isEndOfParametersList(token.kind)) {
            STNode args = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return args;
        }
        STNode firstArg = this.parseArgument();
        STNode argsList = this.parseArgList(firstArg);
        this.endContext();
        return argsList;
    }

    private STNode parseArgList(STNode firstArg) {
        STNode argEnd;
        ArrayList<STNode> argsList = new ArrayList<STNode>();
        argsList.add(firstArg);
        SyntaxKind lastValidArgKind = firstArg.kind;
        STToken nextToken = this.peek();
        while (!this.isEndOfParametersList(nextToken.kind) && (argEnd = this.parseArgEnd()) != null) {
            STNode curArg = this.parseArgument();
            DiagnosticErrorCode errorCode = this.validateArgumentOrder(lastValidArgKind, curArg.kind);
            if (errorCode == null) {
                argsList.add(argEnd);
                argsList.add(curArg);
                lastValidArgKind = curArg.kind;
            } else if (errorCode == DiagnosticErrorCode.ERROR_NAMED_ARG_FOLLOWED_BY_POSITIONAL_ARG && ((STPositionalArgumentNode)curArg).expression.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                STToken missingEqual = SyntaxErrors.createMissingToken(SyntaxKind.EQUAL_TOKEN);
                STToken missingIdentifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                STNode nameRef = STNodeFactory.createSimpleNameReferenceNode(missingIdentifier);
                STNode expr = ((STPositionalArgumentNode)curArg).expression;
                if (((STSimpleNameReferenceNode)expr).name.isMissing()) {
                    errorCode = DiagnosticErrorCode.ERROR_MISSING_NAMED_ARG;
                    expr = nameRef;
                }
                curArg = STNodeFactory.createNamedArgumentNode(expr, missingEqual, nameRef);
                curArg = SyntaxErrors.addDiagnostic(curArg, errorCode, new Object[0]);
                argsList.add(argEnd);
                argsList.add(curArg);
            } else {
                this.updateLastNodeInListWithInvalidNode(argsList, argEnd, null, new Object[0]);
                this.updateLastNodeInListWithInvalidNode(argsList, curArg, errorCode, new Object[0]);
            }
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(argsList);
    }

    private DiagnosticErrorCode validateArgumentOrder(SyntaxKind prevArgKind, SyntaxKind curArgKind) {
        DiagnosticErrorCode errorCode = null;
        switch (prevArgKind) {
            case POSITIONAL_ARG: {
                break;
            }
            case NAMED_ARG: {
                if (curArgKind != SyntaxKind.POSITIONAL_ARG) break;
                errorCode = DiagnosticErrorCode.ERROR_NAMED_ARG_FOLLOWED_BY_POSITIONAL_ARG;
                break;
            }
            case REST_ARG: {
                errorCode = DiagnosticErrorCode.ERROR_REST_ARG_FOLLOWED_BY_ANOTHER_ARG;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid SyntaxKind in an argument");
            }
        }
        return errorCode;
    }

    private STNode parseArgEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_PAREN_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.ARG_END);
                yield this.parseArgEnd();
            }
        };
    }

    private STNode parseArgument() {
        STNode arg;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                STToken ellipsis = this.consume();
                STNode expr = this.parseExpression();
                arg = STNodeFactory.createRestArgumentNode(ellipsis, expr);
                break;
            }
            case IDENTIFIER_TOKEN: {
                arg = this.parseNamedOrPositionalArg();
                break;
            }
            default: {
                if (this.isValidExprStart(nextToken.kind)) {
                    STNode expr = this.parseExpression();
                    arg = STNodeFactory.createPositionalArgumentNode(expr);
                    break;
                }
                this.recover(this.peek(), ParserRuleContext.ARG_START);
                return this.parseArgument();
            }
        }
        return arg;
    }

    private STNode parseNamedOrPositionalArg() {
        STNode argNameOrExpr = this.parseTerminalExpression(true, false, false);
        STToken secondToken = this.peek();
        switch (secondToken.kind) {
            case EQUAL_TOKEN: {
                if (argNameOrExpr.kind != SyntaxKind.SIMPLE_NAME_REFERENCE) break;
                STNode equal = this.parseAssignOp();
                STNode valExpr = this.parseExpression();
                return STNodeFactory.createNamedArgumentNode(argNameOrExpr, equal, valExpr);
            }
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: {
                return STNodeFactory.createPositionalArgumentNode(argNameOrExpr);
            }
        }
        argNameOrExpr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, argNameOrExpr, true, false);
        return STNodeFactory.createPositionalArgumentNode(argNameOrExpr);
    }

    private STNode parseObjectTypeDescriptor(STNode objectKeyword, STNode objectTypeQualifiers) {
        this.startContext(ParserRuleContext.OBJECT_TYPE_DESCRIPTOR);
        STNode openBrace = this.parseOpenBrace();
        STNode objectMemberDescriptors = this.parseObjectMembers(ParserRuleContext.OBJECT_TYPE_MEMBER);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createObjectTypeDescriptorNode(objectTypeQualifiers, objectKeyword, openBrace, objectMemberDescriptors, closeBrace);
    }

    private STNode parseObjectConstructorExpression(STNode annots, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.OBJECT_CONSTRUCTOR);
        STNode objectTypeQualifier = this.createObjectTypeQualNodeList(qualifiers);
        STNode objectKeyword = this.parseObjectKeyword();
        STNode typeReference = this.parseObjectConstructorTypeReference();
        STNode openBrace = this.parseOpenBrace();
        STNode objectMembers = this.parseObjectMembers(ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createObjectConstructorExpressionNode(annots, objectTypeQualifier, objectKeyword, typeReference, openBrace, objectMembers, closeBrace);
    }

    private STNode parseObjectConstructorTypeReference() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACE_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
        }
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            return this.parseTypeReference();
        }
        this.recover(nextToken, ParserRuleContext.OBJECT_CONSTRUCTOR_TYPE_REF);
        return this.parseObjectConstructorTypeReference();
    }

    private boolean isPredeclaredIdentifier(SyntaxKind tokenKind) {
        return tokenKind == SyntaxKind.IDENTIFIER_TOKEN || this.isQualifiedIdentifierPredeclaredPrefix(tokenKind);
    }

    private STNode parseObjectKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OBJECT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OBJECT_KEYWORD);
        return this.parseObjectKeyword();
    }

    private STNode parseObjectMembers(ParserRuleContext context) {
        ArrayList<STNode> objectMembers = new ArrayList<STNode>();
        while (!this.isEndOfObjectTypeNode()) {
            this.startContext(context);
            STNode member = this.parseObjectMember(context);
            this.endContext();
            if (member == null) break;
            if (context == ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER && member.kind == SyntaxKind.TYPE_REFERENCE) {
                this.addInvalidNodeToNextToken(member, DiagnosticErrorCode.ERROR_TYPE_INCLUSION_IN_OBJECT_CONSTRUCTOR, new Object[0]);
                continue;
            }
            objectMembers.add(member);
        }
        return STNodeFactory.createNodeList(objectMembers);
    }

    private STNode parseObjectMember(ParserRuleContext context) {
        STNode metadata;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return null;
            }
            case FINAL_KEYWORD: 
            case PUBLIC_KEYWORD: 
            case FUNCTION_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case RESOURCE_KEYWORD: 
            case REMOTE_KEYWORD: 
            case ASTERISK_TOKEN: 
            case PRIVATE_KEYWORD: {
                metadata = STNodeFactory.createEmptyNode();
                break;
            }
            case DOCUMENTATION_STRING: 
            case AT_TOKEN: {
                metadata = this.parseMetaData();
                break;
            }
            case RETURN_KEYWORD: {
                this.addInvalidNodeToNextToken(this.consume(), DiagnosticErrorCode.ERROR_INVALID_TOKEN, new Object[0]);
                return this.parseObjectMember(context);
            }
            default: {
                if (this.isTypeStartingToken(nextToken.kind)) {
                    metadata = STNodeFactory.createEmptyNode();
                    break;
                }
                ParserRuleContext recoveryCtx = context == ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER ? ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER_START : ParserRuleContext.CLASS_MEMBER_OR_OBJECT_MEMBER_START;
                AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), recoveryCtx);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    metadata = STNodeFactory.createEmptyNode();
                    break;
                }
                return this.parseObjectMember(context);
            }
        }
        return this.parseObjectMemberWithoutMeta(metadata, context);
    }

    private STNode parseObjectMemberWithoutMeta(STNode metadata, ParserRuleContext context) {
        boolean isObjectTypeDesc = context == ParserRuleContext.OBJECT_TYPE_MEMBER;
        ParserRuleContext recoveryCtx = context == ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER ? ParserRuleContext.OBJECT_CONS_MEMBER_WITHOUT_META : ParserRuleContext.CLASS_MEMBER_OR_OBJECT_MEMBER_WITHOUT_META;
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseObjectMemberWithoutMeta(metadata, typeDescQualifiers, recoveryCtx, isObjectTypeDesc);
    }

    private STNode parseObjectMemberWithoutMeta(STNode metadata, List<STNode> qualifiers, ParserRuleContext recoveryCtx, boolean isObjectTypeDesc) {
        this.parseObjectMemberQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                if (metadata != null || !qualifiers.isEmpty()) {
                    return this.createMissingSimpleObjectField(metadata, qualifiers, isObjectTypeDesc);
                }
                return null;
            }
            case PUBLIC_KEYWORD: 
            case PRIVATE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STNode visibilityQualifier = this.consume();
                if (isObjectTypeDesc && visibilityQualifier.kind == SyntaxKind.PRIVATE_KEYWORD) {
                    this.addInvalidNodeToNextToken(visibilityQualifier, DiagnosticErrorCode.ERROR_PRIVATE_QUALIFIER_IN_OBJECT_MEMBER_DESCRIPTOR, new Object[0]);
                    visibilityQualifier = STNodeFactory.createEmptyNode();
                }
                return this.parseObjectMethodOrField(metadata, visibilityQualifier, isObjectTypeDesc);
            }
            case FUNCTION_KEYWORD: {
                STNode visibilityQualifier = STNodeFactory.createEmptyNode();
                return this.parseObjectMethodOrFuncTypeDesc(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
            case ASTERISK_TOKEN: {
                this.reportInvalidMetaData(metadata, "object type inclusion");
                this.reportInvalidQualifierList(qualifiers);
                STToken asterisk = this.consume();
                STNode type = this.parseTypeReferenceInTypeInclusion();
                STNode semicolonToken = this.parseSemicolon();
                return STNodeFactory.createTypeReferenceNode(asterisk, type, semicolonToken);
            }
            case IDENTIFIER_TOKEN: {
                if (this.isObjectFieldStart() || nextToken.isMissing()) {
                    return this.parseObjectField(metadata, STNodeFactory.createEmptyNode(), qualifiers, isObjectTypeDesc);
                }
                if (!this.isObjectMethodStart(this.getNextNextToken())) break;
                this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
                return this.parseObjectMemberWithoutMeta(metadata, qualifiers, recoveryCtx, isObjectTypeDesc);
            }
        }
        if (this.isTypeStartingToken(nextToken.kind) && nextToken.kind != SyntaxKind.IDENTIFIER_TOKEN) {
            return this.parseObjectField(metadata, STNodeFactory.createEmptyNode(), qualifiers, isObjectTypeDesc);
        }
        AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), recoveryCtx);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
            return this.parseObjectField(metadata, STNodeFactory.createEmptyNode(), qualifiers, isObjectTypeDesc);
        }
        return this.parseObjectMemberWithoutMeta(metadata, qualifiers, recoveryCtx, isObjectTypeDesc);
    }

    private boolean isObjectFieldStart() {
        STToken nextNextToken = this.getNextNextToken();
        return switch (nextNextToken.kind) {
            case SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.ERROR_KEYWORD -> false;
            case SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> this.isModuleVarDeclStart(1);
        };
    }

    private boolean isObjectMethodStart(STToken token) {
        return switch (token.kind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.TRANSACTIONAL_KEYWORD, SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.RESOURCE_KEYWORD, SyntaxKind.REMOTE_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseObjectMethodOrField(STNode metadata, STNode visibilityQualifier, boolean isObjectTypeDesc) {
        ArrayList<STNode> objectMemberQualifiers = new ArrayList<STNode>();
        return this.parseObjectMethodOrField(metadata, visibilityQualifier, objectMemberQualifiers, isObjectTypeDesc);
    }

    private STNode parseObjectMethodOrField(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        this.parseObjectMemberQualifiers(qualifiers);
        STToken nextToken = this.peek(1);
        STToken nextNextToken = this.peek(2);
        switch (nextToken.kind) {
            case FUNCTION_KEYWORD: {
                return this.parseObjectMethodOrFuncTypeDesc(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
            case IDENTIFIER_TOKEN: {
                if (nextNextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) break;
                return this.parseObjectField(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
            default: {
                if (!this.isTypeStartingToken(nextToken.kind)) break;
                return this.parseObjectField(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
            }
        }
        this.recover(this.peek(), ParserRuleContext.OBJECT_FUNC_OR_FIELD_WITHOUT_VISIBILITY);
        return this.parseObjectMethodOrField(metadata, visibilityQualifier, qualifiers, isObjectTypeDesc);
    }

    private STNode parseObjectField(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        List<STNode> objectFieldQualifiers = this.extractObjectFieldQualifiers(qualifiers, isObjectTypeDesc);
        STNode objectFieldQualNodeList = STNodeFactory.createNodeList(objectFieldQualifiers);
        STNode type = this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode fieldName = this.parseVariableName();
        return this.parseObjectFieldRhs(metadata, visibilityQualifier, objectFieldQualNodeList, type, fieldName, isObjectTypeDesc);
    }

    private List<STNode> extractObjectFieldQualifiers(List<STNode> qualifiers, boolean isObjectTypeDesc) {
        ArrayList<STNode> objectFieldQualifiers = new ArrayList<STNode>();
        if (!qualifiers.isEmpty() && !isObjectTypeDesc) {
            STNode firstQualifier = qualifiers.get(0);
            if (firstQualifier.kind == SyntaxKind.FINAL_KEYWORD) {
                objectFieldQualifiers.add(qualifiers.remove(0));
            }
        }
        return objectFieldQualifiers;
    }

    private STNode parseObjectFieldRhs(STNode metadata, STNode visibilityQualifier, STNode qualifiers, STNode type, STNode fieldName, boolean isObjectTypeDesc) {
        STNode semicolonToken;
        STNode expression;
        STNode equalsToken;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SEMICOLON_TOKEN: {
                equalsToken = STNodeFactory.createEmptyNode();
                expression = STNodeFactory.createEmptyNode();
                semicolonToken = this.parseSemicolon();
                break;
            }
            case EQUAL_TOKEN: {
                equalsToken = this.parseAssignOp();
                expression = this.parseExpression();
                semicolonToken = this.parseSemicolon();
                if (!isObjectTypeDesc) break;
                fieldName = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(fieldName, equalsToken, (DiagnosticCode)DiagnosticErrorCode.ERROR_FIELD_INITIALIZATION_NOT_ALLOWED_IN_OBJECT_TYPE, new Object[0]);
                fieldName = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(fieldName, expression);
                equalsToken = STNodeFactory.createEmptyNode();
                expression = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.OBJECT_FIELD_RHS);
                return this.parseObjectFieldRhs(metadata, visibilityQualifier, qualifiers, type, fieldName, isObjectTypeDesc);
            }
        }
        return STNodeFactory.createObjectFieldNode(metadata, visibilityQualifier, qualifiers, type, fieldName, equalsToken, expression, semicolonToken);
    }

    private STNode parseObjectMethodOrFuncTypeDesc(STNode metadata, STNode visibilityQualifier, List<STNode> qualifiers, boolean isObjectTypeDesc) {
        return this.parseFuncDefOrFuncTypeDesc(metadata, visibilityQualifier, qualifiers, true, isObjectTypeDesc);
    }

    private STNode parseRelativeResourcePath() {
        STNode leadingSlash;
        this.startContext(ParserRuleContext.RELATIVE_RESOURCE_PATH);
        ArrayList<STNode> pathElementList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DOT_TOKEN) {
            pathElementList.add(this.consume());
            this.endContext();
            return STNodeFactory.createNodeList(pathElementList);
        }
        STNode pathSegment = this.parseResourcePathSegment(true);
        pathElementList.add(pathSegment);
        while (!this.isEndRelativeResourcePath(nextToken.kind) && (leadingSlash = this.parseRelativeResourcePathEnd()) != null) {
            pathElementList.add(leadingSlash);
            pathSegment = this.parseResourcePathSegment(false);
            pathElementList.add(pathSegment);
            nextToken = this.peek();
        }
        this.endContext();
        return this.createResourcePathNodeList(pathElementList);
    }

    private boolean isEndRelativeResourcePath(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.OPEN_PAREN_TOKEN -> true;
            default -> false;
        };
    }

    private STNode createResourcePathNodeList(List<STNode> pathElementList) {
        if (pathElementList.isEmpty()) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        STNode firstElement = pathElementList.get(0);
        validatedList.add(firstElement);
        boolean hasRestPram = firstElement.kind == SyntaxKind.RESOURCE_PATH_REST_PARAM;
        for (int i = 1; i < pathElementList.size(); i += 2) {
            STNode leadingSlash = pathElementList.get(i);
            STNode pathSegment = pathElementList.get(i + 1);
            if (hasRestPram) {
                this.updateLastNodeInListWithInvalidNode(validatedList, leadingSlash, null, new Object[0]);
                this.updateLastNodeInListWithInvalidNode(validatedList, pathSegment, DiagnosticErrorCode.ERROR_RESOURCE_PATH_SEGMENT_NOT_ALLOWED_AFTER_REST_PARAM, new Object[0]);
                continue;
            }
            hasRestPram = pathSegment.kind == SyntaxKind.RESOURCE_PATH_REST_PARAM;
            validatedList.add(leadingSlash);
            validatedList.add(pathSegment);
        }
        return STNodeFactory.createNodeList(validatedList);
    }

    private STNode parseResourcePathSegment(boolean isFirstSegment) {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.IDENTIFIER_TOKEN -> {
                if (isFirstSegment && nextToken.isMissing() && this.isInvalidNodeStackEmpty() && this.getNextNextToken().kind == SyntaxKind.SLASH_TOKEN) {
                    this.removeInsertedToken();
                    yield SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_RESOURCE_PATH_CANNOT_BEGIN_WITH_SLASH);
                }
                yield this.consume();
            }
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseResourcePathParameter();
            default -> {
                this.recover(nextToken, ParserRuleContext.RESOURCE_PATH_SEGMENT);
                yield this.parseResourcePathSegment(isFirstSegment);
            }
        };
    }

    private STNode parseResourcePathParameter() {
        STNode openBracket = this.parseOpenBracket();
        STNode annots = this.parseOptionalAnnotations();
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_PATH_PARAM);
        STNode ellipsis = this.parseOptionalEllipsis();
        STNode paramName = this.parseOptionalPathParamName();
        STNode closeBracket = this.parseCloseBracket();
        SyntaxKind pathPramKind = ellipsis == null ? SyntaxKind.RESOURCE_PATH_SEGMENT_PARAM : SyntaxKind.RESOURCE_PATH_REST_PARAM;
        return STNodeFactory.createResourcePathParameterNode(pathPramKind, openBracket, annots, type, ellipsis, paramName, closeBracket);
    }

    private STNode parseOptionalPathParamName() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.IDENTIFIER_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> STNodeFactory.createEmptyNode();
            default -> {
                this.recover(nextToken, ParserRuleContext.OPTIONAL_PATH_PARAM_NAME);
                yield this.parseOptionalPathParamName();
            }
        };
    }

    private STNode parseOptionalEllipsis() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.ELLIPSIS_TOKEN -> this.consume();
            case SyntaxKind.IDENTIFIER_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> STNodeFactory.createEmptyNode();
            default -> {
                this.recover(nextToken, ParserRuleContext.PATH_PARAM_ELLIPSIS);
                yield this.parseOptionalEllipsis();
            }
        };
    }

    private STNode parseRelativeResourcePathEnd() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.OPEN_PAREN_TOKEN -> null;
            case SyntaxKind.SLASH_TOKEN -> this.consume();
            default -> {
                this.recover(nextToken, ParserRuleContext.RELATIVE_RESOURCE_PATH_END);
                yield this.parseRelativeResourcePathEnd();
            }
        };
    }

    private STNode parseIfElseBlock() {
        this.startContext(ParserRuleContext.IF_BLOCK);
        STNode ifKeyword = this.parseIfKeyword();
        STNode condition = this.parseExpression();
        STNode ifBody = this.parseBlockNode();
        this.endContext();
        STNode elseBody = this.parseElseBlock();
        return STNodeFactory.createIfElseStatementNode(ifKeyword, condition, ifBody, elseBody);
    }

    private STNode parseIfKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IF_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IF_KEYWORD);
        return this.parseIfKeyword();
    }

    private STNode parseElseKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ELSE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ELSE_KEYWORD);
        return this.parseElseKeyword();
    }

    private STNode parseBlockNode() {
        this.startContext(ParserRuleContext.BLOCK_STMT);
        STNode openBrace = this.parseOpenBrace();
        STNode stmts = this.parseStatements();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createBlockStatementNode(openBrace, stmts, closeBrace);
    }

    private STNode parseElseBlock() {
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.ELSE_KEYWORD) {
            return STNodeFactory.createEmptyNode();
        }
        STNode elseKeyword = this.parseElseKeyword();
        STNode elseBody = this.parseElseBody();
        return STNodeFactory.createElseBlockNode(elseKeyword, elseBody);
    }

    private STNode parseElseBody() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.IF_KEYWORD -> this.parseIfElseBlock();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseBlockNode();
            default -> {
                this.recover(this.peek(), ParserRuleContext.ELSE_BODY);
                yield this.parseElseBody();
            }
        };
    }

    private STNode parseDoStatement() {
        this.startContext(ParserRuleContext.DO_BLOCK);
        STNode doKeyword = this.parseDoKeyword();
        STNode doBody = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createDoStatementNode(doKeyword, doBody, onFailClause);
    }

    private STNode parseWhileStatement() {
        this.startContext(ParserRuleContext.WHILE_BLOCK);
        STNode whileKeyword = this.parseWhileKeyword();
        STNode condition = this.parseExpression();
        STNode whileBody = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createWhileStatementNode(whileKeyword, condition, whileBody, onFailClause);
    }

    private STNode parseWhileKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.WHILE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.WHILE_KEYWORD);
        return this.parseWhileKeyword();
    }

    private STNode parsePanicStatement() {
        this.startContext(ParserRuleContext.PANIC_STMT);
        STNode panicKeyword = this.parsePanicKeyword();
        STNode expression = this.parseExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createPanicStatementNode(panicKeyword, expression, semicolon);
    }

    private STNode parsePanicKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.PANIC_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.PANIC_KEYWORD);
        return this.parsePanicKeyword();
    }

    private STNode parseCheckExpression(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode checkingKeyword = this.parseCheckingKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.EXPRESSION_ACTION, isRhsExpr, allowActions, isInConditionalExpr);
        if (this.isAction(expr)) {
            return STNodeFactory.createCheckExpressionNode(SyntaxKind.CHECK_ACTION, checkingKeyword, expr);
        }
        return STNodeFactory.createCheckExpressionNode(SyntaxKind.CHECK_EXPRESSION, checkingKeyword, expr);
    }

    private STNode parseCheckingKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CHECK_KEYWORD || token.kind == SyntaxKind.CHECKPANIC_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CHECKING_KEYWORD);
        return this.parseCheckingKeyword();
    }

    private STNode parseContinueStatement() {
        this.startContext(ParserRuleContext.CONTINUE_STATEMENT);
        STNode continueKeyword = this.parseContinueKeyword();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createContinueStatementNode(continueKeyword, semicolon);
    }

    private STNode parseContinueKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CONTINUE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CONTINUE_KEYWORD);
        return this.parseContinueKeyword();
    }

    private STNode parseFailStatement() {
        this.startContext(ParserRuleContext.FAIL_STATEMENT);
        STNode failKeyword = this.parseFailKeyword();
        STNode expr = this.parseExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createFailStatementNode(failKeyword, expr, semicolon);
    }

    private STNode parseFailKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FAIL_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FAIL_KEYWORD);
        return this.parseFailKeyword();
    }

    private STNode parseReturnStatement() {
        this.startContext(ParserRuleContext.RETURN_STMT);
        STNode returnKeyword = this.parseReturnKeyword();
        STNode returnRhs = this.parseReturnStatementRhs(returnKeyword);
        this.endContext();
        return returnRhs;
    }

    private STNode parseReturnKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RETURN_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RETURN_KEYWORD);
        return this.parseReturnKeyword();
    }

    private STNode parseBreakStatement() {
        this.startContext(ParserRuleContext.BREAK_STATEMENT);
        STNode breakKeyword = this.parseBreakKeyword();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createBreakStatementNode(breakKeyword, semicolon);
    }

    private STNode parseBreakKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BREAK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BREAK_KEYWORD);
        return this.parseBreakKeyword();
    }

    private STNode parseReturnStatementRhs(STNode returnKeyword) {
        STToken token = this.peek();
        STNode expr = switch (token.kind) {
            case SyntaxKind.SEMICOLON_TOKEN -> STNodeFactory.createEmptyNode();
            default -> this.parseActionOrExpression();
        };
        STNode semicolon = this.parseSemicolon();
        return STNodeFactory.createReturnStatementNode(returnKeyword, expr, semicolon);
    }

    private STNode parseMappingConstructorExpr() {
        this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
        STNode openBrace = this.parseOpenBrace();
        STNode fields = this.parseMappingConstructorFields();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
    }

    private STNode parseMappingConstructorFields() {
        STToken nextToken = this.peek();
        if (this.isEndOfMappingConstructor(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> fields = new ArrayList<STNode>();
        STNode field = this.parseMappingField(ParserRuleContext.FIRST_MAPPING_FIELD);
        if (field != null) {
            fields.add(field);
        }
        return this.parseMappingConstructorFields(fields);
    }

    private STNode parseMappingConstructorFields(List<STNode> fields) {
        STNode mappingFieldEnd;
        STToken nextToken = this.peek();
        while (!this.isEndOfMappingConstructor(nextToken.kind) && (mappingFieldEnd = this.parseMappingFieldEnd()) != null) {
            fields.add(mappingFieldEnd);
            STNode field = this.parseMappingField(ParserRuleContext.MAPPING_FIELD);
            fields.add(field);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(fields);
    }

    private STNode parseMappingFieldEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.MAPPING_FIELD_END);
                yield this.parseMappingFieldEnd();
            }
        };
    }

    private boolean isEndOfMappingConstructor(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.READONLY_KEYWORD, SyntaxKind.IDENTIFIER_TOKEN -> false;
            case SyntaxKind.EOF_TOKEN, SyntaxKind.DOCUMENTATION_STRING, SyntaxKind.AT_TOKEN, SyntaxKind.FINAL_KEYWORD, SyntaxKind.PUBLIC_KEYWORD, SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.TYPE_KEYWORD, SyntaxKind.LISTENER_KEYWORD, SyntaxKind.CONST_KEYWORD, SyntaxKind.SERVICE_KEYWORD, SyntaxKind.RESOURCE_KEYWORD, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.RETURNS_KEYWORD, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.PRIVATE_KEYWORD -> true;
            default -> BallerinaParser.isSimpleType(tokenKind);
        };
    }

    private STNode parseMappingField(ParserRuleContext fieldContext) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return this.parseSpecificFieldWithOptionalValue(readonlyKeyword);
            }
            case STRING_LITERAL_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return this.parseQualifiedSpecificField(readonlyKeyword);
            }
            case READONLY_KEYWORD: {
                STNode readonlyKeyword = this.parseReadonlyKeyword();
                return this.parseSpecificField(readonlyKeyword);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseComputedField();
            }
            case ELLIPSIS_TOKEN: {
                STNode ellipsis = this.parseEllipsis();
                STNode expr = this.parseExpression();
                return STNodeFactory.createSpreadFieldNode(ellipsis, expr);
            }
            case CLOSE_BRACE_TOKEN: {
                if (fieldContext != ParserRuleContext.FIRST_MAPPING_FIELD) break;
                return null;
            }
        }
        this.recover(nextToken, fieldContext);
        return this.parseMappingField(fieldContext);
    }

    private STNode parseSpecificField(STNode readonlyKeyword) {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.STRING_LITERAL_TOKEN -> this.parseQualifiedSpecificField(readonlyKeyword);
            case SyntaxKind.IDENTIFIER_TOKEN -> this.parseSpecificFieldWithOptionalValue(readonlyKeyword);
            default -> {
                this.recover(this.peek(), ParserRuleContext.SPECIFIC_FIELD);
                yield this.parseSpecificField(readonlyKeyword);
            }
        };
    }

    private STNode parseQualifiedSpecificField(STNode readonlyKeyword) {
        STNode key = this.parseStringLiteral();
        STNode colon = this.parseColon();
        STNode valueExpr = this.parseExpression();
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
    }

    private STNode parseSpecificFieldWithOptionalValue(STNode readonlyKeyword) {
        STNode key = this.parseIdentifier(ParserRuleContext.MAPPING_FIELD_NAME);
        return this.parseSpecificFieldRhs(readonlyKeyword, key);
    }

    private STNode parseSpecificFieldRhs(STNode readonlyKeyword, STNode key) {
        STNode valueExpr;
        STNode colon;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COLON_TOKEN: {
                colon = this.parseColon();
                valueExpr = this.parseExpression();
                break;
            }
            case COMMA_TOKEN: {
                colon = STNodeFactory.createEmptyNode();
                valueExpr = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                if (this.isEndOfMappingConstructor(nextToken.kind)) {
                    colon = STNodeFactory.createEmptyNode();
                    valueExpr = STNodeFactory.createEmptyNode();
                    break;
                }
                this.recover(nextToken, ParserRuleContext.SPECIFIC_FIELD_RHS);
                return this.parseSpecificFieldRhs(readonlyKeyword, key);
            }
        }
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
    }

    private STNode parseStringLiteral() {
        STToken token = this.peek();
        if (token.kind != SyntaxKind.STRING_LITERAL_TOKEN) {
            this.recover(token, ParserRuleContext.STRING_LITERAL_TOKEN);
            return this.parseStringLiteral();
        }
        STToken stringLiteral = this.consume();
        return this.parseBasicLiteral(stringLiteral);
    }

    private STNode parseColon() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COLON_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COLON);
        return this.parseColon();
    }

    private STNode parseReadonlyKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.READONLY_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.READONLY_KEYWORD);
        return this.parseReadonlyKeyword();
    }

    private STNode parseComputedField() {
        this.startContext(ParserRuleContext.COMPUTED_FIELD_NAME);
        STNode openBracket = this.parseOpenBracket();
        STNode fieldNameExpr = this.parseExpression();
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        STNode colon = this.parseColon();
        STNode valueExpr = this.parseExpression();
        return STNodeFactory.createComputedNameFieldNode(openBracket, fieldNameExpr, closeBracket, colon, valueExpr);
    }

    private STNode parseOpenBracket() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACKET_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OPEN_BRACKET);
        return this.parseOpenBracket();
    }

    private STNode parseCompoundAssignmentStmtRhs(STNode lvExpr) {
        STNode binaryOperator = this.parseCompoundBinaryOperator();
        STNode equalsToken = this.parseAssignOp();
        STNode expr = this.parseActionOrExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        boolean lvExprValid = this.isValidLVExpr(lvExpr);
        if (!lvExprValid) {
            STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
            lvExpr = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(simpleNameRef, lvExpr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_EXPR_IN_COMPOUND_ASSIGNMENT_LHS, new Object[0]);
        }
        return STNodeFactory.createCompoundAssignmentStatementNode(lvExpr, binaryOperator, equalsToken, expr, semicolon);
    }

    private STNode parseCompoundBinaryOperator() {
        STToken token = this.peek();
        if (this.isCompoundAssignment(token.kind)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COMPOUND_BINARY_OPERATOR);
        return this.parseCompoundBinaryOperator();
    }

    private STNode parseServiceDeclOrVarDecl(STNode metadata, STNode publicQualifier, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.SERVICE_DECL);
        List<STNode> serviceDeclQualList = this.extractServiceDeclQualifiers(qualifiers);
        STNode serviceKeyword = this.extractServiceKeyword(qualifiers);
        STNode typeDesc = this.parseServiceDeclTypeDescriptor(qualifiers);
        if (typeDesc != null && typeDesc.kind == SyntaxKind.OBJECT_TYPE_DESC) {
            return this.parseServiceDeclOrVarDecl(metadata, publicQualifier, serviceDeclQualList, serviceKeyword, typeDesc);
        }
        return this.parseServiceDecl(metadata, publicQualifier, serviceDeclQualList, serviceKeyword, typeDesc);
    }

    private STNode parseServiceDeclOrVarDecl(STNode metadata, STNode publicQualifier, List<STNode> serviceDeclQualList, STNode serviceKeyword, STNode typeDesc) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SLASH_TOKEN: 
            case ON_KEYWORD: {
                return this.parseServiceDecl(metadata, publicQualifier, serviceDeclQualList, serviceKeyword, typeDesc);
            }
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                this.endContext();
                typeDesc = this.modifyObjectTypeDescWithALeadingQualifier(typeDesc, serviceKeyword);
                if (!serviceDeclQualList.isEmpty()) {
                    STNode isolatedQualifier = serviceDeclQualList.get(0);
                    typeDesc = this.modifyObjectTypeDescWithALeadingQualifier(typeDesc, isolatedQualifier);
                }
                return this.parseVarDeclTypeDescRhs(typeDesc, metadata, publicQualifier, new ArrayList<STNode>(), true, true);
            }
        }
        this.recover(nextToken, ParserRuleContext.SERVICE_DECL_OR_VAR_DECL);
        return this.parseServiceDeclOrVarDecl(metadata, publicQualifier, serviceDeclQualList, serviceKeyword, typeDesc);
    }

    private List<STNode> extractServiceDeclQualifiers(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (qualifier.kind == SyntaxKind.SERVICE_KEYWORD) {
                qualifierList.subList(0, i).clear();
                break;
            }
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.ISOLATED_KEYWORD) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        return validatedList;
    }

    private STNode extractServiceKeyword(List<STNode> qualifierList) {
        assert (!qualifierList.isEmpty());
        STNode serviceKeyword = qualifierList.remove(0);
        assert (serviceKeyword.kind == SyntaxKind.SERVICE_KEYWORD);
        return serviceKeyword;
    }

    private STNode parseServiceDecl(STNode metadata, STNode publicQualifier, List<STNode> qualList, STNode serviceKeyword, STNode serviceType) {
        if (publicQualifier != null) {
            if (!qualList.isEmpty()) {
                this.updateFirstNodeInListWithLeadingInvalidNode(qualList, publicQualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, new Object[0]);
            } else {
                serviceKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(serviceKeyword, publicQualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, new Object[0]);
            }
        }
        STNode qualNodeList = STNodeFactory.createNodeList(qualList);
        STNode resourcePath = this.parseOptionalAbsolutePathOrStringLiteral();
        STNode onKeyword = this.parseOnKeyword();
        STNode expressionList = this.parseListeners();
        STNode openBrace = this.parseOpenBrace();
        STNode objectMembers = this.parseObjectMembers(ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER);
        STNode closeBrace = this.parseCloseBrace();
        STNode semicolon = this.parseOptionalSemicolon();
        onKeyword = this.cloneWithDiagnosticIfListEmpty(expressionList, onKeyword, DiagnosticErrorCode.ERROR_MISSING_EXPRESSION);
        this.endContext();
        return STNodeFactory.createServiceDeclarationNode(metadata, qualNodeList, serviceKeyword, serviceType, resourcePath, onKeyword, expressionList, openBrace, objectMembers, closeBrace, semicolon);
    }

    private STNode parseServiceDeclTypeDescriptor(List<STNode> qualifiers) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SLASH_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case ON_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                return STNodeFactory.createEmptyNode();
            }
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_SERVICE);
        }
        this.recover(nextToken, ParserRuleContext.OPTIONAL_SERVICE_DECL_TYPE);
        return this.parseServiceDeclTypeDescriptor(qualifiers);
    }

    private STNode parseOptionalAbsolutePathOrStringLiteral() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SLASH_TOKEN: {
                return this.parseAbsoluteResourcePath();
            }
            case STRING_LITERAL_TOKEN: {
                STToken stringLiteralToken = this.consume();
                STNode stringLiteralNode = this.parseBasicLiteral(stringLiteralToken);
                return STNodeFactory.createNodeList(Collections.singletonList(stringLiteralNode));
            }
            case ON_KEYWORD: {
                return STNodeFactory.createEmptyNodeList();
            }
        }
        this.recover(nextToken, ParserRuleContext.OPTIONAL_ABSOLUTE_PATH);
        return this.parseOptionalAbsolutePathOrStringLiteral();
    }

    private STNode parseAbsoluteResourcePath() {
        STNode leadingSlash;
        this.startContext(ParserRuleContext.ABSOLUTE_RESOURCE_PATH);
        ArrayList<STNode> identifierList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        boolean isInitialSlash = true;
        while (!this.isEndAbsoluteResourcePath(nextToken.kind) && (leadingSlash = this.parseAbsoluteResourcePathEnd(isInitialSlash)) != null) {
            identifierList.add(leadingSlash);
            nextToken = this.peek();
            if (isInitialSlash && nextToken.kind == SyntaxKind.ON_KEYWORD) break;
            isInitialSlash = false;
            leadingSlash = this.parseIdentifier(ParserRuleContext.IDENTIFIER);
            identifierList.add(leadingSlash);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(identifierList);
    }

    private boolean isEndAbsoluteResourcePath(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.ON_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseAbsoluteResourcePathEnd(boolean isInitialSlash) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: 
            case ON_KEYWORD: {
                return null;
            }
            case SLASH_TOKEN: {
                return this.consume();
            }
        }
        ParserRuleContext context = isInitialSlash ? ParserRuleContext.OPTIONAL_ABSOLUTE_PATH : ParserRuleContext.ABSOLUTE_RESOURCE_PATH_END;
        this.recover(nextToken, context);
        return this.parseAbsoluteResourcePathEnd(isInitialSlash);
    }

    private STNode parseServiceKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SERVICE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SERVICE_KEYWORD);
        return this.parseServiceKeyword();
    }

    static boolean isCompoundBinaryOperator(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.PIPE_TOKEN, SyntaxKind.BITWISE_AND_TOKEN, SyntaxKind.SLASH_TOKEN, SyntaxKind.ASTERISK_TOKEN, SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN, SyntaxKind.BITWISE_XOR_TOKEN, SyntaxKind.DOUBLE_LT_TOKEN, SyntaxKind.DOUBLE_GT_TOKEN, SyntaxKind.TRIPPLE_GT_TOKEN -> true;
            default -> false;
        };
    }

    private boolean isCompoundAssignment(SyntaxKind tokenKind) {
        return BallerinaParser.isCompoundBinaryOperator(tokenKind) && this.getNextNextToken().kind == SyntaxKind.EQUAL_TOKEN;
    }

    private STNode parseOnKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ON_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ON_KEYWORD);
        return this.parseOnKeyword();
    }

    private STNode parseListeners() {
        STNode listenersMemberEnd;
        this.startContext(ParserRuleContext.LISTENERS_LIST);
        ArrayList<STNode> listeners = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfListeners(nextToken.kind)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode expr = this.parseExpression();
        listeners.add(expr);
        while (!this.isEndOfListeners(this.peek().kind) && (listenersMemberEnd = this.parseListenersMemberEnd()) != null) {
            listeners.add(listenersMemberEnd);
            expr = this.parseExpression();
            listeners.add(expr);
        }
        this.endContext();
        return STNodeFactory.createNodeList(listeners);
    }

    private boolean isEndOfListeners(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseListenersMemberEnd() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.OPEN_BRACE_TOKEN -> null;
            default -> {
                this.recover(nextToken, ParserRuleContext.LISTENERS_LIST_END);
                yield this.parseListenersMemberEnd();
            }
        };
    }

    private boolean isServiceDeclStart(ParserRuleContext currentContext, int lookahead) {
        return switch (this.peek((int)(lookahead + 1)).kind) {
            case SyntaxKind.IDENTIFIER_TOKEN -> {
                SyntaxKind tokenAfterIdentifier = this.peek((int)(lookahead + 2)).kind;
                switch (tokenAfterIdentifier) {
                    case OPEN_BRACE_TOKEN: 
                    case ON_KEYWORD: {
                        yield true;
                    }
                    case EQUAL_TOKEN: 
                    case SEMICOLON_TOKEN: 
                    case QUESTION_MARK_TOKEN: {
                        yield false;
                    }
                }
                yield false;
            }
            case SyntaxKind.ON_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseListenerDeclaration(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.LISTENER_DECL);
        STNode listenerKeyword = this.parseListenerKeyword();
        if (this.peek().kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STNode listenerDecl = this.parseConstantOrListenerDeclWithOptionalType(metadata, qualifier, listenerKeyword, true);
            this.endContext();
            return listenerDecl;
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode variableName = this.parseVariableName();
        STNode equalsToken = this.parseAssignOp();
        STNode initializer = this.parseExpression();
        STNode semicolonToken = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createListenerDeclarationNode(metadata, qualifier, listenerKeyword, typeDesc, variableName, equalsToken, initializer, semicolonToken);
    }

    private STNode parseListenerKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LISTENER_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LISTENER_KEYWORD);
        return this.parseListenerKeyword();
    }

    private STNode parseConstantDeclaration(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.CONSTANT_DECL);
        STNode constKeyword = this.parseConstantKeyword();
        return this.parseConstDecl(metadata, qualifier, constKeyword);
    }

    private STNode parseConstDecl(STNode metadata, STNode qualifier, STNode constKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ANNOTATION_KEYWORD: {
                this.endContext();
                return this.parseAnnotationDeclaration(metadata, qualifier, constKeyword);
            }
            case IDENTIFIER_TOKEN: {
                STNode constantDecl = this.parseConstantOrListenerDeclWithOptionalType(metadata, qualifier, constKeyword, false);
                this.endContext();
                return constantDecl;
            }
        }
        if (!this.isTypeStartingToken(nextToken.kind)) {
            this.recover(this.peek(), ParserRuleContext.CONST_DECL_TYPE);
            return this.parseConstDecl(metadata, qualifier, constKeyword);
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER);
        STNode variableName = this.parseVariableName();
        STNode equalsToken = this.parseAssignOp();
        STNode initializer = this.parseExpression();
        STNode semicolonToken = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createConstantDeclarationNode(metadata, qualifier, constKeyword, typeDesc, variableName, equalsToken, initializer, semicolonToken);
    }

    private STNode parseConstantOrListenerDeclWithOptionalType(STNode metadata, STNode qualifier, STNode constKeyword, boolean isListener) {
        STNode varNameOrTypeName = this.parseStatementStartIdentifier();
        return this.parseConstantOrListenerDeclRhs(metadata, qualifier, constKeyword, varNameOrTypeName, isListener);
    }

    private STNode parseConstantOrListenerDeclRhs(STNode metadata, STNode qualifier, STNode keyword, STNode typeOrVarName, boolean isListener) {
        STNode variableName;
        STNode type;
        if (typeOrVarName.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            STNode type2 = typeOrVarName;
            STNode variableName2 = this.parseVariableName();
            return this.parseListenerOrConstRhs(metadata, qualifier, keyword, isListener, type2, variableName2);
        }
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                type = typeOrVarName;
                variableName = this.parseVariableName();
                break;
            }
            case EQUAL_TOKEN: {
                variableName = ((STSimpleNameReferenceNode)typeOrVarName).name;
                type = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.CONST_DECL_RHS);
                return this.parseConstantOrListenerDeclRhs(metadata, qualifier, keyword, typeOrVarName, isListener);
            }
        }
        return this.parseListenerOrConstRhs(metadata, qualifier, keyword, isListener, type, variableName);
    }

    private STNode parseListenerOrConstRhs(STNode metadata, STNode qualifier, STNode keyword, boolean isListener, STNode type, STNode variableName) {
        STNode equalsToken = this.parseAssignOp();
        STNode initializer = this.parseExpression();
        STNode semicolonToken = this.parseSemicolon();
        if (isListener) {
            return STNodeFactory.createListenerDeclarationNode(metadata, qualifier, keyword, type, variableName, equalsToken, initializer, semicolonToken);
        }
        return STNodeFactory.createConstantDeclarationNode(metadata, qualifier, keyword, type, variableName, equalsToken, initializer, semicolonToken);
    }

    private STNode parseConstantKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CONST_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CONST_KEYWORD);
        return this.parseConstantKeyword();
    }

    private STNode parseTypeofExpression(boolean isRhsExpr, boolean isInConditionalExpr) {
        STNode typeofKeyword = this.parseTypeofKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.UNARY, isRhsExpr, false, isInConditionalExpr);
        return STNodeFactory.createTypeofExpressionNode(typeofKeyword, expr);
    }

    private STNode parseTypeofKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TYPEOF_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TYPEOF_KEYWORD);
        return this.parseTypeofKeyword();
    }

    private STNode parseOptionalTypeDescriptor(STNode typeDescriptorNode) {
        this.startContext(ParserRuleContext.OPTIONAL_TYPE_DESCRIPTOR);
        STNode questionMarkToken = this.parseQuestionMark();
        this.endContext();
        return this.createOptionalTypeDesc(typeDescriptorNode, questionMarkToken);
    }

    private STNode createOptionalTypeDesc(STNode typeDescNode, STNode questionMarkToken) {
        if (typeDescNode.kind == SyntaxKind.UNION_TYPE_DESC) {
            STUnionTypeDescriptorNode unionTypeDesc = (STUnionTypeDescriptorNode)typeDescNode;
            STNode middleTypeDesc = this.createOptionalTypeDesc(unionTypeDesc.rightTypeDesc, questionMarkToken);
            typeDescNode = this.mergeTypesWithUnion(unionTypeDesc.leftTypeDesc, unionTypeDesc.pipeToken, middleTypeDesc);
        } else if (typeDescNode.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
            STIntersectionTypeDescriptorNode intersectionTypeDesc = (STIntersectionTypeDescriptorNode)typeDescNode;
            STNode middleTypeDesc = this.createOptionalTypeDesc(intersectionTypeDesc.rightTypeDesc, questionMarkToken);
            typeDescNode = this.mergeTypesWithIntersection(intersectionTypeDesc.leftTypeDesc, intersectionTypeDesc.bitwiseAndToken, middleTypeDesc);
        } else {
            typeDescNode = this.validateForUsageOfVar(typeDescNode);
            typeDescNode = STNodeFactory.createOptionalTypeDescriptorNode(typeDescNode, questionMarkToken);
        }
        return typeDescNode;
    }

    private STNode parseUnaryExpression(boolean isRhsExpr, boolean isInConditionalExpr) {
        STNode unaryOperator = this.parseUnaryOperator();
        STNode expr = this.parseExpression(OperatorPrecedence.UNARY, isRhsExpr, false, isInConditionalExpr);
        return STNodeFactory.createUnaryExpressionNode(unaryOperator, expr);
    }

    private STNode parseUnaryOperator() {
        STToken token = this.peek();
        if (this.isUnaryOperator(token.kind)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.UNARY_OPERATOR);
        return this.parseUnaryOperator();
    }

    private boolean isUnaryOperator(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN, SyntaxKind.NEGATION_TOKEN, SyntaxKind.EXCLAMATION_MARK_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseArrayTypeDescriptor(STNode memberTypeDesc) {
        this.startContext(ParserRuleContext.ARRAY_TYPE_DESCRIPTOR);
        STNode openBracketToken = this.parseOpenBracket();
        STNode arrayLengthNode = this.parseArrayLength();
        STNode closeBracketToken = this.parseCloseBracket();
        this.endContext();
        return this.createArrayTypeDesc(memberTypeDesc, openBracketToken, arrayLengthNode, closeBracketToken);
    }

    private STNode createArrayTypeDesc(STNode memberTypeDesc, STNode openBracketToken, STNode arrayLengthNode, STNode closeBracketToken) {
        memberTypeDesc = this.validateForUsageOfVar(memberTypeDesc);
        if (arrayLengthNode != null) {
            switch (arrayLengthNode.kind) {
                case SIMPLE_NAME_REFERENCE: 
                case QUALIFIED_NAME_REFERENCE: 
                case ASTERISK_LITERAL: {
                    break;
                }
                case NUMERIC_LITERAL: {
                    SyntaxKind numericLiteralKind = arrayLengthNode.childInBucket((int)0).kind;
                    if (numericLiteralKind == SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN || numericLiteralKind == SyntaxKind.HEX_INTEGER_LITERAL_TOKEN) break;
                }
                default: {
                    openBracketToken = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(openBracketToken, arrayLengthNode, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_ARRAY_LENGTH, new Object[0]);
                    arrayLengthNode = STNodeFactory.createEmptyNode();
                }
            }
        }
        ArrayList<STNode> arrayDimensions = new ArrayList<STNode>();
        if (memberTypeDesc.kind == SyntaxKind.ARRAY_TYPE_DESC) {
            STArrayTypeDescriptorNode innerArrayType = (STArrayTypeDescriptorNode)memberTypeDesc;
            STNode innerArrayDimensions = innerArrayType.dimensions;
            int dimensionCount = innerArrayDimensions.bucketCount();
            for (int i = 0; i < dimensionCount; ++i) {
                arrayDimensions.add(innerArrayDimensions.childInBucket(i));
            }
            memberTypeDesc = innerArrayType.memberTypeDesc;
        }
        STNode arrayDimension = STNodeFactory.createArrayDimensionNode(openBracketToken, arrayLengthNode, closeBracketToken);
        arrayDimensions.add(arrayDimension);
        STNode arrayDimensionNodeList = STNodeFactory.createNodeList(arrayDimensions);
        return STNodeFactory.createArrayTypeDescriptorNode(memberTypeDesc, arrayDimensionNodeList);
    }

    private STNode parseArrayLength() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.ASTERISK_TOKEN, SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN -> this.parseBasicLiteral();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> STNodeFactory.createEmptyNode();
            case SyntaxKind.IDENTIFIER_TOKEN -> this.parseQualifiedIdentifier(ParserRuleContext.ARRAY_LENGTH);
            default -> {
                this.recover(token, ParserRuleContext.ARRAY_LENGTH);
                yield this.parseArrayLength();
            }
        };
    }

    private STNode parseOptionalAnnotations() {
        this.startContext(ParserRuleContext.ANNOTATIONS);
        ArrayList<STNode> annotList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (nextToken.kind == SyntaxKind.AT_TOKEN) {
            annotList.add(this.parseAnnotation());
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(annotList);
    }

    private STNode parseAnnotations() {
        this.startContext(ParserRuleContext.ANNOTATIONS);
        ArrayList<STNode> annotList = new ArrayList<STNode>();
        annotList.add(this.parseAnnotation());
        while (this.peek().kind == SyntaxKind.AT_TOKEN) {
            annotList.add(this.parseAnnotation());
        }
        this.endContext();
        return STNodeFactory.createNodeList(annotList);
    }

    private STNode parseAnnotation() {
        STNode annotReference;
        STNode atToken = this.parseAtToken();
        if (this.isPredeclaredIdentifier(this.peek().kind)) {
            annotReference = this.parseQualifiedIdentifier(ParserRuleContext.ANNOT_REFERENCE);
        } else {
            annotReference = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            annotReference = STNodeFactory.createSimpleNameReferenceNode(annotReference);
        }
        STNode annotValue = this.peek().kind == SyntaxKind.OPEN_BRACE_TOKEN ? this.parseMappingConstructorExpr() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createAnnotationNode(atToken, annotReference, annotValue);
    }

    private STNode parseAtToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.AT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.AT);
        return this.parseAtToken();
    }

    private STNode parseMetaData() {
        STNode annotations;
        STNode docString;
        switch (this.peek().kind) {
            case DOCUMENTATION_STRING: {
                docString = this.parseMarkdownDocumentation();
                annotations = this.parseOptionalAnnotations();
                break;
            }
            case AT_TOKEN: {
                docString = STNodeFactory.createEmptyNode();
                annotations = this.parseOptionalAnnotations();
                break;
            }
            default: {
                return STNodeFactory.createEmptyNode();
            }
        }
        return this.createMetadata(docString, annotations);
    }

    private STNode createMetadata(STNode docString, STNode annotations) {
        if (annotations == null && docString == null) {
            return STNodeFactory.createEmptyNode();
        }
        return STNodeFactory.createMetadataNode(docString, annotations);
    }

    private STNode parseTypeTestExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode isOrNotIsKeyword = this.parseIsOrNotIsKeyword();
        STNode typeDescriptor = this.parseTypeDescriptorInExpression(isInConditionalExpr);
        return STNodeFactory.createTypeTestExpressionNode(lhsExpr, isOrNotIsKeyword, typeDescriptor);
    }

    private STNode parseIsOrNotIsKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IS_KEYWORD || token.kind == SyntaxKind.NOT_IS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IS_KEYWORD);
        return this.parseIsOrNotIsKeyword();
    }

    private STNode parseLocalTypeDefinitionStatement(STNode annots) {
        this.startContext(ParserRuleContext.LOCAL_TYPE_DEFINITION_STMT);
        STNode typeKeyword = this.parseTypeKeyword();
        STNode typeName = this.parseTypeName();
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_DEF);
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createLocalTypeDefinitionStatementNode(annots, typeKeyword, typeName, typeDescriptor, semicolon);
    }

    private STNode parseExpressionStatement(STNode annots) {
        this.startContext(ParserRuleContext.EXPRESSION_STATEMENT);
        STNode expression = this.parseActionOrExpressionInLhs(annots);
        return this.getExpressionAsStatement(expression);
    }

    private STNode parseStatementStartWithExpr(STNode annots) {
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode expr = this.parseActionOrExpressionInLhs(annots);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseStatementStartWithExprRhs(STNode expression) {
        SyntaxKind nextTokenKind = this.peek().kind;
        if (this.isAction(expression) || nextTokenKind == SyntaxKind.SEMICOLON_TOKEN) {
            return this.getExpressionAsStatement(expression);
        }
        switch (nextTokenKind) {
            case EQUAL_TOKEN: {
                this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                return this.parseAssignmentStmtRhs(expression);
            }
        }
        if (this.isCompoundAssignment(nextTokenKind)) {
            return this.parseCompoundAssignmentStmtRhs(expression);
        }
        ParserRuleContext context = this.isPossibleExpressionStatement(expression) ? ParserRuleContext.EXPR_STMT_RHS : ParserRuleContext.STMT_START_WITH_EXPR_RHS;
        this.recover(this.peek(), context);
        return this.parseStatementStartWithExprRhs(expression);
    }

    private boolean isPossibleExpressionStatement(STNode expression) {
        return switch (expression.kind) {
            case SyntaxKind.REMOTE_METHOD_CALL_ACTION, SyntaxKind.BRACED_ACTION, SyntaxKind.CHECK_ACTION, SyntaxKind.START_ACTION, SyntaxKind.TRAP_ACTION, SyntaxKind.FLUSH_ACTION, SyntaxKind.ASYNC_SEND_ACTION, SyntaxKind.SYNC_SEND_ACTION, SyntaxKind.RECEIVE_ACTION, SyntaxKind.WAIT_ACTION, SyntaxKind.QUERY_ACTION, SyntaxKind.COMMIT_ACTION, SyntaxKind.METHOD_CALL, SyntaxKind.FUNCTION_CALL, SyntaxKind.CHECK_EXPRESSION -> true;
            default -> false;
        };
    }

    private STNode getExpressionAsStatement(STNode expression) {
        switch (expression.kind) {
            case METHOD_CALL: 
            case FUNCTION_CALL: {
                return this.parseCallStatement(expression);
            }
            case CHECK_EXPRESSION: {
                return this.parseCheckStatement(expression);
            }
            case REMOTE_METHOD_CALL_ACTION: 
            case BRACED_ACTION: 
            case CHECK_ACTION: 
            case START_ACTION: 
            case TRAP_ACTION: 
            case FLUSH_ACTION: 
            case ASYNC_SEND_ACTION: 
            case SYNC_SEND_ACTION: 
            case RECEIVE_ACTION: 
            case WAIT_ACTION: 
            case QUERY_ACTION: 
            case COMMIT_ACTION: 
            case CLIENT_RESOURCE_ACCESS_ACTION: {
                return this.parseActionStatement(expression);
            }
        }
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        expression = this.getExpression(expression);
        STNode exprStmt = STNodeFactory.createExpressionStatementNode(SyntaxKind.INVALID_EXPRESSION_STATEMENT, expression, semicolon);
        exprStmt = SyntaxErrors.addDiagnostic(exprStmt, DiagnosticErrorCode.ERROR_INVALID_EXPRESSION_STATEMENT, new Object[0]);
        return exprStmt;
    }

    private STNode parseArrayTypeDescriptorNode(STIndexedExpressionNode indexedExpr) {
        STNode memberTypeDesc = this.getTypeDescFromExpr(indexedExpr.containerExpression);
        STNodeList lengthExprs = (STNodeList)indexedExpr.keyExpression;
        if (lengthExprs.isEmpty()) {
            return this.createArrayTypeDesc(memberTypeDesc, indexedExpr.openBracket, STNodeFactory.createEmptyNode(), indexedExpr.closeBracket);
        }
        STNode lengthExpr = lengthExprs.get(0);
        switch (lengthExpr.kind) {
            case SIMPLE_NAME_REFERENCE: {
                STSimpleNameReferenceNode nameRef = (STSimpleNameReferenceNode)lengthExpr;
                if (!nameRef.name.isMissing()) break;
                return this.createArrayTypeDesc(memberTypeDesc, indexedExpr.openBracket, STNodeFactory.createEmptyNode(), indexedExpr.closeBracket);
            }
            case QUALIFIED_NAME_REFERENCE: 
            case ASTERISK_LITERAL: {
                break;
            }
            case NUMERIC_LITERAL: {
                SyntaxKind innerChildKind = lengthExpr.childInBucket((int)0).kind;
                if (innerChildKind == SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN || innerChildKind == SyntaxKind.HEX_INTEGER_LITERAL_TOKEN) break;
            }
            default: {
                STNode newOpenBracketWithDiagnostics = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(indexedExpr.openBracket, lengthExpr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_ARRAY_LENGTH, new Object[0]);
                indexedExpr = (STIndexedExpressionNode)indexedExpr.replace(indexedExpr.openBracket, newOpenBracketWithDiagnostics);
                lengthExpr = STNodeFactory.createEmptyNode();
            }
        }
        return this.createArrayTypeDesc(memberTypeDesc, indexedExpr.openBracket, lengthExpr, indexedExpr.closeBracket);
    }

    private STNode parseCallStatement(STNode expression) {
        return this.parseCallStatementOrCheckStatement(expression);
    }

    private STNode parseCheckStatement(STNode expression) {
        return this.parseCallStatementOrCheckStatement(expression);
    }

    private STNode parseCallStatementOrCheckStatement(STNode expression) {
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createExpressionStatementNode(SyntaxKind.CALL_STATEMENT, expression, semicolon);
    }

    private STNode parseActionStatement(STNode action) {
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createExpressionStatementNode(SyntaxKind.ACTION_STATEMENT, action, semicolon);
    }

    private STNode parseClientResourceAccessAction(STNode expression, STNode rightArrow, STNode slashToken, boolean isRhsExpr, boolean isInMatchGuard) {
        this.startContext(ParserRuleContext.CLIENT_RESOURCE_ACCESS_ACTION);
        STNode resourceAccessPath = this.parseOptionalResourceAccessPath(isRhsExpr, isInMatchGuard);
        STNode resourceAccessMethodDot = this.parseOptionalResourceAccessMethodDot(isRhsExpr, isInMatchGuard);
        STNode resourceAccessMethodName = STNodeFactory.createEmptyNode();
        if (resourceAccessMethodDot != null) {
            resourceAccessMethodName = STNodeFactory.createSimpleNameReferenceNode(this.parseFunctionName());
        }
        STNode resourceMethodCallArgList = this.parseOptionalResourceAccessActionArgList(isRhsExpr, isInMatchGuard);
        this.endContext();
        return STNodeFactory.createClientResourceAccessActionNode(expression, rightArrow, slashToken, resourceAccessPath, resourceAccessMethodDot, resourceAccessMethodName, resourceMethodCallArgList);
    }

    private STNode parseOptionalResourceAccessPath(boolean isRhsExpr, boolean isInMatchGuard) {
        STNode resourceAccessPath = STNodeFactory.createEmptyNodeList();
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: {
                resourceAccessPath = this.parseResourceAccessPath(isRhsExpr, isInMatchGuard);
                break;
            }
            case DOT_TOKEN: 
            case OPEN_PAREN_TOKEN: {
                break;
            }
            default: {
                if (this.isEndOfActionOrExpression(nextToken, isRhsExpr, isInMatchGuard)) break;
                this.recover(nextToken, ParserRuleContext.OPTIONAL_RESOURCE_ACCESS_PATH);
                return this.parseOptionalResourceAccessPath(isRhsExpr, isInMatchGuard);
            }
        }
        return resourceAccessPath;
    }

    private STNode parseOptionalResourceAccessMethodDot(boolean isRhsExpr, boolean isInMatchGuard) {
        STNode dotToken = STNodeFactory.createEmptyNode();
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case DOT_TOKEN: {
                dotToken = this.consume();
                break;
            }
            case OPEN_PAREN_TOKEN: {
                break;
            }
            default: {
                if (this.isEndOfActionOrExpression(nextToken, isRhsExpr, isInMatchGuard)) break;
                this.recover(nextToken, ParserRuleContext.OPTIONAL_RESOURCE_ACCESS_METHOD);
                return this.parseOptionalResourceAccessMethodDot(isRhsExpr, isInMatchGuard);
            }
        }
        return dotToken;
    }

    private STNode parseOptionalResourceAccessActionArgList(boolean isRhsExpr, boolean isInMatchGuard) {
        STNode argList = STNodeFactory.createEmptyNode();
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                argList = this.parseParenthesizedArgList();
                break;
            }
            default: {
                if (this.isEndOfActionOrExpression(nextToken, isRhsExpr, isInMatchGuard)) break;
                this.recover(nextToken, ParserRuleContext.OPTIONAL_RESOURCE_ACCESS_ACTION_ARG_LIST);
                return this.parseOptionalResourceAccessActionArgList(isRhsExpr, isInMatchGuard);
            }
        }
        return argList;
    }

    private STNode parseResourceAccessPath(boolean isRhsExpr, boolean isInMatchGuard) {
        STNode leadingSlash;
        ArrayList<STNode> pathSegmentList = new ArrayList<STNode>();
        STNode pathSegment = this.parseResourceAccessSegment();
        pathSegmentList.add(pathSegment);
        STNode previousPathSegmentNode = pathSegment;
        while (!this.isEndOfResourceAccessPathSegments(this.peek(), isRhsExpr, isInMatchGuard) && (leadingSlash = this.parseResourceAccessSegmentRhs(isRhsExpr, isInMatchGuard)) != null) {
            pathSegment = this.parseResourceAccessSegment();
            if (previousPathSegmentNode.kind == SyntaxKind.RESOURCE_ACCESS_REST_SEGMENT) {
                this.updateLastNodeInListWithInvalidNode(pathSegmentList, leadingSlash, null, new Object[0]);
                this.updateLastNodeInListWithInvalidNode(pathSegmentList, pathSegment, DiagnosticErrorCode.RESOURCE_ACCESS_SEGMENT_IS_NOT_ALLOWED_AFTER_REST_SEGMENT, new Object[0]);
                continue;
            }
            pathSegmentList.add(leadingSlash);
            pathSegmentList.add(pathSegment);
            previousPathSegmentNode = pathSegment;
        }
        return STNodeFactory.createNodeList(pathSegmentList);
    }

    private STNode parseResourceAccessSegment() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.IDENTIFIER_TOKEN -> this.consume();
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseComputedOrResourceAccessRestSegment(this.consume());
            default -> {
                this.recover(nextToken, ParserRuleContext.RESOURCE_ACCESS_PATH_SEGMENT);
                yield this.parseResourceAccessSegment();
            }
        };
    }

    private STNode parseComputedOrResourceAccessRestSegment(STNode openBracket) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                STToken ellipsisToken = this.consume();
                STNode expression = this.parseExpression();
                STNode closeBracketToken = this.parseCloseBracket();
                return STNodeFactory.createResourceAccessRestSegmentNode(openBracket, ellipsisToken, expression, closeBracketToken);
            }
        }
        if (this.isValidExprStart(nextToken.kind)) {
            STNode expression = this.parseExpression();
            STNode closeBracketToken = this.parseCloseBracket();
            return STNodeFactory.createComputedResourceAccessSegmentNode(openBracket, expression, closeBracketToken);
        }
        this.recover(nextToken, ParserRuleContext.COMPUTED_SEGMENT_OR_REST_SEGMENT);
        return this.parseComputedOrResourceAccessRestSegment(openBracket);
    }

    private STNode parseResourceAccessSegmentRhs(boolean isRhsExpr, boolean isInMatchGuard) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SLASH_TOKEN: {
                return this.consume();
            }
        }
        if (this.isEndOfResourceAccessPathSegments(nextToken, isRhsExpr, isInMatchGuard)) {
            return null;
        }
        this.recover(nextToken, ParserRuleContext.RESOURCE_ACCESS_SEGMENT_RHS);
        return this.parseResourceAccessSegmentRhs(isRhsExpr, isInMatchGuard);
    }

    private boolean isEndOfResourceAccessPathSegments(STToken nextToken, boolean isRhsExpr, boolean isInMatchGuard) {
        return switch (nextToken.kind) {
            case SyntaxKind.DOT_TOKEN, SyntaxKind.OPEN_PAREN_TOKEN -> true;
            default -> this.isEndOfActionOrExpression(nextToken, isRhsExpr, isInMatchGuard);
        };
    }

    private STNode parseRemoteMethodCallOrClientResourceAccessOrAsyncSendAction(STNode expression, boolean isRhsExpr, boolean isInMatchGuard) {
        STNode rightArrow = this.parseRightArrow();
        return this.parseClientResourceAccessOrAsyncSendActionRhs(expression, rightArrow, isRhsExpr, isInMatchGuard);
    }

    private STNode parseClientResourceAccessOrAsyncSendActionRhs(STNode expression, STNode rightArrow, boolean isRhsExpr, boolean isInMatchGuard) {
        STNode name;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case FUNCTION_KEYWORD: {
                STToken functionKeyword = this.consume();
                STNode name2 = STNodeFactory.createSimpleNameReferenceNode(functionKeyword);
                return this.parseAsyncSendAction(expression, rightArrow, name2);
            }
            case CONTINUE_KEYWORD: 
            case COMMIT_KEYWORD: {
                name = this.getKeywordAsSimpleNameRef();
                break;
            }
            case SLASH_TOKEN: {
                STToken slashToken = this.consume();
                return this.parseClientResourceAccessAction(expression, rightArrow, slashToken, isRhsExpr, isInMatchGuard);
            }
            default: {
                if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
                    STToken nextNextToken = this.getNextNextToken();
                    if (nextNextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN || this.isEndOfActionOrExpression(nextNextToken, isRhsExpr, isInMatchGuard) || nextToken.isMissing()) {
                        name = STNodeFactory.createSimpleNameReferenceNode(this.parseFunctionName());
                        break;
                    }
                }
                STToken token = this.peek();
                AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.REMOTE_OR_RESOURCE_CALL_OR_ASYNC_SEND_RHS);
                if (solution.action == AbstractParserErrorHandler.Action.KEEP) {
                    name = STNodeFactory.createSimpleNameReferenceNode(this.parseFunctionName());
                    break;
                }
                return this.parseClientResourceAccessOrAsyncSendActionRhs(expression, rightArrow, isRhsExpr, isInMatchGuard);
            }
        }
        return this.parseRemoteCallOrAsyncSendEnd(expression, rightArrow, name);
    }

    private STNode parseRemoteCallOrAsyncSendEnd(STNode expression, STNode rightArrow, STNode name) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                return this.parseRemoteMethodCallAction(expression, rightArrow, name);
            }
            case SEMICOLON_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case FROM_KEYWORD: 
            case LET_KEYWORD: 
            case WHERE_KEYWORD: 
            case SELECT_KEYWORD: 
            case ON_KEYWORD: 
            case LIMIT_KEYWORD: 
            case JOIN_KEYWORD: 
            case ORDER_KEYWORD: {
                return this.parseAsyncSendAction(expression, rightArrow, name);
            }
        }
        if (BallerinaParser.isGroupOrCollectKeyword(nextToken)) {
            return this.parseAsyncSendAction(expression, rightArrow, name);
        }
        this.recover(this.peek(), ParserRuleContext.REMOTE_CALL_OR_ASYNC_SEND_END);
        return this.parseRemoteCallOrAsyncSendEnd(expression, rightArrow, name);
    }

    private STNode parseAsyncSendAction(STNode expression, STNode rightArrow, STNode peerWorker) {
        return STNodeFactory.createAsyncSendActionNode(expression, rightArrow, peerWorker);
    }

    private STNode parseRemoteMethodCallAction(STNode expression, STNode rightArrow, STNode name) {
        STNode openParenToken = this.parseArgListOpenParenthesis();
        STNode arguments = this.parseArgsList();
        STNode closeParenToken = this.parseArgListCloseParenthesis();
        return STNodeFactory.createRemoteMethodCallActionNode(expression, rightArrow, name, openParenToken, arguments, closeParenToken);
    }

    private STNode parseRightArrow() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.RIGHT_ARROW_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.RIGHT_ARROW);
        return this.parseRightArrow();
    }

    private STNode parseMapTypeDescriptor(STNode mapKeyword) {
        STNode typeParameter = this.parseTypeParameter();
        return STNodeFactory.createMapTypeDescriptorNode(mapKeyword, typeParameter);
    }

    private STNode parseParameterizedTypeDescriptor(STNode keywordToken) {
        STToken nextToken = this.peek();
        STNode typeParamNode = nextToken.kind == SyntaxKind.LT_TOKEN ? this.parseTypeParameter() : STNodeFactory.createEmptyNode();
        SyntaxKind parameterizedTypeDescKind = this.getParameterizedTypeDescKind(keywordToken);
        return STNodeFactory.createParameterizedTypeDescriptorNode(parameterizedTypeDescKind, keywordToken, typeParamNode);
    }

    private SyntaxKind getParameterizedTypeDescKind(STNode keywordToken) {
        return switch (keywordToken.kind) {
            case SyntaxKind.TYPEDESC_KEYWORD -> SyntaxKind.TYPEDESC_TYPE_DESC;
            case SyntaxKind.FUTURE_KEYWORD -> SyntaxKind.FUTURE_TYPE_DESC;
            case SyntaxKind.XML_KEYWORD -> SyntaxKind.XML_TYPE_DESC;
            default -> SyntaxKind.ERROR_TYPE_DESC;
        };
    }

    private STNode parseGTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.GT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.GT);
        return this.parseGTToken();
    }

    private STNode parseLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.LT);
        return this.parseLTToken();
    }

    private STNode parseNilLiteral() {
        this.startContext(ParserRuleContext.NIL_LITERAL);
        STNode openParenthesisToken = this.parseOpenParenthesis();
        STNode closeParenthesisToken = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createNilLiteralNode(openParenthesisToken, closeParenthesisToken);
    }

    private STNode parseAnnotationDeclaration(STNode metadata, STNode qualifier, STNode constKeyword) {
        this.startContext(ParserRuleContext.ANNOTATION_DECL);
        STNode annotationKeyword = this.parseAnnotationKeyword();
        STNode annotDecl = this.parseAnnotationDeclFromType(metadata, qualifier, constKeyword, annotationKeyword);
        this.endContext();
        return annotDecl;
    }

    private STNode parseAnnotationKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ANNOTATION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ANNOTATION_KEYWORD);
        return this.parseAnnotationKeyword();
    }

    private STNode parseAnnotationDeclFromType(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                return this.parseAnnotationDeclWithOptionalType(metadata, qualifier, constKeyword, annotationKeyword);
            }
        }
        if (!this.isTypeStartingToken(nextToken.kind)) {
            this.recover(this.peek(), ParserRuleContext.ANNOT_DECL_OPTIONAL_TYPE);
            return this.parseAnnotationDeclFromType(metadata, qualifier, constKeyword, annotationKeyword);
        }
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANNOTATION_DECL);
        STNode annotTag = this.parseAnnotationTag();
        return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
    }

    private STNode parseAnnotationTag() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.ANNOTATION_TAG);
        return this.parseAnnotationTag();
    }

    private STNode parseAnnotationDeclWithOptionalType(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword) {
        STNode typeDescOrAnnotTag = this.parseQualifiedIdentifier(ParserRuleContext.ANNOT_DECL_OPTIONAL_TYPE);
        if (typeDescOrAnnotTag.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            STNode annotTag = this.parseAnnotationTag();
            return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDescOrAnnotTag, annotTag);
        }
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN || this.isValidTypeContinuationToken(nextToken)) {
            STNode typeDesc = this.parseComplexTypeDescriptor(typeDescOrAnnotTag, ParserRuleContext.TYPE_DESC_IN_ANNOTATION_DECL, false);
            STNode annotTag = this.parseAnnotationTag();
            return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
        }
        STNode annotTag = ((STSimpleNameReferenceNode)typeDescOrAnnotTag).name;
        return this.parseAnnotationDeclRhs(metadata, qualifier, constKeyword, annotationKeyword, annotTag);
    }

    private STNode parseAnnotationDeclRhs(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword, STNode typeDescOrAnnotTag) {
        STNode annotTag;
        STNode typeDesc;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                typeDesc = typeDescOrAnnotTag;
                annotTag = this.parseAnnotationTag();
                break;
            }
            case SEMICOLON_TOKEN: 
            case ON_KEYWORD: {
                typeDesc = STNodeFactory.createEmptyNode();
                annotTag = typeDescOrAnnotTag;
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ANNOT_DECL_RHS);
                return this.parseAnnotationDeclRhs(metadata, qualifier, constKeyword, annotationKeyword, typeDescOrAnnotTag);
            }
        }
        return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
    }

    private STNode parseAnnotationDeclAttachPoints(STNode metadata, STNode qualifier, STNode constKeyword, STNode annotationKeyword, STNode typeDesc, STNode annotTag) {
        STNode attachPoints;
        STNode onKeyword;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case SEMICOLON_TOKEN: {
                onKeyword = STNodeFactory.createEmptyNode();
                attachPoints = STNodeFactory.createEmptyNodeList();
                break;
            }
            case ON_KEYWORD: {
                onKeyword = this.parseOnKeyword();
                attachPoints = this.parseAnnotationAttachPoints();
                onKeyword = this.cloneWithDiagnosticIfListEmpty(attachPoints, onKeyword, DiagnosticErrorCode.ERROR_MISSING_ANNOTATION_ATTACH_POINT);
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ANNOT_OPTIONAL_ATTACH_POINTS);
                return this.parseAnnotationDeclAttachPoints(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag);
            }
        }
        STNode semicolonToken = this.parseSemicolon();
        return STNodeFactory.createAnnotationDeclarationNode(metadata, qualifier, constKeyword, annotationKeyword, typeDesc, annotTag, onKeyword, attachPoints, semicolonToken);
    }

    private STNode parseAnnotationAttachPoints() {
        STNode leadingComma;
        this.startContext(ParserRuleContext.ANNOT_ATTACH_POINTS_LIST);
        ArrayList<STNode> attachPoints = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndAnnotAttachPointList(nextToken.kind)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode attachPoint = this.parseAnnotationAttachPoint();
        attachPoints.add(attachPoint);
        nextToken = this.peek();
        while (!this.isEndAnnotAttachPointList(nextToken.kind) && (leadingComma = this.parseAttachPointEnd()) != null) {
            attachPoints.add(leadingComma);
            attachPoint = this.parseAnnotationAttachPoint();
            if (attachPoint == null) {
                STToken missingAttachPointIdent = SyntaxErrors.createMissingToken(SyntaxKind.TYPE_KEYWORD);
                STNode identList = STNodeFactory.createNodeList(missingAttachPointIdent);
                attachPoint = STNodeFactory.createAnnotationAttachPointNode(STNodeFactory.createEmptyNode(), identList);
                attachPoint = SyntaxErrors.addDiagnostic(attachPoint, DiagnosticErrorCode.ERROR_MISSING_ANNOTATION_ATTACH_POINT, new Object[0]);
                attachPoints.add(attachPoint);
                break;
            }
            attachPoints.add(attachPoint);
            nextToken = this.peek();
        }
        if (attachPoint.lastToken().isMissing() && this.tokenReader.peek().kind == SyntaxKind.IDENTIFIER_TOKEN && !this.tokenReader.head().hasTrailingNewline()) {
            STToken nextNonVirtualToken = this.tokenReader.read();
            this.updateLastNodeInListWithInvalidNode(attachPoints, nextNonVirtualToken, DiagnosticErrorCode.ERROR_INVALID_TOKEN, nextNonVirtualToken.text());
        }
        this.endContext();
        return STNodeFactory.createNodeList(attachPoints);
    }

    private STNode parseAttachPointEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.SEMICOLON_TOKEN -> null;
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            default -> {
                this.recover(this.peek(), ParserRuleContext.ATTACH_POINT_END);
                yield this.parseAttachPointEnd();
            }
        };
    }

    private boolean isEndAnnotAttachPointList(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.SEMICOLON_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseAnnotationAttachPoint() {
        switch (this.peek().kind) {
            case EOF_TOKEN: {
                return null;
            }
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case EXTERNAL_KEYWORD: 
            case WORKER_KEYWORD: 
            case VAR_KEYWORD: 
            case SOURCE_KEYWORD: {
                STNode sourceKeyword = this.parseSourceKeyword();
                return this.parseAttachPointIdent(sourceKeyword);
            }
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case CLASS_KEYWORD: 
            case SERVICE_KEYWORD: 
            case OBJECT_KEYWORD: 
            case RECORD_KEYWORD: 
            case RETURN_KEYWORD: 
            case PARAMETER_KEYWORD: 
            case FIELD_KEYWORD: {
                STNode sourceKeyword = STNodeFactory.createEmptyNode();
                STToken firstIdent = this.consume();
                return this.parseDualAttachPointIdent(sourceKeyword, firstIdent);
            }
        }
        this.recover(this.peek(), ParserRuleContext.ATTACH_POINT);
        return this.parseAnnotationAttachPoint();
    }

    private STNode parseSourceKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SOURCE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SOURCE_KEYWORD);
        return this.parseSourceKeyword();
    }

    private STNode parseAttachPointIdent(STNode sourceKeyword) {
        switch (this.peek().kind) {
            case LISTENER_KEYWORD: 
            case CONST_KEYWORD: 
            case ANNOTATION_KEYWORD: 
            case EXTERNAL_KEYWORD: 
            case WORKER_KEYWORD: 
            case VAR_KEYWORD: {
                STToken firstIdent = this.consume();
                STNode identList = STNodeFactory.createNodeList(firstIdent);
                return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, identList);
            }
            case FUNCTION_KEYWORD: 
            case TYPE_KEYWORD: 
            case CLASS_KEYWORD: 
            case SERVICE_KEYWORD: 
            case RESOURCE_KEYWORD: 
            case OBJECT_KEYWORD: 
            case RECORD_KEYWORD: 
            case RETURN_KEYWORD: 
            case PARAMETER_KEYWORD: 
            case FIELD_KEYWORD: {
                STToken firstIdent = this.consume();
                return this.parseDualAttachPointIdent(sourceKeyword, firstIdent);
            }
        }
        this.recover(this.peek(), ParserRuleContext.ATTACH_POINT_IDENT);
        return this.parseAttachPointIdent(sourceKeyword);
    }

    private STNode parseDualAttachPointIdent(STNode sourceKeyword, STNode firstIdent) {
        STNode secondIdent;
        switch (firstIdent.kind) {
            case OBJECT_KEYWORD: {
                secondIdent = this.parseIdentAfterObjectIdent();
                break;
            }
            case RESOURCE_KEYWORD: {
                secondIdent = this.parseFunctionIdent();
                break;
            }
            case RECORD_KEYWORD: {
                secondIdent = this.parseFieldIdent();
                break;
            }
            case SERVICE_KEYWORD: {
                return this.parseServiceAttachPoint(sourceKeyword, firstIdent);
            }
            default: {
                STNode identList = STNodeFactory.createNodeList(firstIdent);
                return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, identList);
            }
        }
        STNode identList = STNodeFactory.createNodeList(firstIdent, secondIdent);
        return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, identList);
    }

    private STNode parseRemoteIdent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.REMOTE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.REMOTE_IDENT);
        return this.parseRemoteIdent();
    }

    private STNode parseServiceAttachPoint(STNode sourceKeyword, STNode firstIdent) {
        STToken token = this.peek();
        switch (token.kind) {
            case REMOTE_KEYWORD: {
                STNode secondIdent = this.parseRemoteIdent();
                STNode thirdIdent = this.parseFunctionIdent();
                STNode identList = STNodeFactory.createNodeList(firstIdent, secondIdent, thirdIdent);
                return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, identList);
            }
            case SEMICOLON_TOKEN: 
            case COMMA_TOKEN: {
                STNode identList = STNodeFactory.createNodeList(firstIdent);
                return STNodeFactory.createAnnotationAttachPointNode(sourceKeyword, identList);
            }
        }
        this.recover(token, ParserRuleContext.SERVICE_IDENT_RHS);
        return this.parseServiceAttachPoint(sourceKeyword, firstIdent);
    }

    private STNode parseIdentAfterObjectIdent() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.FIELD_KEYWORD -> this.consume();
            default -> {
                this.recover(token, ParserRuleContext.IDENT_AFTER_OBJECT_IDENT);
                yield this.parseIdentAfterObjectIdent();
            }
        };
    }

    private STNode parseFunctionIdent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FUNCTION_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FUNCTION_IDENT);
        return this.parseFunctionIdent();
    }

    private STNode parseFieldIdent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FIELD_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FIELD_IDENT);
        return this.parseFieldIdent();
    }

    private STNode parseXMLNamespaceDeclaration(boolean isModuleVar) {
        this.startContext(ParserRuleContext.XML_NAMESPACE_DECLARATION);
        STNode xmlnsKeyword = this.parseXMLNSKeyword();
        STNode namespaceUri = this.parseSimpleConstExpr();
        while (!this.isValidXMLNameSpaceURI(namespaceUri)) {
            xmlnsKeyword = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(xmlnsKeyword, namespaceUri, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_XML_NAMESPACE_URI, new Object[0]);
            namespaceUri = this.parseSimpleConstExpr();
        }
        STNode xmlnsDecl = this.parseXMLDeclRhs(xmlnsKeyword, namespaceUri, isModuleVar);
        this.endContext();
        return xmlnsDecl;
    }

    private STNode parseXMLNSKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XMLNS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XMLNS_KEYWORD);
        return this.parseXMLNSKeyword();
    }

    private boolean isValidXMLNameSpaceURI(STNode expr) {
        return switch (expr.kind) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.STRING_LITERAL -> true;
            default -> false;
        };
    }

    private STNode parseSimpleConstExpr() {
        this.startContext(ParserRuleContext.CONSTANT_EXPRESSION);
        STNode expr = this.parseSimpleConstExprInternal();
        this.endContext();
        return expr;
    }

    private STNode parseSimpleConstExprInternal() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: {
                return this.parseSignedIntOrFloat();
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseNilLiteral();
            }
        }
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            return this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
        }
        this.recover(nextToken, ParserRuleContext.CONSTANT_EXPRESSION_START);
        return this.parseSimpleConstExprInternal();
    }

    private STNode parseXMLDeclRhs(STNode xmlnsKeyword, STNode namespaceUri, boolean isModuleVar) {
        STNode asKeyword = STNodeFactory.createEmptyNode();
        STNode namespacePrefix = STNodeFactory.createEmptyNode();
        switch (this.peek().kind) {
            case AS_KEYWORD: {
                asKeyword = this.parseAsKeyword();
                namespacePrefix = this.parseNamespacePrefix();
                break;
            }
            case SEMICOLON_TOKEN: {
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.XML_NAMESPACE_PREFIX_DECL);
                return this.parseXMLDeclRhs(xmlnsKeyword, namespaceUri, isModuleVar);
            }
        }
        STNode semicolon = this.parseSemicolon();
        if (isModuleVar) {
            return STNodeFactory.createModuleXMLNamespaceDeclarationNode(xmlnsKeyword, namespaceUri, asKeyword, namespacePrefix, semicolon);
        }
        return STNodeFactory.createXMLNamespaceDeclarationNode(xmlnsKeyword, namespaceUri, asKeyword, namespacePrefix, semicolon);
    }

    private STNode parseNamespacePrefix() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.NAMESPACE_PREFIX);
        return this.parseNamespacePrefix();
    }

    private STNode parseNamedWorkerDeclaration(STNode annots, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.NAMED_WORKER_DECL);
        STNode transactionalKeyword = this.getTransactionalKeyword(qualifiers);
        STNode workerKeyword = this.parseWorkerKeyword();
        STNode workerName = this.parseWorkerName();
        STNode returnTypeDesc = this.parseReturnTypeDescriptor();
        STNode workerBody = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createNamedWorkerDeclarationNode(annots, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody, onFailClause);
    }

    private STNode getTransactionalKeyword(List<STNode> qualifierList) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (qualifier.kind == SyntaxKind.TRANSACTIONAL_KEYWORD) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                this.addInvalidNodeToNextToken(qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        STNode transactionalKeyword = validatedList.isEmpty() ? STNodeFactory.createEmptyNode() : (STNode)validatedList.get(0);
        return transactionalKeyword;
    }

    private STNode parseReturnTypeDescriptor() {
        STToken token = this.peek();
        if (token.kind != SyntaxKind.RETURNS_KEYWORD) {
            return STNodeFactory.createEmptyNode();
        }
        STToken returnsKeyword = this.consume();
        STNode annot = this.parseOptionalAnnotations();
        STNode type = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_RETURN_TYPE_DESC);
        return STNodeFactory.createReturnTypeDescriptorNode(returnsKeyword, annot, type);
    }

    private STNode parseWorkerKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.WORKER_KEYWORD) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.WORKER_KEYWORD);
        return this.parseWorkerKeyword();
    }

    private STNode parseWorkerName() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        this.recover(this.peek(), ParserRuleContext.WORKER_NAME);
        return this.parseWorkerName();
    }

    private STNode parseLockStatement() {
        this.startContext(ParserRuleContext.LOCK_STMT);
        STNode lockKeyword = this.parseLockKeyword();
        STNode blockStatement = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createLockStatementNode(lockKeyword, blockStatement, onFailClause);
    }

    private STNode parseLockKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LOCK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LOCK_KEYWORD);
        return this.parseLockKeyword();
    }

    private STNode parseUnionTypeDescriptor(STNode leftTypeDesc, ParserRuleContext context, boolean isTypedBindingPattern) {
        STToken pipeToken = this.consume();
        STNode rightTypeDesc = this.parseTypeDescriptorInternal(new ArrayList<STNode>(), context, isTypedBindingPattern, false, TypePrecedence.UNION);
        return this.mergeTypesWithUnion(leftTypeDesc, pipeToken, rightTypeDesc);
    }

    private STNode createUnionTypeDesc(STNode leftTypeDesc, STNode pipeToken, STNode rightTypeDesc) {
        leftTypeDesc = this.validateForUsageOfVar(leftTypeDesc);
        rightTypeDesc = this.validateForUsageOfVar(rightTypeDesc);
        return STNodeFactory.createUnionTypeDescriptorNode(leftTypeDesc, pipeToken, rightTypeDesc);
    }

    private STNode parsePipeToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.PIPE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.PIPE);
        return this.parsePipeToken();
    }

    private boolean isTypeStartingToken(SyntaxKind nodeKind) {
        return BallerinaParser.isTypeStartingToken(nodeKind, this.getNextNextToken());
    }

    private static boolean isTypeStartingToken(SyntaxKind nextTokenKind, STToken nextNextToken) {
        switch (nextTokenKind) {
            case FUNCTION_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case DISTINCT_KEYWORD: 
            case CLIENT_KEYWORD: 
            case SERVICE_KEYWORD: 
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACKET_TOKEN: 
            case ABSTRACT_KEYWORD: 
            case OBJECT_KEYWORD: 
            case OPEN_PAREN_TOKEN: 
            case RECORD_KEYWORD: 
            case MAP_KEYWORD: 
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: 
            case TRANSACTION_KEYWORD: 
            case NATURAL_KEYWORD: {
                return true;
            }
        }
        if (BallerinaParser.isParameterizedTypeToken(nextTokenKind)) {
            return true;
        }
        if (BallerinaParser.isSingletonTypeDescStart(nextTokenKind, nextNextToken)) {
            return true;
        }
        return BallerinaParser.isSimpleType(nextTokenKind);
    }

    private boolean isSimpleTypeInExpression(SyntaxKind nodeKind) {
        return switch (nodeKind) {
            case SyntaxKind.READONLY_KEYWORD, SyntaxKind.VAR_KEYWORD -> false;
            default -> BallerinaParser.isSimpleType(nodeKind);
        };
    }

    static boolean isSimpleType(SyntaxKind nodeKind) {
        return switch (nodeKind) {
            case SyntaxKind.READONLY_KEYWORD, SyntaxKind.STRING_KEYWORD, SyntaxKind.VAR_KEYWORD, SyntaxKind.INT_KEYWORD, SyntaxKind.FLOAT_KEYWORD, SyntaxKind.DECIMAL_KEYWORD, SyntaxKind.BOOLEAN_KEYWORD, SyntaxKind.BYTE_KEYWORD, SyntaxKind.JSON_KEYWORD, SyntaxKind.HANDLE_KEYWORD, SyntaxKind.ANY_KEYWORD, SyntaxKind.ANYDATA_KEYWORD, SyntaxKind.NEVER_KEYWORD -> true;
            default -> false;
        };
    }

    static boolean isPredeclaredPrefix(SyntaxKind nodeKind) {
        return switch (nodeKind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.ERROR_KEYWORD, SyntaxKind.OBJECT_KEYWORD, SyntaxKind.MAP_KEYWORD, SyntaxKind.STREAM_KEYWORD, SyntaxKind.TABLE_KEYWORD, SyntaxKind.TRANSACTION_KEYWORD, SyntaxKind.TYPEDESC_KEYWORD, SyntaxKind.FUTURE_KEYWORD, SyntaxKind.XML_KEYWORD, SyntaxKind.STRING_KEYWORD, SyntaxKind.NATURAL_KEYWORD, SyntaxKind.INT_KEYWORD, SyntaxKind.FLOAT_KEYWORD, SyntaxKind.DECIMAL_KEYWORD, SyntaxKind.BOOLEAN_KEYWORD -> true;
            default -> false;
        };
    }

    private boolean isQualifiedIdentifierPredeclaredPrefix(SyntaxKind nodeKind) {
        return BallerinaParser.isPredeclaredPrefix(nodeKind) && this.getNextNextToken().kind == SyntaxKind.COLON_TOKEN;
    }

    private static SyntaxKind getBuiltinTypeSyntaxKind(SyntaxKind typeKeyword) {
        return switch (typeKeyword) {
            case SyntaxKind.INT_KEYWORD -> SyntaxKind.INT_TYPE_DESC;
            case SyntaxKind.FLOAT_KEYWORD -> SyntaxKind.FLOAT_TYPE_DESC;
            case SyntaxKind.DECIMAL_KEYWORD -> SyntaxKind.DECIMAL_TYPE_DESC;
            case SyntaxKind.BOOLEAN_KEYWORD -> SyntaxKind.BOOLEAN_TYPE_DESC;
            case SyntaxKind.STRING_KEYWORD -> SyntaxKind.STRING_TYPE_DESC;
            case SyntaxKind.BYTE_KEYWORD -> SyntaxKind.BYTE_TYPE_DESC;
            case SyntaxKind.JSON_KEYWORD -> SyntaxKind.JSON_TYPE_DESC;
            case SyntaxKind.HANDLE_KEYWORD -> SyntaxKind.HANDLE_TYPE_DESC;
            case SyntaxKind.ANY_KEYWORD -> SyntaxKind.ANY_TYPE_DESC;
            case SyntaxKind.ANYDATA_KEYWORD -> SyntaxKind.ANYDATA_TYPE_DESC;
            case SyntaxKind.NEVER_KEYWORD -> SyntaxKind.NEVER_TYPE_DESC;
            case SyntaxKind.VAR_KEYWORD -> SyntaxKind.VAR_TYPE_DESC;
            case SyntaxKind.READONLY_KEYWORD -> SyntaxKind.READONLY_TYPE_DESC;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)(String.valueOf((Object)typeKeyword) + " is not a built-in type"));
                }
                yield SyntaxKind.TYPE_REFERENCE;
            }
        };
    }

    private STNode parseForkKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FORK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FORK_KEYWORD);
        return this.parseForkKeyword();
    }

    private STNode parseForkStatement() {
        STNode stmt;
        this.startContext(ParserRuleContext.FORK_STMT);
        STNode forkKeyword = this.parseForkKeyword();
        STNode openBrace = this.parseOpenBrace();
        ArrayList<STNode> workers = new ArrayList<STNode>();
        block3: while (!this.isEndOfStatements() && (stmt = this.parseStatement()) != null) {
            if (this.validateStatement(stmt)) continue;
            switch (stmt.kind) {
                case NAMED_WORKER_DECLARATION: {
                    workers.add(stmt);
                    continue block3;
                }
            }
            if (workers.isEmpty()) {
                openBrace = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(openBrace, stmt, (DiagnosticCode)DiagnosticErrorCode.ERROR_ONLY_NAMED_WORKERS_ALLOWED_HERE, new Object[0]);
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(workers, stmt, DiagnosticErrorCode.ERROR_ONLY_NAMED_WORKERS_ALLOWED_HERE, new Object[0]);
        }
        STNode namedWorkerDeclarations = STNodeFactory.createNodeList(workers);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        STNode forkStmt = STNodeFactory.createForkStatementNode(forkKeyword, openBrace, namedWorkerDeclarations, closeBrace);
        if (this.isNodeListEmpty(namedWorkerDeclarations)) {
            return SyntaxErrors.addDiagnostic(forkStmt, DiagnosticErrorCode.ERROR_MISSING_NAMED_WORKER_DECLARATION_IN_FORK_STMT, new Object[0]);
        }
        return forkStmt;
    }

    private STNode parseTrapExpression(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode trapKeyword = this.parseTrapKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.TRAP, isRhsExpr, allowActions, isInConditionalExpr);
        if (this.isAction(expr)) {
            return STNodeFactory.createTrapExpressionNode(SyntaxKind.TRAP_ACTION, trapKeyword, expr);
        }
        return STNodeFactory.createTrapExpressionNode(SyntaxKind.TRAP_EXPRESSION, trapKeyword, expr);
    }

    private STNode parseTrapKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRAP_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TRAP_KEYWORD);
        return this.parseTrapKeyword();
    }

    private STNode parseListConstructorExpr() {
        this.startContext(ParserRuleContext.LIST_CONSTRUCTOR);
        STNode openBracket = this.parseOpenBracket();
        STNode listMembers = this.parseListMembers();
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return STNodeFactory.createListConstructorExpressionNode(openBracket, listMembers, closeBracket);
    }

    private STNode parseListMembers() {
        ArrayList<STNode> listMembers = new ArrayList<STNode>();
        if (this.isEndOfListConstructor(this.peek().kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode listMember = this.parseListMember();
        listMembers.add(listMember);
        return this.parseListMembers(listMembers);
    }

    private STNode parseListMembers(List<STNode> listMembers) {
        STNode listConstructorMemberEnd;
        while (!this.isEndOfListConstructor(this.peek().kind) && (listConstructorMemberEnd = this.parseListConstructorMemberEnd()) != null) {
            listMembers.add(listConstructorMemberEnd);
            STNode listMember = this.parseListMember();
            listMembers.add(listMember);
        }
        return STNodeFactory.createNodeList(listMembers);
    }

    private STNode parseListMember() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.ELLIPSIS_TOKEN) {
            return this.parseSpreadMember();
        }
        return this.parseExpression();
    }

    private STNode parseSpreadMember() {
        STNode ellipsis = this.parseEllipsis();
        STNode expr = this.parseExpression();
        return STNodeFactory.createSpreadMemberNode(ellipsis, expr);
    }

    private boolean isEndOfListConstructor(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseListConstructorMemberEnd() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(nextToken, ParserRuleContext.LIST_CONSTRUCTOR_MEMBER_END);
                yield this.parseListConstructorMemberEnd();
            }
        };
    }

    private STNode parseForEachStatement() {
        this.startContext(ParserRuleContext.FOREACH_STMT);
        STNode forEachKeyword = this.parseForEachKeyword();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.FOREACH_STMT);
        STNode inKeyword = this.parseInKeyword();
        STNode actionOrExpr = this.parseActionOrExpression();
        STNode blockStatement = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createForEachStatementNode(forEachKeyword, typedBindingPattern, inKeyword, actionOrExpr, blockStatement, onFailClause);
    }

    private STNode parseForEachKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FOREACH_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FOREACH_KEYWORD);
        return this.parseForEachKeyword();
    }

    private STNode parseInKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IN_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.IN_KEYWORD);
        return this.parseInKeyword();
    }

    private STNode parseTypeCastExpr(boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        this.startContext(ParserRuleContext.TYPE_CAST);
        STNode ltToken = this.parseLTToken();
        return this.parseTypeCastExpr(ltToken, isRhsExpr, allowActions, isInConditionalExpr);
    }

    private STNode parseTypeCastExpr(STNode ltToken, boolean isRhsExpr, boolean allowActions, boolean isInConditionalExpr) {
        STNode typeCastParam = this.parseTypeCastParam();
        STNode gtToken = this.parseGTToken();
        this.endContext();
        STNode expression = this.parseExpression(OperatorPrecedence.EXPRESSION_ACTION, isRhsExpr, allowActions, isInConditionalExpr);
        return STNodeFactory.createTypeCastExpressionNode(ltToken, typeCastParam, gtToken, expression);
    }

    private STNode parseTypeCastParam() {
        STNode annot;
        STToken token = this.peek();
        return STNodeFactory.createTypeCastParamNode(this.getAnnotations(annot), switch (token.kind) {
            case SyntaxKind.AT_TOKEN -> {
                annot = this.parseOptionalAnnotations();
                token = this.peek();
                if (this.isTypeStartingToken(token.kind)) {
                    yield this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
                }
                yield STNodeFactory.createEmptyNode();
            }
            default -> {
                annot = STNodeFactory.createEmptyNode();
                yield this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
            }
        });
    }

    private STNode parseTableConstructorExprRhs(STNode tableKeyword, STNode keySpecifier) {
        this.switchContext(ParserRuleContext.TABLE_CONSTRUCTOR);
        STNode openBracket = this.parseOpenBracket();
        STNode rowList = this.parseRowList();
        STNode closeBracket = this.parseCloseBracket();
        return STNodeFactory.createTableConstructorExpressionNode(tableKeyword, keySpecifier, openBracket, rowList, closeBracket);
    }

    private STNode parseTableKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TABLE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TABLE_KEYWORD);
        return this.parseTableKeyword();
    }

    private STNode parseRowList() {
        STNode rowEnd;
        STToken nextToken = this.peek();
        if (this.isEndOfTableRowList(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> mappings = new ArrayList<STNode>();
        STNode mapExpr = this.parseMappingConstructorExpr();
        mappings.add(mapExpr);
        nextToken = this.peek();
        while (!this.isEndOfTableRowList(nextToken.kind) && (rowEnd = this.parseTableRowEnd()) != null) {
            mappings.add(rowEnd);
            mapExpr = this.parseMappingConstructorExpr();
            mappings.add(mapExpr);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(mappings);
    }

    private boolean isEndOfTableRowList(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            case SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.COMMA_TOKEN -> false;
            default -> this.isEndOfMappingConstructor(tokenKind);
        };
    }

    private STNode parseTableRowEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.TABLE_ROW_END);
                yield this.parseTableRowEnd();
            }
        };
    }

    private STNode parseKeySpecifier() {
        this.startContext(ParserRuleContext.KEY_SPECIFIER);
        STNode keyKeyword = this.parseKeyKeyword();
        STNode openParen = this.parseOpenParenthesis();
        STNode fieldNames = this.parseFieldNames();
        STNode closeParen = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createKeySpecifierNode(keyKeyword, openParen, fieldNames, closeParen);
    }

    private STNode parseKeyKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.KEY_KEYWORD) {
            return this.consume();
        }
        if (BallerinaParser.isKeyKeyword(token)) {
            return this.getKeyKeyword(this.consume());
        }
        this.recover(token, ParserRuleContext.KEY_KEYWORD);
        return this.parseKeyKeyword();
    }

    static boolean isKeyKeyword(STToken token) {
        return token.kind == SyntaxKind.IDENTIFIER_TOKEN && "key".equals(token.text());
    }

    private STNode getKeyKeyword(STToken token) {
        return STNodeFactory.createToken(SyntaxKind.KEY_KEYWORD, token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STToken getUnderscoreKeyword(STToken token) {
        return STNodeFactory.createToken(SyntaxKind.UNDERSCORE_KEYWORD, token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STNode parseFieldNames() {
        STToken nextToken = this.peek();
        if (this.isEndOfFieldNamesList(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> fieldNames = new ArrayList<STNode>();
        STNode fieldName = this.parseVariableName();
        fieldNames.add(fieldName);
        nextToken = this.peek();
        while (!this.isEndOfFieldNamesList(nextToken.kind)) {
            STNode leadingComma = this.parseComma();
            fieldNames.add(leadingComma);
            fieldName = this.parseVariableName();
            fieldNames.add(fieldName);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(fieldNames);
    }

    private boolean isEndOfFieldNamesList(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.IDENTIFIER_TOKEN, SyntaxKind.COMMA_TOKEN -> false;
            default -> true;
        };
    }

    private STNode parseErrorKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ERROR_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ERROR_KEYWORD);
        return this.parseErrorKeyword();
    }

    private STNode parseStreamTypeDescriptor(STNode streamKeywordToken) {
        STToken nextToken = this.peek();
        STNode streamTypeParamsNode = nextToken.kind == SyntaxKind.LT_TOKEN ? this.parseStreamTypeParamsNode() : STNodeFactory.createEmptyNode();
        return STNodeFactory.createStreamTypeDescriptorNode(streamKeywordToken, streamTypeParamsNode);
    }

    private STNode parseStreamTypeParamsNode() {
        STNode ltToken = this.parseLTToken();
        this.startContext(ParserRuleContext.TYPE_DESC_IN_STREAM_TYPE_DESC);
        STNode leftTypeDescNode = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_STREAM_TYPE_DESC);
        STNode streamTypedesc = this.parseStreamTypeParamsNode(ltToken, leftTypeDescNode);
        this.endContext();
        return streamTypedesc;
    }

    private STNode parseStreamTypeParamsNode(STNode ltToken, STNode leftTypeDescNode) {
        STNode rightTypeDescNode;
        STNode commaToken;
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                commaToken = this.parseComma();
                rightTypeDescNode = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_STREAM_TYPE_DESC);
                break;
            }
            case GT_TOKEN: {
                commaToken = STNodeFactory.createEmptyNode();
                rightTypeDescNode = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.STREAM_TYPE_FIRST_PARAM_RHS);
                return this.parseStreamTypeParamsNode(ltToken, leftTypeDescNode);
            }
        }
        STNode gtToken = this.parseGTToken();
        return STNodeFactory.createStreamTypeParamsNode(ltToken, leftTypeDescNode, commaToken, rightTypeDescNode, gtToken);
    }

    private STNode parseLetExpression(boolean isRhsExpr, boolean isInConditionalExpr) {
        STNode letKeyword = this.parseLetKeyword();
        STNode letVarDeclarations = this.parseLetVarDeclarations(ParserRuleContext.LET_EXPR_LET_VAR_DECL, isRhsExpr, false);
        STNode inKeyword = this.parseInKeyword();
        letKeyword = this.cloneWithDiagnosticIfListEmpty(letVarDeclarations, letKeyword, DiagnosticErrorCode.ERROR_MISSING_LET_VARIABLE_DECLARATION);
        STNode expression = this.parseExpression(OperatorPrecedence.REMOTE_CALL_ACTION, isRhsExpr, false, isInConditionalExpr);
        return STNodeFactory.createLetExpressionNode(letKeyword, letVarDeclarations, inKeyword, expression);
    }

    private STNode parseLetKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LET_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LET_KEYWORD);
        return this.parseLetKeyword();
    }

    private STNode parseLetVarDeclarations(ParserRuleContext context, boolean isRhsExpr, boolean allowActions) {
        this.startContext(context);
        ArrayList<STNode> varDecls = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (BallerinaParser.isEndOfLetVarDeclarations(nextToken, this.getNextNextToken())) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode varDec = this.parseLetVarDecl(context, isRhsExpr, allowActions);
        varDecls.add(varDec);
        nextToken = this.peek();
        while (!BallerinaParser.isEndOfLetVarDeclarations(nextToken, this.getNextNextToken())) {
            STNode leadingComma = this.parseComma();
            varDecls.add(leadingComma);
            varDec = this.parseLetVarDecl(context, isRhsExpr, allowActions);
            varDecls.add(varDec);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(varDecls);
    }

    static boolean isEndOfLetVarDeclarations(STToken nextToken, STToken nextNextToken) {
        SyntaxKind tokenKind = nextToken.kind;
        return switch (tokenKind) {
            case SyntaxKind.AT_TOKEN, SyntaxKind.COMMA_TOKEN -> false;
            case SyntaxKind.IN_KEYWORD -> true;
            default -> BallerinaParser.isGroupOrCollectKeyword(nextToken) || !BallerinaParser.isTypeStartingToken(tokenKind, nextNextToken);
        };
    }

    private STNode parseLetVarDecl(ParserRuleContext context, boolean isRhsExpr, boolean allowActions) {
        STNode annot = this.parseOptionalAnnotations();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.LET_EXPR_LET_VAR_DECL);
        STNode assign = this.parseAssignOp();
        STNode expression = context == ParserRuleContext.LET_CLAUSE_LET_VAR_DECL ? this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, allowActions) : this.parseExpression(OperatorPrecedence.ANON_FUNC_OR_LET, isRhsExpr, false);
        return STNodeFactory.createLetVariableDeclarationNode(annot, typedBindingPattern, assign, expression);
    }

    private STNode parseTemplateExpression() {
        STNode type = STNodeFactory.createEmptyNode();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        STNode content = this.parseTemplateContent();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.RAW_TEMPLATE_EXPRESSION, type, startingBackTick, content, endingBackTick);
    }

    private STNode parseTemplateContent() {
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode contentItem = this.parseTemplateItem();
            items.add(contentItem);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(items);
    }

    private boolean isEndOfBacktickContent(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseTemplateItem() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            return this.parseInterpolation();
        }
        if (nextToken.kind != SyntaxKind.TEMPLATE_STRING) {
            nextToken = this.consume();
            return STNodeFactory.createLiteralValueToken(SyntaxKind.TEMPLATE_STRING, nextToken.text(), nextToken.leadingMinutiae(), nextToken.trailingMinutiae(), nextToken.diagnostics());
        }
        return this.consume();
    }

    private STNode parseStringTemplateExpression() {
        STNode type = this.parseStringKeyword();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        STNode content = this.parseTemplateContent();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.STRING_TEMPLATE_EXPRESSION, type, startingBackTick, content, endingBackTick);
    }

    private STNode parseStringKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.STRING_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.STRING_KEYWORD);
        return this.parseStringKeyword();
    }

    private STNode parseXMLTemplateExpression() {
        STNode xmlKeyword = this.parseXMLKeyword();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        if (startingBackTick.isMissing()) {
            return this.createMissingTemplateExpressionNode(xmlKeyword, SyntaxKind.XML_TEMPLATE_EXPRESSION);
        }
        STNode content = this.parseTemplateContentAsXML();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.XML_TEMPLATE_EXPRESSION, xmlKeyword, startingBackTick, content, endingBackTick);
    }

    private STNode parseXMLKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_KEYWORD);
        return this.parseXMLKeyword();
    }

    private STNode parseTemplateContentAsXML() {
        ArrayDeque<STNode> expressions = new ArrayDeque<STNode>();
        StringBuilder xmlStringBuilder = new StringBuilder();
        STToken nextToken = this.peek();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode contentItem = this.parseTemplateItem();
            if (contentItem.kind == SyntaxKind.TEMPLATE_STRING) {
                xmlStringBuilder.append(((STToken)contentItem).text());
            } else {
                xmlStringBuilder.append("${}");
                expressions.add(contentItem);
            }
            nextToken = this.peek();
        }
        CharReader charReader = CharReader.from(xmlStringBuilder.toString());
        TokenReader tokenReader = new TokenReader(new XMLLexer(charReader));
        XMLParser xmlParser = new XMLParser((AbstractTokenReader)tokenReader, expressions);
        return xmlParser.parse();
    }

    private STNode parseRegExpTemplateExpression() {
        STToken reKeyword = this.consume();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        if (startingBackTick.isMissing()) {
            return this.createMissingTemplateExpressionNode(reKeyword, SyntaxKind.REGEX_TEMPLATE_EXPRESSION);
        }
        STNode content = this.parseTemplateContentAsRegExp();
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createTemplateExpressionNode(SyntaxKind.REGEX_TEMPLATE_EXPRESSION, reKeyword, startingBackTick, content, endingBackTick);
    }

    private STNode createMissingTemplateExpressionNode(STNode reKeyword, SyntaxKind kind) {
        STToken startingBackTick = SyntaxErrors.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
        STToken endingBackTick = SyntaxErrors.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
        STNode content = STAbstractNodeFactory.createEmptyNodeList();
        STNode templateExpr = STNodeFactory.createTemplateExpressionNode(kind, reKeyword, startingBackTick, content, endingBackTick);
        templateExpr = SyntaxErrors.addDiagnostic(templateExpr, DiagnosticErrorCode.ERROR_MISSING_BACKTICK_STRING, new Object[0]);
        return templateExpr;
    }

    private STNode parseTemplateContentAsRegExp() {
        this.tokenReader.startMode(ParserMode.REGEXP);
        ArrayDeque<STNode> expressions = new ArrayDeque<STNode>();
        StringBuilder regExpStringBuilder = new StringBuilder();
        STToken nextToken = this.peek();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode contentItem = this.parseTemplateItem();
            if (contentItem.kind == SyntaxKind.TEMPLATE_STRING) {
                regExpStringBuilder.append(((STToken)contentItem).text());
            } else {
                regExpStringBuilder.append("${}");
                expressions.add(contentItem);
            }
            nextToken = this.peek();
        }
        this.tokenReader.endMode();
        CharReader charReader = CharReader.from(regExpStringBuilder.toString());
        TokenReader tokenReader = new TokenReader(new RegExpLexer(charReader));
        RegExpParser regExpParser = new RegExpParser((AbstractTokenReader)tokenReader, expressions);
        return regExpParser.parse();
    }

    private STNode parseInterpolation() {
        this.startContext(ParserRuleContext.INTERPOLATION);
        STNode interpolStart = this.parseInterpolationStart();
        STNode expr = this.parseExpression();
        while (!this.isEndOfInterpolation()) {
            STToken nextToken = this.consume();
            expr = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(expr, (STNode)nextToken, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_TOKEN, nextToken.text());
        }
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createInterpolationNode(interpolStart, expr, closeBrace);
    }

    private boolean isEndOfInterpolation() {
        SyntaxKind nextTokenKind = this.peek().kind;
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN -> true;
            default -> {
                ParserMode currentLexerMode = this.tokenReader.getCurrentMode();
                if (nextTokenKind == SyntaxKind.CLOSE_BRACE_TOKEN && currentLexerMode != ParserMode.INTERPOLATION && currentLexerMode != ParserMode.INTERPOLATION_BRACED_CONTENT) {
                    yield true;
                }
                yield false;
            }
        };
    }

    private STNode parseInterpolationStart() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.INTERPOLATION_START_TOKEN);
        return this.parseInterpolationStart();
    }

    private STNode parseBacktickToken(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BACKTICK_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx);
        return this.parseBacktickToken(ctx);
    }

    private STNode parseTableTypeDescriptor(STNode tableKeywordToken) {
        STNode keyConstraintNode;
        STNode rowTypeParameterNode = this.parseRowTypeParameter();
        STToken nextToken = this.peek();
        if (BallerinaParser.isKeyKeyword(nextToken)) {
            STNode keyKeywordToken = this.getKeyKeyword(this.consume());
            keyConstraintNode = this.parseKeyConstraint(keyKeywordToken);
        } else {
            keyConstraintNode = STNodeFactory.createEmptyNode();
        }
        return STNodeFactory.createTableTypeDescriptorNode(tableKeywordToken, rowTypeParameterNode, keyConstraintNode);
    }

    private STNode parseRowTypeParameter() {
        this.startContext(ParserRuleContext.ROW_TYPE_PARAM);
        STNode rowTypeParameterNode = this.parseTypeParameter();
        this.endContext();
        return rowTypeParameterNode;
    }

    private STNode parseTypeParameter() {
        STNode ltToken = this.parseLTToken();
        STNode typeNode = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_ANGLE_BRACKETS);
        STNode gtToken = this.parseGTToken();
        return STNodeFactory.createTypeParameterNode(ltToken, typeNode, gtToken);
    }

    private STNode parseKeyConstraint(STNode keyKeywordToken) {
        return switch (this.peek().kind) {
            case SyntaxKind.OPEN_PAREN_TOKEN -> this.parseKeySpecifier(keyKeywordToken);
            case SyntaxKind.LT_TOKEN -> this.parseKeyTypeConstraint(keyKeywordToken);
            default -> {
                this.recover(this.peek(), ParserRuleContext.KEY_CONSTRAINTS_RHS);
                yield this.parseKeyConstraint(keyKeywordToken);
            }
        };
    }

    private STNode parseKeySpecifier(STNode keyKeywordToken) {
        this.startContext(ParserRuleContext.KEY_SPECIFIER);
        STNode openParenToken = this.parseOpenParenthesis();
        STNode fieldNamesNode = this.parseFieldNames();
        STNode closeParenToken = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createKeySpecifierNode(keyKeywordToken, openParenToken, fieldNamesNode, closeParenToken);
    }

    private STNode parseKeyTypeConstraint(STNode keyKeywordToken) {
        STNode typeParameterNode = this.parseTypeParameter();
        return STNodeFactory.createKeyTypeConstraintNode(keyKeywordToken, typeParameterNode);
    }

    private STNode parseFunctionTypeDesc(List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.FUNC_TYPE_DESC);
        STNode functionKeyword = this.parseFunctionKeyword();
        boolean hasFuncSignature = false;
        STNode signature = STNodeFactory.createEmptyNode();
        if (this.peek().kind == SyntaxKind.OPEN_PAREN_TOKEN || this.isSyntaxKindInList(qualifiers, SyntaxKind.TRANSACTIONAL_KEYWORD)) {
            signature = this.parseFuncSignature(true);
            hasFuncSignature = true;
        }
        STNode[] nodes = this.createFuncTypeQualNodeList(qualifiers, functionKeyword, hasFuncSignature);
        STNode qualifierList = nodes[0];
        functionKeyword = nodes[1];
        this.endContext();
        return STNodeFactory.createFunctionTypeDescriptorNode(qualifierList, functionKeyword, signature);
    }

    private STNode getLastNodeInList(List<STNode> nodeList) {
        return nodeList.get(nodeList.size() - 1);
    }

    private STNode[] createFuncTypeQualNodeList(List<STNode> qualifierList, STNode functionKeyword, boolean hasFuncSignature) {
        ArrayList<STNode> validatedList = new ArrayList<STNode>();
        for (int i = 0; i < qualifierList.size(); ++i) {
            STNode qualifier = qualifierList.get(i);
            int nextIndex = i + 1;
            if (this.isSyntaxKindInList(validatedList, qualifier.kind)) {
                this.updateLastNodeInListWithInvalidNode(validatedList, qualifier, DiagnosticErrorCode.ERROR_DUPLICATE_QUALIFIER, ((STToken)qualifier).text());
                continue;
            }
            if (hasFuncSignature && this.isRegularFuncQual(qualifier.kind)) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifier.kind == SyntaxKind.ISOLATED_KEYWORD) {
                validatedList.add(qualifier);
                continue;
            }
            if (qualifierList.size() == nextIndex) {
                functionKeyword = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(functionKeyword, qualifier, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
                continue;
            }
            this.updateANodeInListWithLeadingInvalidNode(qualifierList, nextIndex, qualifier, DiagnosticErrorCode.ERROR_QUALIFIER_NOT_ALLOWED, ((STToken)qualifier).text());
        }
        STNode nodeList = STNodeFactory.createNodeList(validatedList);
        return new STNode[]{nodeList, functionKeyword};
    }

    private boolean isRegularFuncQual(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.TRANSACTIONAL_KEYWORD, SyntaxKind.ISOLATED_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseExplicitFunctionExpression(STNode annots, List<STNode> qualifiers, boolean isRhsExpr) {
        this.startContext(ParserRuleContext.ANON_FUNC_EXPRESSION);
        STNode funcKeyword = this.parseFunctionKeyword();
        STNode[] nodes = this.createFuncTypeQualNodeList(qualifiers, funcKeyword, true);
        STNode qualifierList = nodes[0];
        funcKeyword = nodes[1];
        STNode funcSignature = this.parseFuncSignature(false);
        STNode funcBody = this.parseAnonFuncBody(isRhsExpr);
        return STNodeFactory.createExplicitAnonymousFunctionExpressionNode(annots, qualifierList, funcKeyword, funcSignature, funcBody);
    }

    private STNode parseAnonFuncBody(boolean isRhsExpr) {
        switch (this.peek().kind) {
            case EOF_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                STNode body = this.parseFunctionBodyBlock(true);
                this.endContext();
                return body;
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                this.endContext();
                return this.parseExpressionFuncBody(true, isRhsExpr);
            }
        }
        this.recover(this.peek(), ParserRuleContext.ANON_FUNC_BODY);
        return this.parseAnonFuncBody(isRhsExpr);
    }

    private STNode parseExpressionFuncBody(boolean isAnon, boolean isRhsExpr) {
        STNode rightDoubleArrow = this.parseDoubleRightArrow();
        STNode expression = this.parseExpression(OperatorPrecedence.REMOTE_CALL_ACTION, isRhsExpr, false);
        STNode semiColon = isAnon ? STNodeFactory.createEmptyNode() : this.parseSemicolon();
        return STNodeFactory.createExpressionFunctionBodyNode(rightDoubleArrow, expression, semiColon);
    }

    private STNode parseDoubleRightArrow() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.EXPR_FUNC_BODY_START);
        return this.parseDoubleRightArrow();
    }

    private STNode parseImplicitAnonFunc(STNode params, boolean isRhsExpr) {
        switch (params.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case INFER_PARAM_LIST: {
                break;
            }
            case BRACED_EXPRESSION: {
                params = this.getAnonFuncParam((STBracedExpressionNode)params);
                break;
            }
            case NIL_LITERAL: {
                STNilLiteralNode nilLiteralNode = (STNilLiteralNode)params;
                params = STNodeFactory.createImplicitAnonymousFunctionParameters(nilLiteralNode.openParenToken, STNodeFactory.createNodeList(new ArrayList<STNode>()), nilLiteralNode.closeParenToken);
                break;
            }
            default: {
                STToken syntheticParam = STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                syntheticParam = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(syntheticParam, params, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_PARAM_LIST_IN_INFER_ANONYMOUS_FUNCTION_EXPR, new Object[0]);
                params = STNodeFactory.createSimpleNameReferenceNode(syntheticParam);
            }
        }
        STNode rightDoubleArrow = this.parseDoubleRightArrow();
        STNode expression = this.parseExpression(OperatorPrecedence.REMOTE_CALL_ACTION, isRhsExpr, false);
        return STNodeFactory.createImplicitAnonymousFunctionExpressionNode(params, rightDoubleArrow, expression);
    }

    private STNode getAnonFuncParam(STBracedExpressionNode bracedExpression) {
        ArrayList<STNode> paramList = new ArrayList<STNode>();
        STNode innerExpression = bracedExpression.expression;
        STNode openParen = bracedExpression.openParen;
        if (innerExpression.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            paramList.add(innerExpression);
        } else {
            openParen = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(openParen, innerExpression, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_PARAM_LIST_IN_INFER_ANONYMOUS_FUNCTION_EXPR, new Object[0]);
        }
        return STNodeFactory.createImplicitAnonymousFunctionParameters(openParen, STNodeFactory.createNodeList(paramList), bracedExpression.closeParen);
    }

    private STNode parseImplicitAnonFunc(STNode openParen, STNode firstParam, boolean isRhsExpr) {
        STNode paramEnd;
        ArrayList<STNode> paramList = new ArrayList<STNode>();
        paramList.add(firstParam);
        STToken nextToken = this.peek();
        while (!this.isEndOfAnonFuncParametersList(nextToken.kind) && (paramEnd = this.parseImplicitAnonFuncParamEnd()) != null) {
            paramList.add(paramEnd);
            STNode param = this.parseIdentifier(ParserRuleContext.IMPLICIT_ANON_FUNC_PARAM);
            param = STNodeFactory.createSimpleNameReferenceNode(param);
            paramList.add(param);
            nextToken = this.peek();
        }
        STNode params = STNodeFactory.createNodeList(paramList);
        STNode closeParen = this.parseCloseParenthesis();
        this.endContext();
        STNode inferedParams = STNodeFactory.createImplicitAnonymousFunctionParameters(openParen, params, closeParen);
        return this.parseImplicitAnonFunc(inferedParams, isRhsExpr);
    }

    private STNode parseImplicitAnonFuncParamEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_PAREN_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.ANON_FUNC_PARAM_RHS);
                yield this.parseImplicitAnonFuncParamEnd();
            }
        };
    }

    private boolean isEndOfAnonFuncParametersList(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.TYPE_KEYWORD, SyntaxKind.LISTENER_KEYWORD, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.RETURNS_KEYWORD, SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN, SyntaxKind.IF_KEYWORD, SyntaxKind.WHILE_KEYWORD, SyntaxKind.DO_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseTupleTypeDesc() {
        STNode openBracket = this.parseOpenBracket();
        this.startContext(ParserRuleContext.TUPLE_MEMBERS);
        STNode memberTypeDesc = this.parseTupleMemberTypeDescList();
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        openBracket = this.cloneWithDiagnosticIfListEmpty(memberTypeDesc, openBracket, DiagnosticErrorCode.ERROR_MISSING_TYPE_DESC);
        return STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDesc, closeBracket);
    }

    private STNode parseTupleMemberTypeDescList() {
        ArrayList<STNode> typeDescList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfTypeList(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode typeDesc = this.parseTupleMember();
        return this.parseTupleTypeMembers(typeDesc, typeDescList);
    }

    private STNode parseTupleTypeMembers(STNode firstMember, List<STNode> memberList) {
        while (!this.isEndOfTypeList(this.peek().kind)) {
            if (firstMember.kind == SyntaxKind.REST_TYPE) {
                firstMember = this.invalidateTypeDescAfterRestDesc(firstMember);
                break;
            }
            STNode tupleMemberRhs = this.parseTupleMemberRhs();
            if (tupleMemberRhs == null) break;
            memberList.add(firstMember);
            memberList.add(tupleMemberRhs);
            firstMember = this.parseTupleMember();
        }
        memberList.add(firstMember);
        return STNodeFactory.createNodeList(memberList);
    }

    private STNode parseTupleMember() {
        STNode annot = this.parseOptionalAnnotations();
        STNode typeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
        return this.createMemberOrRestNode(annot, typeDesc);
    }

    private STNode createMemberOrRestNode(STNode annot, STNode typeDesc) {
        STNode tupleMemberRhs = this.parseTypeDescInTupleRhs();
        if (tupleMemberRhs != null) {
            if (!((STNodeList)annot).isEmpty()) {
                typeDesc = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(typeDesc, annot, (DiagnosticCode)DiagnosticErrorCode.ERROR_ANNOTATIONS_NOT_ALLOWED_FOR_TUPLE_REST_DESCRIPTOR, new Object[0]);
            }
            return STNodeFactory.createRestDescriptorNode(typeDesc, tupleMemberRhs);
        }
        return STNodeFactory.createMemberTypeDescriptorNode(annot, typeDesc);
    }

    private STNode invalidateTypeDescAfterRestDesc(STNode restDescriptor) {
        STNode tupleMemberRhs;
        while (!this.isEndOfTypeList(this.peek().kind) && (tupleMemberRhs = this.parseTupleMemberRhs()) != null) {
            restDescriptor = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(restDescriptor, tupleMemberRhs, null, new Object[0]);
            restDescriptor = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(restDescriptor, this.parseTupleMember(), (DiagnosticCode)DiagnosticErrorCode.ERROR_TYPE_DESC_AFTER_REST_DESCRIPTOR, new Object[0]);
        }
        return restDescriptor;
    }

    private STNode parseTupleMemberRhs() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(nextToken, ParserRuleContext.TUPLE_TYPE_MEMBER_RHS);
                yield this.parseTupleMemberRhs();
            }
        };
    }

    private STNode parseTypeDescInTupleRhs() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            case SyntaxKind.ELLIPSIS_TOKEN -> this.parseEllipsis();
            default -> {
                this.recover(nextToken, ParserRuleContext.TYPE_DESC_IN_TUPLE_RHS);
                yield this.parseTypeDescInTupleRhs();
            }
        };
    }

    private boolean isEndOfTypeList(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.EQUAL_TOKEN, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseTableConstructorOrQuery(boolean isRhsExpr, boolean allowActions) {
        this.startContext(ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_EXPRESSION);
        STNode tableOrQueryExpr = this.parseTableConstructorOrQueryInternal(isRhsExpr, allowActions);
        this.endContext();
        return tableOrQueryExpr;
    }

    private STNode parseTableConstructorOrQueryInternal(boolean isRhsExpr, boolean allowActions) {
        switch (this.peek().kind) {
            case FROM_KEYWORD: {
                STNode queryConstructType = STNodeFactory.createEmptyNode();
                return this.parseQueryExprRhs(queryConstructType, isRhsExpr, allowActions);
            }
            case TABLE_KEYWORD: {
                STNode tableKeyword = this.parseTableKeyword();
                return this.parseTableConstructorOrQuery(tableKeyword, isRhsExpr, allowActions);
            }
            case MAP_KEYWORD: 
            case STREAM_KEYWORD: {
                STToken streamOrMapKeyword = this.consume();
                STNode keySpecifier = STNodeFactory.createEmptyNode();
                STNode queryConstructType = this.parseQueryConstructType(streamOrMapKeyword, keySpecifier);
                return this.parseQueryExprRhs(queryConstructType, isRhsExpr, allowActions);
            }
        }
        this.recover(this.peek(), ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_START);
        return this.parseTableConstructorOrQueryInternal(isRhsExpr, allowActions);
    }

    private STNode parseTableConstructorOrQuery(STNode tableKeyword, boolean isRhsExpr, boolean allowActions) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                STNode keySpecifier = STNodeFactory.createEmptyNode();
                return this.parseTableConstructorExprRhs(tableKeyword, keySpecifier);
            }
            case KEY_KEYWORD: {
                STNode keySpecifier = this.parseKeySpecifier();
                return this.parseTableConstructorOrQueryRhs(tableKeyword, keySpecifier, isRhsExpr, allowActions);
            }
            case IDENTIFIER_TOKEN: {
                if (!BallerinaParser.isKeyKeyword(nextToken)) break;
                STNode keySpecifier = this.parseKeySpecifier();
                return this.parseTableConstructorOrQueryRhs(tableKeyword, keySpecifier, isRhsExpr, allowActions);
            }
        }
        this.recover(this.peek(), ParserRuleContext.TABLE_KEYWORD_RHS);
        return this.parseTableConstructorOrQuery(tableKeyword, isRhsExpr, allowActions);
    }

    private STNode parseTableConstructorOrQueryRhs(STNode tableKeyword, STNode keySpecifier, boolean isRhsExpr, boolean allowActions) {
        return switch (this.peek().kind) {
            case SyntaxKind.FROM_KEYWORD -> this.parseQueryExprRhs(this.parseQueryConstructType(tableKeyword, keySpecifier), isRhsExpr, allowActions);
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseTableConstructorExprRhs(tableKeyword, keySpecifier);
            default -> {
                this.recover(this.peek(), ParserRuleContext.TABLE_CONSTRUCTOR_OR_QUERY_RHS);
                yield this.parseTableConstructorOrQueryRhs(tableKeyword, keySpecifier, isRhsExpr, allowActions);
            }
        };
    }

    private STNode parseQueryConstructType(STNode keyword, STNode keySpecifier) {
        return STNodeFactory.createQueryConstructTypeNode(keyword, keySpecifier);
    }

    private STNode parseQueryExprRhs(STNode queryConstructType, boolean isRhsExpr, boolean allowActions) {
        STNode intermediateClause;
        this.switchContext(ParserRuleContext.QUERY_EXPRESSION);
        STNode fromClause = this.parseFromClause(isRhsExpr, allowActions);
        ArrayList<STNode> clauses = new ArrayList<STNode>();
        STNode selectClause = null;
        STNode collectClause = null;
        while (!this.isEndOfIntermediateClause(this.peek().kind) && (intermediateClause = this.parseIntermediateClause(isRhsExpr, allowActions)) != null) {
            if (selectClause != null) {
                selectClause = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(selectClause, intermediateClause, (DiagnosticCode)DiagnosticErrorCode.ERROR_MORE_CLAUSES_AFTER_SELECT_CLAUSE, new Object[0]);
                continue;
            }
            if (collectClause != null) {
                collectClause = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(collectClause, intermediateClause, (DiagnosticCode)DiagnosticErrorCode.ERROR_MORE_CLAUSES_AFTER_COLLECT_CLAUSE, new Object[0]);
                continue;
            }
            if (intermediateClause.kind == SyntaxKind.SELECT_CLAUSE) {
                selectClause = intermediateClause;
            } else if (intermediateClause.kind == SyntaxKind.COLLECT_CLAUSE) {
                collectClause = intermediateClause;
            } else {
                clauses.add(intermediateClause);
                continue;
            }
            if (!this.isNestedQueryExpr() && this.isValidIntermediateQueryStart(this.peek())) continue;
        }
        if (this.peek().kind == SyntaxKind.DO_KEYWORD && (!this.isNestedQueryExpr() || selectClause == null && collectClause == null)) {
            STNode intermediateClauses = STNodeFactory.createNodeList(clauses);
            STNode queryPipeline = STNodeFactory.createQueryPipelineNode(fromClause, intermediateClauses);
            return this.parseQueryAction(queryConstructType, queryPipeline, selectClause, collectClause);
        }
        if (selectClause == null && collectClause == null) {
            STToken selectKeyword = SyntaxErrors.createMissingToken(SyntaxKind.SELECT_KEYWORD);
            STNode expr = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
            selectClause = STNodeFactory.createSelectClauseNode(selectKeyword, expr);
            if (clauses.isEmpty()) {
                fromClause = SyntaxErrors.addDiagnostic(fromClause, DiagnosticErrorCode.ERROR_MISSING_SELECT_CLAUSE, new Object[0]);
            } else {
                int lastIndex = clauses.size() - 1;
                STNode intClauseWithDiagnostic = SyntaxErrors.addDiagnostic((STNode)clauses.get(lastIndex), DiagnosticErrorCode.ERROR_MISSING_SELECT_CLAUSE, new Object[0]);
                clauses.set(lastIndex, intClauseWithDiagnostic);
            }
        }
        STNode intermediateClauses = STNodeFactory.createNodeList(clauses);
        STNode queryPipeline = STNodeFactory.createQueryPipelineNode(fromClause, intermediateClauses);
        STNode onConflictClause = this.parseOnConflictClause(isRhsExpr);
        return STNodeFactory.createQueryExpressionNode(queryConstructType, queryPipeline, selectClause == null ? collectClause : selectClause, onConflictClause);
    }

    private boolean isNestedQueryExpr() {
        return Collections.frequency(this.errorHandler.getContextStack(), (Object)ParserRuleContext.QUERY_EXPRESSION) > 1;
    }

    private boolean isValidIntermediateQueryStart(STToken token) {
        return switch (token.kind) {
            case SyntaxKind.FROM_KEYWORD, SyntaxKind.LET_KEYWORD, SyntaxKind.WHERE_KEYWORD, SyntaxKind.SELECT_KEYWORD, SyntaxKind.LIMIT_KEYWORD, SyntaxKind.JOIN_KEYWORD, SyntaxKind.OUTER_KEYWORD, SyntaxKind.ORDER_KEYWORD, SyntaxKind.BY_KEYWORD, SyntaxKind.ASCENDING_KEYWORD, SyntaxKind.DESCENDING_KEYWORD -> true;
            case SyntaxKind.IDENTIFIER_TOKEN -> BallerinaParser.isGroupOrCollectKeyword(token);
            default -> false;
        };
    }

    private static boolean isGroupOrCollectKeyword(STToken nextToken) {
        return BallerinaParser.isKeywordMatch(SyntaxKind.COLLECT_KEYWORD, nextToken) || BallerinaParser.isKeywordMatch(SyntaxKind.GROUP_KEYWORD, nextToken);
    }

    static boolean isKeywordMatch(SyntaxKind syntaxKind, STToken token) {
        return token.kind == SyntaxKind.IDENTIFIER_TOKEN && syntaxKind.stringValue().equals(token.text());
    }

    private STNode parseIntermediateClause(boolean isRhsExpr, boolean allowActions) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case FROM_KEYWORD: {
                return this.parseFromClause(isRhsExpr, allowActions);
            }
            case WHERE_KEYWORD: {
                return this.parseWhereClause(isRhsExpr);
            }
            case LET_KEYWORD: {
                return this.parseLetClause(isRhsExpr, allowActions);
            }
            case SELECT_KEYWORD: {
                return this.parseSelectClause(isRhsExpr, allowActions);
            }
            case JOIN_KEYWORD: 
            case OUTER_KEYWORD: {
                return this.parseJoinClause(isRhsExpr);
            }
            case ORDER_KEYWORD: 
            case ASCENDING_KEYWORD: 
            case DESCENDING_KEYWORD: {
                return this.parseOrderByClause(isRhsExpr);
            }
            case LIMIT_KEYWORD: {
                return this.parseLimitClause(isRhsExpr);
            }
            case SEMICOLON_TOKEN: 
            case DO_KEYWORD: 
            case ON_KEYWORD: 
            case CONFLICT_KEYWORD: {
                return null;
            }
        }
        if (BallerinaParser.isKeywordMatch(SyntaxKind.COLLECT_KEYWORD, nextToken)) {
            return this.parseCollectClause(isRhsExpr);
        }
        if (BallerinaParser.isKeywordMatch(SyntaxKind.GROUP_KEYWORD, nextToken)) {
            return this.parseGroupByClause(isRhsExpr);
        }
        this.recover(this.peek(), ParserRuleContext.QUERY_PIPELINE_RHS);
        return this.parseIntermediateClause(isRhsExpr, allowActions);
    }

    private STNode parseCollectClause(boolean isRhsExpr) {
        this.startContext(ParserRuleContext.COLLECT_CLAUSE);
        STNode collectKeyword = this.parseCollectKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        this.endContext();
        return STNodeFactory.createCollectClauseNode(collectKeyword, expression);
    }

    private STNode parseCollectKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COLLECT_KEYWORD) {
            return this.consume();
        }
        if (BallerinaParser.isKeywordMatch(SyntaxKind.COLLECT_KEYWORD, token)) {
            return this.getCollectKeyword(this.consume());
        }
        this.recover(token, ParserRuleContext.COLLECT_KEYWORD);
        return this.parseCollectKeyword();
    }

    private STNode getCollectKeyword(STToken token) {
        return STNodeFactory.createToken(SyntaxKind.COLLECT_KEYWORD, token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STNode parseJoinKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.JOIN_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.JOIN_KEYWORD);
        return this.parseJoinKeyword();
    }

    private STNode parseEqualsKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EQUALS_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.EQUALS_KEYWORD);
        return this.parseEqualsKeyword();
    }

    private boolean isEndOfIntermediateClause(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.DOCUMENTATION_STRING, SyntaxKind.FINAL_KEYWORD, SyntaxKind.PUBLIC_KEYWORD, SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.TYPE_KEYWORD, SyntaxKind.LISTENER_KEYWORD, SyntaxKind.CONST_KEYWORD, SyntaxKind.SERVICE_KEYWORD, SyntaxKind.RESOURCE_KEYWORD, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.RETURNS_KEYWORD, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN, SyntaxKind.DO_KEYWORD, SyntaxKind.ON_KEYWORD, SyntaxKind.CONFLICT_KEYWORD, SyntaxKind.PRIVATE_KEYWORD -> true;
            default -> this.isValidExprRhsStart(tokenKind, SyntaxKind.NONE);
        };
    }

    private STNode parseFromClause(boolean isRhsExpr, boolean allowActions) {
        STNode fromKeyword = this.parseFromKeyword();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.FROM_CLAUSE);
        STNode inKeyword = this.parseInKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, allowActions);
        return STNodeFactory.createFromClauseNode(fromKeyword, typedBindingPattern, inKeyword, expression);
    }

    private STNode parseFromKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FROM_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FROM_KEYWORD);
        return this.parseFromKeyword();
    }

    private STNode parseWhereClause(boolean isRhsExpr) {
        STNode whereKeyword = this.parseWhereKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createWhereClauseNode(whereKeyword, expression);
    }

    private STNode parseWhereKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.WHERE_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.WHERE_KEYWORD);
        return this.parseWhereKeyword();
    }

    private STNode parseLimitKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LIMIT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LIMIT_KEYWORD);
        return this.parseLimitKeyword();
    }

    private STNode parseLetClause(boolean isRhsExpr, boolean allowActions) {
        STNode letKeyword = this.parseLetKeyword();
        STNode letVarDeclarations = this.parseLetVarDeclarations(ParserRuleContext.LET_CLAUSE_LET_VAR_DECL, isRhsExpr, allowActions);
        letKeyword = this.cloneWithDiagnosticIfListEmpty(letVarDeclarations, letKeyword, DiagnosticErrorCode.ERROR_MISSING_LET_VARIABLE_DECLARATION);
        return STNodeFactory.createLetClauseNode(letKeyword, letVarDeclarations);
    }

    private STNode parseGroupByClause(boolean isRhsExpr) {
        this.startContext(ParserRuleContext.GROUP_BY_CLAUSE);
        STNode groupKeyword = this.parseGroupKeyword();
        STNode byKeyword = this.parseByKeyword();
        STNode groupingKeys = this.parseGroupingKeyList(isRhsExpr);
        byKeyword = this.cloneWithDiagnosticIfListEmpty(groupingKeys, byKeyword, DiagnosticErrorCode.ERROR_MISSING_GROUPING_KEY);
        this.endContext();
        return STNodeFactory.createGroupByClauseNode(groupKeyword, byKeyword, groupingKeys);
    }

    private STNode parseGroupKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.GROUP_KEYWORD) {
            return this.consume();
        }
        if (BallerinaParser.isKeywordMatch(SyntaxKind.GROUP_KEYWORD, token)) {
            return this.getGroupKeyword(this.consume());
        }
        this.recover(token, ParserRuleContext.GROUP_KEYWORD);
        return this.parseGroupKeyword();
    }

    private STNode getGroupKeyword(STToken token) {
        return STNodeFactory.createToken(SyntaxKind.GROUP_KEYWORD, token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
    }

    private STNode parseOrderKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ORDER_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ORDER_KEYWORD);
        return this.parseOrderKeyword();
    }

    private STNode parseByKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BY_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BY_KEYWORD);
        return this.parseByKeyword();
    }

    private STNode parseOrderByClause(boolean isRhsExpr) {
        STNode orderKeyword = this.parseOrderKeyword();
        STNode byKeyword = this.parseByKeyword();
        STNode orderKeys = this.parseOrderKeyList(isRhsExpr);
        byKeyword = this.cloneWithDiagnosticIfListEmpty(orderKeys, byKeyword, DiagnosticErrorCode.ERROR_MISSING_ORDER_KEY);
        return STNodeFactory.createOrderByClauseNode(orderKeyword, byKeyword, orderKeys);
    }

    private STNode parseGroupingKeyList(boolean isRhsExpr) {
        STNode groupingKeyListMemberEnd;
        ArrayList<STNode> groupingKeys = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfGroupByKeyListElement(nextToken)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode groupingKey = this.parseGroupingKey(isRhsExpr);
        groupingKeys.add(groupingKey);
        nextToken = this.peek();
        while (!this.isEndOfGroupByKeyListElement(nextToken) && (groupingKeyListMemberEnd = this.parseGroupingKeyListMemberEnd()) != null) {
            groupingKeys.add(groupingKeyListMemberEnd);
            groupingKey = this.parseGroupingKey(isRhsExpr);
            groupingKeys.add(groupingKey);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(groupingKeys);
    }

    private STNode parseOrderKeyList(boolean isRhsExpr) {
        STNode orderKeyListMemberEnd;
        this.startContext(ParserRuleContext.ORDER_KEY_LIST);
        ArrayList<STNode> orderKeys = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfOrderKeys(nextToken)) {
            this.endContext();
            return STNodeFactory.createEmptyNodeList();
        }
        STNode orderKey = this.parseOrderKey(isRhsExpr);
        orderKeys.add(orderKey);
        nextToken = this.peek();
        while (!this.isEndOfOrderKeys(nextToken) && (orderKeyListMemberEnd = this.parseOrderKeyListMemberEnd()) != null) {
            orderKeys.add(orderKeyListMemberEnd);
            orderKey = this.parseOrderKey(isRhsExpr);
            orderKeys.add(orderKey);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(orderKeys);
    }

    private boolean isEndOfGroupByKeyListElement(STToken nextToken) {
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN -> false;
            case SyntaxKind.EOF_TOKEN -> true;
            default -> this.isQueryClauseStartToken(nextToken);
        };
    }

    private boolean isEndOfOrderKeys(STToken nextToken) {
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN, SyntaxKind.ASCENDING_KEYWORD, SyntaxKind.DESCENDING_KEYWORD -> false;
            case SyntaxKind.EOF_TOKEN, SyntaxKind.SEMICOLON_TOKEN -> true;
            default -> this.isQueryClauseStartToken(nextToken);
        };
    }

    private boolean isQueryClauseStartToken(STToken nextToken) {
        return switch (nextToken.kind) {
            case SyntaxKind.DO_KEYWORD, SyntaxKind.FROM_KEYWORD, SyntaxKind.LET_KEYWORD, SyntaxKind.WHERE_KEYWORD, SyntaxKind.SELECT_KEYWORD, SyntaxKind.LIMIT_KEYWORD, SyntaxKind.JOIN_KEYWORD, SyntaxKind.OUTER_KEYWORD, SyntaxKind.ORDER_KEYWORD -> true;
            case SyntaxKind.IDENTIFIER_TOKEN -> BallerinaParser.isGroupOrCollectKeyword(nextToken);
            default -> false;
        };
    }

    private STNode parseGroupingKeyListMemberEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COMMA_TOKEN: {
                return this.consume();
            }
            case EOF_TOKEN: {
                return null;
            }
        }
        if (this.isQueryClauseStartToken(nextToken)) {
            return null;
        }
        this.recover(this.peek(), ParserRuleContext.GROUPING_KEY_LIST_ELEMENT_END);
        return this.parseGroupingKeyListMemberEnd();
    }

    private STNode parseOrderKeyListMemberEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COMMA_TOKEN: {
                return this.parseComma();
            }
            case EOF_TOKEN: {
                return null;
            }
        }
        if (this.isQueryClauseStartToken(nextToken)) {
            return null;
        }
        this.recover(this.peek(), ParserRuleContext.ORDER_KEY_LIST_END);
        return this.parseOrderKeyListMemberEnd();
    }

    private STNode parseGroupingKeyVariableDeclaration(boolean isRhsExpr) {
        STNode groupingKeyElementTypeDesc = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_BEFORE_IDENTIFIER_IN_GROUPING_KEY);
        this.startContext(ParserRuleContext.BINDING_PATTERN_STARTING_IDENTIFIER);
        STNode groupingKeySimpleBP = this.createCaptureOrWildcardBP(this.parseVariableName());
        this.endContext();
        STNode equalsToken = this.parseAssignOp();
        STNode groupingKeyExpression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createGroupingKeyVarDeclarationNode(groupingKeyElementTypeDesc, groupingKeySimpleBP, equalsToken, groupingKeyExpression);
    }

    private STNode parseGroupingKey(boolean isRhsExpr) {
        STToken nextToken = this.peek();
        SyntaxKind nextTokenKind = nextToken.kind;
        if (nextTokenKind == SyntaxKind.IDENTIFIER_TOKEN && !this.isPossibleGroupingKeyVarDeclaration()) {
            return STNodeFactory.createSimpleNameReferenceNode(this.parseVariableName());
        }
        if (BallerinaParser.isTypeStartingToken(nextTokenKind, nextToken)) {
            return this.parseGroupingKeyVariableDeclaration(isRhsExpr);
        }
        this.recover(nextToken, ParserRuleContext.GROUPING_KEY_LIST_ELEMENT);
        return this.parseGroupingKey(isRhsExpr);
    }

    private boolean isPossibleGroupingKeyVarDeclaration() {
        SyntaxKind nextNextTokenKind = this.getNextNextToken().kind;
        return nextNextTokenKind == SyntaxKind.EQUAL_TOKEN || nextNextTokenKind == SyntaxKind.IDENTIFIER_TOKEN && this.peek((int)3).kind == SyntaxKind.EQUAL_TOKEN;
    }

    private STNode parseOrderKey(boolean isRhsExpr) {
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        STToken nextToken = this.peek();
        STNode orderDirection = switch (nextToken.kind) {
            case SyntaxKind.ASCENDING_KEYWORD, SyntaxKind.DESCENDING_KEYWORD -> this.consume();
            default -> STNodeFactory.createEmptyNode();
        };
        return STNodeFactory.createOrderKeyNode(expression, orderDirection);
    }

    private STNode parseSelectClause(boolean isRhsExpr, boolean allowActions) {
        this.startContext(ParserRuleContext.SELECT_CLAUSE);
        STNode selectKeyword = this.parseSelectKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, allowActions);
        this.endContext();
        return STNodeFactory.createSelectClauseNode(selectKeyword, expression);
    }

    private STNode parseSelectKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SELECT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SELECT_KEYWORD);
        return this.parseSelectKeyword();
    }

    private STNode parseOnConflictClause(boolean isRhsExpr) {
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.ON_KEYWORD && nextToken.kind != SyntaxKind.CONFLICT_KEYWORD) {
            return STNodeFactory.createEmptyNode();
        }
        this.startContext(ParserRuleContext.ON_CONFLICT_CLAUSE);
        STNode onKeyword = this.parseOnKeyword();
        STNode conflictKeyword = this.parseConflictKeyword();
        this.endContext();
        STNode expr = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createOnConflictClauseNode(onKeyword, conflictKeyword, expr);
    }

    private STNode parseConflictKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CONFLICT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.CONFLICT_KEYWORD);
        return this.parseConflictKeyword();
    }

    private STNode parseLimitClause(boolean isRhsExpr) {
        STNode limitKeyword = this.parseLimitKeyword();
        STNode expr = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createLimitClauseNode(limitKeyword, expr);
    }

    private STNode parseJoinClause(boolean isRhsExpr) {
        this.startContext(ParserRuleContext.JOIN_CLAUSE);
        STToken nextToken = this.peek();
        STNode outerKeyword = nextToken.kind == SyntaxKind.OUTER_KEYWORD ? this.consume() : STNodeFactory.createEmptyNode();
        STNode joinKeyword = this.parseJoinKeyword();
        STNode typedBindingPattern = this.parseTypedBindingPattern(ParserRuleContext.JOIN_CLAUSE);
        STNode inKeyword = this.parseInKeyword();
        STNode expression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        this.endContext();
        STNode onCondition = this.parseOnClause(isRhsExpr);
        return STNodeFactory.createJoinClauseNode(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, onCondition);
    }

    private STNode parseOnClause(boolean isRhsExpr) {
        STToken nextToken = this.peek();
        if (this.isQueryClauseStartToken(nextToken)) {
            return this.createMissingOnClauseNode();
        }
        this.startContext(ParserRuleContext.ON_CLAUSE);
        STNode onKeyword = this.parseOnKeyword();
        STNode lhsExpression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        STNode equalsKeyword = this.parseEqualsKeyword();
        this.endContext();
        STNode rhsExpression = this.parseExpression(OperatorPrecedence.QUERY, isRhsExpr, false);
        return STNodeFactory.createOnClauseNode(onKeyword, lhsExpression, equalsKeyword, rhsExpression);
    }

    private STNode createMissingOnClauseNode() {
        STToken onKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ON_KEYWORD, DiagnosticErrorCode.ERROR_MISSING_ON_KEYWORD);
        STToken identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER);
        STToken equalsKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.EQUALS_KEYWORD, DiagnosticErrorCode.ERROR_MISSING_EQUALS_KEYWORD);
        STNode lhsExpression = STNodeFactory.createSimpleNameReferenceNode(identifier);
        STNode rhsExpression = STNodeFactory.createSimpleNameReferenceNode(identifier);
        return STNodeFactory.createOnClauseNode(onKeyword, lhsExpression, equalsKeyword, rhsExpression);
    }

    private STNode parseStartAction(STNode annots) {
        STNode startKeyword = this.parseStartKeyword();
        STNode expr = this.parseActionOrExpression();
        switch (expr.kind) {
            case REMOTE_METHOD_CALL_ACTION: 
            case METHOD_CALL: 
            case FUNCTION_CALL: {
                break;
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case FIELD_ACCESS: 
            case ASYNC_SEND_ACTION: {
                expr = this.generateValidExprForStartAction(expr);
                break;
            }
            default: {
                startKeyword = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startKeyword, expr, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_EXPRESSION_IN_START_ACTION, new Object[0]);
                STNode funcName = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                funcName = STNodeFactory.createSimpleNameReferenceNode(funcName);
                STToken openParenToken = SyntaxErrors.createMissingToken(SyntaxKind.OPEN_PAREN_TOKEN);
                STToken closeParenToken = SyntaxErrors.createMissingToken(SyntaxKind.CLOSE_PAREN_TOKEN);
                expr = STNodeFactory.createFunctionCallExpressionNode(funcName, openParenToken, STNodeFactory.createEmptyNodeList(), closeParenToken);
            }
        }
        return STNodeFactory.createStartActionNode(this.getAnnotations(annots), startKeyword, expr);
    }

    private STNode generateValidExprForStartAction(STNode expr) {
        STToken openParenToken = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.OPEN_PAREN_TOKEN, DiagnosticErrorCode.ERROR_MISSING_OPEN_PAREN_TOKEN);
        STNode arguments = STNodeFactory.createEmptyNodeList();
        STToken closeParenToken = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.CLOSE_PAREN_TOKEN, DiagnosticErrorCode.ERROR_MISSING_CLOSE_PAREN_TOKEN);
        return switch (expr.kind) {
            case SyntaxKind.FIELD_ACCESS -> {
                STFieldAccessExpressionNode fieldAccessExpr = (STFieldAccessExpressionNode)expr;
                yield STNodeFactory.createMethodCallExpressionNode(fieldAccessExpr.expression, fieldAccessExpr.dotToken, fieldAccessExpr.fieldName, openParenToken, arguments, closeParenToken);
            }
            case SyntaxKind.ASYNC_SEND_ACTION -> {
                STAsyncSendActionNode asyncSendAction = (STAsyncSendActionNode)expr;
                yield STNodeFactory.createRemoteMethodCallActionNode(asyncSendAction.expression, asyncSendAction.rightArrowToken, asyncSendAction.peerWorker, openParenToken, arguments, closeParenToken);
            }
            default -> STNodeFactory.createFunctionCallExpressionNode(expr, openParenToken, arguments, closeParenToken);
        };
    }

    private STNode parseStartKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.START_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.START_KEYWORD);
        return this.parseStartKeyword();
    }

    private STNode parseFlushAction() {
        STNode flushKeyword = this.parseFlushKeyword();
        STNode peerWorker = this.parseOptionalPeerWorkerName();
        return STNodeFactory.createFlushActionNode(flushKeyword, peerWorker);
    }

    private STNode parseFlushKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.FLUSH_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.FLUSH_KEYWORD);
        return this.parseFlushKeyword();
    }

    private STNode parseOptionalPeerWorkerName() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.IDENTIFIER_TOKEN -> STNodeFactory.createSimpleNameReferenceNode(this.consume());
            default -> STNodeFactory.createEmptyNode();
        };
    }

    private STNode parseIntersectionTypeDescriptor(STNode leftTypeDesc, ParserRuleContext context, boolean isTypedBindingPattern) {
        STToken bitwiseAndToken = this.consume();
        STNode rightTypeDesc = this.parseTypeDescriptorInternal(new ArrayList<STNode>(), context, isTypedBindingPattern, false, TypePrecedence.INTERSECTION);
        return this.mergeTypesWithIntersection(leftTypeDesc, bitwiseAndToken, rightTypeDesc);
    }

    private STNode createIntersectionTypeDesc(STNode leftTypeDesc, STNode bitwiseAndToken, STNode rightTypeDesc) {
        leftTypeDesc = this.validateForUsageOfVar(leftTypeDesc);
        rightTypeDesc = this.validateForUsageOfVar(rightTypeDesc);
        return STNodeFactory.createIntersectionTypeDescriptorNode(leftTypeDesc, bitwiseAndToken, rightTypeDesc);
    }

    private STNode parseSingletonTypeDesc() {
        STNode simpleContExpr = this.parseSimpleConstExpr();
        return STNodeFactory.createSingletonTypeDescriptorNode(simpleContExpr);
    }

    private STNode parseSignedIntOrFloat() {
        STNode operator = this.parseUnaryOperator();
        STToken nextToken = this.peek();
        STNode literal = switch (nextToken.kind) {
            case SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN -> this.parseBasicLiteral();
            default -> STNodeFactory.createBasicLiteralNode(SyntaxKind.NUMERIC_LITERAL, this.parseDecimalIntLiteral(ParserRuleContext.DECIMAL_INTEGER_LITERAL_TOKEN));
        };
        return STNodeFactory.createUnaryExpressionNode(operator, literal);
    }

    private static boolean isSingletonTypeDescStart(SyntaxKind tokenKind, STToken nextNextToken) {
        return switch (tokenKind) {
            case SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.STRING_LITERAL_TOKEN, SyntaxKind.NULL_KEYWORD, SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD, SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN -> true;
            case SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN -> BallerinaParser.isIntOrFloat(nextNextToken);
            default -> false;
        };
    }

    static boolean isIntOrFloat(STToken token) {
        return switch (token.kind) {
            case SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN -> true;
            default -> false;
        };
    }

    private boolean isValidExpressionStart(SyntaxKind nextTokenKind, int nextTokenIndex) {
        ++nextTokenIndex;
        switch (nextTokenKind) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                SyntaxKind nextNextTokenKind = this.peek((int)nextTokenIndex).kind;
                if (nextNextTokenKind == SyntaxKind.PIPE_TOKEN || nextNextTokenKind == SyntaxKind.BITWISE_AND_TOKEN) {
                    return this.isValidExpressionStart(this.peek((int)(++nextTokenIndex)).kind, nextTokenIndex);
                }
                return nextNextTokenKind == SyntaxKind.SEMICOLON_TOKEN || nextNextTokenKind == SyntaxKind.COMMA_TOKEN || nextNextTokenKind == SyntaxKind.CLOSE_BRACKET_TOKEN || this.isValidExprRhsStart(nextNextTokenKind, SyntaxKind.SIMPLE_NAME_REFERENCE);
            }
            case IDENTIFIER_TOKEN: {
                return this.isValidExprRhsStart(this.peek((int)nextTokenIndex).kind, SyntaxKind.SIMPLE_NAME_REFERENCE);
            }
            case FUNCTION_KEYWORD: 
            case TRANSACTIONAL_KEYWORD: 
            case ISOLATED_KEYWORD: 
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case OPEN_PAREN_TOKEN: 
            case BACKTICK_TOKEN: 
            case LT_TOKEN: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case FROM_KEYWORD: 
            case TYPEOF_KEYWORD: 
            case NEGATION_TOKEN: 
            case EXCLAMATION_MARK_TOKEN: 
            case LET_KEYWORD: 
            case NEW_KEYWORD: 
            case BASE16_KEYWORD: 
            case BASE64_KEYWORD: 
            case NATURAL_KEYWORD: {
                return true;
            }
            case PLUS_TOKEN: 
            case MINUS_TOKEN: {
                return this.isValidExpressionStart(this.peek((int)nextTokenIndex).kind, nextTokenIndex);
            }
            case MAP_KEYWORD: 
            case TABLE_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.FROM_KEYWORD;
            }
            case STREAM_KEYWORD: {
                STToken nextNextToken = this.peek(nextTokenIndex);
                return nextNextToken.kind == SyntaxKind.KEY_KEYWORD || nextNextToken.kind == SyntaxKind.OPEN_BRACKET_TOKEN || nextNextToken.kind == SyntaxKind.FROM_KEYWORD;
            }
            case ERROR_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.OPEN_PAREN_TOKEN;
            }
            case XML_KEYWORD: 
            case STRING_KEYWORD: 
            case RE_KEYWORD: {
                return this.peek((int)nextTokenIndex).kind == SyntaxKind.BACKTICK_TOKEN;
            }
        }
        return false;
    }

    private STNode parseSyncSendAction(STNode expression) {
        STNode syncSendToken = this.parseSyncSendToken();
        STNode peerWorker = this.parsePeerWorkerName();
        return STNodeFactory.createSyncSendActionNode(expression, syncSendToken, peerWorker);
    }

    private STNode parsePeerWorkerName() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.IDENTIFIER_TOKEN -> STNodeFactory.createSimpleNameReferenceNode(this.consume());
            default -> {
                this.recover(token, ParserRuleContext.PEER_WORKER_NAME);
                yield this.parsePeerWorkerName();
            }
        };
    }

    private STNode parseSyncSendToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SYNC_SEND_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SYNC_SEND_TOKEN);
        return this.parseSyncSendToken();
    }

    private STNode parseReceiveAction() {
        STNode leftArrow = this.parseLeftArrowToken();
        STNode receiveWorkers = this.parseReceiveWorkers();
        return STNodeFactory.createReceiveActionNode(leftArrow, receiveWorkers);
    }

    private STNode parseReceiveWorkers() {
        return switch (this.peek().kind) {
            case SyntaxKind.FUNCTION_KEYWORD, SyntaxKind.IDENTIFIER_TOKEN -> this.parseSingleOrAlternateReceiveWorkers();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseMultipleReceiveWorkers();
            default -> {
                this.recover(this.peek(), ParserRuleContext.RECEIVE_WORKERS);
                yield this.parseReceiveWorkers();
            }
        };
    }

    private STNode parseSingleOrAlternateReceiveWorkers() {
        this.startContext(ParserRuleContext.SINGLE_OR_ALTERNATE_WORKER);
        ArrayList<STNode> workers = new ArrayList<STNode>();
        STNode peerWorker = this.parsePeerWorkerName();
        workers.add(peerWorker);
        STToken nextToken = this.peek();
        if (nextToken.kind != SyntaxKind.PIPE_TOKEN) {
            this.endContext();
            return peerWorker;
        }
        while (nextToken.kind == SyntaxKind.PIPE_TOKEN) {
            STToken pipeToken = this.consume();
            workers.add(pipeToken);
            peerWorker = this.parsePeerWorkerName();
            workers.add(peerWorker);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createAlternateReceiveNode(STNodeFactory.createNodeList(workers));
    }

    private STNode parseMultipleReceiveWorkers() {
        this.startContext(ParserRuleContext.MULTI_RECEIVE_WORKERS);
        STNode openBrace = this.parseOpenBrace();
        STNode receiveFields = this.parseReceiveFields();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        openBrace = this.cloneWithDiagnosticIfListEmpty(receiveFields, openBrace, DiagnosticErrorCode.ERROR_MISSING_RECEIVE_FIELD_IN_RECEIVE_ACTION);
        return STNodeFactory.createReceiveFieldsNode(openBrace, receiveFields, closeBrace);
    }

    private STNode parseReceiveFields() {
        STNode recieveFieldEnd;
        ArrayList<STNode> receiveFields = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfReceiveFields(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode receiveField = this.parseReceiveField();
        receiveFields.add(receiveField);
        nextToken = this.peek();
        while (!this.isEndOfReceiveFields(nextToken.kind) && (recieveFieldEnd = this.parseReceiveFieldEnd()) != null) {
            receiveFields.add(recieveFieldEnd);
            receiveField = this.parseReceiveField();
            receiveFields.add(receiveField);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(receiveFields);
    }

    private boolean isEndOfReceiveFields(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseReceiveFieldEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.RECEIVE_FIELD_END);
                yield this.parseReceiveFieldEnd();
            }
        };
    }

    private STNode parseReceiveField() {
        return switch (this.peek().kind) {
            case SyntaxKind.FUNCTION_KEYWORD -> {
                STToken functionKeyword = this.consume();
                yield STNodeFactory.createSimpleNameReferenceNode(functionKeyword);
            }
            case SyntaxKind.IDENTIFIER_TOKEN -> {
                STNode identifier = this.parseIdentifier(ParserRuleContext.RECEIVE_FIELD_NAME);
                yield this.createReceiveField(identifier);
            }
            default -> {
                this.recover(this.peek(), ParserRuleContext.RECEIVE_FIELD);
                yield this.parseReceiveField();
            }
        };
    }

    private STNode createReceiveField(STNode identifier) {
        if (this.peek().kind != SyntaxKind.COLON_TOKEN) {
            return STNodeFactory.createSimpleNameReferenceNode(identifier);
        }
        identifier = STNodeFactory.createSimpleNameReferenceNode(identifier);
        STNode colon = this.parseColon();
        STNode peerWorker = this.parsePeerWorkerName();
        return STNodeFactory.createReceiveFieldNode(identifier, colon, peerWorker);
    }

    private STNode parseLeftArrowToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LEFT_ARROW_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LEFT_ARROW_TOKEN);
        return this.parseLeftArrowToken();
    }

    private STNode parseSignedRightShiftToken() {
        STToken firstToken = this.consume();
        if (firstToken.kind == SyntaxKind.DOUBLE_GT_TOKEN) {
            return firstToken;
        }
        STToken endLGToken = this.consume();
        STToken doubleGTToken = STNodeFactory.createToken(SyntaxKind.DOUBLE_GT_TOKEN, ((STNode)firstToken).leadingMinutiae(), endLGToken.trailingMinutiae());
        if (this.hasTrailingMinutiae(firstToken)) {
            doubleGTToken = SyntaxErrors.addDiagnostic(doubleGTToken, DiagnosticErrorCode.ERROR_NO_WHITESPACES_ALLOWED_IN_RIGHT_SHIFT_OP, new Object[0]);
        }
        return doubleGTToken;
    }

    private STNode parseUnsignedRightShiftToken() {
        boolean validMiddleGTToken;
        STToken firstToken = this.consume();
        if (firstToken.kind == SyntaxKind.TRIPPLE_GT_TOKEN) {
            return firstToken;
        }
        STToken middleGTToken = this.consume();
        STToken endLGToken = this.consume();
        STToken unsignedRightShiftToken = STNodeFactory.createToken(SyntaxKind.TRIPPLE_GT_TOKEN, ((STNode)firstToken).leadingMinutiae(), ((STNode)endLGToken).trailingMinutiae());
        boolean validOpenGTToken = !this.hasTrailingMinutiae(firstToken);
        boolean bl = validMiddleGTToken = !this.hasTrailingMinutiae(middleGTToken);
        if (validOpenGTToken && validMiddleGTToken) {
            return unsignedRightShiftToken;
        }
        unsignedRightShiftToken = SyntaxErrors.addDiagnostic(unsignedRightShiftToken, DiagnosticErrorCode.ERROR_NO_WHITESPACES_ALLOWED_IN_UNSIGNED_RIGHT_SHIFT_OP, new Object[0]);
        return unsignedRightShiftToken;
    }

    private STNode parseWaitAction() {
        STNode waitKeyword = this.parseWaitKeyword();
        if (this.peek().kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.parseMultiWaitAction(waitKeyword);
        }
        return this.parseSingleOrAlternateWaitAction(waitKeyword);
    }

    private STNode parseWaitKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.WAIT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.WAIT_KEYWORD);
        return this.parseWaitKeyword();
    }

    private STNode parseSingleOrAlternateWaitAction(STNode waitKeyword) {
        STNode waitFutureExprEnd;
        this.startContext(ParserRuleContext.ALTERNATE_WAIT_EXPRS);
        STToken nextToken = this.peek();
        if (this.isEndOfWaitFutureExprList(nextToken.kind)) {
            this.endContext();
            STNode waitFutureExprs = STNodeFactory.createSimpleNameReferenceNode(STNodeFactory.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
            waitFutureExprs = SyntaxErrors.addDiagnostic(waitFutureExprs, DiagnosticErrorCode.ERROR_MISSING_WAIT_FUTURE_EXPRESSION, new Object[0]);
            return STNodeFactory.createWaitActionNode(waitKeyword, waitFutureExprs);
        }
        ArrayList<STNode> waitFutureExprList = new ArrayList<STNode>();
        STNode waitField = this.parseWaitFutureExpr();
        waitFutureExprList.add(waitField);
        nextToken = this.peek();
        while (!this.isEndOfWaitFutureExprList(nextToken.kind) && (waitFutureExprEnd = this.parseWaitFutureExprEnd()) != null) {
            waitFutureExprList.add(waitFutureExprEnd);
            waitField = this.parseWaitFutureExpr();
            waitFutureExprList.add(waitField);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createWaitActionNode(waitKeyword, (STNode)waitFutureExprList.get(0));
    }

    private boolean isEndOfWaitFutureExprList(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseWaitFutureExpr() {
        STNode waitFutureExpr = this.parseActionOrExpression();
        if (waitFutureExpr.kind == SyntaxKind.MAPPING_CONSTRUCTOR) {
            waitFutureExpr = SyntaxErrors.addDiagnostic(waitFutureExpr, DiagnosticErrorCode.ERROR_MAPPING_CONSTRUCTOR_EXPR_AS_A_WAIT_EXPR, new Object[0]);
        } else if (this.isAction(waitFutureExpr)) {
            waitFutureExpr = SyntaxErrors.addDiagnostic(waitFutureExpr, DiagnosticErrorCode.ERROR_ACTION_AS_A_WAIT_EXPR, new Object[0]);
        }
        return waitFutureExpr;
    }

    private STNode parseWaitFutureExprEnd() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case PIPE_TOKEN: {
                return this.parsePipeToken();
            }
        }
        if (this.isEndOfWaitFutureExprList(nextToken.kind) || !this.isValidExpressionStart(nextToken.kind, 1)) {
            return null;
        }
        this.recover(this.peek(), ParserRuleContext.WAIT_FUTURE_EXPR_END);
        return this.parseWaitFutureExprEnd();
    }

    private STNode parseMultiWaitAction(STNode waitKeyword) {
        this.startContext(ParserRuleContext.MULTI_WAIT_FIELDS);
        STNode openBrace = this.parseOpenBrace();
        STNode waitFields = this.parseWaitFields();
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        openBrace = this.cloneWithDiagnosticIfListEmpty(waitFields, openBrace, DiagnosticErrorCode.ERROR_MISSING_WAIT_FIELD_IN_WAIT_ACTION);
        STNode waitFieldsNode = STNodeFactory.createWaitFieldsListNode(openBrace, waitFields, closeBrace);
        return STNodeFactory.createWaitActionNode(waitKeyword, waitFieldsNode);
    }

    private STNode parseWaitFields() {
        STNode waitFieldEnd;
        ArrayList<STNode> waitFields = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfWaitFields(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        STNode waitField = this.parseWaitField();
        waitFields.add(waitField);
        nextToken = this.peek();
        while (!this.isEndOfWaitFields(nextToken.kind) && (waitFieldEnd = this.parseWaitFieldEnd()) != null) {
            waitFields.add(waitFieldEnd);
            waitField = this.parseWaitField();
            waitFields.add(waitField);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(waitFields);
    }

    private boolean isEndOfWaitFields(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseWaitFieldEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.WAIT_FIELD_END);
                yield this.parseWaitFieldEnd();
            }
        };
    }

    private STNode parseWaitField() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseIdentifier(ParserRuleContext.WAIT_FIELD_NAME);
                identifier = STNodeFactory.createSimpleNameReferenceNode(identifier);
                return this.createQualifiedWaitField(identifier);
            }
        }
        this.recover(this.peek(), ParserRuleContext.WAIT_FIELD_NAME);
        return this.parseWaitField();
    }

    private STNode createQualifiedWaitField(STNode identifier) {
        if (this.peek().kind != SyntaxKind.COLON_TOKEN) {
            return identifier;
        }
        STNode colon = this.parseColon();
        STNode waitFutureExpr = this.parseWaitFutureExpr();
        return STNodeFactory.createWaitFieldNode(identifier, colon, waitFutureExpr);
    }

    private STNode parseAnnotAccessExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode annotAccessToken = this.parseAnnotChainingToken();
        STNode annotTagReference = this.parseFieldAccessIdentifier(isInConditionalExpr);
        return STNodeFactory.createAnnotAccessExpressionNode(lhsExpr, annotAccessToken, annotTagReference);
    }

    private STNode parseAnnotChainingToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ANNOT_CHAINING_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ANNOT_CHAINING_TOKEN);
        return this.parseAnnotChainingToken();
    }

    private STNode parseFieldAccessIdentifier(boolean isInConditionalExpr) {
        STToken nextToken = this.peek();
        if (!this.isPredeclaredIdentifier(nextToken.kind)) {
            STToken identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER);
            return this.parseQualifiedIdentifier(identifier, isInConditionalExpr);
        }
        return this.parseQualifiedIdentifier(ParserRuleContext.FIELD_ACCESS_IDENTIFIER, isInConditionalExpr);
    }

    private STNode parseQueryAction(STNode queryConstructType, STNode queryPipeline, STNode selectClause, STNode collectClause) {
        if (queryConstructType != null) {
            queryPipeline = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(queryPipeline, queryConstructType, (DiagnosticCode)DiagnosticErrorCode.ERROR_QUERY_CONSTRUCT_TYPE_IN_QUERY_ACTION, new Object[0]);
        }
        if (selectClause != null) {
            queryPipeline = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(queryPipeline, selectClause, (DiagnosticCode)DiagnosticErrorCode.ERROR_SELECT_CLAUSE_IN_QUERY_ACTION, new Object[0]);
        }
        if (collectClause != null) {
            queryPipeline = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(queryPipeline, collectClause, (DiagnosticCode)DiagnosticErrorCode.ERROR_COLLECT_CLAUSE_IN_QUERY_ACTION, new Object[0]);
        }
        this.startContext(ParserRuleContext.DO_CLAUSE);
        STNode doKeyword = this.parseDoKeyword();
        STNode blockStmt = this.parseBlockNode();
        this.endContext();
        return STNodeFactory.createQueryActionNode(queryPipeline, doKeyword, blockStmt);
    }

    private STNode parseDoKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DO_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.DO_KEYWORD);
        return this.parseDoKeyword();
    }

    private STNode parseOptionalFieldAccessExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        STNode optionalFieldAccessToken = this.parseOptionalChainingToken();
        STNode fieldName = this.parseFieldAccessIdentifier(isInConditionalExpr);
        return STNodeFactory.createOptionalFieldAccessExpressionNode(lhsExpr, optionalFieldAccessToken, fieldName);
    }

    private STNode parseOptionalChainingToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPTIONAL_CHAINING_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.OPTIONAL_CHAINING_TOKEN);
        return this.parseOptionalChainingToken();
    }

    private STNode parseConditionalExpression(STNode lhsExpr, boolean isInConditionalExpr) {
        this.startContext(ParserRuleContext.CONDITIONAL_EXPRESSION);
        STNode questionMark = this.parseQuestionMark();
        STNode middleExpr = this.parseExpression(OperatorPrecedence.ANON_FUNC_OR_LET, true, false, true);
        if (this.peek().kind != SyntaxKind.COLON_TOKEN) {
            STNode rightMostQNameRef;
            if (middleExpr.kind == SyntaxKind.CONDITIONAL_EXPRESSION) {
                STConditionalExpressionNode innerConditionalExpr = (STConditionalExpressionNode)middleExpr;
                STNode innerMiddleExpr = innerConditionalExpr.middleExpression;
                STNode rightMostQNameRef2 = ConditionalExprResolver.getQualifiedNameRefNode(innerMiddleExpr, false);
                if (rightMostQNameRef2 != null) {
                    middleExpr = this.generateConditionalExprForRightMost(innerConditionalExpr.lhsExpression, innerConditionalExpr.questionMarkToken, innerMiddleExpr, rightMostQNameRef2);
                    this.endContext();
                    return STNodeFactory.createConditionalExpressionNode(lhsExpr, questionMark, middleExpr, innerConditionalExpr.colonToken, innerConditionalExpr.endExpression);
                }
                STNode leftMostQNameRef = ConditionalExprResolver.getQualifiedNameRefNode(innerMiddleExpr, true);
                if (leftMostQNameRef != null) {
                    middleExpr = this.generateConditionalExprForLeftMost(innerConditionalExpr.lhsExpression, innerConditionalExpr.questionMarkToken, innerMiddleExpr, leftMostQNameRef);
                    this.endContext();
                    return STNodeFactory.createConditionalExpressionNode(lhsExpr, questionMark, middleExpr, innerConditionalExpr.colonToken, innerConditionalExpr.endExpression);
                }
            }
            if ((rightMostQNameRef = ConditionalExprResolver.getQualifiedNameRefNode(middleExpr, false)) != null) {
                this.endContext();
                return this.generateConditionalExprForRightMost(lhsExpr, questionMark, middleExpr, rightMostQNameRef);
            }
            STNode leftMostQNameRef = ConditionalExprResolver.getQualifiedNameRefNode(middleExpr, true);
            if (leftMostQNameRef != null) {
                this.endContext();
                return this.generateConditionalExprForLeftMost(lhsExpr, questionMark, middleExpr, leftMostQNameRef);
            }
        }
        return this.parseConditionalExprRhs(lhsExpr, questionMark, middleExpr, isInConditionalExpr);
    }

    private STNode generateConditionalExprForRightMost(STNode lhsExpr, STNode questionMark, STNode middleExpr, STNode rightMostQualifiedNameRef) {
        STQualifiedNameReferenceNode qualifiedNameRef = (STQualifiedNameReferenceNode)rightMostQualifiedNameRef;
        STNode endExpr = STNodeFactory.createSimpleNameReferenceNode(qualifiedNameRef.identifier);
        STNode simpleNameRef = ConditionalExprResolver.getSimpleNameRefNode(qualifiedNameRef.modulePrefix);
        middleExpr = middleExpr.replace(rightMostQualifiedNameRef, simpleNameRef);
        return STNodeFactory.createConditionalExpressionNode(lhsExpr, questionMark, middleExpr, qualifiedNameRef.colon, endExpr);
    }

    private STNode generateConditionalExprForLeftMost(STNode lhsExpr, STNode questionMark, STNode middleExpr, STNode leftMostQualifiedNameRef) {
        STQualifiedNameReferenceNode qualifiedNameRef = (STQualifiedNameReferenceNode)leftMostQualifiedNameRef;
        STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(qualifiedNameRef.identifier);
        Object endExpr = middleExpr.replace(leftMostQualifiedNameRef, simpleNameRef);
        middleExpr = ConditionalExprResolver.getSimpleNameRefNode(qualifiedNameRef.modulePrefix);
        return STNodeFactory.createConditionalExpressionNode(lhsExpr, questionMark, middleExpr, qualifiedNameRef.colon, endExpr);
    }

    private STNode parseConditionalExprRhs(STNode lhsExpr, STNode questionMark, STNode middleExpr, boolean isInConditionalExpr) {
        STNode colon = this.parseColon();
        this.endContext();
        STNode endExpr = this.parseExpression(OperatorPrecedence.ANON_FUNC_OR_LET, true, false, isInConditionalExpr);
        return STNodeFactory.createConditionalExpressionNode(lhsExpr, questionMark, middleExpr, colon, endExpr);
    }

    private STNode parseEnumDeclaration(STNode metadata, STNode qualifier) {
        this.startContext(ParserRuleContext.MODULE_ENUM_DECLARATION);
        STNode enumKeywordToken = this.parseEnumKeyword();
        STNode identifier = this.parseIdentifier(ParserRuleContext.MODULE_ENUM_NAME);
        STNode openBraceToken = this.parseOpenBrace();
        STNode enumMemberList = this.parseEnumMemberList();
        STNode closeBraceToken = this.parseCloseBrace();
        STNode semicolon = this.parseOptionalSemicolon();
        this.endContext();
        openBraceToken = this.cloneWithDiagnosticIfListEmpty(enumMemberList, openBraceToken, DiagnosticErrorCode.ERROR_MISSING_ENUM_MEMBER);
        return STNodeFactory.createEnumDeclarationNode(metadata, qualifier, enumKeywordToken, identifier, openBraceToken, enumMemberList, closeBraceToken, semicolon);
    }

    private STNode parseEnumKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ENUM_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ENUM_KEYWORD);
        return this.parseEnumKeyword();
    }

    private STNode parseEnumMemberList() {
        STNode enumMemberRhs;
        this.startContext(ParserRuleContext.ENUM_MEMBER_LIST);
        if (this.peek().kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> enumMemberList = new ArrayList<STNode>();
        STNode enumMember = this.parseEnumMember();
        while (this.peek().kind != SyntaxKind.CLOSE_BRACE_TOKEN && (enumMemberRhs = this.parseEnumMemberEnd()) != null) {
            enumMemberList.add(enumMember);
            enumMemberList.add(enumMemberRhs);
            enumMember = this.parseEnumMember();
        }
        enumMemberList.add(enumMember);
        this.endContext();
        return STNodeFactory.createNodeList(enumMemberList);
    }

    private STNode parseEnumMember() {
        STNode metadata = switch (this.peek().kind) {
            case SyntaxKind.DOCUMENTATION_STRING, SyntaxKind.AT_TOKEN -> this.parseMetaData();
            default -> STNodeFactory.createEmptyNode();
        };
        STNode identifierNode = this.parseIdentifier(ParserRuleContext.ENUM_MEMBER_NAME);
        return this.parseEnumMemberRhs(metadata, identifierNode);
    }

    private STNode parseEnumMemberRhs(STNode metadata, STNode identifierNode) {
        STNode constExprNode;
        STNode equalToken;
        switch (this.peek().kind) {
            case EQUAL_TOKEN: {
                equalToken = this.parseAssignOp();
                constExprNode = this.parseExpression();
                break;
            }
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                equalToken = STNodeFactory.createEmptyNode();
                constExprNode = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.ENUM_MEMBER_RHS);
                return this.parseEnumMemberRhs(metadata, identifierNode);
            }
        }
        return STNodeFactory.createEnumMemberNode(metadata, identifierNode, equalToken, constExprNode);
    }

    private STNode parseEnumMemberEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.ENUM_MEMBER_END);
                yield this.parseEnumMemberEnd();
            }
        };
    }

    private STNode parseTransactionStmtOrVarDecl(STNode annots, List<STNode> qualifiers, STToken transactionKeyword) {
        switch (this.peek().kind) {
            case OPEN_BRACE_TOKEN: {
                this.reportInvalidStatementAnnots(annots, qualifiers);
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTransactionStatement(transactionKeyword);
            }
            case COLON_TOKEN: {
                if (this.getNextNextToken().kind != SyntaxKind.IDENTIFIER_TOKEN) break;
                STNode typeDesc = this.parseQualifiedIdentifierWithPredeclPrefix(transactionKeyword, false);
                return this.parseVarDeclTypeDescRhs(typeDesc, annots, qualifiers, true, false);
            }
        }
        AbstractParserErrorHandler.Solution solution = this.recover(this.peek(), ParserRuleContext.TRANSACTION_STMT_RHS_OR_TYPE_REF);
        if (solution.action == AbstractParserErrorHandler.Action.KEEP || solution.action == AbstractParserErrorHandler.Action.INSERT && solution.tokenKind == SyntaxKind.COLON_TOKEN) {
            STNode typeDesc = this.parseQualifiedIdentifierWithPredeclPrefix(transactionKeyword, false);
            return this.parseVarDeclTypeDescRhs(typeDesc, annots, qualifiers, true, false);
        }
        return this.parseTransactionStmtOrVarDecl(annots, qualifiers, transactionKeyword);
    }

    private STNode parseTransactionStatement(STNode transactionKeyword) {
        this.startContext(ParserRuleContext.TRANSACTION_STMT);
        STNode blockStmt = this.parseBlockNode();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createTransactionStatementNode(transactionKeyword, blockStmt, onFailClause);
    }

    private STNode parseCommitAction() {
        STNode commitKeyword = this.parseCommitKeyword();
        return STNodeFactory.createCommitActionNode(commitKeyword);
    }

    private STNode parseCommitKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COMMIT_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.COMMIT_KEYWORD);
        return this.parseCommitKeyword();
    }

    private STNode parseRetryStatement() {
        this.startContext(ParserRuleContext.RETRY_STMT);
        STNode retryKeyword = this.parseRetryKeyword();
        STNode retryStmt = this.parseRetryKeywordRhs(retryKeyword);
        return retryStmt;
    }

    private STNode parseRetryKeywordRhs(STNode retryKeyword) {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.LT_TOKEN -> this.parseRetryTypeParamRhs(retryKeyword, this.parseTypeParameter());
            case SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.OPEN_PAREN_TOKEN, SyntaxKind.TRANSACTION_KEYWORD -> this.parseRetryTypeParamRhs(retryKeyword, STNodeFactory.createEmptyNode());
            default -> {
                this.recover(this.peek(), ParserRuleContext.RETRY_KEYWORD_RHS);
                yield this.parseRetryKeywordRhs(retryKeyword);
            }
        };
    }

    private STNode parseRetryTypeParamRhs(STNode retryKeyword, STNode typeParam) {
        STNode args;
        switch (this.peek().kind) {
            case OPEN_PAREN_TOKEN: {
                args = this.parseParenthesizedArgList();
                break;
            }
            case OPEN_BRACE_TOKEN: 
            case TRANSACTION_KEYWORD: {
                args = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                this.recover(this.peek(), ParserRuleContext.RETRY_TYPE_PARAM_RHS);
                return this.parseRetryTypeParamRhs(retryKeyword, typeParam);
            }
        }
        STNode blockStmt = this.parseRetryBody();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createRetryStatementNode(retryKeyword, typeParam, args, blockStmt, onFailClause);
    }

    private STNode parseRetryBody() {
        return switch (this.peek().kind) {
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseBlockNode();
            case SyntaxKind.TRANSACTION_KEYWORD -> this.parseTransactionStatement(this.consume());
            default -> {
                this.recover(this.peek(), ParserRuleContext.RETRY_BODY);
                yield this.parseRetryBody();
            }
        };
    }

    private STNode parseOptionalOnFailClause() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.ON_KEYWORD) {
            return this.parseOnFailClause();
        }
        if (this.isEndOfRegularCompoundStmt(nextToken.kind)) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(nextToken, ParserRuleContext.REGULAR_COMPOUND_STMT_RHS);
        return this.parseOptionalOnFailClause();
    }

    private boolean isEndOfRegularCompoundStmt(SyntaxKind nodeKind) {
        return switch (nodeKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.AT_TOKEN, SyntaxKind.SEMICOLON_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> this.isStatementStartingToken(nodeKind);
        };
    }

    private boolean isStatementStartingToken(SyntaxKind nodeKind) {
        switch (nodeKind) {
            case FINAL_KEYWORD: 
            case TYPE_KEYWORD: 
            case CONST_KEYWORD: 
            case XMLNS_KEYWORD: 
            case OPEN_BRACE_TOKEN: 
            case TRANSACTION_KEYWORD: 
            case IF_KEYWORD: 
            case WHILE_KEYWORD: 
            case DO_KEYWORD: 
            case PANIC_KEYWORD: 
            case CONTINUE_KEYWORD: 
            case BREAK_KEYWORD: 
            case RETURN_KEYWORD: 
            case FAIL_KEYWORD: 
            case LOCK_KEYWORD: 
            case WORKER_KEYWORD: 
            case FORK_KEYWORD: 
            case FOREACH_KEYWORD: 
            case START_KEYWORD: 
            case CHECK_KEYWORD: 
            case CHECKPANIC_KEYWORD: 
            case TRAP_KEYWORD: 
            case FLUSH_KEYWORD: 
            case LEFT_ARROW_TOKEN: 
            case WAIT_KEYWORD: 
            case COMMIT_KEYWORD: 
            case RETRY_KEYWORD: 
            case ROLLBACK_KEYWORD: 
            case MATCH_KEYWORD: {
                return true;
            }
        }
        if (this.isTypeStartingToken(nodeKind)) {
            return true;
        }
        return this.isValidExpressionStart(nodeKind, 1);
    }

    private STNode parseOnFailClause() {
        this.startContext(ParserRuleContext.ON_FAIL_CLAUSE);
        STNode onKeyword = this.parseOnKeyword();
        STNode failKeyword = this.parseFailKeyword();
        STNode typedBindingPattern = this.parseOnfailOptionalBP();
        STNode blockStatement = this.parseBlockNode();
        this.endContext();
        return STNodeFactory.createOnFailClauseNode(onKeyword, failKeyword, typedBindingPattern, blockStatement);
    }

    private STNode parseOnfailOptionalBP() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return STAbstractNodeFactory.createEmptyNode();
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseTypedBindingPattern();
        }
        this.recover(nextToken, ParserRuleContext.ON_FAIL_OPTIONAL_BINDING_PATTERN);
        return this.parseOnfailOptionalBP();
    }

    private STNode parseTypedBindingPattern() {
        STNode typeDescriptor = this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true, false, TypePrecedence.DEFAULT);
        STNode bindingPattern = this.parseBindingPattern();
        return STNodeFactory.createTypedBindingPatternNode(typeDescriptor, bindingPattern);
    }

    private STNode parseRetryKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.RETRY_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.RETRY_KEYWORD);
        return this.parseRetryKeyword();
    }

    private STNode parseRollbackStatement() {
        this.startContext(ParserRuleContext.ROLLBACK_STMT);
        STNode rollbackKeyword = this.parseRollbackKeyword();
        STNode expression = this.peek().kind == SyntaxKind.SEMICOLON_TOKEN ? STNodeFactory.createEmptyNode() : this.parseExpression();
        STNode semicolon = this.parseSemicolon();
        this.endContext();
        return STNodeFactory.createRollbackStatementNode(rollbackKeyword, expression, semicolon);
    }

    private STNode parseRollbackKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.ROLLBACK_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ROLLBACK_KEYWORD);
        return this.parseRollbackKeyword();
    }

    private STNode parseTransactionalExpression() {
        STNode transactionalKeyword = this.parseTransactionalKeyword();
        return STNodeFactory.createTransactionalExpressionNode(transactionalKeyword);
    }

    private STNode parseTransactionalKeyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRANSACTIONAL_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.TRANSACTIONAL_KEYWORD);
        return this.parseTransactionalKeyword();
    }

    private STNode parseByteArrayLiteral() {
        STNode type = this.peek().kind == SyntaxKind.BASE16_KEYWORD ? this.parseBase16Keyword() : this.parseBase64Keyword();
        STNode startingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_START);
        if (startingBackTick.isMissing()) {
            startingBackTick = SyntaxErrors.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
            STToken endingBackTick = SyntaxErrors.createMissingToken(SyntaxKind.BACKTICK_TOKEN);
            STNode content = STNodeFactory.createEmptyNode();
            STNode byteArrayLiteral = STNodeFactory.createByteArrayLiteralNode(type, startingBackTick, content, endingBackTick);
            byteArrayLiteral = SyntaxErrors.addDiagnostic(byteArrayLiteral, DiagnosticErrorCode.ERROR_MISSING_BYTE_ARRAY_CONTENT, new Object[0]);
            return byteArrayLiteral;
        }
        STNode content = this.parseByteArrayContent();
        return this.parseByteArrayLiteral(type, startingBackTick, content);
    }

    private STNode parseByteArrayLiteral(STNode typeKeyword, STNode startingBackTick, STNode byteArrayContent) {
        STNode content = STNodeFactory.createEmptyNode();
        STNode newStartingBackTick = startingBackTick;
        STNodeList items = (STNodeList)byteArrayContent;
        if (items.size() == 1) {
            STNode item = items.get(0);
            if (typeKeyword.kind == SyntaxKind.BASE16_KEYWORD && !BallerinaParser.isValidBase16LiteralContent(item.toString())) {
                newStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startingBackTick, item, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_BASE16_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
            } else if (typeKeyword.kind == SyntaxKind.BASE64_KEYWORD && !BallerinaParser.isValidBase64LiteralContent(item.toString())) {
                newStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startingBackTick, item, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_BASE64_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
            } else if (item.kind != SyntaxKind.TEMPLATE_STRING) {
                newStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(startingBackTick, item, (DiagnosticCode)DiagnosticErrorCode.ERROR_INVALID_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
            } else {
                content = item;
            }
        } else if (items.size() > 1) {
            STNode clonedStartingBackTick = startingBackTick;
            for (int index = 0; index < items.size(); ++index) {
                STNode item = items.get(index);
                clonedStartingBackTick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(clonedStartingBackTick, item);
            }
            newStartingBackTick = SyntaxErrors.addDiagnostic(clonedStartingBackTick, DiagnosticErrorCode.ERROR_INVALID_CONTENT_IN_BYTE_ARRAY_LITERAL, new Object[0]);
        }
        STNode endingBackTick = this.parseBacktickToken(ParserRuleContext.TEMPLATE_END);
        return STNodeFactory.createByteArrayLiteralNode(typeKeyword, newStartingBackTick, content, endingBackTick);
    }

    private STNode parseBase16Keyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BASE16_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BASE16_KEYWORD);
        return this.parseBase16Keyword();
    }

    private STNode parseBase64Keyword() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BASE64_KEYWORD) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.BASE64_KEYWORD);
        return this.parseBase64Keyword();
    }

    private STNode parseByteArrayContent() {
        STToken nextToken = this.peek();
        ArrayList<STNode> items = new ArrayList<STNode>();
        while (!this.isEndOfBacktickContent(nextToken.kind)) {
            STNode content = this.parseTemplateItem();
            items.add(content);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(items);
    }

    static boolean isValidBase16LiteralContent(String content) {
        char[] charArray = content.toCharArray();
        int hexDigitCount = 0;
        block3: for (char c : charArray) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    if (BallerinaParser.isHexDigit(c)) {
                        ++hexDigitCount;
                        continue block3;
                    }
                    return false;
                }
            }
        }
        return hexDigitCount % 2 == 0;
    }

    static boolean isValidBase64LiteralContent(String content) {
        char[] charArray = content.toCharArray();
        int base64CharCount = 0;
        int paddingCharCount = 0;
        block4: for (char c : charArray) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                case '=': {
                    ++paddingCharCount;
                    continue block4;
                }
                default: {
                    if (BallerinaParser.isBase64Char(c)) {
                        if (paddingCharCount == 0) {
                            ++base64CharCount;
                            continue block4;
                        }
                        return false;
                    }
                    return false;
                }
            }
        }
        if (paddingCharCount > 2) {
            return false;
        }
        if (paddingCharCount == 0) {
            return base64CharCount % 4 == 0;
        }
        return base64CharCount % 4 == 4 - paddingCharCount;
    }

    static boolean isBase64Char(int c) {
        if (97 <= c && c <= 122) {
            return true;
        }
        if (65 <= c && c <= 90) {
            return true;
        }
        if (c == 43 || c == 47) {
            return true;
        }
        return BallerinaParser.isDigit(c);
    }

    static boolean isHexDigit(int c) {
        if (97 <= c && c <= 102) {
            return true;
        }
        if (65 <= c && c <= 70) {
            return true;
        }
        return BallerinaParser.isDigit(c);
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private STNode parseXMLFilterExpression(STNode lhsExpr) {
        STNode xmlNamePatternChain = this.parseXMLFilterExpressionRhs();
        return STNodeFactory.createXMLFilterExpressionNode(lhsExpr, xmlNamePatternChain);
    }

    private STNode parseXMLFilterExpressionRhs() {
        STNode dotLTToken = this.parseDotLTToken();
        return this.parseXMLNamePatternChain(dotLTToken);
    }

    private STNode parseXMLNamePatternChain(STNode startToken) {
        this.startContext(ParserRuleContext.XML_NAME_PATTERN);
        STNode xmlNamePattern = this.parseXMLNamePattern();
        STNode gtToken = this.parseGTToken();
        this.endContext();
        startToken = this.cloneWithDiagnosticIfListEmpty(xmlNamePattern, startToken, DiagnosticErrorCode.ERROR_MISSING_XML_ATOMIC_NAME_PATTERN);
        return STNodeFactory.createXMLNamePatternChainingNode(startToken, xmlNamePattern, gtToken);
    }

    private STNode parseXMLStepExtends() {
        STToken nextToken = this.peek();
        if (this.isEndOfXMLStepExtend(nextToken.kind)) {
            return STNodeFactory.createEmptyNodeList();
        }
        ArrayList<STNode> xmlStepExtendList = new ArrayList<STNode>();
        this.startContext(ParserRuleContext.XML_STEP_EXTENDS);
        while (!this.isEndOfXMLStepExtend(nextToken.kind)) {
            STNode stepExtension = nextToken.kind == SyntaxKind.DOT_TOKEN ? this.parseXMLStepMethodCallExtend() : (nextToken.kind == SyntaxKind.DOT_LT_TOKEN ? this.parseXMLFilterExpressionRhs() : this.parseXMLIndexedStepExtend());
            xmlStepExtendList.add(stepExtension);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(xmlStepExtendList);
    }

    private STNode parseXMLIndexedStepExtend() {
        this.startContext(ParserRuleContext.MEMBER_ACCESS_KEY_EXPR);
        STNode openBracket = this.parseOpenBracket();
        STNode keyExpr = this.parseKeyExpr(true);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return STNodeFactory.createXMLStepIndexedExtendNode(openBracket, keyExpr, closeBracket);
    }

    private STNode parseXMLStepMethodCallExtend() {
        STNode dotToken = this.parseDotToken();
        STNode methodName = this.parseMethodName();
        STNode parenthesizedArgsList = this.parseParenthesizedArgList();
        return STNodeFactory.createXMLStepMethodCallExtendNode(dotToken, methodName, parenthesizedArgsList);
    }

    private STNode parseMethodName() {
        if (this.isSpecialMethodName(this.peek())) {
            return this.getKeywordAsSimpleNameRef();
        }
        return STNodeFactory.createSimpleNameReferenceNode(this.parseIdentifier(ParserRuleContext.IDENTIFIER));
    }

    private STNode parseDotLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DOT_LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.DOT_LT_TOKEN);
        return this.parseDotLTToken();
    }

    private STNode parseXMLNamePattern() {
        STNode separator;
        ArrayList<STNode> xmlAtomicNamePatternList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        if (this.isEndOfXMLNamePattern(nextToken.kind)) {
            return STNodeFactory.createNodeList(xmlAtomicNamePatternList);
        }
        STNode xmlAtomicNamePattern = this.parseXMLAtomicNamePattern();
        xmlAtomicNamePatternList.add(xmlAtomicNamePattern);
        while (!this.isEndOfXMLNamePattern(this.peek().kind) && (separator = this.parseXMLNamePatternSeparator()) != null) {
            xmlAtomicNamePatternList.add(separator);
            xmlAtomicNamePattern = this.parseXMLAtomicNamePattern();
            xmlAtomicNamePatternList.add(xmlAtomicNamePattern);
        }
        return STNodeFactory.createNodeList(xmlAtomicNamePatternList);
    }

    private boolean isEndOfXMLNamePattern(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.GT_TOKEN -> true;
            default -> false;
        };
    }

    private boolean isEndOfXMLStepExtend(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.DOT_LT_TOKEN -> false;
            case SyntaxKind.DOT_TOKEN -> {
                if (this.peek((int)3).kind != SyntaxKind.OPEN_PAREN_TOKEN) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private STNode parseXMLNamePatternSeparator() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.PIPE_TOKEN -> this.consume();
            case SyntaxKind.EOF_TOKEN, SyntaxKind.GT_TOKEN -> null;
            default -> {
                this.recover(token, ParserRuleContext.XML_NAME_PATTERN_RHS);
                yield this.parseXMLNamePatternSeparator();
            }
        };
    }

    private STNode parseXMLAtomicNamePattern() {
        this.startContext(ParserRuleContext.XML_ATOMIC_NAME_PATTERN);
        STNode atomicNamePattern = this.parseXMLAtomicNamePatternBody();
        this.endContext();
        return atomicNamePattern;
    }

    private STNode parseXMLAtomicNamePatternBody() {
        STToken identifier;
        STToken token = this.peek();
        switch (token.kind) {
            case ASTERISK_TOKEN: {
                return this.consume();
            }
            case IDENTIFIER_TOKEN: {
                identifier = this.consume();
                break;
            }
            default: {
                this.recover(token, ParserRuleContext.XML_ATOMIC_NAME_PATTERN_START);
                return this.parseXMLAtomicNamePatternBody();
            }
        }
        return this.parseXMLAtomicNameIdentifier(identifier);
    }

    private STNode parseXMLAtomicNameIdentifier(STNode identifier) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.COLON_TOKEN) {
            STToken colon = this.consume();
            STToken nextToken = this.peek();
            if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN || nextToken.kind == SyntaxKind.ASTERISK_TOKEN) {
                STToken endToken = this.consume();
                return STNodeFactory.createXMLAtomicNamePatternNode(identifier, colon, endToken);
            }
        }
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseXMLStepExpression(STNode lhsExpr) {
        STNode xmlStepStart = this.parseXMLStepStart();
        STNode xmlStepExtends = this.parseXMLStepExtends();
        return STNodeFactory.createXMLStepExpressionNode(lhsExpr, xmlStepStart, xmlStepExtends);
    }

    private STNode parseXMLStepStart() {
        STNode startToken;
        STToken token = this.peek();
        switch (token.kind) {
            case SLASH_ASTERISK_TOKEN: {
                return this.consume();
            }
            case DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN: {
                startToken = this.parseDoubleSlashDoubleAsteriskLTToken();
                break;
            }
            default: {
                startToken = this.parseSlashLTToken();
            }
        }
        return this.parseXMLNamePatternChain(startToken);
    }

    private STNode parseSlashLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.SLASH_LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.SLASH_LT_TOKEN);
        return this.parseSlashLTToken();
    }

    private STNode parseDoubleSlashDoubleAsteriskLTToken() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN);
        return this.parseDoubleSlashDoubleAsteriskLTToken();
    }

    private STNode parseMatchStatement() {
        this.startContext(ParserRuleContext.MATCH_STMT);
        STNode matchKeyword = this.parseMatchKeyword();
        STNode actionOrExpr = this.parseActionOrExpression();
        this.startContext(ParserRuleContext.MATCH_BODY);
        STNode openBrace = this.parseOpenBrace();
        ArrayList<STNode> matchClausesList = new ArrayList<STNode>();
        while (!this.isEndOfMatchClauses(this.peek().kind)) {
            STNode clause = this.parseMatchClause();
            matchClausesList.add(clause);
        }
        STNode matchClauses = STNodeFactory.createNodeList(matchClausesList);
        if (this.isNodeListEmpty(matchClauses)) {
            openBrace = SyntaxErrors.addDiagnostic(openBrace, DiagnosticErrorCode.ERROR_MATCH_STATEMENT_SHOULD_HAVE_ONE_OR_MORE_MATCH_CLAUSES, new Object[0]);
        }
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        this.endContext();
        STNode onFailClause = this.parseOptionalOnFailClause();
        return STNodeFactory.createMatchStatementNode(matchKeyword, actionOrExpr, openBrace, matchClauses, closeBrace, onFailClause);
    }

    private STNode parseMatchKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.MATCH_KEYWORD) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.MATCH_KEYWORD);
        return this.parseMatchKeyword();
    }

    private boolean isEndOfMatchClauses(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.TYPE_KEYWORD, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> this.isEndOfStatements();
        };
    }

    private STNode parseMatchClause() {
        STNode matchPatterns = this.parseMatchPatternList();
        STNode matchGuard = this.parseMatchGuard();
        STNode rightDoubleArrow = this.parseDoubleRightArrow();
        STNode blockStmt = this.parseBlockNode();
        if (this.isNodeListEmpty(matchPatterns)) {
            STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            STNode constantPattern = STNodeFactory.createSimpleNameReferenceNode(identifier);
            matchPatterns = STNodeFactory.createNodeList(constantPattern);
            DiagnosticErrorCode errorCode = DiagnosticErrorCode.ERROR_MISSING_MATCH_PATTERN;
            if (matchGuard != null) {
                matchGuard = SyntaxErrors.addDiagnostic(matchGuard, errorCode, new Object[0]);
            } else {
                rightDoubleArrow = SyntaxErrors.addDiagnostic(rightDoubleArrow, errorCode, new Object[0]);
            }
        }
        return STNodeFactory.createMatchClauseNode(matchPatterns, matchGuard, rightDoubleArrow, blockStmt);
    }

    private STNode parseMatchGuard() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IF_KEYWORD: {
                STNode ifKeyword = this.parseIfKeyword();
                STNode expr = this.parseExpression(DEFAULT_OP_PRECEDENCE, true, false, true, false);
                return STNodeFactory.createMatchGuardNode(ifKeyword, expr);
            }
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
        }
        this.recover(nextToken, ParserRuleContext.OPTIONAL_MATCH_GUARD);
        return this.parseMatchGuard();
    }

    private STNode parseMatchPatternList() {
        STNode clause;
        this.startContext(ParserRuleContext.MATCH_PATTERN);
        ArrayList<STNode> matchClauses = new ArrayList<STNode>();
        while (!this.isEndOfMatchPattern(this.peek().kind) && (clause = this.parseMatchPattern()) != null) {
            matchClauses.add(clause);
            STNode seperator = this.parseMatchPatternListMemberRhs();
            if (seperator == null) break;
            matchClauses.add(seperator);
        }
        this.endContext();
        return STNodeFactory.createNodeList(matchClauses);
    }

    private boolean isEndOfMatchPattern(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.PIPE_TOKEN, SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, SyntaxKind.IF_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseMatchPattern() {
        STToken nextToken = this.peek();
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            STNode typeRefOrConstExpr = this.parseQualifiedIdentifier(ParserRuleContext.MATCH_PATTERN);
            return this.parseErrorMatchPatternOrConsPattern(typeRefOrConstExpr);
        }
        return switch (nextToken.kind) {
            case SyntaxKind.OPEN_PAREN_TOKEN, SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN, SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.STRING_LITERAL_TOKEN, SyntaxKind.NULL_KEYWORD, SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD, SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN -> this.parseSimpleConstExpr();
            case SyntaxKind.VAR_KEYWORD -> this.parseVarTypedBindingPattern();
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseListMatchPattern();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseMappingMatchPattern();
            case SyntaxKind.ERROR_KEYWORD -> this.parseErrorMatchPattern();
            default -> {
                this.recover(nextToken, ParserRuleContext.MATCH_PATTERN_START);
                yield this.parseMatchPattern();
            }
        };
    }

    private STNode parseMatchPatternListMemberRhs() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.PIPE_TOKEN -> this.parsePipeToken();
            case SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, SyntaxKind.IF_KEYWORD -> null;
            default -> {
                this.recover(nextToken, ParserRuleContext.MATCH_PATTERN_LIST_MEMBER_RHS);
                yield this.parseMatchPatternListMemberRhs();
            }
        };
    }

    private STNode parseVarTypedBindingPattern() {
        STNode varKeyword = this.parseVarKeyword();
        STNode varTypeDesc = BallerinaParser.createBuiltinSimpleNameReference(varKeyword);
        STNode bindingPattern = this.parseBindingPattern();
        return STNodeFactory.createTypedBindingPatternNode(varTypeDesc, bindingPattern);
    }

    private STNode parseVarKeyword() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.VAR_KEYWORD) {
            return this.consume();
        }
        this.recover(nextToken, ParserRuleContext.VAR_KEYWORD);
        return this.parseVarKeyword();
    }

    private STNode parseListMatchPattern() {
        this.startContext(ParserRuleContext.LIST_MATCH_PATTERN);
        STNode openBracketToken = this.parseOpenBracket();
        ArrayList<STNode> matchPatternList = new ArrayList<STNode>();
        STNode listMatchPatternMemberRhs = null;
        boolean isEndOfFields = false;
        while (!this.isEndOfListMatchPattern()) {
            STNode listMatchPatternMember = this.parseListMatchPatternMember();
            matchPatternList.add(listMatchPatternMember);
            listMatchPatternMemberRhs = this.parseListMatchPatternMemberRhs();
            if (listMatchPatternMember.kind == SyntaxKind.REST_MATCH_PATTERN) {
                isEndOfFields = true;
                break;
            }
            if (listMatchPatternMemberRhs == null) break;
            matchPatternList.add(listMatchPatternMemberRhs);
        }
        while (isEndOfFields && listMatchPatternMemberRhs != null) {
            this.updateLastNodeInListWithInvalidNode(matchPatternList, listMatchPatternMemberRhs, null, new Object[0]);
            if (this.peek().kind == SyntaxKind.CLOSE_BRACKET_TOKEN) break;
            STNode invalidField = this.parseListMatchPatternMember();
            this.updateLastNodeInListWithInvalidNode(matchPatternList, invalidField, DiagnosticErrorCode.ERROR_MATCH_PATTERN_AFTER_REST_MATCH_PATTERN, new Object[0]);
            listMatchPatternMemberRhs = this.parseListMatchPatternMemberRhs();
        }
        STNode matchPatternListNode = STNodeFactory.createNodeList(matchPatternList);
        STNode closeBracketToken = this.parseCloseBracket();
        this.endContext();
        return STNodeFactory.createListMatchPatternNode(openBracketToken, matchPatternListNode, closeBracketToken);
    }

    public boolean isEndOfListMatchPattern() {
        return switch (this.peek().kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseListMatchPatternMember() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.ELLIPSIS_TOKEN -> this.parseRestMatchPattern();
            default -> this.parseMatchPattern();
        };
    }

    private STNode parseRestMatchPattern() {
        this.startContext(ParserRuleContext.REST_MATCH_PATTERN);
        STNode ellipsisToken = this.parseEllipsis();
        STNode varKeywordToken = this.parseVarKeyword();
        STNode variableName = this.parseVariableName();
        this.endContext();
        STSimpleNameReferenceNode simpleNameReferenceNode = (STSimpleNameReferenceNode)STNodeFactory.createSimpleNameReferenceNode(variableName);
        return STNodeFactory.createRestMatchPatternNode(ellipsisToken, varKeywordToken, simpleNameReferenceNode);
    }

    private STNode parseListMatchPatternMemberRhs() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.LIST_MATCH_PATTERN_MEMBER_RHS);
                yield this.parseListMatchPatternMemberRhs();
            }
        };
    }

    private STNode parseMappingMatchPattern() {
        this.startContext(ParserRuleContext.MAPPING_MATCH_PATTERN);
        STNode openBraceToken = this.parseOpenBrace();
        STNode fieldMatchPatterns = this.parseFieldMatchPatternList();
        STNode closeBraceToken = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createMappingMatchPatternNode(openBraceToken, fieldMatchPatterns, closeBraceToken);
    }

    private STNode parseFieldMatchPatternList() {
        ArrayList<STNode> fieldMatchPatterns = new ArrayList<STNode>();
        STNode fieldMatchPatternMember = this.parseFieldMatchPatternMember();
        if (fieldMatchPatternMember == null) {
            return STNodeFactory.createEmptyNodeList();
        }
        fieldMatchPatterns.add(fieldMatchPatternMember);
        if (fieldMatchPatternMember.kind == SyntaxKind.REST_MATCH_PATTERN) {
            this.invalidateExtraFieldMatchPatterns(fieldMatchPatterns);
            return STNodeFactory.createNodeList(fieldMatchPatterns);
        }
        return this.parseFieldMatchPatternList(fieldMatchPatterns);
    }

    private STNode parseFieldMatchPatternList(List<STNode> fieldMatchPatterns) {
        STNode fieldMatchPatternRhs;
        while (!this.isEndOfMappingMatchPattern() && (fieldMatchPatternRhs = this.parseFieldMatchPatternRhs()) != null) {
            fieldMatchPatterns.add(fieldMatchPatternRhs);
            STNode fieldMatchPatternMember = this.parseFieldMatchPatternMember();
            if (fieldMatchPatternMember == null) {
                fieldMatchPatternMember = this.createMissingFieldMatchPattern();
            }
            fieldMatchPatterns.add(fieldMatchPatternMember);
            if (fieldMatchPatternMember.kind != SyntaxKind.REST_MATCH_PATTERN) continue;
            this.invalidateExtraFieldMatchPatterns(fieldMatchPatterns);
            break;
        }
        return STNodeFactory.createNodeList(fieldMatchPatterns);
    }

    private STNode createMissingFieldMatchPattern() {
        STToken fieldName = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
        STToken colon = SyntaxErrors.createMissingToken(SyntaxKind.COLON_TOKEN);
        STToken identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
        STNode matchPattern = STNodeFactory.createSimpleNameReferenceNode(identifier);
        STNode fieldMatchPatternMember = STNodeFactory.createFieldMatchPatternNode(fieldName, colon, matchPattern);
        fieldMatchPatternMember = SyntaxErrors.addDiagnostic(fieldMatchPatternMember, DiagnosticErrorCode.ERROR_MISSING_FIELD_MATCH_PATTERN_MEMBER, new Object[0]);
        return fieldMatchPatternMember;
    }

    private void invalidateExtraFieldMatchPatterns(List<STNode> fieldMatchPatterns) {
        STNode fieldMatchPatternRhs;
        while (!this.isEndOfMappingMatchPattern() && (fieldMatchPatternRhs = this.parseFieldMatchPatternRhs()) != null) {
            STNode fieldMatchPatternMember = this.parseFieldMatchPatternMember();
            if (fieldMatchPatternMember == null) {
                this.updateLastNodeInListWithInvalidNode(fieldMatchPatterns, fieldMatchPatternRhs, DiagnosticErrorCode.ERROR_INVALID_TOKEN, ((STToken)fieldMatchPatternRhs).text());
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(fieldMatchPatterns, fieldMatchPatternRhs, null, new Object[0]);
            this.updateLastNodeInListWithInvalidNode(fieldMatchPatterns, fieldMatchPatternMember, DiagnosticErrorCode.ERROR_MATCH_PATTERN_AFTER_REST_MATCH_PATTERN, new Object[0]);
        }
    }

    private STNode parseFieldMatchPatternMember() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.IDENTIFIER_TOKEN -> this.parseFieldMatchPattern();
            case SyntaxKind.ELLIPSIS_TOKEN -> this.parseRestMatchPattern();
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(nextToken, ParserRuleContext.FIELD_MATCH_PATTERNS_START);
                yield this.parseFieldMatchPatternMember();
            }
        };
    }

    public STNode parseFieldMatchPattern() {
        STNode fieldNameNode = this.parseVariableName();
        STNode colonToken = this.parseColon();
        STNode matchPattern = this.parseMatchPattern();
        return STNodeFactory.createFieldMatchPatternNode(fieldNameNode, colonToken, matchPattern);
    }

    public boolean isEndOfMappingMatchPattern() {
        return switch (this.peek().kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseFieldMatchPatternRhs() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.FIELD_MATCH_PATTERN_MEMBER_RHS);
                yield this.parseFieldMatchPatternRhs();
            }
        };
    }

    private STNode parseErrorMatchPatternOrConsPattern(STNode typeRefOrConstExpr) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                STToken errorKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ERROR_KEYWORD, ParserRuleContext.ERROR_KEYWORD);
                this.startContext(ParserRuleContext.ERROR_MATCH_PATTERN);
                return this.parseErrorMatchPattern(errorKeyword, typeRefOrConstExpr);
            }
        }
        if (this.isMatchPatternEnd(this.peek().kind)) {
            return typeRefOrConstExpr;
        }
        this.recover(this.peek(), ParserRuleContext.ERROR_MATCH_PATTERN_OR_CONST_PATTERN);
        return this.parseErrorMatchPatternOrConsPattern(typeRefOrConstExpr);
    }

    private boolean isMatchPatternEnd(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.PIPE_TOKEN, SyntaxKind.COMMA_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN, SyntaxKind.IF_KEYWORD -> true;
            default -> false;
        };
    }

    private STNode parseErrorMatchPattern() {
        this.startContext(ParserRuleContext.ERROR_MATCH_PATTERN);
        STToken errorKeyword = this.consume();
        return this.parseErrorMatchPattern(errorKeyword);
    }

    private STNode parseErrorMatchPattern(STNode errorKeyword) {
        STNode typeRef;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                typeRef = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                if (this.isPredeclaredIdentifier(nextToken.kind)) {
                    typeRef = this.parseTypeReference();
                    break;
                }
                this.recover(this.peek(), ParserRuleContext.ERROR_MATCH_PATTERN_ERROR_KEYWORD_RHS);
                return this.parseErrorMatchPattern(errorKeyword);
            }
        }
        return this.parseErrorMatchPattern(errorKeyword, typeRef);
    }

    private STNode parseErrorMatchPattern(STNode errorKeyword, STNode typeRef) {
        STNode openParenthesisToken = this.parseOpenParenthesis();
        STNode argListMatchPatternNode = this.parseErrorArgListMatchPatterns();
        STNode closeParenthesisToken = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createErrorMatchPatternNode(errorKeyword, typeRef, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken);
    }

    private STNode parseErrorArgListMatchPatterns() {
        ArrayList<STNode> argListMatchPatterns = new ArrayList<STNode>();
        if (this.isEndOfErrorFieldMatchPatterns()) {
            return STNodeFactory.createNodeList(argListMatchPatterns);
        }
        this.startContext(ParserRuleContext.ERROR_ARG_LIST_MATCH_PATTERN_FIRST_ARG);
        STNode firstArg = this.parseErrorArgListMatchPattern(ParserRuleContext.ERROR_ARG_LIST_MATCH_PATTERN_START);
        this.endContext();
        if (this.isSimpleMatchPattern(firstArg.kind)) {
            argListMatchPatterns.add(firstArg);
            STNode argEnd = this.parseErrorArgListMatchPatternEnd(ParserRuleContext.ERROR_MESSAGE_MATCH_PATTERN_END);
            if (argEnd != null) {
                STNode secondArg = this.parseErrorArgListMatchPattern(ParserRuleContext.ERROR_MESSAGE_MATCH_PATTERN_RHS);
                if (this.isValidSecondArgMatchPattern(secondArg.kind)) {
                    argListMatchPatterns.add(argEnd);
                    argListMatchPatterns.add(secondArg);
                } else {
                    this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, argEnd, null, new Object[0]);
                    this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, secondArg, DiagnosticErrorCode.ERROR_MATCH_PATTERN_NOT_ALLOWED, new Object[0]);
                }
            }
        } else if (firstArg.kind != SyntaxKind.NAMED_ARG_MATCH_PATTERN && firstArg.kind != SyntaxKind.REST_MATCH_PATTERN) {
            this.addInvalidNodeToNextToken(firstArg, DiagnosticErrorCode.ERROR_MATCH_PATTERN_NOT_ALLOWED, new Object[0]);
        } else {
            argListMatchPatterns.add(firstArg);
        }
        this.parseErrorFieldMatchPatterns(argListMatchPatterns);
        return STNodeFactory.createNodeList(argListMatchPatterns);
    }

    private boolean isSimpleMatchPattern(SyntaxKind matchPatternKind) {
        return switch (matchPatternKind) {
            case SyntaxKind.IDENTIFIER_TOKEN, SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.STRING_LITERAL, SyntaxKind.NIL_LITERAL, SyntaxKind.NULL_LITERAL, SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.TYPED_BINDING_PATTERN, SyntaxKind.UNARY_EXPRESSION -> true;
            default -> false;
        };
    }

    private boolean isValidSecondArgMatchPattern(SyntaxKind syntaxKind) {
        return switch (syntaxKind) {
            case SyntaxKind.ERROR_MATCH_PATTERN, SyntaxKind.NAMED_ARG_MATCH_PATTERN, SyntaxKind.REST_MATCH_PATTERN -> true;
            default -> this.isSimpleMatchPattern(syntaxKind);
        };
    }

    private void parseErrorFieldMatchPatterns(List<STNode> argListMatchPatterns) {
        STNode argEnd;
        SyntaxKind lastValidArgKind = SyntaxKind.NAMED_ARG_MATCH_PATTERN;
        while (!this.isEndOfErrorFieldMatchPatterns() && (argEnd = this.parseErrorArgListMatchPatternEnd(ParserRuleContext.ERROR_FIELD_MATCH_PATTERN_RHS)) != null) {
            STNode currentArg = this.parseErrorArgListMatchPattern(ParserRuleContext.ERROR_FIELD_MATCH_PATTERN);
            DiagnosticErrorCode errorCode = this.validateErrorFieldMatchPatternOrder(lastValidArgKind, currentArg.kind);
            if (errorCode == null) {
                argListMatchPatterns.add(argEnd);
                argListMatchPatterns.add(currentArg);
                lastValidArgKind = currentArg.kind;
                continue;
            }
            if (argListMatchPatterns.isEmpty()) {
                this.addInvalidNodeToNextToken(argEnd, null, new Object[0]);
                this.addInvalidNodeToNextToken(currentArg, errorCode, new Object[0]);
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, argEnd, null, new Object[0]);
            this.updateLastNodeInListWithInvalidNode(argListMatchPatterns, currentArg, errorCode, new Object[0]);
        }
    }

    private boolean isEndOfErrorFieldMatchPatterns() {
        return this.isEndOfErrorFieldBindingPatterns();
    }

    private STNode parseErrorArgListMatchPatternEnd(ParserRuleContext currentCtx) {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_PAREN_TOKEN -> null;
            default -> {
                this.recover(this.peek(), currentCtx);
                yield this.parseErrorArgListMatchPatternEnd(currentCtx);
            }
        };
    }

    private STNode parseErrorArgListMatchPattern(ParserRuleContext context) {
        STToken nextToken = this.peek();
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            return this.parseNamedArgOrSimpleMatchPattern();
        }
        switch (nextToken.kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestMatchPattern();
            }
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: 
            case OPEN_PAREN_TOKEN: 
            case PLUS_TOKEN: 
            case MINUS_TOKEN: 
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                return this.parseMatchPattern();
            }
            case VAR_KEYWORD: {
                STNode varType = BallerinaParser.createBuiltinSimpleNameReference(this.consume());
                STNode variableName = this.createCaptureOrWildcardBP(this.parseVariableName());
                return STNodeFactory.createTypedBindingPatternNode(varType, variableName);
            }
            case CLOSE_PAREN_TOKEN: {
                return SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_MATCH_PATTERN);
            }
        }
        this.recover(nextToken, context);
        return this.parseErrorArgListMatchPattern(context);
    }

    private STNode parseNamedArgOrSimpleMatchPattern() {
        STNode constRefExpr = this.parseQualifiedIdentifier(ParserRuleContext.MATCH_PATTERN);
        if (constRefExpr.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE || this.peek().kind != SyntaxKind.EQUAL_TOKEN) {
            return constRefExpr;
        }
        return this.parseNamedArgMatchPattern(((STSimpleNameReferenceNode)constRefExpr).name);
    }

    private STNode parseNamedArgMatchPattern(STNode identifier) {
        this.startContext(ParserRuleContext.NAMED_ARG_MATCH_PATTERN);
        STNode equalToken = this.parseAssignOp();
        STNode matchPattern = this.parseMatchPattern();
        this.endContext();
        return STNodeFactory.createNamedArgMatchPatternNode(identifier, equalToken, matchPattern);
    }

    private DiagnosticErrorCode validateErrorFieldMatchPatternOrder(SyntaxKind prevArgKind, SyntaxKind currentArgKind) {
        return switch (currentArgKind) {
            case SyntaxKind.NAMED_ARG_MATCH_PATTERN, SyntaxKind.REST_MATCH_PATTERN -> {
                if (prevArgKind == SyntaxKind.REST_MATCH_PATTERN) {
                    yield DiagnosticErrorCode.ERROR_REST_ARG_FOLLOWED_BY_ANOTHER_ARG;
                }
                yield null;
            }
            default -> DiagnosticErrorCode.ERROR_MATCH_PATTERN_NOT_ALLOWED;
        };
    }

    private STNode parseMarkdownDocumentation() {
        ArrayList<STNode> markdownDocLineList = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (nextToken.kind == SyntaxKind.DOCUMENTATION_STRING) {
            STToken documentationString = this.consume();
            STNode parsedDocLines = this.parseDocumentationString(documentationString);
            this.appendParsedDocumentationLines(markdownDocLineList, parsedDocLines);
            nextToken = this.peek();
        }
        STNode markdownDocLines = STNodeFactory.createNodeList(markdownDocLineList);
        return STNodeFactory.createMarkdownDocumentationNode(markdownDocLines);
    }

    private STNode parseDocumentationString(STToken documentationStringToken) {
        List<STNode> leadingTriviaList = this.getLeadingTriviaList(documentationStringToken.leadingMinutiae());
        ArrayList<STNodeDiagnostic> diagnostics = new ArrayList<STNodeDiagnostic>(documentationStringToken.diagnostics());
        CharReader charReader = CharReader.from(documentationStringToken.text());
        DocumentationLexer documentationLexer = new DocumentationLexer(charReader, leadingTriviaList, diagnostics);
        TokenReader tokenReader = new TokenReader(documentationLexer);
        DocumentationParser documentationParser = new DocumentationParser(tokenReader);
        return documentationParser.parse();
    }

    private List<STNode> getLeadingTriviaList(STNode leadingMinutiaeNode) {
        ArrayList<STNode> leadingTriviaList = new ArrayList<STNode>();
        int bucketCount = leadingMinutiaeNode.bucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            leadingTriviaList.add(leadingMinutiaeNode.childInBucket(i));
        }
        return leadingTriviaList;
    }

    private void appendParsedDocumentationLines(List<STNode> markdownDocLineList, STNode parsedDocLines) {
        int bucketCount = parsedDocLines.bucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            STNode markdownDocLine = parsedDocLines.childInBucket(i);
            markdownDocLineList.add(markdownDocLine);
        }
    }

    private STNode parseStmtStartsWithTypeOrExpr(STNode annots, List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode typeOrExpr = this.parseTypedBindingPatternOrExpr(qualifiers, true);
        return this.parseStmtStartsWithTypedBPOrExprRhs(annots, typeOrExpr);
    }

    private STNode parseStmtStartsWithTypedBPOrExprRhs(STNode annots, STNode typedBindingPatternOrExpr) {
        if (typedBindingPatternOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
            ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBindingPatternOrExpr, false);
        }
        STNode expr = this.getExpression(typedBindingPatternOrExpr);
        expr = this.getExpression(this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true));
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseTypedBindingPatternOrExpr(boolean allowAssignment) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypedBindingPatternOrExpr(typeDescQualifiers, allowAssignment);
    }

    private STNode parseTypedBindingPatternOrExpr(List<STNode> qualifiers, boolean allowAssignment) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        if (this.isPredeclaredIdentifier(nextToken.kind)) {
            this.reportInvalidQualifierList(qualifiers);
            STNode typeOrExpr = this.parseQualifiedIdentifier(ParserRuleContext.TYPE_NAME_OR_VAR_NAME);
            return this.parseTypedBindingPatternOrExprRhs(typeOrExpr, allowAssignment);
        }
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseTypedBPOrExprStartsWithOpenParenthesis();
            }
            case FUNCTION_KEYWORD: {
                return this.parseAnonFuncExprOrTypedBPWithFuncType(qualifiers);
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode typeOrExpr = this.parseTupleTypeDescOrListConstructor(STNodeFactory.createEmptyNodeList());
                return this.parseTypedBindingPatternOrExprRhs(typeOrExpr, allowAssignment);
            }
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode basicLiteral = this.parseBasicLiteral();
                return this.parseTypedBindingPatternOrExprRhs(basicLiteral, allowAssignment);
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseActionOrExpressionInLhs(STNodeFactory.createEmptyNodeList());
        }
        return this.parseTypedBindingPattern(qualifiers, ParserRuleContext.VAR_DECL_STMT);
    }

    private STNode parseTypedBindingPatternOrExprRhs(STNode typeOrExpr, boolean allowAssignment) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: {
                STToken nextNextToken = this.peek(2);
                if (nextNextToken.kind == SyntaxKind.EQUAL_TOKEN) {
                    return typeOrExpr;
                }
                STNode pipeOrAndToken = this.parseBinaryOperator();
                STNode rhsTypedBPOrExpr = this.parseTypedBindingPatternOrExpr(allowAssignment);
                if (rhsTypedBPOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
                    STTypedBindingPatternNode typedBP = (STTypedBindingPatternNode)rhsTypedBPOrExpr;
                    typeOrExpr = this.getTypeDescFromExpr(typeOrExpr);
                    STNode newTypeDesc = this.mergeTypes(typeOrExpr, pipeOrAndToken, typedBP.typeDescriptor);
                    return STNodeFactory.createTypedBindingPatternNode(newTypeDesc, typedBP.bindingPattern);
                }
                if (this.peek().kind == SyntaxKind.EQUAL_TOKEN) {
                    return this.createCaptureBPWithMissingVarName(typeOrExpr, pipeOrAndToken, rhsTypedBPOrExpr);
                }
                return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, typeOrExpr, pipeOrAndToken, rhsTypedBPOrExpr);
            }
            case SEMICOLON_TOKEN: {
                if (this.isExpression(typeOrExpr.kind)) {
                    return typeOrExpr;
                }
                if (this.isDefiniteTypeDesc(typeOrExpr.kind) || !this.isAllBasicLiterals(typeOrExpr)) {
                    STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                    return this.parseTypeBindingPatternStartsWithAmbiguousNode(typeDesc);
                }
                return typeOrExpr;
            }
            case IDENTIFIER_TOKEN: 
            case QUESTION_MARK_TOKEN: {
                if (this.isAmbiguous(typeOrExpr) || this.isDefiniteTypeDesc(typeOrExpr.kind)) {
                    STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                    return this.parseTypeBindingPatternStartsWithAmbiguousNode(typeDesc);
                }
                return typeOrExpr;
            }
            case EQUAL_TOKEN: {
                return typeOrExpr;
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseTypedBindingPatternOrMemberAccess(typeOrExpr, false, allowAssignment, ParserRuleContext.AMBIGUOUS_STMT);
            }
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                return this.parseTypeBindingPatternStartsWithAmbiguousNode(typeDesc);
            }
        }
        if (this.isCompoundAssignment(nextToken.kind)) {
            return typeOrExpr;
        }
        if (this.isValidExprRhsStart(nextToken.kind, typeOrExpr.kind)) {
            return typeOrExpr;
        }
        STToken token = this.peek();
        SyntaxKind typeOrExprKind = typeOrExpr.kind;
        if (typeOrExprKind == SyntaxKind.QUALIFIED_NAME_REFERENCE || typeOrExprKind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            this.recover(token, ParserRuleContext.BINDING_PATTERN_OR_VAR_REF_RHS);
        } else {
            this.recover(token, ParserRuleContext.BINDING_PATTERN_OR_EXPR_RHS);
        }
        return this.parseTypedBindingPatternOrExprRhs(typeOrExpr, allowAssignment);
    }

    private STNode createCaptureBPWithMissingVarName(STNode lhsType, STNode separatorToken, STNode rhsType) {
        lhsType = this.getTypeDescFromExpr(lhsType);
        rhsType = this.getTypeDescFromExpr(rhsType);
        STNode newTypeDesc = this.mergeTypes(lhsType, separatorToken, rhsType);
        STToken identifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, ParserRuleContext.VARIABLE_NAME);
        STNode captureBP = STNodeFactory.createCaptureBindingPatternNode(identifier);
        return STNodeFactory.createTypedBindingPatternNode(newTypeDesc, captureBP);
    }

    private STNode parseTypeBindingPatternStartsWithAmbiguousNode(STNode typeDesc) {
        typeDesc = this.parseComplexTypeDescriptor(typeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        return this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
    }

    private STNode parseTypedBPOrExprStartsWithOpenParenthesis() {
        STNode exprOrTypeDesc = this.parseTypedDescOrExprStartsWithOpenParenthesis();
        if (this.isDefiniteTypeDesc(exprOrTypeDesc.kind)) {
            return this.parseTypeBindingPatternStartsWithAmbiguousNode(exprOrTypeDesc);
        }
        return this.parseTypedBindingPatternOrExprRhs(exprOrTypeDesc, false);
    }

    private boolean isDefiniteTypeDesc(SyntaxKind kind) {
        return kind.compareTo(SyntaxKind.RECORD_TYPE_DESC) >= 0 && kind.compareTo(SyntaxKind.FUTURE_TYPE_DESC) <= 0;
    }

    private boolean isDefiniteExpr(SyntaxKind kind) {
        if (kind == SyntaxKind.QUALIFIED_NAME_REFERENCE || kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return false;
        }
        return kind.compareTo(SyntaxKind.BINARY_EXPRESSION) >= 0 && kind.compareTo(SyntaxKind.ERROR_CONSTRUCTOR) <= 0;
    }

    private boolean isDefiniteAction(SyntaxKind kind) {
        return kind.compareTo(SyntaxKind.REMOTE_METHOD_CALL_ACTION) >= 0 && kind.compareTo(SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION) <= 0;
    }

    private STNode parseTypedDescOrExprStartsWithOpenParenthesis() {
        STNode openParen = this.parseOpenParenthesis();
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            STNode closeParen = this.parseCloseParenthesis();
            return this.parseTypeOrExprStartWithEmptyParenthesis(openParen, closeParen);
        }
        STNode typeOrExpr = this.parseTypeDescOrExpr();
        if (this.isAction(typeOrExpr)) {
            STNode closeParen = this.parseCloseParenthesis();
            return STNodeFactory.createBracedExpressionNode(SyntaxKind.BRACED_ACTION, openParen, typeOrExpr, closeParen);
        }
        if (this.isExpression(typeOrExpr.kind)) {
            this.startContext(ParserRuleContext.BRACED_EXPR_OR_ANON_FUNC_PARAMS);
            return this.parseBracedExprOrAnonFuncParamRhs(openParen, typeOrExpr, false);
        }
        STNode typeDescNode = this.getTypeDescFromExpr(typeOrExpr);
        typeDescNode = this.parseComplexTypeDescriptor(typeDescNode, ParserRuleContext.TYPE_DESC_IN_PARENTHESIS, false);
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createParenthesisedTypeDescriptorNode(openParen, typeDescNode, closeParen);
    }

    private STNode parseTypeDescOrExpr() {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypeDescOrExpr(typeDescQualifiers);
    }

    private STNode parseTypeDescOrExpr(List<STNode> qualifiers) {
        STNode typeOrExpr;
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                typeOrExpr = this.parseTypedDescOrExprStartsWithOpenParenthesis();
                break;
            }
            case FUNCTION_KEYWORD: {
                typeOrExpr = this.parseAnonFuncExprOrFuncTypeDesc(qualifiers);
                break;
            }
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode typeOrExpr2 = this.parseQualifiedIdentifier(ParserRuleContext.TYPE_NAME_OR_VAR_NAME);
                return this.parseTypeDescOrExprRhs(typeOrExpr2);
            }
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                typeOrExpr = this.parseTupleTypeDescOrListConstructor(STNodeFactory.createEmptyNodeList());
                break;
            }
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: 
            case NULL_KEYWORD: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: 
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode basicLiteral = this.parseBasicLiteral();
                return this.parseTypeDescOrExprRhs(basicLiteral);
            }
            default: {
                if (this.isValidExpressionStart(nextToken.kind, 1)) {
                    this.reportInvalidQualifierList(qualifiers);
                    return this.parseActionOrExpressionInLhs(STNodeFactory.createEmptyNodeList());
                }
                return this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
            }
        }
        if (this.isDefiniteTypeDesc(typeOrExpr.kind)) {
            return this.parseComplexTypeDescriptor(typeOrExpr, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        }
        return this.parseTypeDescOrExprRhs(typeOrExpr);
    }

    private boolean isExpression(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.STRING_LITERAL_TOKEN, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.NIL_LITERAL, SyntaxKind.NULL_LITERAL, SyntaxKind.BOOLEAN_LITERAL -> true;
            default -> kind.compareTo(SyntaxKind.BINARY_EXPRESSION) >= 0 && kind.compareTo(SyntaxKind.ERROR_CONSTRUCTOR) <= 0;
        };
    }

    private STNode parseTypeOrExprStartWithEmptyParenthesis(STNode openParen, STNode closeParen) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                STNode params = STNodeFactory.createEmptyNodeList();
                STNode anonFuncParam = STNodeFactory.createImplicitAnonymousFunctionParameters(openParen, params, closeParen);
                return this.parseImplicitAnonFunc(anonFuncParam, false);
            }
        }
        return STNodeFactory.createNilLiteralNode(openParen, closeParen);
    }

    private STNode parseAnonFuncExprOrTypedBPWithFuncType(List<STNode> qualifiers) {
        STNode exprOrTypeDesc = this.parseAnonFuncExprOrFuncTypeDesc(qualifiers);
        if (this.isAction(exprOrTypeDesc) || this.isExpression(exprOrTypeDesc.kind)) {
            return exprOrTypeDesc;
        }
        return this.parseTypedBindingPatternTypeRhs(exprOrTypeDesc, ParserRuleContext.VAR_DECL_STMT);
    }

    private STNode parseAnonFuncExprOrFuncTypeDesc(List<STNode> qualifiers) {
        this.startContext(ParserRuleContext.FUNC_TYPE_DESC_OR_ANON_FUNC);
        STNode functionKeyword = this.parseFunctionKeyword();
        if (this.peek().kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            STNode funcSignature = this.parseFuncSignature(true);
            STNode[] nodes = this.createFuncTypeQualNodeList(qualifiers, functionKeyword, true);
            STNode qualifierList = nodes[0];
            functionKeyword = nodes[1];
            this.endContext();
            return this.parseAnonFuncExprOrFuncTypeDesc(qualifierList, functionKeyword, funcSignature);
        }
        STNode funcSignature = STNodeFactory.createEmptyNode();
        STNode[] nodes = this.createFuncTypeQualNodeList(qualifiers, functionKeyword, false);
        STNode qualifierList = nodes[0];
        functionKeyword = nodes[1];
        STNode funcTypeDesc = STNodeFactory.createFunctionTypeDescriptorNode(qualifierList, functionKeyword, funcSignature);
        if (this.getCurrentContext() != ParserRuleContext.STMT_START_BRACKETED_LIST) {
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseComplexTypeDescriptor(funcTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        }
        return this.parseComplexTypeDescriptor(funcTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
    }

    private STNode parseAnonFuncExprOrFuncTypeDesc(STNode qualifierList, STNode functionKeyword, STNode funcSignature) {
        ParserRuleContext currentCtx = this.getCurrentContext();
        switch (this.peek().kind) {
            case OPEN_BRACE_TOKEN: 
            case RIGHT_DOUBLE_ARROW_TOKEN: {
                if (currentCtx != ParserRuleContext.STMT_START_BRACKETED_LIST) {
                    this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                }
                this.startContext(ParserRuleContext.ANON_FUNC_EXPRESSION);
                funcSignature = this.validateAndGetFuncParams((STFunctionSignatureNode)funcSignature);
                STNode funcBody = this.parseAnonFuncBody(false);
                STNode annots = STNodeFactory.createEmptyNodeList();
                STNode anonFunc = STNodeFactory.createExplicitAnonymousFunctionExpressionNode(annots, qualifierList, functionKeyword, funcSignature, funcBody);
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, anonFunc, false, true);
            }
        }
        STNode funcTypeDesc = STNodeFactory.createFunctionTypeDescriptorNode(qualifierList, functionKeyword, funcSignature);
        if (currentCtx != ParserRuleContext.STMT_START_BRACKETED_LIST) {
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseComplexTypeDescriptor(funcTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        }
        return this.parseComplexTypeDescriptor(funcTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
    }

    private STNode parseTypeDescOrExprRhs(STNode typeOrExpr) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: {
                STToken nextNextToken = this.peek(2);
                if (nextNextToken.kind == SyntaxKind.EQUAL_TOKEN) {
                    return typeOrExpr;
                }
                STNode pipeOrAndToken = this.parseBinaryOperator();
                STNode rhsTypeDescOrExpr = this.parseTypeDescOrExpr();
                if (this.isExpression(rhsTypeDescOrExpr.kind)) {
                    return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, typeOrExpr, pipeOrAndToken, rhsTypeDescOrExpr);
                }
                STNode typeDesc = this.getTypeDescFromExpr(typeOrExpr);
                rhsTypeDescOrExpr = this.getTypeDescFromExpr(rhsTypeDescOrExpr);
                return this.mergeTypes(typeDesc, pipeOrAndToken, rhsTypeDescOrExpr);
            }
            case IDENTIFIER_TOKEN: 
            case QUESTION_MARK_TOKEN: {
                STNode typeDesc = this.parseComplexTypeDescriptor(this.getTypeDescFromExpr(typeOrExpr), ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, false);
                return typeDesc;
            }
            case SEMICOLON_TOKEN: {
                return this.getTypeDescFromExpr(typeOrExpr);
            }
            case EOF_TOKEN: 
            case EQUAL_TOKEN: 
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                return typeOrExpr;
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseTypedBindingPatternOrMemberAccess(typeOrExpr, false, true, ParserRuleContext.AMBIGUOUS_STMT);
            }
            case ELLIPSIS_TOKEN: {
                STNode ellipsis = this.parseEllipsis();
                typeOrExpr = this.getTypeDescFromExpr(typeOrExpr);
                return STNodeFactory.createRestDescriptorNode(typeOrExpr, ellipsis);
            }
        }
        if (this.isCompoundAssignment(nextToken.kind)) {
            return typeOrExpr;
        }
        if (this.isValidExprRhsStart(nextToken.kind, typeOrExpr.kind)) {
            return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, typeOrExpr, false, false, false, false);
        }
        this.recover(this.peek(), ParserRuleContext.TYPE_DESC_OR_EXPR_RHS);
        return this.parseTypeDescOrExprRhs(typeOrExpr);
    }

    private boolean isAmbiguous(STNode node) {
        switch (node.kind) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NIL_LITERAL: 
            case NULL_LITERAL: 
            case BOOLEAN_LITERAL: 
            case BRACKETED_LIST: {
                return true;
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)node;
                if (binaryExpr.operator.kind != SyntaxKind.PIPE_TOKEN) {
                    return false;
                }
                return this.isAmbiguous(binaryExpr.lhsExpr) && this.isAmbiguous(binaryExpr.rhsExpr);
            }
            case BRACED_EXPRESSION: {
                return this.isAmbiguous(((STBracedExpressionNode)node).expression);
            }
            case INDEXED_EXPRESSION: {
                STIndexedExpressionNode indexExpr = (STIndexedExpressionNode)node;
                if (!this.isAmbiguous(indexExpr.containerExpression)) {
                    return false;
                }
                STNode keys = indexExpr.keyExpression;
                for (int i = 0; i < keys.bucketCount(); ++i) {
                    STNode item = keys.childInBucket(i);
                    if (item.kind == SyntaxKind.COMMA_TOKEN || this.isAmbiguous(item)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isAllBasicLiterals(STNode node) {
        switch (node.kind) {
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NIL_LITERAL: 
            case NULL_LITERAL: 
            case BOOLEAN_LITERAL: {
                return true;
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)node;
                if (binaryExpr.operator.kind != SyntaxKind.PIPE_TOKEN) {
                    return false;
                }
                return this.isAmbiguous(binaryExpr.lhsExpr) && this.isAmbiguous(binaryExpr.rhsExpr);
            }
            case BRACED_EXPRESSION: {
                return this.isAmbiguous(((STBracedExpressionNode)node).expression);
            }
            case BRACKETED_LIST: {
                STAmbiguousCollectionNode list = (STAmbiguousCollectionNode)node;
                for (STNode member : list.members) {
                    if (member.kind == SyntaxKind.COMMA_TOKEN || this.isAllBasicLiterals(member)) continue;
                    return false;
                }
                return true;
            }
            case UNARY_EXPRESSION: {
                STUnaryExpressionNode unaryExpr = (STUnaryExpressionNode)node;
                if (unaryExpr.unaryOperator.kind != SyntaxKind.PLUS_TOKEN && unaryExpr.unaryOperator.kind != SyntaxKind.MINUS_TOKEN) {
                    return false;
                }
                return this.isNumericLiteral(unaryExpr.expression);
            }
        }
        return false;
    }

    private boolean isNumericLiteral(STNode node) {
        return switch (node.kind) {
            case SyntaxKind.NUMERIC_LITERAL -> true;
            default -> false;
        };
    }

    private STNode parseBindingPattern() {
        return switch (this.peek().kind) {
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseListBindingPattern();
            case SyntaxKind.IDENTIFIER_TOKEN -> this.parseBindingPatternStartsWithIdentifier();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseMappingBindingPattern();
            case SyntaxKind.ERROR_KEYWORD -> this.parseErrorBindingPattern();
            default -> {
                this.recover(this.peek(), ParserRuleContext.BINDING_PATTERN);
                yield this.parseBindingPattern();
            }
        };
    }

    private STNode parseBindingPatternStartsWithIdentifier() {
        STNode argNameOrBindingPattern = this.parseQualifiedIdentifier(ParserRuleContext.BINDING_PATTERN_STARTING_IDENTIFIER);
        STToken secondToken = this.peek();
        if (secondToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            this.startContext(ParserRuleContext.ERROR_BINDING_PATTERN);
            STToken errorKeyword = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.ERROR_KEYWORD, ParserRuleContext.ERROR_KEYWORD);
            return this.parseErrorBindingPattern(errorKeyword, argNameOrBindingPattern);
        }
        if (argNameOrBindingPattern.kind != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            STNode identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
            identifier = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(identifier, argNameOrBindingPattern, (DiagnosticCode)DiagnosticErrorCode.ERROR_FIELD_BP_INSIDE_LIST_BP, new Object[0]);
            return STNodeFactory.createCaptureBindingPatternNode(identifier);
        }
        return this.createCaptureOrWildcardBP(((STSimpleNameReferenceNode)argNameOrBindingPattern).name);
    }

    private STNode createCaptureOrWildcardBP(STNode varName) {
        STNode bindingPattern = this.isWildcardBP(varName) ? this.getWildcardBindingPattern(varName) : STNodeFactory.createCaptureBindingPatternNode(varName);
        return bindingPattern;
    }

    private STNode parseListBindingPattern() {
        this.startContext(ParserRuleContext.LIST_BINDING_PATTERN);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> bindingPatternsList = new ArrayList<STNode>();
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, bindingPatternsList);
        this.endContext();
        return listBindingPattern;
    }

    private STNode parseListBindingPattern(STNode openBracket, List<STNode> bindingPatternsList) {
        if (this.isEndOfListBindingPattern(this.peek().kind) && bindingPatternsList.isEmpty()) {
            STNode closeBracket = this.parseCloseBracket();
            STNode bindingPatternsNode = STNodeFactory.createNodeList(bindingPatternsList);
            return STNodeFactory.createListBindingPatternNode(openBracket, bindingPatternsNode, closeBracket);
        }
        STNode listBindingPatternMember = this.parseListBindingPatternMember();
        bindingPatternsList.add(listBindingPatternMember);
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, listBindingPatternMember, bindingPatternsList);
        return listBindingPattern;
    }

    private STNode parseListBindingPattern(STNode openBracket, STNode firstMember, List<STNode> bindingPatterns) {
        STNode member = firstMember;
        STToken token = this.peek();
        STNode listBindingPatternRhs = null;
        while (!this.isEndOfListBindingPattern(token.kind) && member.kind != SyntaxKind.REST_BINDING_PATTERN && (listBindingPatternRhs = this.parseListBindingPatternMemberRhs()) != null) {
            bindingPatterns.add(listBindingPatternRhs);
            member = this.parseListBindingPatternMember();
            bindingPatterns.add(member);
            token = this.peek();
        }
        STNode closeBracket = this.parseCloseBracket();
        STNode bindingPatternsNode = STNodeFactory.createNodeList(bindingPatterns);
        return STNodeFactory.createListBindingPatternNode(openBracket, bindingPatternsNode, closeBracket);
    }

    private STNode parseListBindingPatternMemberRhs() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.LIST_BINDING_PATTERN_MEMBER_END);
                yield this.parseListBindingPatternMemberRhs();
            }
        };
    }

    private boolean isEndOfListBindingPattern(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseListBindingPatternMember() {
        return switch (this.peek().kind) {
            case SyntaxKind.ELLIPSIS_TOKEN -> this.parseRestBindingPattern();
            case SyntaxKind.IDENTIFIER_TOKEN, SyntaxKind.OPEN_BRACKET_TOKEN, SyntaxKind.OPEN_BRACE_TOKEN, SyntaxKind.ERROR_KEYWORD -> this.parseBindingPattern();
            default -> {
                this.recover(this.peek(), ParserRuleContext.LIST_BINDING_PATTERN_MEMBER);
                yield this.parseListBindingPatternMember();
            }
        };
    }

    private STNode parseRestBindingPattern() {
        this.startContext(ParserRuleContext.REST_BINDING_PATTERN);
        STNode ellipsis = this.parseEllipsis();
        STNode varName = this.parseVariableName();
        this.endContext();
        STSimpleNameReferenceNode simpleNameReferenceNode = (STSimpleNameReferenceNode)STNodeFactory.createSimpleNameReferenceNode(varName);
        return STNodeFactory.createRestBindingPatternNode(ellipsis, simpleNameReferenceNode);
    }

    private STNode parseTypedBindingPattern(ParserRuleContext context) {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseTypedBindingPattern(typeDescQualifiers, context);
    }

    private STNode parseTypedBindingPattern(List<STNode> qualifiers, ParserRuleContext context) {
        STNode typeDesc = this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true, false, TypePrecedence.DEFAULT);
        STNode typeBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, context);
        return typeBindingPattern;
    }

    private STNode parseMappingBindingPattern() {
        this.startContext(ParserRuleContext.MAPPING_BINDING_PATTERN);
        STNode openBrace = this.parseOpenBrace();
        STToken token = this.peek();
        if (this.isEndOfMappingBindingPattern(token.kind)) {
            STNode closeBrace = this.parseCloseBrace();
            STNode bindingPatternsNode = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return STNodeFactory.createMappingBindingPatternNode(openBrace, bindingPatternsNode, closeBrace);
        }
        ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
        STNode prevMember = this.parseMappingBindingPatternMember();
        if (prevMember.kind != SyntaxKind.REST_BINDING_PATTERN) {
            bindingPatterns.add(prevMember);
        }
        return this.parseMappingBindingPattern(openBrace, bindingPatterns, prevMember);
    }

    private STNode parseMappingBindingPattern(STNode openBrace, List<STNode> bindingPatterns, STNode prevMember) {
        STToken token = this.peek();
        STNode mappingBindingPatternRhs = null;
        while (!this.isEndOfMappingBindingPattern(token.kind) && prevMember.kind != SyntaxKind.REST_BINDING_PATTERN && (mappingBindingPatternRhs = this.parseMappingBindingPatternEnd()) != null) {
            bindingPatterns.add(mappingBindingPatternRhs);
            prevMember = this.parseMappingBindingPatternMember();
            if (prevMember.kind == SyntaxKind.REST_BINDING_PATTERN) break;
            bindingPatterns.add(prevMember);
            token = this.peek();
        }
        if (prevMember.kind == SyntaxKind.REST_BINDING_PATTERN) {
            bindingPatterns.add(prevMember);
        }
        STNode closeBrace = this.parseCloseBrace();
        STNode bindingPatternsNode = STNodeFactory.createNodeList(bindingPatterns);
        this.endContext();
        return STNodeFactory.createMappingBindingPatternNode(openBrace, bindingPatternsNode, closeBrace);
    }

    private STNode parseMappingBindingPatternMember() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.ELLIPSIS_TOKEN -> this.parseRestBindingPattern();
            default -> this.parseFieldBindingPattern();
        };
    }

    private STNode parseMappingBindingPatternEnd() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(nextToken, ParserRuleContext.MAPPING_BINDING_PATTERN_END);
                yield this.parseMappingBindingPatternEnd();
            }
        };
    }

    private STNode parseFieldBindingPattern() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseIdentifier(ParserRuleContext.FIELD_BINDING_PATTERN_NAME);
                STNode simpleNameReference = STNodeFactory.createSimpleNameReferenceNode(identifier);
                return this.parseFieldBindingPattern(simpleNameReference);
            }
        }
        this.recover(nextToken, ParserRuleContext.FIELD_BINDING_PATTERN_NAME);
        return this.parseFieldBindingPattern();
    }

    private STNode parseFieldBindingPattern(STNode simpleNameReference) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                return STNodeFactory.createFieldBindingPatternVarnameNode(simpleNameReference);
            }
            case COLON_TOKEN: {
                STNode colon = this.parseColon();
                STNode bindingPattern = this.parseBindingPattern();
                return STNodeFactory.createFieldBindingPatternFullNode(simpleNameReference, colon, bindingPattern);
            }
        }
        this.recover(nextToken, ParserRuleContext.FIELD_BINDING_PATTERN_END);
        return this.parseFieldBindingPattern(simpleNameReference);
    }

    private boolean isEndOfMappingBindingPattern(SyntaxKind nextTokenKind) {
        return nextTokenKind == SyntaxKind.CLOSE_BRACE_TOKEN || this.isEndOfModuleLevelNode(1);
    }

    private STNode parseErrorTypeDescOrErrorBP(STNode annots) {
        STToken nextNextToken = this.peek(2);
        switch (nextNextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                return this.parseAsErrorBindingPattern();
            }
            case LT_TOKEN: {
                return this.parseAsErrorTypeDesc(annots);
            }
            case IDENTIFIER_TOKEN: {
                SyntaxKind nextNextNextTokenKind = this.peek((int)3).kind;
                if (nextNextNextTokenKind != SyntaxKind.COLON_TOKEN && nextNextNextTokenKind != SyntaxKind.OPEN_PAREN_TOKEN) break;
                return this.parseAsErrorBindingPattern();
            }
        }
        return this.parseAsErrorTypeDesc(annots);
    }

    private STNode parseAsErrorBindingPattern() {
        this.startContext(ParserRuleContext.ASSIGNMENT_STMT);
        return this.parseAssignmentStmtRhs(this.parseErrorBindingPattern());
    }

    private STNode parseAsErrorTypeDesc(STNode annots) {
        STNode finalKeyword = STNodeFactory.createEmptyNode();
        return this.parseVariableDecl(this.getAnnotations(annots), finalKeyword);
    }

    private STNode parseErrorBindingPattern() {
        this.startContext(ParserRuleContext.ERROR_BINDING_PATTERN);
        STNode errorKeyword = this.parseErrorKeyword();
        return this.parseErrorBindingPattern(errorKeyword);
    }

    private STNode parseErrorBindingPattern(STNode errorKeyword) {
        STNode typeRef;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_PAREN_TOKEN: {
                typeRef = STNodeFactory.createEmptyNode();
                break;
            }
            default: {
                if (this.isPredeclaredIdentifier(nextToken.kind)) {
                    typeRef = this.parseTypeReference();
                    break;
                }
                this.recover(this.peek(), ParserRuleContext.ERROR_BINDING_PATTERN_ERROR_KEYWORD_RHS);
                return this.parseErrorBindingPattern(errorKeyword);
            }
        }
        return this.parseErrorBindingPattern(errorKeyword, typeRef);
    }

    private STNode parseErrorBindingPattern(STNode errorKeyword, STNode typeRef) {
        STNode openParenthesis = this.parseOpenParenthesis();
        STNode argListBindingPatterns = this.parseErrorArgListBindingPatterns();
        STNode closeParenthesis = this.parseCloseParenthesis();
        this.endContext();
        return STNodeFactory.createErrorBindingPatternNode(errorKeyword, typeRef, openParenthesis, argListBindingPatterns, closeParenthesis);
    }

    private STNode parseErrorArgListBindingPatterns() {
        ArrayList<STNode> argListBindingPatterns = new ArrayList<STNode>();
        if (this.isEndOfErrorFieldBindingPatterns()) {
            return STNodeFactory.createNodeList(argListBindingPatterns);
        }
        return this.parseErrorArgListBindingPatterns(argListBindingPatterns);
    }

    private STNode parseErrorArgListBindingPatterns(List<STNode> argListBindingPatterns) {
        STNode firstArg = this.parseErrorArgListBindingPattern(ParserRuleContext.ERROR_ARG_LIST_BINDING_PATTERN_START, true);
        if (firstArg == null) {
            return STNodeFactory.createNodeList(argListBindingPatterns);
        }
        switch (firstArg.kind) {
            case WILDCARD_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: {
                argListBindingPatterns.add(firstArg);
                return this.parseErrorArgListBPWithoutErrorMsg(argListBindingPatterns);
            }
            case ERROR_BINDING_PATTERN: {
                STToken missingIdentifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
                STNode missingErrorMsgBP = STNodeFactory.createCaptureBindingPatternNode(missingIdentifier);
                missingErrorMsgBP = SyntaxErrors.addDiagnostic(missingErrorMsgBP, DiagnosticErrorCode.ERROR_MISSING_ERROR_MESSAGE_BINDING_PATTERN, new Object[0]);
                STToken missingComma = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.COMMA_TOKEN, DiagnosticErrorCode.ERROR_MISSING_COMMA_TOKEN);
                argListBindingPatterns.add(missingErrorMsgBP);
                argListBindingPatterns.add(missingComma);
                argListBindingPatterns.add(firstArg);
                return this.parseErrorArgListBPWithoutErrorMsgAndCause(argListBindingPatterns, firstArg.kind);
            }
            case REST_BINDING_PATTERN: 
            case NAMED_ARG_BINDING_PATTERN: {
                argListBindingPatterns.add(firstArg);
                return this.parseErrorArgListBPWithoutErrorMsgAndCause(argListBindingPatterns, firstArg.kind);
            }
        }
        this.addInvalidNodeToNextToken(firstArg, DiagnosticErrorCode.ERROR_BINDING_PATTERN_NOT_ALLOWED, new Object[0]);
        return this.parseErrorArgListBindingPatterns(argListBindingPatterns);
    }

    private STNode parseErrorArgListBPWithoutErrorMsg(List<STNode> argListBindingPatterns) {
        STNode argEnd = this.parseErrorArgsBindingPatternEnd(ParserRuleContext.ERROR_MESSAGE_BINDING_PATTERN_END);
        if (argEnd == null) {
            return STNodeFactory.createNodeList(argListBindingPatterns);
        }
        STNode secondArg = this.parseErrorArgListBindingPattern(ParserRuleContext.ERROR_MESSAGE_BINDING_PATTERN_RHS, false);
        assert (secondArg != null);
        switch (secondArg.kind) {
            case ERROR_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: 
            case NAMED_ARG_BINDING_PATTERN: {
                argListBindingPatterns.add(argEnd);
                argListBindingPatterns.add(secondArg);
                return this.parseErrorArgListBPWithoutErrorMsgAndCause(argListBindingPatterns, secondArg.kind);
            }
        }
        this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, argEnd, null, new Object[0]);
        this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, secondArg, DiagnosticErrorCode.ERROR_BINDING_PATTERN_NOT_ALLOWED, new Object[0]);
        return this.parseErrorArgListBPWithoutErrorMsg(argListBindingPatterns);
    }

    private STNode parseErrorArgListBPWithoutErrorMsgAndCause(List<STNode> argListBindingPatterns, SyntaxKind lastValidArgKind) {
        STNode argEnd;
        while (!this.isEndOfErrorFieldBindingPatterns() && (argEnd = this.parseErrorArgsBindingPatternEnd(ParserRuleContext.ERROR_FIELD_BINDING_PATTERN_END)) != null) {
            STNode currentArg = this.parseErrorArgListBindingPattern(ParserRuleContext.ERROR_FIELD_BINDING_PATTERN, false);
            assert (currentArg != null);
            DiagnosticErrorCode errorCode = this.validateErrorFieldBindingPatternOrder(lastValidArgKind, currentArg.kind);
            if (errorCode == null) {
                argListBindingPatterns.add(argEnd);
                argListBindingPatterns.add(currentArg);
                lastValidArgKind = currentArg.kind;
                continue;
            }
            if (argListBindingPatterns.isEmpty()) {
                this.addInvalidNodeToNextToken(argEnd, null, new Object[0]);
                this.addInvalidNodeToNextToken(currentArg, errorCode, new Object[0]);
                continue;
            }
            this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, argEnd, null, new Object[0]);
            this.updateLastNodeInListWithInvalidNode(argListBindingPatterns, currentArg, errorCode, new Object[0]);
        }
        return STNodeFactory.createNodeList(argListBindingPatterns);
    }

    private boolean isEndOfErrorFieldBindingPatterns() {
        SyntaxKind nextTokenKind = this.peek().kind;
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseErrorArgsBindingPatternEnd(ParserRuleContext currentCtx) {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_PAREN_TOKEN -> null;
            default -> {
                this.recover(this.peek(), currentCtx);
                yield this.parseErrorArgsBindingPatternEnd(currentCtx);
            }
        };
    }

    private STNode parseErrorArgListBindingPattern(ParserRuleContext context, boolean isFirstArg) {
        switch (this.peek().kind) {
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingPattern();
            }
            case IDENTIFIER_TOKEN: {
                STToken argNameOrSimpleBindingPattern = this.consume();
                return this.parseNamedOrSimpleArgBindingPattern(argNameOrSimpleBindingPattern);
            }
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                return this.parseBindingPattern();
            }
            case CLOSE_PAREN_TOKEN: {
                if (!isFirstArg) break;
                return null;
            }
        }
        this.recover(this.peek(), context);
        return this.parseErrorArgListBindingPattern(context, isFirstArg);
    }

    private STNode parseNamedOrSimpleArgBindingPattern(STNode argNameOrSimpleBindingPattern) {
        STToken secondToken = this.peek();
        switch (secondToken.kind) {
            case EQUAL_TOKEN: {
                STToken equal = this.consume();
                STNode bindingPattern = this.parseBindingPattern();
                return STNodeFactory.createNamedArgBindingPatternNode(argNameOrSimpleBindingPattern, equal, bindingPattern);
            }
        }
        return this.createCaptureOrWildcardBP(argNameOrSimpleBindingPattern);
    }

    private DiagnosticErrorCode validateErrorFieldBindingPatternOrder(SyntaxKind prevArgKind, SyntaxKind currentArgKind) {
        return switch (currentArgKind) {
            case SyntaxKind.REST_BINDING_PATTERN, SyntaxKind.NAMED_ARG_BINDING_PATTERN -> {
                if (prevArgKind == SyntaxKind.REST_BINDING_PATTERN) {
                    yield DiagnosticErrorCode.ERROR_REST_ARG_FOLLOWED_BY_ANOTHER_ARG;
                }
                yield null;
            }
            default -> DiagnosticErrorCode.ERROR_BINDING_PATTERN_NOT_ALLOWED;
        };
    }

    private STNode parseTypedBindingPatternTypeRhs(STNode typeDesc, ParserRuleContext context) {
        return this.parseTypedBindingPatternTypeRhs(typeDesc, context, true);
    }

    private STNode parseTypedBindingPatternTypeRhs(STNode typeDesc, ParserRuleContext context, boolean isRoot) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                STNode bindingPattern = this.parseBindingPattern();
                return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
            }
            case OPEN_BRACKET_TOKEN: {
                STNode typedBindingPattern = this.parseTypedBindingPatternOrMemberAccess(typeDesc, true, true, context);
                assert (typedBindingPattern.kind == SyntaxKind.TYPED_BINDING_PATTERN);
                return typedBindingPattern;
            }
            case COMMA_TOKEN: 
            case CLOSE_PAREN_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                if (isRoot) break;
                return typeDesc;
            }
        }
        this.recover(nextToken, ParserRuleContext.TYPED_BINDING_PATTERN_TYPE_RHS);
        return this.parseTypedBindingPatternTypeRhs(typeDesc, context, isRoot);
    }

    private STNode parseTypedBindingPatternOrMemberAccess(STNode typeDescOrExpr, boolean isTypedBindingPattern, boolean allowAssignment, ParserRuleContext context) {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        if (this.isBracketedListEnd(this.peek().kind)) {
            return this.parseAsArrayTypeDesc(typeDescOrExpr, openBracket, STNodeFactory.createEmptyNode(), context);
        }
        STNode member = this.parseBracketedListMember(isTypedBindingPattern);
        SyntaxKind currentNodeType = this.getBracketedListNodeType(member, isTypedBindingPattern);
        switch (currentNodeType) {
            case ARRAY_TYPE_DESC: {
                STNode typedBindingPattern = this.parseAsArrayTypeDesc(typeDescOrExpr, openBracket, member, context);
                return typedBindingPattern;
            }
            case LIST_BINDING_PATTERN: {
                STNode bindingPattern = this.parseAsListBindingPattern(openBracket, new ArrayList<STNode>(), member, false);
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
            }
            case INDEXED_EXPRESSION: {
                return this.parseAsMemberAccessExpr(typeDescOrExpr, openBracket, member);
            }
            case ARRAY_TYPE_DESC_OR_MEMBER_ACCESS: {
                break;
            }
            default: {
                STNode memberEnd = this.parseBracketedListMemberEnd();
                if (memberEnd == null) break;
                ArrayList<STNode> memberList = new ArrayList<STNode>();
                memberList.add(this.getBindingPattern(member, true));
                memberList.add(memberEnd);
                STNode bindingPattern = this.parseAsListBindingPattern(openBracket, memberList);
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
            }
        }
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        return this.parseTypedBindingPatternOrMemberAccessRhs(typeDescOrExpr, openBracket, member, closeBracket, isTypedBindingPattern, allowAssignment, context);
    }

    private STNode parseAsMemberAccessExpr(STNode typeNameOrExpr, STNode openBracket, STNode member) {
        member = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, member, false, true);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        STNode keyExpr = STNodeFactory.createNodeList(member);
        STNode memberAccessExpr = STNodeFactory.createIndexedExpressionNode(typeNameOrExpr, openBracket, keyExpr, closeBracket);
        return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, memberAccessExpr, false, false);
    }

    private boolean isBracketedListEnd(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseBracketedListMember(boolean isTypedBindingPattern) {
        STNode expr;
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case ASTERISK_TOKEN: 
            case DECIMAL_INTEGER_LITERAL_TOKEN: 
            case HEX_INTEGER_LITERAL_TOKEN: 
            case STRING_LITERAL_TOKEN: {
                return this.parseBasicLiteral();
            }
            case CLOSE_BRACKET_TOKEN: {
                return STNodeFactory.createEmptyNode();
            }
            case OPEN_BRACKET_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: 
            case ELLIPSIS_TOKEN: {
                return this.parseStatementStartBracketedListMember();
            }
            case IDENTIFIER_TOKEN: {
                if (!isTypedBindingPattern) break;
                return this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
            }
            default: {
                if (!isTypedBindingPattern && this.isValidExpressionStart(nextToken.kind, 1) || this.isQualifiedIdentifierPredeclaredPrefix(nextToken.kind)) break;
                ParserRuleContext recoverContext = isTypedBindingPattern ? ParserRuleContext.LIST_BINDING_MEMBER_OR_ARRAY_LENGTH : ParserRuleContext.BRACKETED_LIST_MEMBER;
                this.recover(this.peek(), recoverContext);
                return this.parseBracketedListMember(isTypedBindingPattern);
            }
        }
        if (this.isWildcardBP(expr = this.parseExpression())) {
            return this.getWildcardBindingPattern(expr);
        }
        return expr;
    }

    private STNode parseAsArrayTypeDesc(STNode typeDesc, STNode openBracket, STNode member, ParserRuleContext context) {
        typeDesc = this.getTypeDescFromExpr(typeDesc);
        this.switchContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
        this.startContext(ParserRuleContext.ARRAY_TYPE_DESCRIPTOR);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        this.endContext();
        return this.parseTypedBindingPatternOrMemberAccessRhs(typeDesc, openBracket, member, closeBracket, true, true, context);
    }

    private STNode parseBracketedListMemberEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.parseComma();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.BRACKETED_LIST_MEMBER_END);
                yield this.parseBracketedListMemberEnd();
            }
        };
    }

    private STNode parseTypedBindingPatternOrMemberAccessRhs(STNode typeDescOrExpr, STNode openBracket, STNode member, STNode closeBracket, boolean isTypedBindingPattern, boolean allowAssignment, ParserRuleContext context) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: 
            case ERROR_KEYWORD: {
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                STNode arrayTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, typeDesc);
                return this.parseTypedBindingPatternTypeRhs(arrayTypeDesc, context);
            }
            case OPEN_BRACKET_TOKEN: {
                if (isTypedBindingPattern) {
                    STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                    STNode arrayTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, typeDesc);
                    return this.parseTypedBindingPatternTypeRhs(arrayTypeDesc, context);
                }
                STNode keyExpr = this.getKeyExpr(member);
                STNode expr = STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
                return this.parseTypedBindingPatternOrMemberAccess(expr, false, allowAssignment, context);
            }
            case QUESTION_MARK_TOKEN: {
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                STNode arrayTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, typeDesc);
                typeDesc = this.parseComplexTypeDescriptor(arrayTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
                return this.parseTypedBindingPatternTypeRhs(typeDesc, context);
            }
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: {
                return this.parseComplexTypeDescInTypedBPOrExprRhs(typeDescOrExpr, openBracket, member, closeBracket, isTypedBindingPattern);
            }
            case IN_KEYWORD: {
                if (context != ParserRuleContext.FOREACH_STMT && context != ParserRuleContext.FROM_CLAUSE && context != ParserRuleContext.JOIN_CLAUSE) break;
                return this.createTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket);
            }
            case EQUAL_TOKEN: {
                if (context == ParserRuleContext.FOREACH_STMT || context == ParserRuleContext.FROM_CLAUSE) break;
                if (isTypedBindingPattern || !allowAssignment || !this.isValidLVExpr(typeDescOrExpr)) {
                    return this.createTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket);
                }
                STNode keyExpr = this.getKeyExpr(member);
                typeDescOrExpr = this.getExpression(typeDescOrExpr);
                return STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
            }
            case SEMICOLON_TOKEN: {
                if (context == ParserRuleContext.FOREACH_STMT || context == ParserRuleContext.FROM_CLAUSE) break;
                return this.createTypedBindingPattern(typeDescOrExpr, openBracket, member, closeBracket);
            }
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                if (context == ParserRuleContext.AMBIGUOUS_STMT) {
                    STNode keyExpr = this.getKeyExpr(member);
                    return STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
                }
            }
            default: {
                if (isTypedBindingPattern || !this.isValidExprRhsStart(nextToken.kind, closeBracket.kind)) break;
                STNode keyExpr = this.getKeyExpr(member);
                typeDescOrExpr = this.getExpression(typeDescOrExpr);
                return STNodeFactory.createIndexedExpressionNode(typeDescOrExpr, openBracket, keyExpr, closeBracket);
            }
        }
        ParserRuleContext recoveryCtx = ParserRuleContext.BRACKETED_LIST_RHS;
        if (isTypedBindingPattern) {
            recoveryCtx = ParserRuleContext.TYPE_DESC_RHS_OR_BP_RHS;
        }
        this.recover(this.peek(), recoveryCtx);
        return this.parseTypedBindingPatternOrMemberAccessRhs(typeDescOrExpr, openBracket, member, closeBracket, isTypedBindingPattern, allowAssignment, context);
    }

    private STNode getKeyExpr(STNode member) {
        if (member == null) {
            STToken keyIdentifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_KEY_EXPR_IN_MEMBER_ACCESS_EXPR);
            STNode missingVarRef = STNodeFactory.createSimpleNameReferenceNode(keyIdentifier);
            return STNodeFactory.createNodeList(missingVarRef);
        }
        return STNodeFactory.createNodeList(member);
    }

    private STNode createTypedBindingPattern(STNode typeDescOrExpr, STNode openBracket, STNode member, STNode closeBracket) {
        STNode bindingPatterns = STNodeFactory.createEmptyNodeList();
        if (!this.isEmpty(member)) {
            SyntaxKind memberKind = member.kind;
            if (memberKind == SyntaxKind.NUMERIC_LITERAL || memberKind == SyntaxKind.ASTERISK_LITERAL) {
                STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
                STNode arrayTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, typeDesc);
                STToken identifierToken = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_VARIABLE_NAME);
                STNode variableName = STNodeFactory.createCaptureBindingPatternNode(identifierToken);
                return STNodeFactory.createTypedBindingPatternNode(arrayTypeDesc, variableName);
            }
            STNode bindingPattern = this.getBindingPattern(member, true);
            bindingPatterns = STNodeFactory.createNodeList(bindingPattern);
        }
        STNode bindingPattern = STNodeFactory.createListBindingPatternNode(openBracket, bindingPatterns, closeBracket);
        STNode typeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
        return STNodeFactory.createTypedBindingPatternNode(typeDesc, bindingPattern);
    }

    private STNode parseComplexTypeDescInTypedBPOrExprRhs(STNode typeDescOrExpr, STNode openBracket, STNode member, STNode closeBracket, boolean isTypedBindingPattern) {
        STNode pipeOrAndToken = this.parseUnionOrIntersectionToken();
        STNode typedBindingPatternOrExpr = this.parseTypedBindingPatternOrExpr(false);
        if (typedBindingPatternOrExpr.kind == SyntaxKind.TYPED_BINDING_PATTERN) {
            STNode lhsTypeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
            lhsTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, lhsTypeDesc);
            STTypedBindingPatternNode rhsTypedBindingPattern = (STTypedBindingPatternNode)typedBindingPatternOrExpr;
            STNode rhsTypeDesc = rhsTypedBindingPattern.typeDescriptor;
            STNode newTypeDesc = this.mergeTypes(lhsTypeDesc, pipeOrAndToken, rhsTypeDesc);
            return STNodeFactory.createTypedBindingPatternNode(newTypeDesc, rhsTypedBindingPattern.bindingPattern);
        }
        if (isTypedBindingPattern) {
            STNode lhsTypeDesc = this.getTypeDescFromExpr(typeDescOrExpr);
            lhsTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, lhsTypeDesc);
            return this.createCaptureBPWithMissingVarName(lhsTypeDesc, pipeOrAndToken, typedBindingPatternOrExpr);
        }
        STNode keyExpr = this.getExpression(member);
        STNode containerExpr = this.getExpression(typeDescOrExpr);
        STNode lhsExpr = STNodeFactory.createIndexedExpressionNode(containerExpr, openBracket, keyExpr, closeBracket);
        return STNodeFactory.createBinaryExpressionNode(SyntaxKind.BINARY_EXPRESSION, lhsExpr, pipeOrAndToken, typedBindingPatternOrExpr);
    }

    private STNode mergeTypes(STNode lhsTypeDesc, STNode pipeOrAndToken, STNode rhsTypeDesc) {
        if (pipeOrAndToken.kind == SyntaxKind.PIPE_TOKEN) {
            return this.mergeTypesWithUnion(lhsTypeDesc, pipeOrAndToken, rhsTypeDesc);
        }
        return this.mergeTypesWithIntersection(lhsTypeDesc, pipeOrAndToken, rhsTypeDesc);
    }

    private STNode mergeTypesWithUnion(STNode lhsTypeDesc, STNode pipeToken, STNode rhsTypeDesc) {
        if (rhsTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            STUnionTypeDescriptorNode rhsUnionTypeDesc = (STUnionTypeDescriptorNode)rhsTypeDesc;
            return this.replaceLeftMostUnionWithAUnion(lhsTypeDesc, pipeToken, rhsUnionTypeDesc);
        }
        return this.createUnionTypeDesc(lhsTypeDesc, pipeToken, rhsTypeDesc);
    }

    private STNode mergeTypesWithIntersection(STNode lhsTypeDesc, STNode bitwiseAndToken, STNode rhsTypeDesc) {
        if (lhsTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            STUnionTypeDescriptorNode lhsUnionTypeDesc = (STUnionTypeDescriptorNode)lhsTypeDesc;
            if (rhsTypeDesc.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
                rhsTypeDesc = this.replaceLeftMostIntersectionWithAIntersection(lhsUnionTypeDesc.rightTypeDesc, bitwiseAndToken, (STIntersectionTypeDescriptorNode)rhsTypeDesc);
                return this.createUnionTypeDesc(lhsUnionTypeDesc.leftTypeDesc, lhsUnionTypeDesc.pipeToken, rhsTypeDesc);
            }
            if (rhsTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
                rhsTypeDesc = this.replaceLeftMostUnionWithAIntersection(lhsUnionTypeDesc.rightTypeDesc, bitwiseAndToken, (STUnionTypeDescriptorNode)rhsTypeDesc);
                return this.replaceLeftMostUnionWithAUnion(lhsUnionTypeDesc.leftTypeDesc, lhsUnionTypeDesc.pipeToken, (STUnionTypeDescriptorNode)rhsTypeDesc);
            }
            rhsTypeDesc = this.createIntersectionTypeDesc(lhsUnionTypeDesc.rightTypeDesc, bitwiseAndToken, rhsTypeDesc);
            return this.createUnionTypeDesc(lhsUnionTypeDesc.leftTypeDesc, lhsUnionTypeDesc.pipeToken, rhsTypeDesc);
        }
        if (rhsTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            STUnionTypeDescriptorNode rhsUnionTypeDesc = (STUnionTypeDescriptorNode)rhsTypeDesc;
            return this.replaceLeftMostUnionWithAIntersection(lhsTypeDesc, bitwiseAndToken, rhsUnionTypeDesc);
        }
        if (rhsTypeDesc.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
            STIntersectionTypeDescriptorNode rhsIntSecTypeDesc = (STIntersectionTypeDescriptorNode)rhsTypeDesc;
            return this.replaceLeftMostIntersectionWithAIntersection(lhsTypeDesc, bitwiseAndToken, rhsIntSecTypeDesc);
        }
        return this.createIntersectionTypeDesc(lhsTypeDesc, bitwiseAndToken, rhsTypeDesc);
    }

    private STNode replaceLeftMostUnionWithAUnion(STNode typeDesc, STNode pipeToken, STUnionTypeDescriptorNode unionTypeDesc) {
        STNode leftTypeDesc = unionTypeDesc.leftTypeDesc;
        if (leftTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            return unionTypeDesc.replace(unionTypeDesc.leftTypeDesc, this.replaceLeftMostUnionWithAUnion(typeDesc, pipeToken, (STUnionTypeDescriptorNode)leftTypeDesc));
        }
        leftTypeDesc = this.createUnionTypeDesc(typeDesc, pipeToken, leftTypeDesc);
        return unionTypeDesc.replace(unionTypeDesc.leftTypeDesc, leftTypeDesc);
    }

    private STNode replaceLeftMostUnionWithAIntersection(STNode typeDesc, STNode bitwiseAndToken, STUnionTypeDescriptorNode unionTypeDesc) {
        STNode leftTypeDesc = unionTypeDesc.leftTypeDesc;
        if (leftTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            return unionTypeDesc.replace(unionTypeDesc.leftTypeDesc, this.replaceLeftMostUnionWithAIntersection(typeDesc, bitwiseAndToken, (STUnionTypeDescriptorNode)leftTypeDesc));
        }
        if (leftTypeDesc.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
            return unionTypeDesc.replace(unionTypeDesc.leftTypeDesc, this.replaceLeftMostIntersectionWithAIntersection(typeDesc, bitwiseAndToken, (STIntersectionTypeDescriptorNode)leftTypeDesc));
        }
        leftTypeDesc = this.createIntersectionTypeDesc(typeDesc, bitwiseAndToken, leftTypeDesc);
        return unionTypeDesc.replace(unionTypeDesc.leftTypeDesc, leftTypeDesc);
    }

    private STNode replaceLeftMostIntersectionWithAIntersection(STNode typeDesc, STNode bitwiseAndToken, STIntersectionTypeDescriptorNode intersectionTypeDesc) {
        STNode leftTypeDesc = intersectionTypeDesc.leftTypeDesc;
        if (leftTypeDesc.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
            return intersectionTypeDesc.replace(intersectionTypeDesc.leftTypeDesc, this.replaceLeftMostIntersectionWithAIntersection(typeDesc, bitwiseAndToken, (STIntersectionTypeDescriptorNode)leftTypeDesc));
        }
        leftTypeDesc = this.createIntersectionTypeDesc(typeDesc, bitwiseAndToken, leftTypeDesc);
        return intersectionTypeDesc.replace(intersectionTypeDesc.leftTypeDesc, leftTypeDesc);
    }

    private STNode getArrayTypeDesc(STNode openBracket, STNode member, STNode closeBracket, STNode lhsTypeDesc) {
        if (lhsTypeDesc.kind == SyntaxKind.UNION_TYPE_DESC) {
            STUnionTypeDescriptorNode unionTypeDesc = (STUnionTypeDescriptorNode)lhsTypeDesc;
            STNode middleTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, unionTypeDesc.rightTypeDesc);
            lhsTypeDesc = this.mergeTypesWithUnion(unionTypeDesc.leftTypeDesc, unionTypeDesc.pipeToken, middleTypeDesc);
        } else if (lhsTypeDesc.kind == SyntaxKind.INTERSECTION_TYPE_DESC) {
            STIntersectionTypeDescriptorNode intersectionTypeDesc = (STIntersectionTypeDescriptorNode)lhsTypeDesc;
            STNode middleTypeDesc = this.getArrayTypeDesc(openBracket, member, closeBracket, intersectionTypeDesc.rightTypeDesc);
            lhsTypeDesc = this.mergeTypesWithIntersection(intersectionTypeDesc.leftTypeDesc, intersectionTypeDesc.bitwiseAndToken, middleTypeDesc);
        } else {
            lhsTypeDesc = this.createArrayTypeDesc(lhsTypeDesc, openBracket, member, closeBracket);
        }
        return lhsTypeDesc;
    }

    private STNode parseUnionOrIntersectionToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.PIPE_TOKEN || token.kind == SyntaxKind.BITWISE_AND_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.UNION_OR_INTERSECTION_TOKEN);
        return this.parseUnionOrIntersectionToken();
    }

    private SyntaxKind getBracketedListNodeType(STNode memberNode, boolean isTypedBindingPattern) {
        if (this.isEmpty(memberNode)) {
            return SyntaxKind.NONE;
        }
        if (this.isDefiniteTypeDesc(memberNode.kind)) {
            return SyntaxKind.TUPLE_TYPE_DESC;
        }
        switch (memberNode.kind) {
            case ASTERISK_LITERAL: {
                return SyntaxKind.ARRAY_TYPE_DESC;
            }
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: {
                return SyntaxKind.LIST_BINDING_PATTERN;
            }
            case QUALIFIED_NAME_REFERENCE: 
            case REST_TYPE: {
                return SyntaxKind.TUPLE_TYPE_DESC;
            }
            case NUMERIC_LITERAL: {
                if (isTypedBindingPattern) {
                    return SyntaxKind.ARRAY_TYPE_DESC;
                }
                return SyntaxKind.ARRAY_TYPE_DESC_OR_MEMBER_ACCESS;
            }
            case SIMPLE_NAME_REFERENCE: 
            case BRACKETED_LIST: 
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                return SyntaxKind.NONE;
            }
            case ERROR_CONSTRUCTOR: {
                if (isTypedBindingPattern) {
                    return SyntaxKind.LIST_BINDING_PATTERN;
                }
                if (this.isPossibleErrorBindingPattern((STErrorConstructorExpressionNode)memberNode)) {
                    return SyntaxKind.NONE;
                }
                return SyntaxKind.INDEXED_EXPRESSION;
            }
        }
        if (isTypedBindingPattern) {
            return SyntaxKind.NONE;
        }
        return SyntaxKind.INDEXED_EXPRESSION;
    }

    private STNode parseStatementStartsWithOpenBracket(STNode annots, boolean possibleMappingField) {
        this.startContext(ParserRuleContext.ASSIGNMENT_OR_VAR_DECL_STMT);
        return this.parseStatementStartsWithOpenBracket(annots, true, possibleMappingField);
    }

    private STNode parseMemberBracketedList() {
        STNode annots = STNodeFactory.createEmptyNodeList();
        return this.parseStatementStartsWithOpenBracket(annots, false, false);
    }

    private STNode parseStatementStartsWithOpenBracket(STNode annots, boolean isRoot, boolean possibleMappingField) {
        this.startContext(ParserRuleContext.STMT_START_BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        while (!this.isBracketedListEnd(this.peek().kind)) {
            STNode member = this.parseStatementStartBracketedListMember();
            SyntaxKind currentNodeType = this.getStmtStartBracketedListType(member);
            switch (currentNodeType) {
                case TUPLE_TYPE_DESC: {
                    member = this.parseComplexTypeDescriptor(member, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
                    member = this.createMemberOrRestNode(STNodeFactory.createEmptyNodeList(), member);
                    return this.parseAsTupleTypeDesc(annots, openBracket, memberList, member, isRoot);
                }
                case REST_TYPE: 
                case MEMBER_TYPE_DESC: {
                    return this.parseAsTupleTypeDesc(annots, openBracket, memberList, member, isRoot);
                }
                case LIST_BINDING_PATTERN: {
                    return this.parseAsListBindingPattern(openBracket, memberList, member, isRoot);
                }
                case LIST_CONSTRUCTOR: {
                    return this.parseAsListConstructor(openBracket, memberList, member, isRoot);
                }
                case LIST_BP_OR_LIST_CONSTRUCTOR: {
                    return this.parseAsListBindingPatternOrListConstructor(openBracket, memberList, member, isRoot);
                }
                case TUPLE_TYPE_DESC_OR_LIST_CONST: {
                    return this.parseAsTupleTypeDescOrListConstructor(annots, openBracket, memberList, member, isRoot);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
        }
        STNode closeBracket = this.parseCloseBracket();
        STNode bracketedList = this.parseStatementStartBracketedListRhs(annots, openBracket, memberList, closeBracket, isRoot, possibleMappingField);
        return bracketedList;
    }

    private STNode parseStatementStartBracketedListMember() {
        ArrayList<STNode> typeDescQualifiers = new ArrayList<STNode>();
        return this.parseStatementStartBracketedListMember(typeDescQualifiers);
    }

    private STNode parseStatementStartBracketedListMember(List<STNode> qualifiers) {
        this.parseTypeDescQualifiers(qualifiers);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMemberBracketedList();
            }
            case IDENTIFIER_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                STNode identifier = this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
                if (this.isWildcardBP(identifier)) {
                    STNode varName = ((STSimpleNameReferenceNode)identifier).name;
                    return this.getWildcardBindingPattern(varName);
                }
                nextToken = this.peek();
                if (nextToken.kind == SyntaxKind.ELLIPSIS_TOKEN) {
                    STNode ellipsis = this.parseEllipsis();
                    return STNodeFactory.createRestDescriptorNode(identifier, ellipsis);
                }
                if (nextToken.kind != SyntaxKind.OPEN_BRACKET_TOKEN && this.isValidTypeContinuationToken(nextToken)) {
                    return this.parseComplexTypeDescriptor(identifier, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
                }
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, identifier, false, true);
            }
            case OPEN_BRACE_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseMappingBindingPatterOrMappingConstructor();
            }
            case ERROR_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN || nextNextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
                    return this.parseErrorBindingPatternOrErrorConstructor();
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case ELLIPSIS_TOKEN: {
                this.reportInvalidQualifierList(qualifiers);
                return this.parseRestBindingOrSpreadMember();
            }
            case XML_KEYWORD: 
            case STRING_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                if (this.getNextNextToken().kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseExpression(false);
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: {
                this.reportInvalidQualifierList(qualifiers);
                if (this.getNextNextToken().kind == SyntaxKind.LT_TOKEN) {
                    return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
                }
                return this.parseExpression(false);
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseTypeDescOrExpr(qualifiers);
            }
            case FUNCTION_KEYWORD: {
                return this.parseAnonFuncExprOrFuncTypeDesc(qualifiers);
            }
            case AT_TOKEN: {
                return this.parseTupleMember();
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            this.reportInvalidQualifierList(qualifiers);
            return this.parseExpression(false);
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseTypeDescriptor(qualifiers, ParserRuleContext.TYPE_DESC_IN_TUPLE);
        }
        this.recover(this.peek(), ParserRuleContext.STMT_START_BRACKETED_LIST_MEMBER);
        return this.parseStatementStartBracketedListMember(qualifiers);
    }

    private STNode parseRestBindingOrSpreadMember() {
        STNode ellipsis = this.parseEllipsis();
        STNode expr = this.parseExpression();
        if (expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return STNodeFactory.createRestBindingPatternNode(ellipsis, expr);
        }
        return STNodeFactory.createSpreadMemberNode(ellipsis, expr);
    }

    private STNode parseAsTupleTypeDescOrListConstructor(STNode annots, STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        STNode tupleTypeDescOrListCons;
        memberList.add(member);
        STNode memberEnd = this.parseBracketedListMemberEnd();
        if (memberEnd == null) {
            STNode closeBracket = this.parseCloseBracket();
            tupleTypeDescOrListCons = this.parseTupleTypeDescOrListConstructorRhs(openBracket, memberList, closeBracket, isRoot);
        } else {
            memberList.add(memberEnd);
            tupleTypeDescOrListCons = this.parseTupleTypeDescOrListConstructor(annots, openBracket, memberList, isRoot);
        }
        return tupleTypeDescOrListCons;
    }

    private STNode parseTupleTypeDescOrListConstructor(STNode annots) {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        return this.parseTupleTypeDescOrListConstructor(annots, openBracket, memberList, false);
    }

    private STNode parseTupleTypeDescOrListConstructor(STNode annots, STNode openBracket, List<STNode> memberList, boolean isRoot) {
        STToken nextToken = this.peek();
        while (!this.isBracketedListEnd(nextToken.kind)) {
            STNode member = this.parseTupleTypeDescOrListConstructorMember(annots);
            SyntaxKind currentNodeType = this.getParsingNodeTypeOfTupleTypeOrListCons(member);
            switch (currentNodeType) {
                case LIST_CONSTRUCTOR: {
                    return this.parseAsListConstructor(openBracket, memberList, member, isRoot);
                }
                case REST_TYPE: 
                case MEMBER_TYPE_DESC: {
                    return this.parseAsTupleTypeDesc(annots, openBracket, memberList, member, isRoot);
                }
                case TUPLE_TYPE_DESC: {
                    member = this.parseComplexTypeDescriptor(member, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
                    member = this.createMemberOrRestNode(STNodeFactory.createEmptyNodeList(), member);
                    return this.parseAsTupleTypeDesc(annots, openBracket, memberList, member, isRoot);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
            nextToken = this.peek();
        }
        STNode closeBracket = this.parseCloseBracket();
        return this.parseTupleTypeDescOrListConstructorRhs(openBracket, memberList, closeBracket, isRoot);
    }

    private STNode parseTupleTypeDescOrListConstructorMember(STNode annots) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                return this.parseTupleTypeDescOrListConstructor(annots);
            }
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
                if (this.peek().kind == SyntaxKind.ELLIPSIS_TOKEN) {
                    STNode ellipsis = this.parseEllipsis();
                    return STNodeFactory.createRestDescriptorNode(identifier, ellipsis);
                }
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, identifier, false, false);
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingConstructorExpr();
            }
            case ERROR_KEYWORD: {
                STToken nextNextToken = this.getNextNextToken();
                if (nextNextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN || nextNextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
                    return this.parseErrorConstructorExpr(false);
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case XML_KEYWORD: 
            case STRING_KEYWORD: {
                if (this.getNextNextToken().kind == SyntaxKind.BACKTICK_TOKEN) {
                    return this.parseExpression(false);
                }
                return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
            }
            case STREAM_KEYWORD: 
            case TABLE_KEYWORD: {
                if (this.getNextNextToken().kind == SyntaxKind.LT_TOKEN) {
                    return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
                }
                return this.parseExpression(false);
            }
            case OPEN_PAREN_TOKEN: {
                return this.parseTypeDescOrExpr();
            }
            case AT_TOKEN: {
                return this.parseTupleMember();
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            return this.parseExpression(false);
        }
        if (this.isTypeStartingToken(nextToken.kind)) {
            return this.parseTypeDescriptor(ParserRuleContext.TYPE_DESC_IN_TUPLE);
        }
        this.recover(this.peek(), ParserRuleContext.TUPLE_TYPE_DESC_OR_LIST_CONST_MEMBER);
        return this.parseTupleTypeDescOrListConstructorMember(annots);
    }

    private SyntaxKind getParsingNodeTypeOfTupleTypeOrListCons(STNode memberNode) {
        return this.getStmtStartBracketedListType(memberNode);
    }

    private STNode parseTupleTypeDescOrListConstructorRhs(STNode openBracket, List<STNode> members, STNode closeBracket, boolean isRoot) {
        STNode tupleTypeOrListConst;
        switch (this.peek().kind) {
            case PIPE_TOKEN: 
            case BITWISE_AND_TOKEN: 
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                if (isRoot) break;
                this.endContext();
                return new STAmbiguousCollectionNode(SyntaxKind.TUPLE_TYPE_DESC_OR_LIST_CONST, openBracket, members, closeBracket);
            }
        }
        if (this.isValidExprRhsStart(this.peek().kind, closeBracket.kind) || isRoot && this.peek().kind == SyntaxKind.EQUAL_TOKEN) {
            members = this.getExpressionList(members, false);
            STNode memberExpressions = STNodeFactory.createNodeList(members);
            tupleTypeOrListConst = STNodeFactory.createListConstructorExpressionNode(openBracket, memberExpressions, closeBracket);
        } else {
            STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTupleMemberList(members));
            STNode tupleTypeDesc = STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDescs, closeBracket);
            tupleTypeOrListConst = this.parseComplexTypeDescriptor(tupleTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
        }
        this.endContext();
        if (!isRoot) {
            return tupleTypeOrListConst;
        }
        STNode annots = STNodeFactory.createEmptyNodeList();
        return this.parseStmtStartsWithTupleTypeOrExprRhs(annots, tupleTypeOrListConst, true);
    }

    private STNode parseStmtStartsWithTupleTypeOrExprRhs(STNode annots, STNode tupleTypeOrListConst, boolean isRoot) {
        if (tupleTypeOrListConst.kind.compareTo(SyntaxKind.RECORD_TYPE_DESC) >= 0 && tupleTypeOrListConst.kind.compareTo(SyntaxKind.TYPEDESC_TYPE_DESC) <= 0) {
            ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
            STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(tupleTypeOrListConst, ParserRuleContext.VAR_DECL_STMT, isRoot);
            if (!isRoot) {
                return typedBindingPattern;
            }
            this.switchContext(ParserRuleContext.VAR_DECL_STMT);
            return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBindingPattern, false);
        }
        STNode expr = this.getExpression(tupleTypeOrListConst);
        expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseAsTupleTypeDesc(STNode annots, STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        memberList = this.getTupleMemberList(memberList);
        this.startContext(ParserRuleContext.TUPLE_MEMBERS);
        STNode tupleTypeMembers = this.parseTupleTypeMembers(member, memberList);
        STNode closeBracket = this.parseCloseBracket();
        this.endContext();
        STNode tupleType = STNodeFactory.createTupleTypeDescriptorNode(openBracket, tupleTypeMembers, closeBracket);
        STNode typeDesc = this.parseComplexTypeDescriptor(tupleType, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
        this.endContext();
        if (!isRoot) {
            return typeDesc;
        }
        STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT, true);
        this.switchContext(ParserRuleContext.VAR_DECL_STMT);
        return this.parseVarDeclRhs(annots, new ArrayList<STNode>(), typedBindingPattern, false);
    }

    private STNode parseAsListBindingPattern(STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        memberList = this.getBindingPatternsList(memberList, true);
        memberList.add(this.getBindingPattern(member, true));
        this.switchContext(ParserRuleContext.LIST_BINDING_PATTERN);
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, member, memberList);
        this.endContext();
        if (!isRoot) {
            return listBindingPattern;
        }
        return this.parseAssignmentStmtRhs(listBindingPattern);
    }

    private STNode parseAsListBindingPattern(STNode openBracket, List<STNode> memberList) {
        memberList = this.getBindingPatternsList(memberList, true);
        this.switchContext(ParserRuleContext.LIST_BINDING_PATTERN);
        STNode listBindingPattern = this.parseListBindingPattern(openBracket, memberList);
        this.endContext();
        return listBindingPattern;
    }

    private STNode parseAsListBindingPatternOrListConstructor(STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        STNode listBindingPatternOrListCons;
        memberList.add(member);
        STNode memberEnd = this.parseBracketedListMemberEnd();
        if (memberEnd == null) {
            STNode closeBracket = this.parseCloseBracket();
            listBindingPatternOrListCons = this.parseListBindingPatternOrListConstructor(openBracket, memberList, closeBracket, isRoot);
        } else {
            memberList.add(memberEnd);
            listBindingPatternOrListCons = this.parseListBindingPatternOrListConstructor(openBracket, memberList, isRoot);
        }
        return listBindingPatternOrListCons;
    }

    private SyntaxKind getStmtStartBracketedListType(STNode memberNode) {
        if (memberNode.kind.compareTo(SyntaxKind.RECORD_TYPE_DESC) >= 0 && memberNode.kind.compareTo(SyntaxKind.FUTURE_TYPE_DESC) <= 0) {
            return SyntaxKind.TUPLE_TYPE_DESC;
        }
        return switch (memberNode.kind) {
            case SyntaxKind.LIST_BINDING_PATTERN, SyntaxKind.MAPPING_BINDING_PATTERN, SyntaxKind.ERROR_BINDING_PATTERN, SyntaxKind.WILDCARD_BINDING_PATTERN, SyntaxKind.CAPTURE_BINDING_PATTERN -> SyntaxKind.LIST_BINDING_PATTERN;
            case SyntaxKind.QUALIFIED_NAME_REFERENCE -> SyntaxKind.TUPLE_TYPE_DESC;
            case SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.MAPPING_CONSTRUCTOR, SyntaxKind.SPREAD_MEMBER -> SyntaxKind.LIST_CONSTRUCTOR;
            case SyntaxKind.REST_BINDING_PATTERN, SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR -> SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR;
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.BRACKETED_LIST -> SyntaxKind.NONE;
            case SyntaxKind.ERROR_CONSTRUCTOR -> {
                if (this.isPossibleErrorBindingPattern((STErrorConstructorExpressionNode)memberNode)) {
                    yield SyntaxKind.NONE;
                }
                yield SyntaxKind.LIST_CONSTRUCTOR;
            }
            case SyntaxKind.INDEXED_EXPRESSION -> SyntaxKind.TUPLE_TYPE_DESC_OR_LIST_CONST;
            case SyntaxKind.MEMBER_TYPE_DESC -> SyntaxKind.MEMBER_TYPE_DESC;
            case SyntaxKind.REST_TYPE -> SyntaxKind.REST_TYPE;
            default -> this.isExpression(memberNode.kind) && !this.isAllBasicLiterals(memberNode) && !this.isAmbiguous(memberNode) ? SyntaxKind.LIST_CONSTRUCTOR : SyntaxKind.NONE;
        };
    }

    private boolean isPossibleErrorBindingPattern(STErrorConstructorExpressionNode errorConstructor) {
        STNode args = errorConstructor.arguments;
        int size = args.bucketCount();
        for (int i = 0; i < size; ++i) {
            STNode arg = args.childInBucket(i);
            if (arg.kind != SyntaxKind.NAMED_ARG && arg.kind != SyntaxKind.POSITIONAL_ARG && arg.kind != SyntaxKind.REST_ARG || this.isPosibleArgBindingPattern((STFunctionArgumentNode)arg)) continue;
            return false;
        }
        return true;
    }

    private boolean isPosibleArgBindingPattern(STFunctionArgumentNode arg) {
        return switch (arg.kind) {
            case SyntaxKind.POSITIONAL_ARG -> this.isPosibleBindingPattern(((STPositionalArgumentNode)arg).expression);
            case SyntaxKind.NAMED_ARG -> this.isPosibleBindingPattern(((STNamedArgumentNode)arg).expression);
            case SyntaxKind.REST_ARG -> {
                if (((STRestArgumentNode)arg).expression.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isPosibleBindingPattern(STNode node) {
        switch (node.kind) {
            case SIMPLE_NAME_REFERENCE: {
                return true;
            }
            case LIST_CONSTRUCTOR: {
                STListConstructorExpressionNode listConstructor = (STListConstructorExpressionNode)node;
                for (int i = 0; i < listConstructor.bucketCount(); ++i) {
                    STNode expr = listConstructor.childInBucket(i);
                    if (this.isPosibleBindingPattern(expr)) continue;
                    return false;
                }
                return true;
            }
            case MAPPING_CONSTRUCTOR: {
                STMappingConstructorExpressionNode mappingConstructor = (STMappingConstructorExpressionNode)node;
                for (int i = 0; i < mappingConstructor.bucketCount(); ++i) {
                    STNode expr = mappingConstructor.childInBucket(i);
                    if (this.isPosibleBindingPattern(expr)) continue;
                    return false;
                }
                return true;
            }
            case SPECIFIC_FIELD: {
                STSpecificFieldNode specificField = (STSpecificFieldNode)node;
                if (specificField.readonlyKeyword != null) {
                    return false;
                }
                if (specificField.valueExpr == null) {
                    return true;
                }
                return this.isPosibleBindingPattern(specificField.valueExpr);
            }
            case ERROR_CONSTRUCTOR: {
                return this.isPossibleErrorBindingPattern((STErrorConstructorExpressionNode)node);
            }
        }
        return false;
    }

    private STNode parseStatementStartBracketedListRhs(STNode annots, STNode openBracket, List<STNode> members, STNode closeBracket, boolean isRoot, boolean possibleMappingField) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EQUAL_TOKEN: {
                if (!isRoot) {
                    this.endContext();
                    return new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
                }
                STNode memberBindingPatterns = STNodeFactory.createNodeList(this.getBindingPatternsList(members, true));
                STNode listBindingPattern = STNodeFactory.createListBindingPatternNode(openBracket, memberBindingPatterns, closeBracket);
                this.endContext();
                this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                return this.parseAssignmentStmtRhs(listBindingPattern);
            }
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                if (!isRoot) {
                    this.endContext();
                    return new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
                }
                if (members.isEmpty()) {
                    openBracket = SyntaxErrors.addDiagnostic(openBracket, DiagnosticErrorCode.ERROR_MISSING_TUPLE_MEMBER, new Object[0]);
                }
                this.switchContext(ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN);
                this.startContext(ParserRuleContext.TUPLE_MEMBERS);
                STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTupleMemberList(members));
                STNode tupleTypeDesc = STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDescs, closeBracket);
                this.endContext();
                STNode typeDesc = this.parseComplexTypeDescriptor(tupleTypeDesc, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
                STNode typedBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
                this.endContext();
                return this.parseStmtStartsWithTypedBPOrExprRhs(annots, typedBindingPattern);
            }
            case OPEN_BRACKET_TOKEN: {
                if (!isRoot) {
                    STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTupleMemberList(members));
                    STNode tupleTypeDesc = STNodeFactory.createTupleTypeDescriptorNode(openBracket, memberTypeDescs, closeBracket);
                    this.endContext();
                    STNode typeDesc = this.parseComplexTypeDescriptor(tupleTypeDesc, ParserRuleContext.TYPE_DESC_IN_TUPLE, false);
                    return typeDesc;
                }
                STAmbiguousCollectionNode list = new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
                this.endContext();
                STNode tpbOrExpr = this.parseTypedBindingPatternOrExprRhs(list, true);
                return this.parseStmtStartsWithTypedBPOrExprRhs(annots, tpbOrExpr);
            }
            case COLON_TOKEN: {
                if (!possibleMappingField || members.size() != 1) break;
                this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
                STNode colon = this.parseColon();
                STNode fieldNameExpr = this.getExpression(members.get(0));
                STNode valueExpr = this.parseExpression();
                return STNodeFactory.createComputedNameFieldNode(openBracket, fieldNameExpr, closeBracket, colon, valueExpr);
            }
        }
        this.endContext();
        if (!isRoot) {
            return new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
        }
        STAmbiguousCollectionNode list = new STAmbiguousCollectionNode(SyntaxKind.BRACKETED_LIST, openBracket, members, closeBracket);
        STNode exprOrTPB = this.parseTypedBindingPatternOrExprRhs(list, false);
        return this.parseStmtStartsWithTypedBPOrExprRhs(annots, exprOrTPB);
    }

    private boolean isWildcardBP(STNode node) {
        return switch (node.kind) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE -> {
                STToken nameToken = (STToken)((STSimpleNameReferenceNode)node).name;
                yield this.isUnderscoreToken(nameToken);
            }
            case SyntaxKind.IDENTIFIER_TOKEN -> this.isUnderscoreToken((STToken)node);
            default -> false;
        };
    }

    private boolean isUnderscoreToken(STToken token) {
        return "_".equals(token.text());
    }

    private STNode getWildcardBindingPattern(STNode identifier) {
        switch (identifier.kind) {
            case SIMPLE_NAME_REFERENCE: {
                STNode varName = ((STSimpleNameReferenceNode)identifier).name;
                STToken underscore = this.getUnderscoreKeyword((STToken)varName);
                return STNodeFactory.createWildcardBindingPatternNode(underscore);
            }
            case IDENTIFIER_TOKEN: {
                STToken underscore = this.getUnderscoreKeyword((STToken)identifier);
                return STNodeFactory.createWildcardBindingPatternNode(underscore);
            }
        }
        throw new IllegalStateException();
    }

    private STNode parseStatementStartsWithOpenBrace() {
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode openBrace = this.parseOpenBrace();
        if (this.peek().kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            STNode closeBrace = this.parseCloseBrace();
            switch (this.peek().kind) {
                case EQUAL_TOKEN: {
                    this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                    STNode fields = STNodeFactory.createEmptyNodeList();
                    STNode bindingPattern = STNodeFactory.createMappingBindingPatternNode(openBrace, fields, closeBrace);
                    return this.parseAssignmentStmtRhs(bindingPattern);
                }
                case RIGHT_ARROW_TOKEN: 
                case SYNC_SEND_TOKEN: {
                    this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                    STNode fields = STNodeFactory.createEmptyNodeList();
                    STNode expr = STNodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
                    expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
                    return this.parseStatementStartWithExprRhs(expr);
                }
            }
            STNode statements = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return STNodeFactory.createBlockStatementNode(openBrace, statements, closeBrace);
        }
        STNode member = this.parseStatementStartingBracedListFirstMember(openBrace.isMissing());
        SyntaxKind nodeType = this.getBracedListType(member);
        switch (nodeType) {
            case MAPPING_BINDING_PATTERN: {
                return this.parseStmtAsMappingBindingPatternStart(openBrace, member);
            }
            case MAPPING_CONSTRUCTOR: {
                return this.parseStmtAsMappingConstructorStart(openBrace, member);
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                return this.parseStmtAsMappingBPOrMappingConsStart(openBrace, member);
            }
            case BLOCK_STATEMENT: {
                STNode closeBrace = this.parseCloseBrace();
                STNode stmt = STNodeFactory.createBlockStatementNode(openBrace, member, closeBrace);
                this.endContext();
                return stmt;
            }
        }
        ArrayList<STNode> stmts = new ArrayList<STNode>();
        stmts.add(member);
        STNode statements = this.parseStatements(stmts);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createBlockStatementNode(openBrace, statements, closeBrace);
    }

    private STNode parseStmtAsMappingBindingPatternStart(STNode openBrace, STNode firstMappingField) {
        this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
        this.startContext(ParserRuleContext.MAPPING_BINDING_PATTERN);
        ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
        if (firstMappingField.kind != SyntaxKind.REST_BINDING_PATTERN) {
            bindingPatterns.add(this.getBindingPattern(firstMappingField, false));
        }
        STNode mappingBP = this.parseMappingBindingPattern(openBrace, bindingPatterns, firstMappingField);
        return this.parseAssignmentStmtRhs(mappingBP);
    }

    private STNode parseStmtAsMappingConstructorStart(STNode openBrace, STNode firstMember) {
        this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
        this.startContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
        ArrayList<STNode> members = new ArrayList<STNode>();
        STNode mappingCons = this.parseAsMappingConstructor(openBrace, members, firstMember);
        STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, mappingCons, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseAsMappingConstructor(STNode openBrace, List<STNode> members, STNode member) {
        members.add(member);
        members = this.getExpressionList(members, true);
        this.switchContext(ParserRuleContext.MAPPING_CONSTRUCTOR);
        STNode fields = this.parseMappingConstructorFields(members);
        STNode closeBrace = this.parseCloseBrace();
        this.endContext();
        return STNodeFactory.createMappingConstructorExpressionNode(openBrace, fields, closeBrace);
    }

    private STNode parseStmtAsMappingBPOrMappingConsStart(STNode openBrace, STNode member) {
        STNode expr;
        STNode bpOrConstructor;
        this.startContext(ParserRuleContext.MAPPING_BP_OR_MAPPING_CONSTRUCTOR);
        ArrayList<STNode> members = new ArrayList<STNode>();
        members.add(member);
        STNode memberEnd = this.parseMappingFieldEnd();
        if (memberEnd == null) {
            STNode closeBrace = this.parseCloseBrace();
            bpOrConstructor = this.parseMappingBindingPatternOrMappingConstructor(openBrace, members, closeBrace);
        } else {
            members.add(memberEnd);
            bpOrConstructor = this.parseMappingBindingPatternOrMappingConstructor(openBrace, members);
        }
        switch (bpOrConstructor.kind) {
            case MAPPING_CONSTRUCTOR: {
                this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, bpOrConstructor, false, true);
                return this.parseStatementStartWithExprRhs(expr);
            }
            case MAPPING_BINDING_PATTERN: {
                this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
                STNode bindingPattern = this.getBindingPattern(bpOrConstructor, false);
                return this.parseAssignmentStmtRhs(bindingPattern);
            }
        }
        if (this.peek().kind == SyntaxKind.EQUAL_TOKEN) {
            this.switchContext(ParserRuleContext.ASSIGNMENT_STMT);
            STNode bindingPattern = this.getBindingPattern(bpOrConstructor, false);
            return this.parseAssignmentStmtRhs(bindingPattern);
        }
        this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
        expr = this.getExpression(bpOrConstructor);
        expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, false, true);
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseStatementStartingBracedListFirstMember(boolean isOpenBraceMissing) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case READONLY_KEYWORD: {
                STNode readonlyKeyword = this.parseReadonlyKeyword();
                return this.bracedListMemberStartsWithReadonly(readonlyKeyword);
            }
            case IDENTIFIER_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return this.parseIdentifierRhsInStmtStartingBrace(readonlyKeyword);
            }
            case STRING_LITERAL_TOKEN: {
                STNode key = this.parseStringLiteral();
                if (this.peek().kind == SyntaxKind.COLON_TOKEN) {
                    STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                    STNode colon = this.parseColon();
                    STNode valueExpr = this.parseExpression();
                    return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
                }
                this.switchContext(ParserRuleContext.BLOCK_STMT);
                this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
                STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, key, false, true);
                return this.parseStatementStartWithExprRhs(expr);
            }
            case OPEN_BRACKET_TOKEN: {
                STNode annots = STNodeFactory.createEmptyNodeList();
                return this.parseStatementStartsWithOpenBracket(annots, true);
            }
            case OPEN_BRACE_TOKEN: {
                this.switchContext(ParserRuleContext.BLOCK_STMT);
                return this.parseStatementStartsWithOpenBrace();
            }
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingPattern();
            }
        }
        if (isOpenBraceMissing) {
            STNode readonlyKeyword = STNodeFactory.createEmptyNode();
            return this.parseIdentifierRhsInStmtStartingBrace(readonlyKeyword);
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        return this.parseStatements();
    }

    private STNode bracedListMemberStartsWithReadonly(STNode readonlyKeyword) {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case IDENTIFIER_TOKEN: {
                return this.parseIdentifierRhsInStmtStartingBrace(readonlyKeyword);
            }
            case STRING_LITERAL_TOKEN: {
                if (this.peek((int)2).kind != SyntaxKind.COLON_TOKEN) break;
                STNode key = this.parseStringLiteral();
                STNode colon = this.parseColon();
                STNode valueExpr = this.parseExpression();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        STNode typeDesc = BallerinaParser.createBuiltinSimpleNameReference(readonlyKeyword);
        return this.parseVarDeclTypeDescRhs(typeDesc, STNodeFactory.createEmptyNodeList(), new ArrayList<STNode>(), true, false);
    }

    private STNode parseIdentifierRhsInStmtStartingBrace(STNode readonlyKeyword) {
        STNode identifier = this.parseIdentifier(ParserRuleContext.VARIABLE_REF);
        switch (this.peek().kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                STNode colon = STNodeFactory.createEmptyNode();
                STNode value = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, value);
            }
            case COLON_TOKEN: {
                STNode colon = this.parseColon();
                if (!this.isEmpty(readonlyKeyword)) {
                    STNode value = this.parseExpression();
                    return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, value);
                }
                return switch (this.peek().kind) {
                    case SyntaxKind.OPEN_BRACKET_TOKEN -> {
                        STNode bindingPatternOrExpr = this.parseListBindingPatternOrListConstructor();
                        yield this.getMappingField(identifier, colon, bindingPatternOrExpr);
                    }
                    case SyntaxKind.OPEN_BRACE_TOKEN -> {
                        STNode bindingPatternOrExpr = this.parseMappingBindingPatterOrMappingConstructor();
                        yield this.getMappingField(identifier, colon, bindingPatternOrExpr);
                    }
                    case SyntaxKind.ERROR_KEYWORD -> {
                        STNode bindingPatternOrExpr = this.parseErrorBindingPatternOrErrorConstructor();
                        yield this.getMappingField(identifier, colon, bindingPatternOrExpr);
                    }
                    case SyntaxKind.IDENTIFIER_TOKEN -> this.parseQualifiedIdentifierRhsInStmtStartBrace(identifier, colon);
                    default -> {
                        STNode expr = this.parseExpression();
                        yield this.getMappingField(identifier, colon, expr);
                    }
                };
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        if (!this.isEmpty(readonlyKeyword)) {
            this.startContext(ParserRuleContext.VAR_DECL_STMT);
            STNode bindingPattern = STNodeFactory.createCaptureBindingPatternNode(identifier);
            STNode typedBindingPattern = STNodeFactory.createTypedBindingPatternNode(readonlyKeyword, bindingPattern);
            STNode annots = STNodeFactory.createEmptyNodeList();
            ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
            return this.parseVarDeclRhs(annots, varDeclQualifiers, typedBindingPattern, false);
        }
        this.startContext(ParserRuleContext.AMBIGUOUS_STMT);
        STNode qualifiedIdentifier = this.parseQualifiedIdentifier(identifier, false);
        STNode expr = this.parseTypedBindingPatternOrExprRhs(qualifiedIdentifier, true);
        STNode annots = STNodeFactory.createEmptyNodeList();
        return this.parseStmtStartsWithTypedBPOrExprRhs(annots, expr);
    }

    private STNode parseQualifiedIdentifierRhsInStmtStartBrace(STNode identifier, STNode colon) {
        STNode secondIdentifier = this.parseIdentifier(ParserRuleContext.VARIABLE_REF);
        STNode secondNameRef = STNodeFactory.createSimpleNameReferenceNode(secondIdentifier);
        if (this.isWildcardBP(secondIdentifier)) {
            STNode wildcardBP = this.getWildcardBindingPattern(secondIdentifier);
            STNode nameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
            return STNodeFactory.createFieldBindingPatternFullNode(nameRef, colon, wildcardBP);
        }
        STNode qualifiedNameRef = this.createQualifiedNameReferenceNode(identifier, colon, secondIdentifier);
        switch (this.peek().kind) {
            case COMMA_TOKEN: {
                return STNodeFactory.createSpecificFieldNode(STNodeFactory.createEmptyNode(), identifier, colon, secondNameRef);
            }
            case IDENTIFIER_TOKEN: 
            case OPEN_BRACE_TOKEN: {
                this.switchContext(ParserRuleContext.BLOCK_STMT);
                this.startContext(ParserRuleContext.VAR_DECL_STMT);
                ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
                STNode typeBindingPattern = this.parseTypedBindingPatternTypeRhs(qualifiedNameRef, ParserRuleContext.VAR_DECL_STMT);
                STNode annots = STNodeFactory.createEmptyNodeList();
                return this.parseVarDeclRhs(annots, varDeclQualifiers, typeBindingPattern, false);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseMemberRhsInStmtStartWithBrace(identifier, colon, secondIdentifier, secondNameRef);
            }
            case QUESTION_MARK_TOKEN: {
                STNode typeDesc = this.parseComplexTypeDescriptor(qualifiedNameRef, ParserRuleContext.TYPE_DESC_IN_TYPE_BINDING_PATTERN, true);
                ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
                STNode typeBindingPattern = this.parseTypedBindingPatternTypeRhs(typeDesc, ParserRuleContext.VAR_DECL_STMT);
                STNode annots = STNodeFactory.createEmptyNodeList();
                return this.parseVarDeclRhs(annots, varDeclQualifiers, typeBindingPattern, false);
            }
            case EQUAL_TOKEN: 
            case SEMICOLON_TOKEN: {
                return this.parseStatementStartWithExprRhs(qualifiedNameRef);
            }
        }
        return this.parseMemberWithExprInRhs(identifier, colon, secondIdentifier, secondNameRef);
    }

    private SyntaxKind getBracedListType(STNode member) {
        switch (member.kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case FIELD_BINDING_PATTERN: {
                return SyntaxKind.MAPPING_BINDING_PATTERN;
            }
            case SPECIFIC_FIELD: {
                STNode expr = ((STSpecificFieldNode)member).valueExpr;
                if (expr == null) {
                    return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                }
                return switch (expr.kind) {
                    case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR, SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR -> SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                    case SyntaxKind.ERROR_BINDING_PATTERN -> SyntaxKind.MAPPING_BINDING_PATTERN;
                    case SyntaxKind.ERROR_CONSTRUCTOR -> {
                        if (this.isPossibleErrorBindingPattern((STErrorConstructorExpressionNode)expr)) {
                            yield SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                        }
                        yield SyntaxKind.MAPPING_CONSTRUCTOR;
                    }
                    default -> SyntaxKind.MAPPING_CONSTRUCTOR;
                };
            }
            case SPREAD_FIELD: 
            case COMPUTED_NAME_FIELD: {
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case REST_BINDING_PATTERN: 
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: {
                return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
            }
            case LIST: {
                return SyntaxKind.BLOCK_STATEMENT;
            }
        }
        return SyntaxKind.NONE;
    }

    private STNode parseMappingBindingPatterOrMappingConstructor() {
        this.startContext(ParserRuleContext.MAPPING_BP_OR_MAPPING_CONSTRUCTOR);
        STNode openBrace = this.parseOpenBrace();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        return this.parseMappingBindingPatternOrMappingConstructor(openBrace, memberList);
    }

    private boolean isBracedListEnd(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.CLOSE_BRACE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseMappingBindingPatternOrMappingConstructor(STNode openBrace, List<STNode> memberList) {
        STToken nextToken = this.peek();
        while (!this.isBracedListEnd(nextToken.kind)) {
            STNode member = this.parseMappingBindingPatterOrMappingConstructorMember();
            SyntaxKind currentNodeType = this.getTypeOfMappingBPOrMappingCons(member);
            switch (currentNodeType) {
                case MAPPING_CONSTRUCTOR: {
                    return this.parseAsMappingConstructor(openBrace, memberList, member);
                }
                case MAPPING_BINDING_PATTERN: {
                    return this.parseAsMappingBindingPattern(openBrace, memberList, member);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseMappingFieldEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
            nextToken = this.peek();
        }
        STNode closeBrace = this.parseCloseBrace();
        return this.parseMappingBindingPatternOrMappingConstructor(openBrace, memberList, closeBrace);
    }

    private STNode parseMappingBindingPatterOrMappingConstructorMember() {
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode key = this.parseIdentifier(ParserRuleContext.MAPPING_FIELD_NAME);
                return this.parseMappingFieldRhs(key);
            }
            case STRING_LITERAL_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                STNode key = this.parseStringLiteral();
                STNode colon = this.parseColon();
                STNode valueExpr = this.parseExpression();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
            }
            case OPEN_BRACKET_TOKEN: {
                return this.parseComputedField();
            }
            case ELLIPSIS_TOKEN: {
                STNode ellipsis = this.parseEllipsis();
                STNode expr = this.parseExpression();
                if (expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    return STNodeFactory.createRestBindingPatternNode(ellipsis, expr);
                }
                return STNodeFactory.createSpreadFieldNode(ellipsis, expr);
            }
        }
        this.recover(this.peek(), ParserRuleContext.MAPPING_BP_OR_MAPPING_CONSTRUCTOR_MEMBER);
        return this.parseMappingBindingPatterOrMappingConstructorMember();
    }

    private STNode parseMappingFieldRhs(STNode key) {
        switch (this.peek().kind) {
            case COLON_TOKEN: {
                STNode colon = this.parseColon();
                return this.parseMappingFieldValue(key, colon);
            }
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                STNode colon = STNodeFactory.createEmptyNode();
                STNode valueExpr = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, valueExpr);
            }
        }
        STToken token = this.peek();
        this.recover(token, ParserRuleContext.FIELD_BINDING_PATTERN_END);
        STNode readonlyKeyword = STNodeFactory.createEmptyNode();
        return this.parseSpecificFieldRhs(readonlyKeyword, key);
    }

    private STNode parseMappingFieldValue(STNode key, STNode colon) {
        STNode expr;
        switch (this.peek().kind) {
            case IDENTIFIER_TOKEN: {
                STNode sTNode = this.parseExpression();
                break;
            }
            case OPEN_BRACKET_TOKEN: {
                STNode sTNode = this.parseListBindingPatternOrListConstructor();
                break;
            }
            case OPEN_BRACE_TOKEN: {
                STNode sTNode = this.parseMappingBindingPatterOrMappingConstructor();
                break;
            }
            default: {
                STNode sTNode = expr = this.parseExpression();
            }
        }
        if (this.isBindingPattern(expr.kind)) {
            key = STNodeFactory.createSimpleNameReferenceNode(key);
            return STNodeFactory.createFieldBindingPatternFullNode(key, colon, expr);
        }
        STNode readonlyKeyword = STNodeFactory.createEmptyNode();
        return STNodeFactory.createSpecificFieldNode(readonlyKeyword, key, colon, expr);
    }

    private boolean isBindingPattern(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.LIST_BINDING_PATTERN, SyntaxKind.MAPPING_BINDING_PATTERN, SyntaxKind.WILDCARD_BINDING_PATTERN, SyntaxKind.CAPTURE_BINDING_PATTERN, SyntaxKind.FIELD_BINDING_PATTERN -> true;
            default -> false;
        };
    }

    private SyntaxKind getTypeOfMappingBPOrMappingCons(STNode memberNode) {
        switch (memberNode.kind) {
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case FIELD_BINDING_PATTERN: {
                return SyntaxKind.MAPPING_BINDING_PATTERN;
            }
            case SPECIFIC_FIELD: {
                STNode expr = ((STSpecificFieldNode)memberNode).valueExpr;
                if (expr == null || expr.kind == SyntaxKind.SIMPLE_NAME_REFERENCE || expr.kind == SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR || expr.kind == SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR) {
                    return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
                }
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
            case SPREAD_FIELD: 
            case COMPUTED_NAME_FIELD: {
                return SyntaxKind.MAPPING_CONSTRUCTOR;
            }
        }
        return SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR;
    }

    private STNode parseMappingBindingPatternOrMappingConstructor(STNode openBrace, List<STNode> members, STNode closeBrace) {
        this.endContext();
        return new STAmbiguousCollectionNode(SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR, openBrace, members, closeBrace);
    }

    private STNode parseAsMappingBindingPattern(STNode openBrace, List<STNode> members, STNode member) {
        members.add(member);
        members = this.getBindingPatternsList(members, false);
        this.switchContext(ParserRuleContext.MAPPING_BINDING_PATTERN);
        return this.parseMappingBindingPattern(openBrace, members, member);
    }

    private STNode parseListBindingPatternOrListConstructor() {
        this.startContext(ParserRuleContext.BRACKETED_LIST);
        STNode openBracket = this.parseOpenBracket();
        ArrayList<STNode> memberList = new ArrayList<STNode>();
        return this.parseListBindingPatternOrListConstructor(openBracket, memberList, false);
    }

    private STNode parseListBindingPatternOrListConstructor(STNode openBracket, List<STNode> memberList, boolean isRoot) {
        STToken nextToken = this.peek();
        while (!this.isBracketedListEnd(nextToken.kind)) {
            STNode member = this.parseListBindingPatternOrListConstructorMember();
            SyntaxKind currentNodeType = this.getParsingNodeTypeOfListBPOrListCons(member);
            switch (currentNodeType) {
                case LIST_CONSTRUCTOR: {
                    return this.parseAsListConstructor(openBracket, memberList, member, isRoot);
                }
                case LIST_BINDING_PATTERN: {
                    return this.parseAsListBindingPattern(openBracket, memberList, member, isRoot);
                }
            }
            memberList.add(member);
            STNode memberEnd = this.parseBracketedListMemberEnd();
            if (memberEnd == null) break;
            memberList.add(memberEnd);
            nextToken = this.peek();
        }
        STNode closeBracket = this.parseCloseBracket();
        return this.parseListBindingPatternOrListConstructor(openBracket, memberList, closeBracket, isRoot);
    }

    private STNode parseListBindingPatternOrListConstructorMember() {
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case OPEN_BRACKET_TOKEN: {
                return this.parseListBindingPatternOrListConstructor();
            }
            case IDENTIFIER_TOKEN: {
                STNode identifier = this.parseQualifiedIdentifier(ParserRuleContext.VARIABLE_REF);
                if (this.isWildcardBP(identifier)) {
                    return this.getWildcardBindingPattern(identifier);
                }
                return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, identifier, false, false);
            }
            case OPEN_BRACE_TOKEN: {
                return this.parseMappingBindingPatterOrMappingConstructor();
            }
            case ELLIPSIS_TOKEN: {
                return this.parseRestBindingOrSpreadMember();
            }
        }
        if (this.isValidExpressionStart(nextToken.kind, 1)) {
            return this.parseExpression();
        }
        this.recover(this.peek(), ParserRuleContext.LIST_BP_OR_LIST_CONSTRUCTOR_MEMBER);
        return this.parseListBindingPatternOrListConstructorMember();
    }

    private SyntaxKind getParsingNodeTypeOfListBPOrListCons(STNode memberNode) {
        return switch (memberNode.kind) {
            case SyntaxKind.LIST_BINDING_PATTERN, SyntaxKind.MAPPING_BINDING_PATTERN, SyntaxKind.WILDCARD_BINDING_PATTERN, SyntaxKind.CAPTURE_BINDING_PATTERN -> SyntaxKind.LIST_BINDING_PATTERN;
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.REST_BINDING_PATTERN, SyntaxKind.MAPPING_BP_OR_MAPPING_CONSTRUCTOR, SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR -> SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR;
            default -> SyntaxKind.LIST_CONSTRUCTOR;
        };
    }

    private STNode parseAsListConstructor(STNode openBracket, List<STNode> memberList, STNode member, boolean isRoot) {
        memberList.add(member);
        memberList = this.getExpressionList(memberList, false);
        this.switchContext(ParserRuleContext.LIST_CONSTRUCTOR);
        STNode listMembers = this.parseListMembers(memberList);
        STNode closeBracket = this.parseCloseBracket();
        STNode listConstructor = STNodeFactory.createListConstructorExpressionNode(openBracket, listMembers, closeBracket);
        this.endContext();
        STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, listConstructor, false, true);
        if (!isRoot) {
            return expr;
        }
        return this.parseStatementStartWithExprRhs(expr);
    }

    private STNode parseListBindingPatternOrListConstructor(STNode openBracket, List<STNode> members, STNode closeBracket, boolean isRoot) {
        STNode lbpOrListCons;
        switch (this.peek().kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: 
            case CLOSE_BRACKET_TOKEN: {
                if (isRoot) break;
                this.endContext();
                return new STAmbiguousCollectionNode(SyntaxKind.LIST_BP_OR_LIST_CONSTRUCTOR, openBracket, members, closeBracket);
            }
        }
        SyntaxKind nextTokenKind = this.peek().kind;
        if (this.isValidExprRhsStart(nextTokenKind, closeBracket.kind) || nextTokenKind == SyntaxKind.SEMICOLON_TOKEN && isRoot) {
            members = this.getExpressionList(members, false);
            STNode memberExpressions = STNodeFactory.createNodeList(members);
            lbpOrListCons = STNodeFactory.createListConstructorExpressionNode(openBracket, memberExpressions, closeBracket);
            lbpOrListCons = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, lbpOrListCons, false, true);
        } else {
            members = this.getBindingPatternsList(members, true);
            STNode bindingPatternsNode = STNodeFactory.createNodeList(members);
            lbpOrListCons = STNodeFactory.createListBindingPatternNode(openBracket, bindingPatternsNode, closeBracket);
        }
        this.endContext();
        if (!isRoot) {
            return lbpOrListCons;
        }
        if (lbpOrListCons.kind == SyntaxKind.LIST_BINDING_PATTERN) {
            return this.parseAssignmentStmtRhs(lbpOrListCons);
        }
        return this.parseStatementStartWithExprRhs(lbpOrListCons);
    }

    private STNode parseMemberRhsInStmtStartWithBrace(STNode identifier, STNode colon, STNode secondIdentifier, STNode secondNameRef) {
        STNode typedBPOrExpr = this.parseTypedBindingPatternOrMemberAccess(secondNameRef, false, true, ParserRuleContext.AMBIGUOUS_STMT);
        if (this.isExpression(typedBPOrExpr.kind)) {
            return this.parseMemberWithExprInRhs(identifier, colon, secondIdentifier, typedBPOrExpr);
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        this.startContext(ParserRuleContext.VAR_DECL_STMT);
        ArrayList<STNode> varDeclQualifiers = new ArrayList<STNode>();
        STNode annots = STNodeFactory.createEmptyNodeList();
        STTypedBindingPatternNode typedBP = (STTypedBindingPatternNode)typedBPOrExpr;
        STNode qualifiedNameRef = this.createQualifiedNameReferenceNode(identifier, colon, secondIdentifier);
        STNode newTypeDesc = this.mergeQualifiedNameWithTypeDesc(qualifiedNameRef, typedBP.typeDescriptor);
        STNode newTypeBP = STNodeFactory.createTypedBindingPatternNode(newTypeDesc, typedBP.bindingPattern);
        STNode publicQualifier = STNodeFactory.createEmptyNode();
        return this.parseVarDeclRhs(annots, publicQualifier, varDeclQualifiers, newTypeBP, false);
    }

    private STNode parseMemberWithExprInRhs(STNode identifier, STNode colon, STNode secondIdentifier, STNode memberAccessExpr) {
        STNode expr = this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, memberAccessExpr, false, true);
        switch (this.peek().kind) {
            case COMMA_TOKEN: 
            case CLOSE_BRACE_TOKEN: {
                this.switchContext(ParserRuleContext.EXPRESSION_STATEMENT);
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                return STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, expr);
            }
        }
        this.switchContext(ParserRuleContext.BLOCK_STMT);
        this.startContext(ParserRuleContext.EXPRESSION_STATEMENT);
        STNode qualifiedName = this.createQualifiedNameReferenceNode(identifier, colon, secondIdentifier);
        STNode updatedExpr = this.mergeQualifiedNameWithExpr(qualifiedName, expr);
        return this.parseStatementStartWithExprRhs(updatedExpr);
    }

    private STNode parseInferredTypeDescDefaultOrExpression() {
        STToken nextToken = this.peek();
        SyntaxKind nextTokenKind = nextToken.kind;
        if (nextTokenKind == SyntaxKind.LT_TOKEN) {
            return this.parseInferredTypeDescDefaultOrExpression(this.consume());
        }
        if (this.isValidExprStart(nextTokenKind)) {
            return this.parseExpression();
        }
        this.recover(nextToken, ParserRuleContext.EXPR_START_OR_INFERRED_TYPEDESC_DEFAULT_START);
        return this.parseInferredTypeDescDefaultOrExpression();
    }

    private STNode parseInferredTypeDescDefaultOrExpression(STToken ltToken) {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.GT_TOKEN) {
            return STNodeFactory.createInferredTypedescDefaultNode(ltToken, this.consume());
        }
        if (this.isTypeStartingToken(nextToken.kind) || nextToken.kind == SyntaxKind.AT_TOKEN) {
            this.startContext(ParserRuleContext.TYPE_CAST);
            STNode expr = this.parseTypeCastExpr(ltToken, true, false, false);
            return this.parseExpressionRhs(DEFAULT_OP_PRECEDENCE, expr, true, false);
        }
        this.recover(nextToken, ParserRuleContext.TYPE_CAST_PARAM_START_OR_INFERRED_TYPEDESC_DEFAULT_END);
        return this.parseInferredTypeDescDefaultOrExpression(ltToken);
    }

    private STNode mergeQualifiedNameWithExpr(STNode qualifiedName, STNode exprOrAction) {
        switch (exprOrAction.kind) {
            case SIMPLE_NAME_REFERENCE: {
                return qualifiedName;
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, binaryExpr.lhsExpr);
                return STNodeFactory.createBinaryExpressionNode(binaryExpr.kind, newLhsExpr, binaryExpr.operator, binaryExpr.rhsExpr);
            }
            case FIELD_ACCESS: {
                STFieldAccessExpressionNode fieldAccess = (STFieldAccessExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, fieldAccess.expression);
                return STNodeFactory.createFieldAccessExpressionNode(newLhsExpr, fieldAccess.dotToken, fieldAccess.fieldName);
            }
            case INDEXED_EXPRESSION: {
                STIndexedExpressionNode memberAccess = (STIndexedExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, memberAccess.containerExpression);
                return STNodeFactory.createIndexedExpressionNode(newLhsExpr, memberAccess.openBracket, memberAccess.keyExpression, memberAccess.closeBracket);
            }
            case TYPE_TEST_EXPRESSION: {
                STTypeTestExpressionNode typeTest = (STTypeTestExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, typeTest.expression);
                return STNodeFactory.createTypeTestExpressionNode(newLhsExpr, typeTest.isKeyword, typeTest.typeDescriptor);
            }
            case ANNOT_ACCESS: {
                STAnnotAccessExpressionNode annotAccess = (STAnnotAccessExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, annotAccess.expression);
                return STNodeFactory.createFieldAccessExpressionNode(newLhsExpr, annotAccess.annotChainingToken, annotAccess.annotTagReference);
            }
            case OPTIONAL_FIELD_ACCESS: {
                STOptionalFieldAccessExpressionNode optionalFieldAccess = (STOptionalFieldAccessExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, optionalFieldAccess.expression);
                return STNodeFactory.createFieldAccessExpressionNode(newLhsExpr, optionalFieldAccess.optionalChainingToken, optionalFieldAccess.fieldName);
            }
            case CONDITIONAL_EXPRESSION: {
                STConditionalExpressionNode conditionalExpr = (STConditionalExpressionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, conditionalExpr.lhsExpression);
                return STNodeFactory.createConditionalExpressionNode(newLhsExpr, conditionalExpr.questionMarkToken, conditionalExpr.middleExpression, conditionalExpr.colonToken, conditionalExpr.endExpression);
            }
            case REMOTE_METHOD_CALL_ACTION: {
                STRemoteMethodCallActionNode remoteCall = (STRemoteMethodCallActionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, remoteCall.expression);
                return STNodeFactory.createRemoteMethodCallActionNode(newLhsExpr, remoteCall.rightArrowToken, remoteCall.methodName, remoteCall.openParenToken, remoteCall.arguments, remoteCall.closeParenToken);
            }
            case ASYNC_SEND_ACTION: {
                STAsyncSendActionNode asyncSend = (STAsyncSendActionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, asyncSend.expression);
                return STNodeFactory.createAsyncSendActionNode(newLhsExpr, asyncSend.rightArrowToken, asyncSend.peerWorker);
            }
            case SYNC_SEND_ACTION: {
                STSyncSendActionNode syncSend = (STSyncSendActionNode)exprOrAction;
                STNode newLhsExpr = this.mergeQualifiedNameWithExpr(qualifiedName, syncSend.expression);
                return STNodeFactory.createAsyncSendActionNode(newLhsExpr, syncSend.syncSendToken, syncSend.peerWorker);
            }
            case FUNCTION_CALL: {
                STFunctionCallExpressionNode funcCall = (STFunctionCallExpressionNode)exprOrAction;
                return STNodeFactory.createFunctionCallExpressionNode(qualifiedName, funcCall.openParenToken, funcCall.arguments, funcCall.closeParenToken);
            }
        }
        return exprOrAction;
    }

    private STNode mergeQualifiedNameWithTypeDesc(STNode qualifiedName, STNode typeDesc) {
        switch (typeDesc.kind) {
            case SIMPLE_NAME_REFERENCE: {
                return qualifiedName;
            }
            case ARRAY_TYPE_DESC: {
                STArrayTypeDescriptorNode arrayTypeDesc = (STArrayTypeDescriptorNode)typeDesc;
                STNode newMemberType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, arrayTypeDesc.memberTypeDesc);
                return STNodeFactory.createArrayTypeDescriptorNode(newMemberType, arrayTypeDesc.dimensions);
            }
            case UNION_TYPE_DESC: {
                STUnionTypeDescriptorNode unionTypeDesc = (STUnionTypeDescriptorNode)typeDesc;
                STNode newlhsType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, unionTypeDesc.leftTypeDesc);
                return this.mergeTypesWithUnion(newlhsType, unionTypeDesc.pipeToken, unionTypeDesc.rightTypeDesc);
            }
            case INTERSECTION_TYPE_DESC: {
                STIntersectionTypeDescriptorNode intersectionTypeDesc = (STIntersectionTypeDescriptorNode)typeDesc;
                STNode newlhsType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, intersectionTypeDesc.leftTypeDesc);
                return this.mergeTypesWithIntersection(newlhsType, intersectionTypeDesc.bitwiseAndToken, intersectionTypeDesc.rightTypeDesc);
            }
            case OPTIONAL_TYPE_DESC: {
                STOptionalTypeDescriptorNode optionalType = (STOptionalTypeDescriptorNode)typeDesc;
                STNode newMemberType = this.mergeQualifiedNameWithTypeDesc(qualifiedName, optionalType.typeDescriptor);
                return STNodeFactory.createOptionalTypeDescriptorNode(newMemberType, optionalType.questionMarkToken);
            }
        }
        return typeDesc;
    }

    private List<STNode> getTupleMemberList(List<STNode> ambiguousList) {
        ArrayList<STNode> tupleMemberList = new ArrayList<STNode>();
        for (STNode item : ambiguousList) {
            if (item.kind == SyntaxKind.COMMA_TOKEN) {
                tupleMemberList.add(item);
                continue;
            }
            tupleMemberList.add(STNodeFactory.createMemberTypeDescriptorNode(STNodeFactory.createEmptyNodeList(), this.getTypeDescFromExpr(item)));
        }
        return tupleMemberList;
    }

    private STNode getTypeDescFromExpr(STNode expression) {
        if (this.isDefiniteTypeDesc(expression.kind) || expression.kind == SyntaxKind.COMMA_TOKEN) {
            return expression;
        }
        switch (expression.kind) {
            case INDEXED_EXPRESSION: {
                return this.parseArrayTypeDescriptorNode((STIndexedExpressionNode)expression);
            }
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case BOOLEAN_LITERAL: 
            case UNARY_EXPRESSION: {
                return STNodeFactory.createSingletonTypeDescriptorNode(expression);
            }
            case TYPE_REFERENCE_TYPE_DESC: {
                return ((STTypeReferenceTypeDescNode)expression).typeRef;
            }
            case BRACED_EXPRESSION: {
                STBracedExpressionNode bracedExpr = (STBracedExpressionNode)expression;
                STNode typeDesc = this.getTypeDescFromExpr(bracedExpr.expression);
                return STNodeFactory.createParenthesisedTypeDescriptorNode(bracedExpr.openParen, typeDesc, bracedExpr.closeParen);
            }
            case NIL_LITERAL: {
                STNilLiteralNode nilLiteral = (STNilLiteralNode)expression;
                return STNodeFactory.createNilTypeDescriptorNode(nilLiteral.openParenToken, nilLiteral.closeParenToken);
            }
            case BRACKETED_LIST: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: 
            case TUPLE_TYPE_DESC_OR_LIST_CONST: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)expression;
                STNode memberTypeDescs = STNodeFactory.createNodeList(this.getTupleMemberList(innerList.members));
                return STNodeFactory.createTupleTypeDescriptorNode(innerList.collectionStartToken, memberTypeDescs, innerList.collectionEndToken);
            }
            case BINARY_EXPRESSION: {
                STBinaryExpressionNode binaryExpr = (STBinaryExpressionNode)expression;
                switch (binaryExpr.operator.kind) {
                    case PIPE_TOKEN: 
                    case BITWISE_AND_TOKEN: {
                        STNode lhsTypeDesc = this.getTypeDescFromExpr(binaryExpr.lhsExpr);
                        STNode rhsTypeDesc = this.getTypeDescFromExpr(binaryExpr.rhsExpr);
                        return this.mergeTypes(lhsTypeDesc, binaryExpr.operator, rhsTypeDesc);
                    }
                }
                return expression;
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: {
                return expression;
            }
        }
        STNode simpleTypeDescIdentifier = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_TYPE_DESC);
        simpleTypeDescIdentifier = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(simpleTypeDescIdentifier, expression);
        return STNodeFactory.createSimpleNameReferenceNode(simpleTypeDescIdentifier);
    }

    private List<STNode> getBindingPatternsList(List<STNode> ambibuousList, boolean isListBP) {
        ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
        for (STNode item : ambibuousList) {
            bindingPatterns.add(this.getBindingPattern(item, isListBP));
        }
        return bindingPatterns;
    }

    private STNode getBindingPattern(STNode ambiguousNode, boolean isListBP) {
        DiagnosticErrorCode errorCode = DiagnosticErrorCode.ERROR_INVALID_BINDING_PATTERN;
        if (this.isEmpty(ambiguousNode)) {
            return null;
        }
        switch (ambiguousNode.kind) {
            case COMMA_TOKEN: 
            case LIST_BINDING_PATTERN: 
            case MAPPING_BINDING_PATTERN: 
            case ERROR_BINDING_PATTERN: 
            case WILDCARD_BINDING_PATTERN: 
            case CAPTURE_BINDING_PATTERN: 
            case REST_BINDING_PATTERN: 
            case NAMED_ARG_BINDING_PATTERN: 
            case FIELD_BINDING_PATTERN: {
                return ambiguousNode;
            }
            case SIMPLE_NAME_REFERENCE: {
                STNode varName = ((STSimpleNameReferenceNode)ambiguousNode).name;
                return this.createCaptureOrWildcardBP(varName);
            }
            case QUALIFIED_NAME_REFERENCE: {
                if (isListBP) {
                    errorCode = DiagnosticErrorCode.ERROR_FIELD_BP_INSIDE_LIST_BP;
                    break;
                }
                STQualifiedNameReferenceNode qualifiedName = (STQualifiedNameReferenceNode)ambiguousNode;
                STNode fieldName = STNodeFactory.createSimpleNameReferenceNode(qualifiedName.modulePrefix);
                return STNodeFactory.createFieldBindingPatternFullNode(fieldName, qualifiedName.colon, this.createCaptureOrWildcardBP(qualifiedName.identifier));
            }
            case BRACKETED_LIST: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                STNode memberBindingPatterns = STNodeFactory.createNodeList(this.getBindingPatternsList(innerList.members, true));
                return STNodeFactory.createListBindingPatternNode(innerList.collectionStartToken, memberBindingPatterns, innerList.collectionEndToken);
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
                for (int i = 0; i < innerList.members.size(); ++i) {
                    STNode bp = this.getBindingPattern(innerList.members.get(i), false);
                    bindingPatterns.add(bp);
                    if (bp.kind == SyntaxKind.REST_BINDING_PATTERN) break;
                }
                STNode memberBindingPatterns = STNodeFactory.createNodeList(bindingPatterns);
                return STNodeFactory.createMappingBindingPatternNode(innerList.collectionStartToken, memberBindingPatterns, innerList.collectionEndToken);
            }
            case SPECIFIC_FIELD: {
                STSpecificFieldNode field = (STSpecificFieldNode)ambiguousNode;
                STNode fieldName = STNodeFactory.createSimpleNameReferenceNode(field.fieldName);
                if (field.valueExpr == null) {
                    return STNodeFactory.createFieldBindingPatternVarnameNode(fieldName);
                }
                return STNodeFactory.createFieldBindingPatternFullNode(fieldName, field.colon, this.getBindingPattern(field.valueExpr, false));
            }
            case ERROR_CONSTRUCTOR: {
                STErrorConstructorExpressionNode errorCons = (STErrorConstructorExpressionNode)ambiguousNode;
                STNode args = errorCons.arguments;
                int size = args.bucketCount();
                ArrayList<STNode> bindingPatterns = new ArrayList<STNode>();
                for (int i = 0; i < size; ++i) {
                    STNode arg = args.childInBucket(i);
                    bindingPatterns.add(this.getBindingPattern(arg, false));
                }
                STNode argListBindingPatterns = STNodeFactory.createNodeList(bindingPatterns);
                return STNodeFactory.createErrorBindingPatternNode(errorCons.errorKeyword, errorCons.typeReference, errorCons.openParenToken, argListBindingPatterns, errorCons.closeParenToken);
            }
            case POSITIONAL_ARG: {
                STPositionalArgumentNode positionalArg = (STPositionalArgumentNode)ambiguousNode;
                return this.getBindingPattern(positionalArg.expression, false);
            }
            case NAMED_ARG: {
                STNamedArgumentNode namedArg = (STNamedArgumentNode)ambiguousNode;
                STNode bindingPatternArgName = ((STSimpleNameReferenceNode)namedArg.argumentName).name;
                return STNodeFactory.createNamedArgBindingPatternNode(bindingPatternArgName, namedArg.equalsToken, this.getBindingPattern(namedArg.expression, false));
            }
            case REST_ARG: {
                STRestArgumentNode restArg = (STRestArgumentNode)ambiguousNode;
                return STNodeFactory.createRestBindingPatternNode(restArg.ellipsis, restArg.expression);
            }
        }
        STNode identifier = SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN);
        identifier = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(identifier, ambiguousNode, (DiagnosticCode)errorCode, new Object[0]);
        return STNodeFactory.createCaptureBindingPatternNode(identifier);
    }

    private List<STNode> getExpressionList(List<STNode> ambibuousList, boolean isMappingConstructor) {
        ArrayList<STNode> exprList = new ArrayList<STNode>();
        for (STNode item : ambibuousList) {
            exprList.add(this.getExpression(item, isMappingConstructor));
        }
        return exprList;
    }

    private STNode getExpression(STNode ambiguousNode) {
        return this.getExpression(ambiguousNode, false);
    }

    private STNode getExpression(STNode ambiguousNode, boolean isInMappingConstructor) {
        if (this.isEmpty(ambiguousNode) || this.isDefiniteExpr(ambiguousNode.kind) && ambiguousNode.kind != SyntaxKind.INDEXED_EXPRESSION || this.isDefiniteAction(ambiguousNode.kind) || ambiguousNode.kind == SyntaxKind.COMMA_TOKEN) {
            return ambiguousNode;
        }
        switch (ambiguousNode.kind) {
            case BRACKETED_LIST: 
            case LIST_BP_OR_LIST_CONSTRUCTOR: 
            case TUPLE_TYPE_DESC_OR_LIST_CONST: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                STNode memberExprs = STNodeFactory.createNodeList(this.getExpressionList(innerList.members, false));
                return STNodeFactory.createListConstructorExpressionNode(innerList.collectionStartToken, memberExprs, innerList.collectionEndToken);
            }
            case MAPPING_BP_OR_MAPPING_CONSTRUCTOR: {
                STAmbiguousCollectionNode innerList = (STAmbiguousCollectionNode)ambiguousNode;
                ArrayList<STNode> fieldList = new ArrayList<STNode>();
                for (int i = 0; i < innerList.members.size(); ++i) {
                    STNode fieldNode;
                    STNode field = innerList.members.get(i);
                    if (field.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                        STQualifiedNameReferenceNode qualifiedNameRefNode = (STQualifiedNameReferenceNode)field;
                        STNode readOnlyKeyword = STNodeFactory.createEmptyNode();
                        STNode fieldName = qualifiedNameRefNode.modulePrefix;
                        STNode colon = qualifiedNameRefNode.colon;
                        STNode valueExpr = this.getExpression(qualifiedNameRefNode.identifier);
                        fieldNode = STNodeFactory.createSpecificFieldNode(readOnlyKeyword, fieldName, colon, valueExpr);
                    } else {
                        fieldNode = this.getExpression(field, true);
                    }
                    fieldList.add(fieldNode);
                }
                STNode fields = STNodeFactory.createNodeList(fieldList);
                return STNodeFactory.createMappingConstructorExpressionNode(innerList.collectionStartToken, fields, innerList.collectionEndToken);
            }
            case REST_BINDING_PATTERN: {
                STRestBindingPatternNode restBindingPattern = (STRestBindingPatternNode)ambiguousNode;
                if (isInMappingConstructor) {
                    return STNodeFactory.createSpreadFieldNode(restBindingPattern.ellipsisToken, restBindingPattern.variableName);
                }
                return STNodeFactory.createSpreadMemberNode(restBindingPattern.ellipsisToken, restBindingPattern.variableName);
            }
            case SPECIFIC_FIELD: {
                STSpecificFieldNode field = (STSpecificFieldNode)ambiguousNode;
                return STNodeFactory.createSpecificFieldNode(field.readonlyKeyword, field.fieldName, field.colon, this.getExpression(field.valueExpr));
            }
            case ERROR_CONSTRUCTOR: {
                STErrorConstructorExpressionNode errorCons = (STErrorConstructorExpressionNode)ambiguousNode;
                STNode errorArgs = this.getErrorArgList(errorCons.arguments);
                return STNodeFactory.createErrorConstructorExpressionNode(errorCons.errorKeyword, errorCons.typeReference, errorCons.openParenToken, errorArgs, errorCons.closeParenToken);
            }
            case IDENTIFIER_TOKEN: {
                return STNodeFactory.createSimpleNameReferenceNode(ambiguousNode);
            }
            case INDEXED_EXPRESSION: {
                STIndexedExpressionNode indexedExpressionNode = (STIndexedExpressionNode)ambiguousNode;
                STNodeList keys = (STNodeList)indexedExpressionNode.keyExpression;
                if (!keys.isEmpty()) {
                    return ambiguousNode;
                }
                STNode lhsExpr = indexedExpressionNode.containerExpression;
                STNode openBracket = indexedExpressionNode.openBracket;
                STNode closeBracket = indexedExpressionNode.closeBracket;
                STNode missingVarRef = STNodeFactory.createSimpleNameReferenceNode(SyntaxErrors.createMissingToken(SyntaxKind.IDENTIFIER_TOKEN));
                STNode keyExpr = STNodeFactory.createNodeList(missingVarRef);
                closeBracket = SyntaxErrors.addDiagnostic(closeBracket, DiagnosticErrorCode.ERROR_MISSING_KEY_EXPR_IN_MEMBER_ACCESS_EXPR, new Object[0]);
                return STNodeFactory.createIndexedExpressionNode(lhsExpr, openBracket, keyExpr, closeBracket);
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: 
            case SPREAD_MEMBER: 
            case SPREAD_FIELD: 
            case COMPUTED_NAME_FIELD: {
                return ambiguousNode;
            }
        }
        STNode simpleVarRef = SyntaxErrors.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN, DiagnosticErrorCode.ERROR_MISSING_EXPRESSION);
        simpleVarRef = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(simpleVarRef, ambiguousNode);
        return STNodeFactory.createSimpleNameReferenceNode(simpleVarRef);
    }

    private STNode getMappingField(STNode identifier, STNode colon, STNode bindingPatternOrExpr) {
        STNode simpleNameRef = STNodeFactory.createSimpleNameReferenceNode(identifier);
        return switch (bindingPatternOrExpr.kind) {
            case SyntaxKind.LIST_BINDING_PATTERN, SyntaxKind.MAPPING_BINDING_PATTERN -> STNodeFactory.createFieldBindingPatternFullNode(simpleNameRef, colon, bindingPatternOrExpr);
            case SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.MAPPING_CONSTRUCTOR -> {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                yield STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, bindingPatternOrExpr);
            }
            default -> {
                STNode readonlyKeyword = STNodeFactory.createEmptyNode();
                yield STNodeFactory.createSpecificFieldNode(readonlyKeyword, identifier, colon, bindingPatternOrExpr);
            }
        };
    }

    private AbstractParserErrorHandler.Solution recover(STToken nextToken, ParserRuleContext currentCtx) {
        if (this.isInsideABlock(nextToken)) {
            return this.recover(nextToken, currentCtx, true);
        }
        return this.recover(nextToken, currentCtx, false);
    }

    private boolean isInsideABlock(STToken nextToken) {
        if (nextToken.kind != SyntaxKind.CLOSE_BRACE_TOKEN) {
            return false;
        }
        for (ParserRuleContext ctx : this.errorHandler.getContextStack()) {
            if (!this.isBlockContext(ctx)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlockContext(ParserRuleContext ctx) {
        return switch (ctx) {
            case ParserRuleContext.FUNC_BODY_BLOCK, ParserRuleContext.CLASS_MEMBER, ParserRuleContext.OBJECT_CONSTRUCTOR_MEMBER, ParserRuleContext.OBJECT_TYPE_MEMBER, ParserRuleContext.BLOCK_STMT, ParserRuleContext.MATCH_BODY, ParserRuleContext.MAPPING_MATCH_PATTERN, ParserRuleContext.MAPPING_BINDING_PATTERN, ParserRuleContext.MAPPING_CONSTRUCTOR, ParserRuleContext.FORK_STMT, ParserRuleContext.MULTI_RECEIVE_WORKERS, ParserRuleContext.MULTI_WAIT_FIELDS, ParserRuleContext.MODULE_ENUM_DECLARATION -> true;
            default -> false;
        };
    }

    private boolean isSpecialMethodName(STToken token) {
        return token.kind == SyntaxKind.MAP_KEYWORD || token.kind == SyntaxKind.START_KEYWORD || token.kind == SyntaxKind.JOIN_KEYWORD;
    }
}

