/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticWarningCode;
import io.ballerina.compiler.internal.parser.AbstractParser;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.util.ArrayList;
import java.util.List;

public class DocumentationParser
extends AbstractParser {
    protected DocumentationParser(AbstractTokenReader tokenReader) {
        super(tokenReader);
    }

    @Override
    public STNode parse() {
        return this.parseDocumentationLines();
    }

    private STNode parseDocumentationLines() {
        ArrayList<STNode> docLines = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (nextToken.kind == SyntaxKind.HASH_TOKEN) {
            docLines.add(this.parseSingleDocumentationLine());
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(docLines);
    }

    private STNode parseSingleDocumentationLine() {
        STToken hashToken = this.consume();
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.PLUS_TOKEN -> this.parseParameterDocumentationLine(hashToken);
            case SyntaxKind.DEPRECATION_LITERAL -> this.parseDeprecationDocumentationLine(hashToken);
            case SyntaxKind.TRIPLE_BACKTICK_TOKEN, SyntaxKind.DOUBLE_BACKTICK_TOKEN -> this.parseCodeBlockOrInlineCodeRef(hashToken);
            default -> this.parseDocumentationLine(hashToken);
        };
    }

    private STNode parseCodeBlockOrInlineCodeRef(STNode startLineHash) {
        STToken startBacktick = this.consume();
        STToken nextToken = this.peek();
        if (!this.isInlineCodeRef(nextToken.kind)) {
            return this.parseCodeBlock(startLineHash, startBacktick);
        }
        STNode inlineCodeNode = this.parseInlineCode(startBacktick);
        ArrayList<STNode> docElements = new ArrayList<STNode>();
        docElements.add(inlineCodeNode);
        this.parseDocElements(docElements);
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        return this.createMarkdownReferenceDocumentationLineNode(startLineHash, docElementList);
    }

    private boolean isInlineCodeRef(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.HASH_TOKEN -> {
                if (this.getNextNextToken().kind == SyntaxKind.DOCUMENTATION_DESCRIPTION) {
                    yield true;
                }
                yield false;
            }
            case SyntaxKind.CODE_CONTENT -> {
                if (this.getNextNextToken().kind != SyntaxKind.HASH_TOKEN) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private STNode parseDeprecationDocumentationLine(STNode hashToken) {
        STToken deprecationLiteral = this.consume();
        List<STNode> docElements = this.parseDocumentationElements();
        docElements.add(0, deprecationLiteral);
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        return this.createMarkdownDeprecationDocumentationLineNode(hashToken, docElementList);
    }

    private STNode parseDocumentationLine(STNode hashToken) {
        List<STNode> docElements = this.parseDocumentationElements();
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        switch (docElements.size()) {
            case 0: {
                return this.createMarkdownDocumentationLineNode(hashToken, docElementList);
            }
            case 1: {
                STNode docElement = docElements.get(0);
                if (docElement.kind != SyntaxKind.DOCUMENTATION_DESCRIPTION) break;
                return this.createMarkdownDocumentationLineNode(hashToken, docElementList);
            }
        }
        return this.createMarkdownReferenceDocumentationLineNode(hashToken, docElementList);
    }

    private List<STNode> parseDocumentationElements() {
        ArrayList<STNode> docElements = new ArrayList<STNode>();
        this.parseDocElements(docElements);
        return docElements;
    }

    private void parseDocElements(List<STNode> docElements) {
        SyntaxKind nextTokenKind = this.peek().kind;
        block6: while (!this.isEndOfIntermediateDocumentation(nextTokenKind)) {
            STNode docElement;
            switch (nextTokenKind) {
                case DOCUMENTATION_DESCRIPTION: {
                    docElement = this.consume();
                    break;
                }
                case CODE_CONTENT: {
                    STToken token = this.consume();
                    docElement = this.convertToDocDescriptionToken(token);
                    break;
                }
                case TRIPLE_BACKTICK_TOKEN: 
                case DOUBLE_BACKTICK_TOKEN: {
                    docElement = this.parseInlineCode(this.consume());
                    break;
                }
                case BACKTICK_TOKEN: {
                    STNode referenceType = STNodeFactory.createEmptyNode();
                    docElement = this.parseBallerinaNameRefOrInlineCodeRef(referenceType);
                    break;
                }
                default: {
                    STNode referenceType;
                    if (this.isDocumentReferenceType(nextTokenKind)) {
                        referenceType = this.consume();
                        docElement = this.parseBallerinaNameRefOrInlineCodeRef(referenceType);
                        break;
                    }
                    assert (false);
                    this.consume();
                    nextTokenKind = this.peek().kind;
                    continue block6;
                }
            }
            docElements.add(docElement);
            nextTokenKind = this.peek().kind;
        }
    }

    private STNode convertToDocDescriptionToken(STToken token) {
        return STNodeFactory.createLiteralValueToken(SyntaxKind.DOCUMENTATION_DESCRIPTION, token.text(), token.leadingMinutiae(), token.trailingMinutiae());
    }

    private STNode convertToCodeContentToken(STToken token) {
        return STNodeFactory.createLiteralValueToken(SyntaxKind.CODE_CONTENT, token.text(), token.leadingMinutiae(), token.trailingMinutiae());
    }

    private STNode parseInlineCode(STNode startBacktick) {
        STNode codeDescription = this.parseInlineCodeContentToken();
        STNode endBacktick = this.parseCodeEndBacktick(startBacktick.kind);
        return STNodeFactory.createInlineCodeReferenceNode(startBacktick, codeDescription, endBacktick);
    }

    private STNode parseInlineCodeContentToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CODE_CONTENT) {
            return this.consume();
        }
        if (token.kind == SyntaxKind.DOCUMENTATION_DESCRIPTION) {
            token = this.consume();
            return this.convertToCodeContentToken(token);
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.CODE_CONTENT);
    }

    private STNode parseCodeBlock(STNode startLineHash, STNode startBacktick) {
        STNode langAttribute = this.parseOptionalLangAttributeToken();
        STNode codeLines = this.parseCodeLines();
        STNode endLineHash = this.parseHashToken();
        STNode endBacktick = this.parseCodeEndBacktick(startBacktick.kind);
        while (!this.isEndOfIntermediateDocumentation(this.peek().kind)) {
            STToken invalidToken = this.consume();
            endBacktick = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(endBacktick, (STNode)invalidToken, (DiagnosticCode)DiagnosticWarningCode.WARNING_CANNOT_HAVE_DOCUMENTATION_INLINE_WITH_A_CODE_REFERENCE_BLOCK, new Object[0]);
        }
        return STNodeFactory.createMarkdownCodeBlockNode(startLineHash, startBacktick, langAttribute, codeLines, endLineHash, endBacktick);
    }

    private STNode parseOptionalLangAttributeToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CODE_CONTENT) {
            return this.consume();
        }
        return STNodeFactory.createEmptyNode();
    }

    private STNode parseCodeLines() {
        ArrayList<STNode> codeLineList = new ArrayList<STNode>();
        while (!this.isEndOfCodeLines()) {
            STNode codeLineNode = this.parseCodeLine();
            codeLineList.add(codeLineNode);
        }
        return STNodeFactory.createNodeList(codeLineList);
    }

    private STNode parseCodeLine() {
        STNode hash = this.parseHashToken();
        STToken nextToken = this.peek();
        STNode codeDescription = nextToken.kind == SyntaxKind.HASH_TOKEN ? this.createEmptyCodeContentToken() : this.parseInlineCodeContentToken();
        return STNodeFactory.createMarkdownCodeLineNode(hash, codeDescription);
    }

    private STNode createEmptyCodeContentToken() {
        String lexeme = "";
        STNode emptyMinutiae = STNodeFactory.createEmptyNodeList();
        STToken codeDescription = STNodeFactory.createLiteralValueToken(SyntaxKind.CODE_CONTENT, lexeme, emptyMinutiae, emptyMinutiae);
        return codeDescription;
    }

    private STNode parseHashToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.HASH_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.HASH_TOKEN);
    }

    private STNode parseCodeEndBacktick(SyntaxKind backtickKind) {
        STToken token = this.peek();
        if (token.kind == backtickKind) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(backtickKind);
    }

    private boolean isEndOfCodeLines() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.HASH_TOKEN) {
            STToken nextNextToken = this.getNextNextToken();
            return switch (nextNextToken.kind) {
                case SyntaxKind.HASH_TOKEN, SyntaxKind.CODE_CONTENT -> false;
                default -> true;
            };
        }
        return true;
    }

    private STNode parseBallerinaNameRefOrInlineCodeRef(STNode referenceType) {
        STNode contentToken;
        STNode startBacktick = this.parseBacktickToken();
        boolean isCodeRef = false;
        ReferenceGenre referenceGenre = this.getReferenceGenre(referenceType);
        if (this.isBallerinaNameRefTokenSequence(referenceGenre)) {
            contentToken = this.parseNameReferenceContent();
        } else {
            contentToken = this.combineAndCreateCodeContentToken();
            if (referenceGenre != ReferenceGenre.NO_KEY) {
                contentToken = SyntaxErrors.addDiagnostic(contentToken, DiagnosticWarningCode.WARNING_INVALID_BALLERINA_NAME_REFERENCE, ((STToken)contentToken).text());
            } else {
                isCodeRef = true;
            }
        }
        STNode endBacktick = this.parseBacktickToken();
        if (isCodeRef) {
            return STNodeFactory.createInlineCodeReferenceNode(startBacktick, contentToken, endBacktick);
        }
        return STNodeFactory.createBallerinaNameReferenceNode(referenceType, startBacktick, contentToken, endBacktick);
    }

    private boolean isBallerinaNameRefTokenSequence(ReferenceGenre refGenre) {
        Lookahead lookahead = new Lookahead();
        boolean hasMatch = switch (refGenre.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.hasQualifiedIdentifier(lookahead);
            case 2 -> this.hasBacktickExpr(lookahead, true);
            case 0 -> this.hasBacktickExpr(lookahead, false);
        };
        return hasMatch && this.peek((int)lookahead.offset).kind == SyntaxKind.BACKTICK_TOKEN;
    }

    private boolean hasBacktickExpr(Lookahead lookahead, boolean isFunctionKey) {
        if (!this.hasQualifiedIdentifier(lookahead)) {
            return false;
        }
        STToken nextToken = this.peek(lookahead.offset);
        if (nextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            return this.hasFuncSignature(lookahead);
        }
        if (nextToken.kind == SyntaxKind.DOT_TOKEN) {
            ++lookahead.offset;
            if (!this.hasIdentifier(lookahead)) {
                return false;
            }
            return this.hasFuncSignature(lookahead);
        }
        return isFunctionKey;
    }

    private boolean hasFuncSignature(Lookahead lookahead) {
        if (!this.hasOpenParenthesis(lookahead)) {
            return false;
        }
        return this.hasCloseParenthesis(lookahead);
    }

    private boolean hasOpenParenthesis(Lookahead lookahead) {
        STToken nextToken = this.peek(lookahead.offset);
        if (nextToken.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            ++lookahead.offset;
            return true;
        }
        return false;
    }

    private boolean hasCloseParenthesis(Lookahead lookahead) {
        STToken nextToken = this.peek(lookahead.offset);
        if (nextToken.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            ++lookahead.offset;
            return true;
        }
        return false;
    }

    private boolean hasQualifiedIdentifier(Lookahead lookahead) {
        if (!this.hasIdentifier(lookahead)) {
            return false;
        }
        STToken nextToken = this.peek(lookahead.offset);
        if (nextToken.kind == SyntaxKind.COLON_TOKEN) {
            ++lookahead.offset;
            return this.hasIdentifier(lookahead);
        }
        return true;
    }

    private boolean hasIdentifier(Lookahead lookahead) {
        STToken nextToken = this.peek(lookahead.offset);
        if (nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            ++lookahead.offset;
            return true;
        }
        return false;
    }

    private boolean isDocumentReferenceType(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.TYPE_DOC_REFERENCE_TOKEN, SyntaxKind.SERVICE_DOC_REFERENCE_TOKEN, SyntaxKind.VARIABLE_DOC_REFERENCE_TOKEN, SyntaxKind.VAR_DOC_REFERENCE_TOKEN, SyntaxKind.ANNOTATION_DOC_REFERENCE_TOKEN, SyntaxKind.MODULE_DOC_REFERENCE_TOKEN, SyntaxKind.FUNCTION_DOC_REFERENCE_TOKEN, SyntaxKind.PARAMETER_DOC_REFERENCE_TOKEN, SyntaxKind.CONST_DOC_REFERENCE_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseParameterDocumentationLine(STNode hashToken) {
        STToken plusToken = this.consume();
        STNode parameterName = this.parseParameterName();
        STNode dashToken = this.parseMinusToken();
        List<STNode> docElements = this.parseDocumentationElements();
        STNode docElementList = STNodeFactory.createNodeList(docElements);
        SyntaxKind kind = parameterName.kind == SyntaxKind.RETURN_KEYWORD ? SyntaxKind.MARKDOWN_RETURN_PARAMETER_DOCUMENTATION_LINE : SyntaxKind.MARKDOWN_PARAMETER_DOCUMENTATION_LINE;
        return STNodeFactory.createMarkdownParameterDocumentationLineNode(kind, hashToken, plusToken, parameterName, dashToken, docElementList);
    }

    private boolean isEndOfIntermediateDocumentation(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.PLUS_TOKEN, SyntaxKind.DEPRECATION_LITERAL, SyntaxKind.TRIPLE_BACKTICK_TOKEN, SyntaxKind.DOUBLE_BACKTICK_TOKEN, SyntaxKind.CODE_CONTENT, SyntaxKind.DOCUMENTATION_DESCRIPTION, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.PARAMETER_NAME, SyntaxKind.MINUS_TOKEN, SyntaxKind.RETURN_KEYWORD -> false;
            default -> !this.isDocumentReferenceType(kind);
        };
    }

    private STNode parseParameterName() {
        SyntaxKind tokenKind = this.peek().kind;
        if (tokenKind == SyntaxKind.PARAMETER_NAME || tokenKind == SyntaxKind.RETURN_KEYWORD) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.PARAMETER_NAME);
    }

    private STNode parseMinusToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.MINUS_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.MINUS_TOKEN);
    }

    private STNode parseBacktickToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.BACKTICK_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.BACKTICK_TOKEN);
    }

    private ReferenceGenre getReferenceGenre(STNode referenceType) {
        if (referenceType == null) {
            return ReferenceGenre.NO_KEY;
        }
        if (referenceType.kind == SyntaxKind.FUNCTION_DOC_REFERENCE_TOKEN) {
            return ReferenceGenre.FUNCTION_KEY;
        }
        return ReferenceGenre.SPECIAL_KEY;
    }

    private STNode combineAndCreateCodeContentToken() {
        STToken token;
        if (!this.isBacktickExprToken(this.peek().kind)) {
            return this.createMissingTokenWithDiagnostics(SyntaxKind.CODE_CONTENT);
        }
        StringBuilder backtickContent = new StringBuilder();
        while (this.isBacktickExprToken(this.peek((int)2).kind)) {
            token = this.consume();
            backtickContent.append(token.toString());
        }
        token = this.consume();
        backtickContent.append(token.text());
        STNode leadingMinutiae = STNodeFactory.createEmptyNodeList();
        STNode trailingMinutiae = token.trailingMinutiae();
        return STNodeFactory.createLiteralValueToken(SyntaxKind.CODE_CONTENT, backtickContent.toString(), leadingMinutiae, trailingMinutiae);
    }

    private boolean isBacktickExprToken(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.CODE_CONTENT, SyntaxKind.DOT_TOKEN, SyntaxKind.COLON_TOKEN, SyntaxKind.OPEN_PAREN_TOKEN, SyntaxKind.CLOSE_PAREN_TOKEN, SyntaxKind.IDENTIFIER_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseNameReferenceContent() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STToken identifier = this.consume();
            return this.parseBacktickExpr(identifier);
        }
        return this.parseNameReferenceContent();
    }

    private STNode parseBacktickExpr(STNode identifier) {
        STNode referenceName = this.parseQualifiedIdentifier(identifier);
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.BACKTICK_TOKEN -> referenceName;
            case SyntaxKind.DOT_TOKEN -> {
                STToken dotToken = this.consume();
                yield this.parseMethodCall(referenceName, dotToken);
            }
            case SyntaxKind.OPEN_PAREN_TOKEN -> this.parseFuncCall(referenceName);
            default -> throw new IllegalStateException("Unsupported token kind");
        };
    }

    private STNode parseQualifiedIdentifier(STNode identifier) {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.COLON_TOKEN) {
            STToken colon = this.consume();
            return this.parseQualifiedIdentifier(identifier, colon);
        }
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseQualifiedIdentifier(STNode identifier, STNode colon) {
        STNode refName = this.parseIdentifier();
        return STNodeFactory.createQualifiedNameReferenceNode(identifier, colon, refName);
    }

    private STNode parseIdentifier() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.IDENTIFIER_TOKEN);
    }

    private STNode parseFuncCall(STNode referenceName) {
        STNode openParen = this.parseOpenParenthesis();
        STNode args = STNodeFactory.createEmptyNodeList();
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createFunctionCallExpressionNode(referenceName, openParen, args, closeParen);
    }

    private STNode parseMethodCall(STNode referenceName, STNode dotToken) {
        STNode methodName = this.parseSimpleNameReference();
        STNode openParen = this.parseOpenParenthesis();
        STNode args = STNodeFactory.createEmptyNodeList();
        STNode closeParen = this.parseCloseParenthesis();
        return STNodeFactory.createMethodCallExpressionNode(referenceName, dotToken, methodName, openParen, args, closeParen);
    }

    private STNode parseSimpleNameReference() {
        STNode identifier = this.parseIdentifier();
        return STNodeFactory.createSimpleNameReferenceNode(identifier);
    }

    private STNode parseOpenParenthesis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_PAREN_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.OPEN_PAREN_TOKEN);
    }

    private STNode parseCloseParenthesis() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_PAREN_TOKEN) {
            return this.consume();
        }
        return this.createMissingTokenWithDiagnostics(SyntaxKind.CLOSE_PAREN_TOKEN);
    }

    private STNode createMissingTokenWithDiagnostics(SyntaxKind expectedKind) {
        return SyntaxErrors.createMissingDocTokenWithDiagnostics(expectedKind);
    }

    private STNode createMarkdownDocumentationLineNode(STNode hashToken, STNode documentationElements) {
        return STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, hashToken, documentationElements);
    }

    private STNode createMarkdownDeprecationDocumentationLineNode(STNode hashToken, STNode documentationElements) {
        return STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_DEPRECATION_DOCUMENTATION_LINE, hashToken, documentationElements);
    }

    private STNode createMarkdownReferenceDocumentationLineNode(STNode hashToken, STNode documentationElements) {
        return STNodeFactory.createMarkdownDocumentationLineNode(SyntaxKind.MARKDOWN_REFERENCE_DOCUMENTATION_LINE, hashToken, documentationElements);
    }

    private static enum ReferenceGenre {
        NO_KEY,
        SPECIAL_KEY,
        FUNCTION_KEY;

    }

    private static class Lookahead {
        private int offset = 1;

        private Lookahead() {
        }
    }
}

