/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STFieldBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternFullNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFieldBindingPatternFullNode
extends STFieldBindingPatternNode {
    public final STNode variableName;
    public final STNode colon;
    public final STNode bindingPattern;

    STFieldBindingPatternFullNode(STNode variableName, STNode colon, STNode bindingPattern) {
        this(variableName, colon, bindingPattern, Collections.emptyList());
    }

    STFieldBindingPatternFullNode(STNode variableName, STNode colon, STNode bindingPattern, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FIELD_BINDING_PATTERN, diagnostics);
        this.variableName = variableName;
        this.colon = colon;
        this.bindingPattern = bindingPattern;
        this.addChildren(variableName, colon, bindingPattern);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFieldBindingPatternFullNode(this.variableName, this.colon, this.bindingPattern, diagnostics);
    }

    public STFieldBindingPatternFullNode modify(STNode variableName, STNode colon, STNode bindingPattern) {
        if (this.checkForReferenceEquality(variableName, colon, bindingPattern)) {
            return this;
        }
        return new STFieldBindingPatternFullNode(variableName, colon, bindingPattern, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FieldBindingPatternFullNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

