/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STImportOrgNameNode
extends STNode {
    public final STNode orgName;
    public final STNode slashToken;

    STImportOrgNameNode(STNode orgName, STNode slashToken) {
        this(orgName, slashToken, Collections.emptyList());
    }

    STImportOrgNameNode(STNode orgName, STNode slashToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.IMPORT_ORG_NAME, diagnostics);
        this.orgName = orgName;
        this.slashToken = slashToken;
        this.addChildren(orgName, slashToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STImportOrgNameNode(this.orgName, this.slashToken, diagnostics);
    }

    public STImportOrgNameNode modify(STNode orgName, STNode slashToken) {
        if (this.checkForReferenceEquality(orgName, slashToken)) {
            return this;
        }
        return new STImportOrgNameNode(orgName, slashToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ImportOrgNameNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

