/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STParenthesizedArgList
extends STNode {
    public final STNode openParenToken;
    public final STNode arguments;
    public final STNode closeParenToken;

    STParenthesizedArgList(STNode openParenToken, STNode arguments, STNode closeParenToken) {
        this(openParenToken, arguments, closeParenToken, Collections.emptyList());
    }

    STParenthesizedArgList(STNode openParenToken, STNode arguments, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.PARENTHESIZED_ARG_LIST, diagnostics);
        this.openParenToken = openParenToken;
        this.arguments = arguments;
        this.closeParenToken = closeParenToken;
        this.addChildren(openParenToken, arguments, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STParenthesizedArgList(this.openParenToken, this.arguments, this.closeParenToken, diagnostics);
    }

    public STParenthesizedArgList modify(STNode openParenToken, STNode arguments, STNode closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, arguments, closeParenToken)) {
            return this;
        }
        return new STParenthesizedArgList(openParenToken, arguments, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ParenthesizedArgList(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

