/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRecordRestDescriptorNode
extends STNode {
    public final STNode typeName;
    public final STNode ellipsisToken;
    public final STNode semicolonToken;

    STRecordRestDescriptorNode(STNode typeName, STNode ellipsisToken, STNode semicolonToken) {
        this(typeName, ellipsisToken, semicolonToken, Collections.emptyList());
    }

    STRecordRestDescriptorNode(STNode typeName, STNode ellipsisToken, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RECORD_REST_TYPE, diagnostics);
        this.typeName = typeName;
        this.ellipsisToken = ellipsisToken;
        this.semicolonToken = semicolonToken;
        this.addChildren(typeName, ellipsisToken, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRecordRestDescriptorNode(this.typeName, this.ellipsisToken, this.semicolonToken, diagnostics);
    }

    public STRecordRestDescriptorNode modify(STNode typeName, STNode ellipsisToken, STNode semicolonToken) {
        if (this.checkForReferenceEquality(typeName, ellipsisToken, semicolonToken)) {
            return this;
        }
        return new STRecordRestDescriptorNode(typeName, ellipsisToken, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RecordRestDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

