/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeTestExpressionNode
extends STExpressionNode {
    public final STNode expression;
    public final STNode isKeyword;
    public final STNode typeDescriptor;

    STTypeTestExpressionNode(STNode expression, STNode isKeyword, STNode typeDescriptor) {
        this(expression, isKeyword, typeDescriptor, Collections.emptyList());
    }

    STTypeTestExpressionNode(STNode expression, STNode isKeyword, STNode typeDescriptor, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPE_TEST_EXPRESSION, diagnostics);
        this.expression = expression;
        this.isKeyword = isKeyword;
        this.typeDescriptor = typeDescriptor;
        this.addChildren(expression, isKeyword, typeDescriptor);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeTestExpressionNode(this.expression, this.isKeyword, this.typeDescriptor, diagnostics);
    }

    public STTypeTestExpressionNode modify(STNode expression, STNode isKeyword, STNode typeDescriptor) {
        if (this.checkForReferenceEquality(expression, isKeyword, typeDescriptor)) {
            return this;
        }
        return new STTypeTestExpressionNode(expression, isKeyword, typeDescriptor, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeTestExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

