/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLElementTagNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLEndTagNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLEndTagNode
extends STXMLElementTagNode {
    public final STNode ltToken;
    public final STNode slashToken;
    public final STNode name;
    public final STNode getToken;

    STXMLEndTagNode(STNode ltToken, STNode slashToken, STNode name, STNode getToken) {
        this(ltToken, slashToken, name, getToken, Collections.emptyList());
    }

    STXMLEndTagNode(STNode ltToken, STNode slashToken, STNode name, STNode getToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_ELEMENT_END_TAG, diagnostics);
        this.ltToken = ltToken;
        this.slashToken = slashToken;
        this.name = name;
        this.getToken = getToken;
        this.addChildren(ltToken, slashToken, name, getToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLEndTagNode(this.ltToken, this.slashToken, this.name, this.getToken, diagnostics);
    }

    public STXMLEndTagNode modify(STNode ltToken, STNode slashToken, STNode name, STNode getToken) {
        if (this.checkForReferenceEquality(ltToken, slashToken, name, getToken)) {
            return this;
        }
        return new STXMLEndTagNode(ltToken, slashToken, name, getToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLEndTagNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

