/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Optional;

public class ChildNodeEntry {
    private final String name;
    private final Node node;

    ChildNodeEntry(String name, Node node) {
        this.name = name;
        this.node = node;
    }

    public String name() {
        return this.name;
    }

    public Optional<Node> node() {
        if (this.isList()) {
            NonTerminalNode nodeList = (NonTerminalNode)this.node;
            if (nodeList.bucketCount() == 0) {
                return Optional.empty();
            }
            return Optional.of(nodeList.childInBucket(0));
        }
        return Optional.of(this.node);
    }

    public NodeList<Node> nodeList() {
        return new NodeList<Node>((NonTerminalNode)this.node);
    }

    public boolean isList() {
        return this.node.kind() == SyntaxKind.LIST;
    }
}

