/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class IfElseStatementNode
extends StatementNode {
    public IfElseStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ifKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode condition() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public BlockStatementNode ifBody() {
        return (BlockStatementNode)this.childInBucket(2);
    }

    public Optional<Node> elseBody() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ifKeyword", "condition", "ifBody", "elseBody"};
    }

    public IfElseStatementNode modify(Token ifKeyword, ExpressionNode condition, BlockStatementNode ifBody, Node elseBody) {
        if (this.checkForReferenceEquality(ifKeyword, condition, ifBody, elseBody)) {
            return this;
        }
        return NodeFactory.createIfElseStatementNode(ifKeyword, condition, ifBody, elseBody);
    }

    public IfElseStatementNodeModifier modify() {
        return new IfElseStatementNodeModifier(this);
    }

    public static class IfElseStatementNodeModifier {
        private final IfElseStatementNode oldNode;
        private Token ifKeyword;
        private ExpressionNode condition;
        private BlockStatementNode ifBody;
        private Node elseBody;

        public IfElseStatementNodeModifier(IfElseStatementNode oldNode) {
            this.oldNode = oldNode;
            this.ifKeyword = oldNode.ifKeyword();
            this.condition = oldNode.condition();
            this.ifBody = oldNode.ifBody();
            this.elseBody = oldNode.elseBody().orElse(null);
        }

        public IfElseStatementNodeModifier withIfKeyword(Token ifKeyword) {
            Objects.requireNonNull(ifKeyword, "ifKeyword must not be null");
            this.ifKeyword = ifKeyword;
            return this;
        }

        public IfElseStatementNodeModifier withCondition(ExpressionNode condition) {
            Objects.requireNonNull(condition, "condition must not be null");
            this.condition = condition;
            return this;
        }

        public IfElseStatementNodeModifier withIfBody(BlockStatementNode ifBody) {
            Objects.requireNonNull(ifBody, "ifBody must not be null");
            this.ifBody = ifBody;
            return this;
        }

        public IfElseStatementNodeModifier withElseBody(Node elseBody) {
            this.elseBody = elseBody;
            return this;
        }

        public IfElseStatementNode apply() {
            return this.oldNode.modify(this.ifKeyword, this.condition, this.ifBody, this.elseBody);
        }
    }
}

