/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ListMatchPatternNode
extends NonTerminalNode {
    public ListMatchPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<Node> matchPatterns() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "matchPatterns", "closeBracket"};
    }

    public ListMatchPatternNode modify(Token openBracket, SeparatedNodeList<Node> matchPatterns, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, matchPatterns.underlyingListNode(), closeBracket)) {
            return this;
        }
        return NodeFactory.createListMatchPatternNode(openBracket, matchPatterns, closeBracket);
    }

    public ListMatchPatternNodeModifier modify() {
        return new ListMatchPatternNodeModifier(this);
    }

    public static class ListMatchPatternNodeModifier {
        private final ListMatchPatternNode oldNode;
        private Token openBracket;
        private SeparatedNodeList<Node> matchPatterns;
        private Token closeBracket;

        public ListMatchPatternNodeModifier(ListMatchPatternNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.matchPatterns = oldNode.matchPatterns();
            this.closeBracket = oldNode.closeBracket();
        }

        public ListMatchPatternNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ListMatchPatternNodeModifier withMatchPatterns(SeparatedNodeList<Node> matchPatterns) {
            Objects.requireNonNull(matchPatterns, "matchPatterns must not be null");
            this.matchPatterns = matchPatterns;
            return this;
        }

        public ListMatchPatternNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ListMatchPatternNode apply() {
            return this.oldNode.modify(this.openBracket, this.matchPatterns, this.closeBracket);
        }
    }
}

