/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;
import java.util.Optional;

public class ModuleVariableDeclarationNode
extends ModuleMemberDeclarationNode {
    public ModuleVariableDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public NodeList<Token> qualifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(2));
    }

    public TypedBindingPatternNode typedBindingPattern() {
        return (TypedBindingPatternNode)this.childInBucket(3);
    }

    public Optional<Token> equalsToken() {
        return this.optionalChildInBucket(4);
    }

    public Optional<ExpressionNode> initializer() {
        return this.optionalChildInBucket(5);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "qualifiers", "typedBindingPattern", "equalsToken", "initializer", "semicolonToken"};
    }

    public ModuleVariableDeclarationNode modify(MetadataNode metadata, Token visibilityQualifier, NodeList<Token> qualifiers, TypedBindingPatternNode typedBindingPattern, Token equalsToken, ExpressionNode initializer, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, qualifiers.underlyingListNode(), typedBindingPattern, equalsToken, initializer, semicolonToken)) {
            return this;
        }
        return NodeFactory.createModuleVariableDeclarationNode(metadata, visibilityQualifier, qualifiers, typedBindingPattern, equalsToken, initializer, semicolonToken);
    }

    public ModuleVariableDeclarationNodeModifier modify() {
        return new ModuleVariableDeclarationNodeModifier(this);
    }

    public static class ModuleVariableDeclarationNodeModifier {
        private final ModuleVariableDeclarationNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private NodeList<Token> qualifiers;
        private TypedBindingPatternNode typedBindingPattern;
        private Token equalsToken;
        private ExpressionNode initializer;
        private Token semicolonToken;

        public ModuleVariableDeclarationNodeModifier(ModuleVariableDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.qualifiers = oldNode.qualifiers();
            this.typedBindingPattern = oldNode.typedBindingPattern();
            this.equalsToken = oldNode.equalsToken().orElse(null);
            this.initializer = oldNode.initializer().orElse(null);
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ModuleVariableDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ModuleVariableDeclarationNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public ModuleVariableDeclarationNodeModifier withQualifiers(NodeList<Token> qualifiers) {
            Objects.requireNonNull(qualifiers, "qualifiers must not be null");
            this.qualifiers = qualifiers;
            return this;
        }

        public ModuleVariableDeclarationNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            Objects.requireNonNull(typedBindingPattern, "typedBindingPattern must not be null");
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public ModuleVariableDeclarationNodeModifier withEqualsToken(Token equalsToken) {
            this.equalsToken = equalsToken;
            return this;
        }

        public ModuleVariableDeclarationNodeModifier withInitializer(ExpressionNode initializer) {
            this.initializer = initializer;
            return this;
        }

        public ModuleVariableDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ModuleVariableDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.qualifiers, this.typedBindingPattern, this.equalsToken, this.initializer, this.semicolonToken);
        }
    }
}

