/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class OnClauseNode
extends ClauseNode {
    public OnClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token onKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode lhsExpression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token equalsKeyword() {
        return (Token)this.childInBucket(2);
    }

    public ExpressionNode rhsExpression() {
        return (ExpressionNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"onKeyword", "lhsExpression", "equalsKeyword", "rhsExpression"};
    }

    public OnClauseNode modify(Token onKeyword, ExpressionNode lhsExpression, Token equalsKeyword, ExpressionNode rhsExpression) {
        if (this.checkForReferenceEquality(onKeyword, lhsExpression, equalsKeyword, rhsExpression)) {
            return this;
        }
        return NodeFactory.createOnClauseNode(onKeyword, lhsExpression, equalsKeyword, rhsExpression);
    }

    public OnClauseNodeModifier modify() {
        return new OnClauseNodeModifier(this);
    }

    public static class OnClauseNodeModifier {
        private final OnClauseNode oldNode;
        private Token onKeyword;
        private ExpressionNode lhsExpression;
        private Token equalsKeyword;
        private ExpressionNode rhsExpression;

        public OnClauseNodeModifier(OnClauseNode oldNode) {
            this.oldNode = oldNode;
            this.onKeyword = oldNode.onKeyword();
            this.lhsExpression = oldNode.lhsExpression();
            this.equalsKeyword = oldNode.equalsKeyword();
            this.rhsExpression = oldNode.rhsExpression();
        }

        public OnClauseNodeModifier withOnKeyword(Token onKeyword) {
            Objects.requireNonNull(onKeyword, "onKeyword must not be null");
            this.onKeyword = onKeyword;
            return this;
        }

        public OnClauseNodeModifier withLhsExpression(ExpressionNode lhsExpression) {
            Objects.requireNonNull(lhsExpression, "lhsExpression must not be null");
            this.lhsExpression = lhsExpression;
            return this;
        }

        public OnClauseNodeModifier withEqualsKeyword(Token equalsKeyword) {
            Objects.requireNonNull(equalsKeyword, "equalsKeyword must not be null");
            this.equalsKeyword = equalsKeyword;
            return this;
        }

        public OnClauseNodeModifier withRhsExpression(ExpressionNode rhsExpression) {
            Objects.requireNonNull(rhsExpression, "rhsExpression must not be null");
            this.rhsExpression = rhsExpression;
            return this;
        }

        public OnClauseNode apply() {
            return this.oldNode.modify(this.onKeyword, this.lhsExpression, this.equalsKeyword, this.rhsExpression);
        }
    }
}

