/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ReceiveFieldNode
extends NonTerminalNode {
    public ReceiveFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SimpleNameReferenceNode fieldName() {
        return (SimpleNameReferenceNode)this.childInBucket(0);
    }

    public Token colon() {
        return (Token)this.childInBucket(1);
    }

    public SimpleNameReferenceNode peerWorker() {
        return (SimpleNameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"fieldName", "colon", "peerWorker"};
    }

    public ReceiveFieldNode modify(SimpleNameReferenceNode fieldName, Token colon, SimpleNameReferenceNode peerWorker) {
        if (this.checkForReferenceEquality(fieldName, colon, peerWorker)) {
            return this;
        }
        return NodeFactory.createReceiveFieldNode(fieldName, colon, peerWorker);
    }

    public ReceiveFieldNodeModifier modify() {
        return new ReceiveFieldNodeModifier(this);
    }

    public static class ReceiveFieldNodeModifier {
        private final ReceiveFieldNode oldNode;
        private SimpleNameReferenceNode fieldName;
        private Token colon;
        private SimpleNameReferenceNode peerWorker;

        public ReceiveFieldNodeModifier(ReceiveFieldNode oldNode) {
            this.oldNode = oldNode;
            this.fieldName = oldNode.fieldName();
            this.colon = oldNode.colon();
            this.peerWorker = oldNode.peerWorker();
        }

        public ReceiveFieldNodeModifier withFieldName(SimpleNameReferenceNode fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public ReceiveFieldNodeModifier withColon(Token colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public ReceiveFieldNodeModifier withPeerWorker(SimpleNameReferenceNode peerWorker) {
            Objects.requireNonNull(peerWorker, "peerWorker must not be null");
            this.peerWorker = peerWorker;
            return this;
        }

        public ReceiveFieldNode apply() {
            return this.oldNode.modify(this.fieldName, this.colon, this.peerWorker);
        }
    }
}

