/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class RestDescriptorNode
extends NonTerminalNode {
    public RestDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(0);
    }

    public Token ellipsisToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"typeDescriptor", "ellipsisToken"};
    }

    public RestDescriptorNode modify(TypeDescriptorNode typeDescriptor, Token ellipsisToken) {
        if (this.checkForReferenceEquality(typeDescriptor, ellipsisToken)) {
            return this;
        }
        return NodeFactory.createRestDescriptorNode(typeDescriptor, ellipsisToken);
    }

    public RestDescriptorNodeModifier modify() {
        return new RestDescriptorNodeModifier(this);
    }

    public static class RestDescriptorNodeModifier {
        private final RestDescriptorNode oldNode;
        private TypeDescriptorNode typeDescriptor;
        private Token ellipsisToken;

        public RestDescriptorNodeModifier(RestDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.typeDescriptor = oldNode.typeDescriptor();
            this.ellipsisToken = oldNode.ellipsisToken();
        }

        public RestDescriptorNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public RestDescriptorNodeModifier withEllipsisToken(Token ellipsisToken) {
            Objects.requireNonNull(ellipsisToken, "ellipsisToken must not be null");
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public RestDescriptorNode apply() {
            return this.oldNode.modify(this.typeDescriptor, this.ellipsisToken);
        }
    }
}

