/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class TableConstructorExpressionNode
extends ExpressionNode {
    public TableConstructorExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token tableKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<KeySpecifierNode> keySpecifier() {
        return this.optionalChildInBucket(1);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(2);
    }

    public SeparatedNodeList<Node> rows() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"tableKeyword", "keySpecifier", "openBracket", "rows", "closeBracket"};
    }

    public TableConstructorExpressionNode modify(Token tableKeyword, KeySpecifierNode keySpecifier, Token openBracket, SeparatedNodeList<Node> rows, Token closeBracket) {
        if (this.checkForReferenceEquality(tableKeyword, keySpecifier, openBracket, rows.underlyingListNode(), closeBracket)) {
            return this;
        }
        return NodeFactory.createTableConstructorExpressionNode(tableKeyword, keySpecifier, openBracket, rows, closeBracket);
    }

    public TableConstructorExpressionNodeModifier modify() {
        return new TableConstructorExpressionNodeModifier(this);
    }

    public static class TableConstructorExpressionNodeModifier {
        private final TableConstructorExpressionNode oldNode;
        private Token tableKeyword;
        private KeySpecifierNode keySpecifier;
        private Token openBracket;
        private SeparatedNodeList<Node> rows;
        private Token closeBracket;

        public TableConstructorExpressionNodeModifier(TableConstructorExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.tableKeyword = oldNode.tableKeyword();
            this.keySpecifier = oldNode.keySpecifier().orElse(null);
            this.openBracket = oldNode.openBracket();
            this.rows = oldNode.rows();
            this.closeBracket = oldNode.closeBracket();
        }

        public TableConstructorExpressionNodeModifier withTableKeyword(Token tableKeyword) {
            Objects.requireNonNull(tableKeyword, "tableKeyword must not be null");
            this.tableKeyword = tableKeyword;
            return this;
        }

        public TableConstructorExpressionNodeModifier withKeySpecifier(KeySpecifierNode keySpecifier) {
            this.keySpecifier = keySpecifier;
            return this;
        }

        public TableConstructorExpressionNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public TableConstructorExpressionNodeModifier withRows(SeparatedNodeList<Node> rows) {
            Objects.requireNonNull(rows, "rows must not be null");
            this.rows = rows;
            return this;
        }

        public TableConstructorExpressionNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public TableConstructorExpressionNode apply() {
            return this.oldNode.modify(this.tableKeyword, this.keySpecifier, this.openBracket, this.rows, this.closeBracket);
        }
    }
}

