/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class WaitFieldNode
extends NonTerminalNode {
    public WaitFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SimpleNameReferenceNode fieldName() {
        return (SimpleNameReferenceNode)this.childInBucket(0);
    }

    public Token colon() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode waitFutureExpr() {
        return (ExpressionNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"fieldName", "colon", "waitFutureExpr"};
    }

    public WaitFieldNode modify(SimpleNameReferenceNode fieldName, Token colon, ExpressionNode waitFutureExpr) {
        if (this.checkForReferenceEquality(fieldName, colon, waitFutureExpr)) {
            return this;
        }
        return NodeFactory.createWaitFieldNode(fieldName, colon, waitFutureExpr);
    }

    public WaitFieldNodeModifier modify() {
        return new WaitFieldNodeModifier(this);
    }

    public static class WaitFieldNodeModifier {
        private final WaitFieldNode oldNode;
        private SimpleNameReferenceNode fieldName;
        private Token colon;
        private ExpressionNode waitFutureExpr;

        public WaitFieldNodeModifier(WaitFieldNode oldNode) {
            this.oldNode = oldNode;
            this.fieldName = oldNode.fieldName();
            this.colon = oldNode.colon();
            this.waitFutureExpr = oldNode.waitFutureExpr();
        }

        public WaitFieldNodeModifier withFieldName(SimpleNameReferenceNode fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public WaitFieldNodeModifier withColon(Token colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public WaitFieldNodeModifier withWaitFutureExpr(ExpressionNode waitFutureExpr) {
            Objects.requireNonNull(waitFutureExpr, "waitFutureExpr must not be null");
            this.waitFutureExpr = waitFutureExpr;
            return this;
        }

        public WaitFieldNode apply() {
            return this.oldNode.modify(this.fieldName, this.colon, this.waitFutureExpr);
        }
    }
}

