/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class XMLNamePatternChainingNode
extends NonTerminalNode {
    public XMLNamePatternChainingNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token startToken() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<Node> xmlNamePattern() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token gtToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startToken", "xmlNamePattern", "gtToken"};
    }

    public XMLNamePatternChainingNode modify(Token startToken, SeparatedNodeList<Node> xmlNamePattern, Token gtToken) {
        if (this.checkForReferenceEquality(startToken, xmlNamePattern.underlyingListNode(), gtToken)) {
            return this;
        }
        return NodeFactory.createXMLNamePatternChainingNode(startToken, xmlNamePattern, gtToken);
    }

    public XMLNamePatternChainingNodeModifier modify() {
        return new XMLNamePatternChainingNodeModifier(this);
    }

    public static class XMLNamePatternChainingNodeModifier {
        private final XMLNamePatternChainingNode oldNode;
        private Token startToken;
        private SeparatedNodeList<Node> xmlNamePattern;
        private Token gtToken;

        public XMLNamePatternChainingNodeModifier(XMLNamePatternChainingNode oldNode) {
            this.oldNode = oldNode;
            this.startToken = oldNode.startToken();
            this.xmlNamePattern = oldNode.xmlNamePattern();
            this.gtToken = oldNode.gtToken();
        }

        public XMLNamePatternChainingNodeModifier withStartToken(Token startToken) {
            Objects.requireNonNull(startToken, "startToken must not be null");
            this.startToken = startToken;
            return this;
        }

        public XMLNamePatternChainingNodeModifier withXmlNamePattern(SeparatedNodeList<Node> xmlNamePattern) {
            Objects.requireNonNull(xmlNamePattern, "xmlNamePattern must not be null");
            this.xmlNamePattern = xmlNamePattern;
            return this;
        }

        public XMLNamePatternChainingNodeModifier withGtToken(Token gtToken) {
            Objects.requireNonNull(gtToken, "gtToken must not be null");
            this.gtToken = gtToken;
            return this;
        }

        public XMLNamePatternChainingNode apply() {
            return this.oldNode.modify(this.startToken, this.xmlNamePattern, this.gtToken);
        }
    }
}

