/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.internal.parser.tree.STValueNode;
import io.ballerina.toml.syntax.tree.LiteralStringLiteralNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STLiteralStringLiteralNode
extends STValueNode {
    public final STNode startSingleQuote;
    public final STNode content;
    public final STNode endSingleQuote;

    STLiteralStringLiteralNode(STNode startSingleQuote, STNode content, STNode endSingleQuote) {
        this(startSingleQuote, content, endSingleQuote, Collections.emptyList());
    }

    STLiteralStringLiteralNode(STNode startSingleQuote, STNode content, STNode endSingleQuote, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LITERAL_STRING, diagnostics);
        this.startSingleQuote = startSingleQuote;
        this.content = content;
        this.endSingleQuote = endSingleQuote;
        this.addChildren(startSingleQuote, content, endSingleQuote);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STLiteralStringLiteralNode(this.startSingleQuote, this.content, this.endSingleQuote, diagnostics);
    }

    public STLiteralStringLiteralNode modify(STNode startSingleQuote, STNode content, STNode endSingleQuote) {
        if (this.checkForReferenceEquality(startSingleQuote, content, endSingleQuote)) {
            return this;
        }
        return new STLiteralStringLiteralNode(startSingleQuote, content, endSingleQuote, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new LiteralStringLiteralNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

