/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class STToken
extends STNode {
    protected final STNode leadingMinutiae;
    protected final STNode trailingMinutiae;
    protected final int lookback = 1;
    protected final int lookahead = 1;

    STToken(SyntaxKind kind, STNode leadingMinutiae, STNode trailingMinutiae) {
        this(kind, kind.stringValue().length(), leadingMinutiae, trailingMinutiae);
    }

    STToken(SyntaxKind kind, int width, STNode leadingMinutiae, STNode trailingMinutiae) {
        this(kind, width, leadingMinutiae, trailingMinutiae, Collections.emptyList());
    }

    STToken(SyntaxKind kind, int width, STNode leadingMinutiae, STNode trailingMinutiae, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.leadingMinutiae = leadingMinutiae;
        this.trailingMinutiae = trailingMinutiae;
        this.width = width;
        this.widthWithLeadingMinutiae = this.width + leadingMinutiae.width;
        this.widthWithTrailingMinutiae = this.width + trailingMinutiae.width;
        this.widthWithMinutiae = this.width + leadingMinutiae.width + trailingMinutiae.width;
    }

    public String text() {
        return this.kind.stringValue();
    }

    @Override
    public STNode leadingMinutiae() {
        return this.leadingMinutiae;
    }

    @Override
    public STNode trailingMinutiae() {
        return this.trailingMinutiae;
    }

    public int lookbackTokenCount() {
        return 1;
    }

    @Override
    public List<STToken> tokens() {
        return Collections.singletonList(this);
    }

    @Override
    protected void tokensInternal(List<STToken> tokens) {
        tokens.add(this);
    }

    @Override
    public STToken firstToken() {
        return this;
    }

    @Override
    public STToken lastToken() {
        return this;
    }

    @Override
    public STToken modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STToken(this.kind, this.width, this.leadingMinutiae, this.trailingMinutiae, diagnostics);
    }

    public STToken modifyWith(STNode leadingMinutiae, STNode trailingMinutiae) {
        return new STToken(this.kind, this.width, leadingMinutiae, trailingMinutiae, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new Token(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.leadingMinutiae) + this.kind.stringValue() + String.valueOf(this.trailingMinutiae);
    }

    @Override
    public void writeTo(StringBuilder builder) {
        this.leadingMinutiae.writeTo(builder);
        builder.append(this.kind.stringValue());
        this.trailingMinutiae.writeTo(builder);
    }
}

