/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.diagnostics.DiagnosticComparator;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class TomlNode {
    private final TomlType kind;
    private final TomlNodeLocation location;
    private final Node syntaxTreeNode;
    protected Set<Diagnostic> diagnostics;

    public TomlNode(Node syntaxTreeNode, TomlType kind, TomlNodeLocation location) {
        this.kind = kind;
        this.location = location;
        this.syntaxTreeNode = syntaxTreeNode;
        this.diagnostics = new TreeSet<Diagnostic>(new DiagnosticComparator());
        this.diagnostics.addAll(TomlNode.reportSyntaxDiagnostics(syntaxTreeNode.diagnostics()));
    }

    public abstract void accept(TomlNodeVisitor var1);

    public Set<Diagnostic> diagnostics() {
        return this.diagnostics;
    }

    public void clearDiagnostics() {
        this.diagnostics.clear();
    }

    public void addDiagnostic(Diagnostic diagnostic) {
        this.diagnostics.add(diagnostic);
    }

    public void addDiagnostics(List<Diagnostic> diagnostics) {
        this.diagnostics.addAll(diagnostics);
    }

    public TomlNodeLocation location() {
        return this.location;
    }

    public Node externalTreeNode() {
        return this.syntaxTreeNode;
    }

    public TomlType kind() {
        return this.kind;
    }

    public boolean isMissingNode() {
        return this.syntaxTreeNode.isMissing();
    }

    private static Set<Diagnostic> reportSyntaxDiagnostics(Iterable<Diagnostic> syntaxDiagnostics) {
        TreeSet<Diagnostic> diagnostics = new TreeSet<Diagnostic>(new DiagnosticComparator());
        for (Diagnostic syntaxDiagnostic : syntaxDiagnostics) {
            TomlNodeLocation tomlNodeLocation = new TomlNodeLocation(syntaxDiagnostic.location().lineRange(), syntaxDiagnostic.location().textRange());
            TomlDiagnostic tomlDiagnostic = new TomlDiagnostic(tomlNodeLocation, syntaxDiagnostic.diagnosticInfo(), syntaxDiagnostic.message());
            diagnostics.add(tomlDiagnostic);
        }
        return diagnostics;
    }
}

