/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.ballerinalang.maven.Dependency;
import org.ballerinalang.maven.TransferListener;
import org.ballerinalang.maven.exceptions.MavenResolverException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class MavenResolver {
    Dependency rootNode = null;
    private final List<RemoteRepository> repositories;
    RepositorySystem system;
    DefaultRepositorySystemSession session;

    public MavenResolver(String targetLocation) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.system = locator.getService(RepositorySystem.class);
        this.session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(targetLocation);
        this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(this.session, localRepo));
        this.repositories = new ArrayList<RemoteRepository>();
        this.repositories.add(new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2/").build());
        this.repositories.add(new RemoteRepository.Builder("wso2-nexus", "default", "https://maven.wso2.org/nexus/content/groups/public/").build());
        String localRepoPath = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        if (new File(localRepoPath).exists()) {
            this.repositories.add(new RemoteRepository.Builder("local", "default", "file:" + localRepoPath).build());
        }
    }

    public void addRepository(String id, String url) {
        this.repositories.add(new RemoteRepository.Builder(id, "default", url).build());
    }

    public void addRepository(String id, String url, String username, String password) {
        Authentication authentication = new AuthenticationBuilder().addUsername(username).addPassword(password).build();
        this.repositories.add(new RemoteRepository.Builder(id, "default", url).setAuthentication(authentication).build());
    }

    private Dependency convertDependency(DependencyNode dependencyNode) {
        return new Dependency(dependencyNode.getArtifact().getGroupId(), dependencyNode.getArtifact().getArtifactId(), dependencyNode.getArtifact().getVersion());
    }

    public Dependency resolve(String groupId, String artifactId, String version, boolean resolveTransitiveDependencies) throws MavenResolverException {
        DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
        if (resolveTransitiveDependencies) {
            try {
                DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter("compile");
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRoot(new org.eclipse.aether.graph.Dependency(artifact, "compile"));
                collectRequest.setRepositories(this.repositories);
                DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
                this.system.resolveDependencies(this.session, dependencyRequest);
                CollectResult collectResult = this.system.collectDependencies(this.session, collectRequest);
                DependencyNode node = collectResult.getRoot();
                node.accept(new TreeDependencyVisitor(new DependencyVisitor(){
                    int level = 0;

                    @Override
                    public boolean visitEnter(DependencyNode dependencyNode) {
                        Dependency currentNode = MavenResolver.this.convertDependency(dependencyNode);
                        if (this.level == 0) {
                            MavenResolver.this.rootNode = currentNode;
                        } else {
                            Dependency parent = MavenResolver.this.rootNode;
                            for (int i = 0; i < this.level; ++i) {
                                if (this.level <= 1) continue;
                                parent = MavenResolver.this.rootNode.getDepedencies().get(MavenResolver.this.rootNode.getDepedencies().size() - 1);
                            }
                            parent.addDependency(currentNode);
                        }
                        ++this.level;
                        return true;
                    }

                    @Override
                    public boolean visitLeave(DependencyNode dependencyNode) {
                        --this.level;
                        return true;
                    }
                }));
            }
            catch (DependencyCollectionException | DependencyResolutionException e) {
                throw new MavenResolverException(e.getMessage());
            }
        }
        try {
            this.session.setTransferListener(new TransferListener());
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(artifact);
            artifactRequest.setRepositories(this.repositories);
            this.system.resolveArtifact(this.session, artifactRequest);
            this.rootNode = new Dependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenResolverException(e.getMessage());
        }
        return this.rootNode;
    }
}

