/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.maven.bala.client;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.ballerinalang.maven.bala.client.MavenResolverClientException;
import org.ballerinalang.maven.bala.client.TransferListenerForClient;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class MavenResolverClient {
    public static final String PLATFORM = "platform";
    public static final String BALA_EXTENSION = "bala";
    public static final String POM = "pom";
    public static final String DEFAULT_REPO = "default";
    public static final String ARTIFACT_SEPERATOR = "-";
    RepositorySystem system;
    DefaultRepositorySystemSession session;
    RemoteRepository.Builder repository;

    public MavenResolverClient() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.system = locator.getService(RepositorySystem.class);
        this.session = MavenRepositorySystemUtils.newSession();
    }

    public void pullPackage(String groupId, String artifactId, String version, String targetLocation) throws MavenResolverClientException {
        LocalRepository localRepo = new LocalRepository(targetLocation);
        this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(this.session, localRepo));
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, BALA_EXTENSION, version);
        try {
            this.session.setTransferListener(new TransferListenerForClient());
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(artifact);
            artifactRequest.addRepository(this.repository.build());
            this.system.resolveArtifact(this.session, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new MavenResolverClientException(e.getMessage());
        }
    }

    public void pushPackage(Path balaPath, String orgName, String packageName, String version, Path localRepoPath) throws MavenResolverClientException {
        LocalRepository localRepo = new LocalRepository(localRepoPath.toAbsolutePath().toString());
        this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(this.session, localRepo));
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.setRepository(this.repository.build());
        Artifact mainArtifact = new DefaultArtifact(orgName, packageName, BALA_EXTENSION, version).setFile(balaPath.toFile());
        deployRequest.addArtifact(mainArtifact);
        try {
            File temporaryPom = this.generatePomFile(orgName, packageName, version);
            deployRequest.addArtifact(new SubArtifact(mainArtifact, "", POM, temporaryPom));
            this.system.deploy(this.session, deployRequest);
        }
        catch (IOException | DeploymentException e) {
            throw new MavenResolverClientException(e.getMessage());
        }
    }

    public void addRepository(String id, String url) {
        this.repository = new RemoteRepository.Builder(id, DEFAULT_REPO, url);
    }

    public void addRepository(String id, String url, String username, String password) {
        Authentication authentication = new AuthenticationBuilder().addUsername(username).addPassword(password).build();
        this.repository = new RemoteRepository.Builder(id, DEFAULT_REPO, url).setAuthentication(authentication);
    }

    public void setProxy(String url, int port, String username, String password) {
        Proxy proxy;
        if (url.isEmpty() || port == 0) {
            return;
        }
        if (!username.isEmpty() && !password.isEmpty()) {
            Authentication authentication = new AuthenticationBuilder().addUsername(username).addPassword(password).build();
            proxy = new Proxy(null, url, port, authentication);
        } else {
            proxy = new Proxy(null, url, port);
        }
        this.repository.setProxy(proxy);
    }

    private File generatePomFile(String groupId, String artifactId, String version) throws IOException {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setVersion(version);
        model.setPackaging(BALA_EXTENSION);
        File tempFile = File.createTempFile(groupId + ARTIFACT_SEPERATOR + artifactId + ARTIFACT_SEPERATOR + version, ".pom");
        tempFile.deleteOnExit();
        XmlStreamWriter fw = WriterFactory.newXmlWriter(tempFile);
        new MavenXpp3Writer().write(fw, model);
        ((Writer)fw).close();
        return tempFile;
    }
}

