/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiCounter<K> {
    private static final Logger logger = LoggerFactory.getLogger(MultiCounter.class);
    private Map<K, AtomicInteger> counterMap = new ConcurrentHashMap<K, AtomicInteger>();

    public synchronized int incrementAndGet(K key) {
        if (!this.counterMap.containsKey(key)) {
            this.counterMap.put(key, new AtomicInteger(1));
            logger.debug("IncrementAndGet key: {}, count: {}", key, (Object)1);
            return 1;
        }
        int tally = this.counterMap.get(key).incrementAndGet();
        logger.debug("IncrementAndGet key: {}, count: {}", key, (Object)tally);
        return tally;
    }

    public synchronized int decrementAndGet(K key) {
        if (this.counterMap.containsKey(key)) {
            int tally = this.counterMap.get(key).decrementAndGet();
            logger.debug("DecrementAndGet key: {}, count: {}", key, (Object)tally);
            return tally;
        }
        this.counterMap.put(key, new AtomicInteger(-1));
        logger.debug("DecrementAndGet key: {}, count: {}", key, (Object)-1);
        return -1;
    }

    public int get(K key) {
        if (this.counterMap.get(key) == null) {
            return 0;
        }
        return this.counterMap.get(key).get();
    }

    public List<K> getAllKeys() {
        return new ArrayList<K>(this.counterMap.keySet());
    }

    public List<K> getKeysWithNonZeroCount() {
        return this.counterMap.keySet().stream().filter(key -> this.counterMap.get(key).get() != 0).collect(Collectors.toList());
    }
}

