/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.nativeimpl;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.time.nativeimpl.Civil;
import io.ballerina.stdlib.time.nativeimpl.CustomDuration;
import io.ballerina.stdlib.time.nativeimpl.Utc;
import io.ballerina.stdlib.time.nativeimpl.Zone;
import io.ballerina.stdlib.time.util.Errors;
import io.ballerina.stdlib.time.util.Utils;
import java.time.DateTimeException;
import java.time.ZonedDateTime;

public class TimeZoneExternUtils {
    private static final String ZONE_ID_ENTRY = "zoneId";

    private TimeZoneExternUtils() {
    }

    public static Object externTimeZoneInitWithSystemZone(BObject timeZoneObj) {
        try {
            Zone zone = new Zone();
            timeZoneObj.addNativeData(ZONE_ID_ENTRY, (Object)zone);
            return null;
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static void externTimeZoneInitWithId(BObject timeZoneObj, BString zoneId) {
        Zone zone = new Zone(zoneId.getValue());
        timeZoneObj.addNativeData(ZONE_ID_ENTRY, (Object)zone);
    }

    public static Object externTimeZoneFixedOffset(BObject timeZoneObj) {
        Zone zone = (Zone)timeZoneObj.getNativeData(ZONE_ID_ENTRY);
        return zone.isFixedOffset();
    }

    public static Object externTimeZoneUtcFromCivil(BObject timeZoneObj, long year, long month, long day, long hour, long minute, BDecimal second, BString zoneAbbr, BString zoneHandling) {
        Zone zone = (Zone)timeZoneObj.getNativeData(ZONE_ID_ENTRY);
        ZonedDateTime zonedDateTime = Utils.createZoneDateTimeFromCivilValues(year, month, day, hour, minute, second, 0L, 0L, BDecimal.valueOf((int)0), zoneAbbr, zoneHandling.getValue());
        return zone.utcFromCivil(new Civil(zonedDateTime)).build();
    }

    public static BMap externTimeZoneUtcToCivil(BObject timeZoneObj, BArray utc) {
        Zone zone = (Zone)timeZoneObj.getNativeData(ZONE_ID_ENTRY);
        return zone.utcToCivil(new Utc(utc)).build();
    }

    public static Object externTimeZoneCivilAddDuration(BObject timeZoneObj, int year, int month, int day, int hour, int minute, BDecimal second, int zoneHour, int zoneMinute, BDecimal zoneSecond, BString zoneAbbrev, BString zoneHandling, int duYears, int duMonths, int duDays, int duHours, int duMinutes, BDecimal duSeconds) {
        try {
            Zone zone = (Zone)timeZoneObj.getNativeData(ZONE_ID_ENTRY);
            ZonedDateTime zonedDateTime = Utils.createZoneDateTimeFromCivilValues(year, month, day, hour, minute, second, zoneHour, zoneMinute, zoneSecond, zoneAbbrev, zoneHandling.getValue());
            CustomDuration customDuration = new CustomDuration(duYears, duMonths, duDays, duHours, duMinutes, duSeconds);
            return zone.civilAddDuration(new Civil(zonedDateTime), customDuration);
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }
}

