/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.nativeimpl;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.time.nativeimpl.Civil;
import io.ballerina.stdlib.time.nativeimpl.CustomDuration;
import io.ballerina.stdlib.time.nativeimpl.Utc;
import io.ballerina.stdlib.time.util.Utils;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;

public class Zone {
    private ZoneId zoneId;

    public Zone() throws DateTimeException {
        this.zoneId = ZoneId.systemDefault();
    }

    public Zone(String zoneId) {
        this.zoneId = ZoneId.of(zoneId);
    }

    public Object isFixedOffset() {
        if (this.zoneId.getRules().isFixedOffset()) {
            Map<String, Integer> zoneInfo = Utils.zoneOffsetMapFromString(this.zoneId.getRules().getOffset(Instant.now()).toString());
            return Utils.createZoneOffsetFromZoneInfoMap(zoneInfo);
        }
        return null;
    }

    public Utc utcFromCivil(Civil civil) {
        return new Utc(civil.getZonedDateTime().toInstant());
    }

    public Civil utcToCivil(Utc utc) {
        return new Civil(utc.generateInstant().atZone(this.zoneId));
    }

    public BMap<BString, Object> civilAddDuration(Civil civil, CustomDuration customDuration) {
        return civil.addDuration(this.zoneId, customDuration).build();
    }
}

