/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.util;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.time.util.Constants;
import io.ballerina.stdlib.time.util.Errors;
import io.ballerina.stdlib.time.util.ModuleUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    private Utils() {
    }

    public static Map<String, Integer> zoneOffsetMapFromString(String dateTime) {
        HashMap<String, Integer> zone = new HashMap<String, Integer>();
        if (dateTime.strip().startsWith("+")) {
            String[] zoneInfo = (dateTime = dateTime.replaceFirst("\\+", "")).split(":");
            if (zoneInfo.length > 0 && zoneInfo[0] != null) {
                zone.put("hours", Integer.parseInt(zoneInfo[0]));
            }
            if (zoneInfo.length > 1 && zoneInfo[1] != null) {
                zone.put("minutes", Integer.parseInt(zoneInfo[1]));
            }
            if (zoneInfo.length > 2 && zoneInfo[2] != null) {
                zone.put("seconds", Integer.parseInt(zoneInfo[2]));
            }
        } else if (dateTime.strip().startsWith("-")) {
            String[] zoneInfo = (dateTime = dateTime.replaceFirst("\\-", "")).split(":");
            if (zoneInfo.length > 0 && zoneInfo[0] != null) {
                zone.put("hours", Integer.parseInt(zoneInfo[0]) * -1);
            }
            if (zoneInfo.length > 1 && zoneInfo[1] != null) {
                zone.put("minutes", Integer.parseInt(zoneInfo[1]) * -1);
            }
            if (zoneInfo.length > 2 && zoneInfo[2] != null) {
                zone.put("seconds", Integer.parseInt(zoneInfo[2]) * -1);
            }
        }
        return zone;
    }

    public static BMap<BString, Object> createZoneOffsetFromZoneInfoMap(Map<String, Integer> zoneInfo) {
        BMap zoneOffsetMap = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"ReadWriteZoneOffset");
        if (zoneInfo.get("hours") != null) {
            zoneOffsetMap.put((Object)Constants.ZONE_OFFSET_RECORD_HOUR_BSTRING, (Object)zoneInfo.get("hours").longValue());
        } else {
            zoneOffsetMap.put((Object)Constants.ZONE_OFFSET_RECORD_HOUR_BSTRING, (Object)0);
        }
        if (zoneInfo.get("minutes") != null) {
            zoneOffsetMap.put((Object)Constants.ZONE_OFFSET_RECORD_MINUTE_BSTRING, (Object)zoneInfo.get("minutes").longValue());
        } else {
            zoneOffsetMap.put((Object)Constants.ZONE_OFFSET_RECORD_MINUTE_BSTRING, (Object)0);
        }
        if (zoneInfo.get("seconds") != null) {
            zoneOffsetMap.put((Object)Constants.ZONE_OFFSET_RECORD_SECOND_BSTRING, (Object)zoneInfo.get("seconds").longValue());
        }
        zoneOffsetMap.freezeDirect();
        return zoneOffsetMap;
    }

    public static ZonedDateTime createZoneDateTimeFromCivilValues(long year, long month, long day, long hour, long minute, BDecimal second, long zoneHour, long zoneMinute, BDecimal zoneSecond, BString zoneAbbr, String zoneHandling) {
        int intSecond = second.decimalValue().setScale(0, RoundingMode.FLOOR).intValue();
        int intNanoSecond = second.decimalValue().subtract(new BigDecimal(intSecond)).multiply(Constants.ANALOG_GIGA).setScale(0, RoundingMode.HALF_UP).intValue();
        int intZoneSecond = zoneSecond.decimalValue().setScale(0, RoundingMode.HALF_UP).intValue();
        ZoneId zoneId = Constants.HeaderZoneHandling.PREFER_ZONE_OFFSET.toString().equals(zoneHandling) ? ZoneId.of(ZoneOffset.ofHoursMinutesSeconds(Long.valueOf(zoneHour).intValue(), Long.valueOf(zoneMinute).intValue(), intZoneSecond).toString()) : ZoneId.of(zoneAbbr.getValue());
        return ZonedDateTime.of(Long.valueOf(year).intValue(), Long.valueOf(month).intValue(), Long.valueOf(day).intValue(), Long.valueOf(hour).intValue(), Long.valueOf(minute).intValue(), intSecond, intNanoSecond, zoneId);
    }

    public static BError createError(Errors errorType, String errorMsg) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorType.name(), (BString)StringUtils.fromString((String)errorMsg), null, null);
    }

    public static Duration createTimeDuration(int hours, int minutes, int seconds, int nanoSeconds) {
        return Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusNanos(nanoSeconds);
    }
}

