/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ModuleMemberVisitor
extends NodeVisitor {
    Set<TypeDefinitionNode> typeDefinitionNodes = new LinkedHashSet<TypeDefinitionNode>();
    Set<ListenerDeclarationNode> listenerDeclarationNodes = new LinkedHashSet<ListenerDeclarationNode>();
    Set<ClassDefinitionNode> interceptorServiceClassNodes = new LinkedHashSet<ClassDefinitionNode>();
    Set<ServiceContractType> serviceContractTypeNodes = new LinkedHashSet<ServiceContractType>();
    Map<String, VariableDeclaredValue> variableDeclarations = new LinkedHashMap<String, VariableDeclaredValue>();
    SemanticModel semanticModel;

    public ModuleMemberVisitor(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
        this.typeDefinitionNodes.add(typeDefinitionNode);
        Node descriptorNode = MapperCommonUtils.getTypeDescriptor(typeDefinitionNode);
        if (descriptorNode.kind().equals((Object)SyntaxKind.OBJECT_TYPE_DESC) && MapperCommonUtils.isHttpServiceContract(descriptorNode, this.semanticModel)) {
            this.serviceContractTypeNodes.add(new ServiceContractType(typeDefinitionNode));
        }
    }

    public void visit(ListenerDeclarationNode listenerDeclarationNode) {
        this.listenerDeclarationNodes.add(listenerDeclarationNode);
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        this.interceptorServiceClassNodes.add(classDefinitionNode);
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        if (this.notBelongsToTheServiceModule((Node)moduleVariableDeclarationNode)) {
            return;
        }
        TypedBindingPatternNode typedBindingPatternNode = moduleVariableDeclarationNode.typedBindingPattern();
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        BindingPatternNode bindingPatternNode = typedBindingPatternNode.bindingPattern();
        if (!bindingPatternNode.kind().equals((Object)SyntaxKind.CAPTURE_BINDING_PATTERN) || !typeDescriptorNode.kind().equals((Object)SyntaxKind.INT_TYPE_DESC) && !typeDescriptorNode.kind().equals((Object)SyntaxKind.VAR_TYPE_DESC)) {
            return;
        }
        CaptureBindingPatternNode captureBindingPatternNode = (CaptureBindingPatternNode)bindingPatternNode;
        if (captureBindingPatternNode.variableName().isMissing()) {
            return;
        }
        String variableName = captureBindingPatternNode.variableName().text();
        Optional variableValue = moduleVariableDeclarationNode.initializer();
        boolean isConfigurable = moduleVariableDeclarationNode.qualifiers().stream().anyMatch(token -> token.kind().equals((Object)SyntaxKind.CONFIGURABLE_KEYWORD));
        variableValue.ifPresent(expressionNode -> this.variableDeclarations.put(variableName, new VariableDeclaredValue((ExpressionNode)expressionNode, isConfigurable)));
    }

    public void visit(ConstantDeclarationNode constantDeclarationNode) {
        if (this.notBelongsToTheServiceModule((Node)constantDeclarationNode)) {
            return;
        }
        String variableName = constantDeclarationNode.variableName().text();
        Node variableValue = constantDeclarationNode.initializer();
        if (variableValue instanceof ExpressionNode) {
            ExpressionNode valueExpression = (ExpressionNode)variableValue;
            this.variableDeclarations.put(variableName, new VariableDeclaredValue(valueExpression, false));
        }
    }

    public Set<ListenerDeclarationNode> getListenerDeclarationNodes() {
        return this.listenerDeclarationNodes;
    }

    public Optional<TypeDefinitionNode> getTypeDefinitionNode(String typeName) {
        for (TypeDefinitionNode typeDefinitionNode : this.typeDefinitionNodes) {
            if (!MapperCommonUtils.unescapeIdentifier(typeDefinitionNode.typeName().text()).equals(typeName)) continue;
            return Optional.of(typeDefinitionNode);
        }
        return Optional.empty();
    }

    public Optional<ClassDefinitionNode> getInterceptorServiceClassNode(String typeName) {
        for (ClassDefinitionNode classDefinitionNode : this.interceptorServiceClassNodes) {
            if (!MapperCommonUtils.unescapeIdentifier(classDefinitionNode.className().text()).equals(typeName)) continue;
            return Optional.of(classDefinitionNode);
        }
        return Optional.empty();
    }

    public boolean hasVariableDeclaration(String variableName) {
        return this.variableDeclarations.containsKey(variableName);
    }

    public VariableDeclaredValue getVariableDeclaredValue(String variableName) {
        return this.variableDeclarations.get(variableName);
    }

    public Set<ServiceContractType> getServiceContractTypeNodes() {
        return this.serviceContractTypeNodes;
    }

    private boolean notBelongsToTheServiceModule(Node node) {
        return this.semanticModel.symbol(node).isEmpty();
    }

    public record VariableDeclaredValue(ExpressionNode value, boolean isConfigurable) {
    }
}

