/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.openapi.service.mapper.model.ServiceDeclaration;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Objects;

public class OASGenerationMetaInfo {
    private final String openApiFileName;
    private final Path ballerinaFilePath;
    private final SemanticModel semanticModel;
    private final ServiceNode serviceNode;
    private final Project project;
    private final Boolean ballerinaExtensionLevel;

    public OASGenerationMetaInfo(OASGenerationMetaInfoBuilder builder) {
        this.openApiFileName = builder.openApiFileName;
        this.ballerinaFilePath = builder.ballerinaFilePath;
        this.semanticModel = builder.semanticModel;
        ServiceNode serviceNodeFromBuilder = builder.serviceNode;
        if (Objects.isNull(serviceNodeFromBuilder)) {
            serviceNodeFromBuilder = new ServiceDeclaration(builder.serviceDeclarationNode, this.semanticModel);
        }
        this.serviceNode = serviceNodeFromBuilder;
        this.project = builder.project;
        this.ballerinaExtensionLevel = builder.ballerinaExtension;
    }

    public String getOpenApiFileName() {
        return this.openApiFileName;
    }

    public Path getBallerinaFilePath() {
        return this.ballerinaFilePath;
    }

    public SemanticModel getSemanticModel() {
        return this.semanticModel;
    }

    public ServiceNode getServiceNode() {
        return this.serviceNode;
    }

    public Project getProject() {
        return this.project;
    }

    public Boolean getBallerinaExtension() {
        return this.ballerinaExtensionLevel;
    }

    public static class OASGenerationMetaInfoBuilder {
        private String openApiFileName;
        private Path ballerinaFilePath;
        private SemanticModel semanticModel;
        private ServiceDeclarationNode serviceDeclarationNode;
        private ServiceNode serviceNode;
        private Project project;
        private Boolean ballerinaExtension = false;

        public OASGenerationMetaInfoBuilder setBallerinaFilePath(Path ballerinaFilePath) {
            this.ballerinaFilePath = ballerinaFilePath;
            return this;
        }

        public OASGenerationMetaInfoBuilder setSemanticModel(SemanticModel semanticModel) {
            this.semanticModel = semanticModel;
            return this;
        }

        @Deprecated(forRemoval=true, since="2.1.0")
        public OASGenerationMetaInfoBuilder setServiceDeclarationNode(ServiceDeclarationNode serviceDeclarationNode) {
            this.serviceDeclarationNode = serviceDeclarationNode;
            return this;
        }

        public OASGenerationMetaInfoBuilder setServiceNode(ServiceNode serviceNode) {
            this.serviceNode = serviceNode;
            return this;
        }

        public OASGenerationMetaInfoBuilder setOpenApiFileName(String openApiFileName) {
            this.openApiFileName = openApiFileName;
            return this;
        }

        public OASGenerationMetaInfoBuilder setBallerinaExtension(Boolean balExt) {
            this.ballerinaExtension = balExt;
            return this;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public OASGenerationMetaInfo build() {
            return new OASGenerationMetaInfo(this);
        }
    }
}

