/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.ballerina.openapi.service.mapper.type.UnionTypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RecordTypeMapper
extends AbstractTypeMapper {
    public RecordTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)this.typeSymbol.typeDescriptor();
        return RecordTypeMapper.getSchema(recordTypeSymbol, components, this.name, this.additionalData).description(this.description);
    }

    public static Schema getSchema(RecordTypeSymbol typeSymbol, Components components, String recordName, AdditionalData additionalData) {
        HashSet<String> fieldsOnlyForRequiredList = new HashSet<String>();
        ObjectSchema schema = new ObjectSchema();
        HashSet<String> requiredFields = new HashSet<String>();
        LinkedHashMap<String, RecordFieldSymbol> recordFieldMap = new LinkedHashMap<String, RecordFieldSymbol>(typeSymbol.fieldDescriptors());
        List<Schema> allOfSchemaList = RecordTypeMapper.mapIncludedRecords(typeSymbol, components, recordFieldMap, additionalData, recordName, fieldsOnlyForRequiredList);
        RecordFieldMappingContext mappingContext = new RecordFieldMappingContext(recordFieldMap, components, requiredFields, recordName, false, true, additionalData, fieldsOnlyForRequiredList);
        Map<String, Schema> properties = RecordTypeMapper.mapRecordFields(mappingContext);
        Optional restFieldType = typeSymbol.restTypeDescriptor();
        if (restFieldType.isPresent()) {
            if (!additionalData.semanticModel().types().JSON.subtypeOf((TypeSymbol)restFieldType.get())) {
                Schema restFieldSchema = TypeMapperImpl.getTypeSchema((TypeSymbol)restFieldType.get(), components, additionalData);
                schema.additionalProperties((Object)restFieldSchema);
            }
        } else {
            schema.additionalProperties((Object)false);
        }
        schema.setRequired(requiredFields.stream().toList());
        schema.setProperties(properties);
        if (!allOfSchemaList.isEmpty()) {
            ObjectSchema schemaWithAllOf = new ObjectSchema();
            allOfSchemaList.add((Schema)schema);
            schemaWithAllOf.setAllOf(allOfSchemaList);
            return schemaWithAllOf;
        }
        return schema;
    }

    static List<Schema> mapIncludedRecords(RecordTypeSymbol typeSymbol, Components components, Map<String, RecordFieldSymbol> recordFieldMap, AdditionalData additionalData, String recordName, Set<String> fieldsOnlyForRequiredList) {
        ArrayList<Schema> allOfSchemaList = new ArrayList<Schema>();
        List typeInclusions = typeSymbol.typeInclusions();
        for (TypeSymbol typeInclusion : typeInclusions) {
            if (typeInclusion.typeKind() != TypeDescKind.TYPE_REFERENCE || ((TypeReferenceTypeSymbol)typeInclusion).typeDescriptor().typeKind() != TypeDescKind.RECORD) continue;
            Schema includedRecordSchema = TypeMapperImpl.getTypeSchema(typeInclusion, components, additionalData);
            allOfSchemaList.add(includedRecordSchema);
            RecordTypeSymbol includedRecordTypeSymbol = (RecordTypeSymbol)((TypeReferenceTypeSymbol)typeInclusion).typeDescriptor();
            Map includedRecordFieldMap = includedRecordTypeSymbol.fieldDescriptors();
            for (Map.Entry<String, RecordFieldSymbol> entry : includedRecordFieldMap.entrySet()) {
                if (!recordFieldMap.containsKey(entry.getKey())) continue;
                RecordFieldSymbol recordFieldSymbol = recordFieldMap.get(entry.getKey());
                RecordFieldSymbol includedRecordFieldValue = (RecordFieldSymbol)entry.getValue();
                if (!includedRecordFieldValue.typeDescriptor().equals((Object)recordFieldSymbol.typeDescriptor())) continue;
                IncludedFieldContext context = new IncludedFieldContext(recordFieldMap, recordName, typeInclusion, entry, recordFieldSymbol, includedRecordFieldValue);
                RecordTypeMapper.eliminateRedundantFields(context, additionalData, fieldsOnlyForRequiredList);
            }
        }
        return allOfSchemaList;
    }

    private static void eliminateRedundantFields(IncludedFieldContext context, AdditionalData additionalData, Set<String> fieldsOnlyForRequiredList) {
        Map<String, RecordFieldSymbol> recordFieldMap = context.recordFieldMap();
        String recordName = context.recordName();
        TypeSymbol typeInclusion = context.typeInclusion();
        Map.Entry<String, RecordFieldSymbol> includedRecordField = context.includedRecordField();
        RecordFieldSymbol recordFieldSymbol = context.recordFieldSymbol();
        RecordFieldSymbol includedRecordFieldValue = context.includedRecordFieldValue();
        boolean recordHasDefault = recordFieldSymbol.hasDefaultValue();
        boolean includedHasDefault = includedRecordFieldValue.hasDefaultValue();
        boolean hasTypeInclusionName = typeInclusion.getName().isPresent();
        boolean isIncludedOptional = includedRecordFieldValue.isOptional();
        boolean isRecordFieldOptional = recordFieldSymbol.isOptional();
        boolean recordFieldName = recordFieldSymbol.getName().isPresent();
        if (recordHasDefault && includedHasDefault && hasTypeInclusionName) {
            boolean onlyIncludedHasDefault;
            Optional<Object> recordFieldDefaultValueOpt = RecordTypeMapper.getRecordFieldDefaultValue(recordName, includedRecordField.getKey(), additionalData.moduleMemberVisitor(), additionalData.semanticModel());
            Optional<Object> includedFieldDefaultValueOpt = RecordTypeMapper.getRecordFieldDefaultValue((String)typeInclusion.getName().get(), includedRecordField.getKey(), additionalData.moduleMemberVisitor(), additionalData.semanticModel());
            boolean defaultsAreEqual = recordFieldDefaultValueOpt.isPresent() && includedFieldDefaultValueOpt.isPresent() && recordFieldDefaultValueOpt.get().toString().equals(includedFieldDefaultValueOpt.get().toString());
            boolean bl = onlyIncludedHasDefault = recordFieldDefaultValueOpt.isEmpty() && includedFieldDefaultValueOpt.isPresent();
            if (defaultsAreEqual || onlyIncludedHasDefault) {
                recordFieldMap.remove(includedRecordField.getKey());
            }
        } else if (!recordHasDefault && !includedHasDefault) {
            recordFieldMap.remove(includedRecordField.getKey());
        }
        if (!isRecordFieldOptional && isIncludedOptional && !recordHasDefault && recordFieldName) {
            fieldsOnlyForRequiredList.add(MapperCommonUtils.unescapeIdentifier((String)recordFieldSymbol.getName().get()));
            recordFieldMap.remove(includedRecordField.getKey());
        }
    }

    public static Map<String, Schema> mapRecordFields(RecordFieldMappingContext context) {
        Map<String, RecordFieldSymbol> recordFieldMap = context.recordFieldMap();
        Components components = context.components();
        Set<String> requiredFields = context.requiredFields();
        String recordName = context.recordName();
        boolean treatNilableAsOptional = context.treatNilableAsOptional();
        boolean inferNameFromJsonData = context.inferNameFromJsonData();
        AdditionalData additionalData = context.additionalData();
        Set<String> fieldsOnlyForRequiredList = context.fieldsOnlyForRequiredList();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        for (Map.Entry<String, RecordFieldSymbol> recordField : recordFieldMap.entrySet()) {
            RecordFieldSymbol recordFieldSymbol = recordField.getValue();
            String recordFieldName = RecordTypeMapper.getRecordFieldName(inferNameFromJsonData, recordField, additionalData.semanticModel());
            if (!(recordFieldSymbol.isOptional() || recordFieldSymbol.hasDefaultValue() || treatNilableAsOptional && UnionTypeMapper.hasNilableType(recordFieldSymbol.typeDescriptor()))) {
                requiredFields.add(recordFieldName);
            }
            if (!fieldsOnlyForRequiredList.isEmpty()) {
                requiredFields.addAll(fieldsOnlyForRequiredList);
            }
            String recordFieldDescription = MapperCommonUtils.getRecordFieldTypeDescription(recordFieldSymbol);
            Schema recordFieldSchema = TypeMapperImpl.getTypeSchema(recordFieldSymbol.typeDescriptor(), components, additionalData);
            if (Objects.nonNull(recordFieldDescription) && Objects.nonNull(recordFieldSchema)) {
                recordFieldSchema = recordFieldSchema.description(recordFieldDescription);
            }
            if (recordFieldSymbol.hasDefaultValue()) {
                Optional<Object> recordFieldDefaultValueOpt = RecordTypeMapper.getRecordFieldDefaultValue(recordName, recordFieldName, additionalData.moduleMemberVisitor(), additionalData.semanticModel());
                if (recordFieldDefaultValueOpt.isPresent()) {
                    TypeMapper.setDefaultValue(recordFieldSchema, recordFieldDefaultValueOpt.get());
                } else {
                    ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_124, recordFieldName);
                    additionalData.diagnostics().add(error);
                }
            }
            if (!Objects.nonNull(recordFieldSchema)) continue;
            properties.put(recordFieldName, recordFieldSchema);
        }
        return properties;
    }

    private static String getRecordFieldName(boolean inferNameFromJsonData, Map.Entry<String, RecordFieldSymbol> recordFieldEntry, SemanticModel semanticModel) {
        String defaultName = MapperCommonUtils.unescapeIdentifier(recordFieldEntry.getKey().trim());
        return inferNameFromJsonData ? MapperCommonUtils.getNameFromAnnotation("data.jsondata", "NameConfig", "value", semanticModel, defaultName, recordFieldEntry.getValue()) : defaultName;
    }

    public static Optional<Object> getRecordFieldDefaultValue(String recordName, String fieldName, ModuleMemberVisitor moduleMemberVisitor, SemanticModel semanticModel) {
        Node node;
        Optional<TypeDefinitionNode> recordDefNodeOpt = moduleMemberVisitor.getTypeDefinitionNode(recordName);
        if (recordDefNodeOpt.isPresent() && (node = recordDefNodeOpt.get().typeDescriptor()) instanceof RecordTypeDescriptorNode) {
            RecordTypeDescriptorNode recordDefNode = (RecordTypeDescriptorNode)node;
            return RecordTypeMapper.getRecordFieldDefaultValue(fieldName, recordDefNode, semanticModel);
        }
        return Optional.empty();
    }

    private static Optional<Object> getRecordFieldDefaultValue(String fieldName, RecordTypeDescriptorNode recordDefNode, SemanticModel semanticModel) {
        NodeList recordFields = recordDefNode.fields();
        RecordFieldWithDefaultValueNode defaultValueNode = recordFields.stream().filter(field -> field instanceof RecordFieldWithDefaultValueNode).map(field -> (RecordFieldWithDefaultValueNode)field).filter(field -> MapperCommonUtils.unescapeIdentifier(field.fieldName().toString().trim()).equals(fieldName)).findFirst().orElse(null);
        if (Objects.isNull(defaultValueNode)) {
            return Optional.empty();
        }
        ExpressionNode defaultValueExpression = defaultValueNode.expression();
        Optional symbol = semanticModel.symbol((Node)defaultValueExpression);
        Optional<Object> value = MapperCommonUtils.getConstantValues(symbol);
        if (value.isPresent()) {
            return value;
        }
        if (MapperCommonUtils.isNotSimpleValueLiteralKind(defaultValueExpression.kind())) {
            return Optional.empty();
        }
        return Optional.of(MapperCommonUtils.parseBalSimpleLiteral(defaultValueExpression.toString().trim()));
    }

    public static RecordTypeInfo getDirectRecordType(TypeSymbol typeSymbol, String recordName) {
        List memberTypeSymbols;
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            return new RecordTypeInfo(recordName, (RecordTypeSymbol)typeSymbol);
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeSymbol referredType = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            String referredRecordName = MapperCommonUtils.getTypeName(typeSymbol);
            return RecordTypeMapper.getDirectRecordType(referredType, referredRecordName);
        }
        if (typeSymbol.typeKind() == TypeDescKind.INTERSECTION) {
            List memberTypeSymbols2 = ((IntersectionTypeSymbol)typeSymbol).memberTypeDescriptors();
            if (memberTypeSymbols2.size() == 2) {
                if (((TypeSymbol)memberTypeSymbols2.get(0)).typeKind() == TypeDescKind.READONLY) {
                    return RecordTypeMapper.getDirectRecordType((TypeSymbol)memberTypeSymbols2.get(1), recordName);
                }
                if (((TypeSymbol)memberTypeSymbols2.get(1)).typeKind() == TypeDescKind.READONLY) {
                    return RecordTypeMapper.getDirectRecordType((TypeSymbol)memberTypeSymbols2.get(0), recordName);
                }
            }
        } else if (typeSymbol.typeKind() == TypeDescKind.UNION && (memberTypeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()).size() == 2) {
            if (((TypeSymbol)memberTypeSymbols.get(0)).typeKind() == TypeDescKind.NIL) {
                return RecordTypeMapper.getDirectRecordType((TypeSymbol)memberTypeSymbols.get(1), recordName);
            }
            if (((TypeSymbol)memberTypeSymbols.get(1)).typeKind() == TypeDescKind.NIL) {
                return RecordTypeMapper.getDirectRecordType((TypeSymbol)memberTypeSymbols.get(0), recordName);
            }
        }
        return null;
    }

    public record RecordFieldMappingContext(Map<String, RecordFieldSymbol> recordFieldMap, Components components, Set<String> requiredFields, String recordName, boolean treatNilableAsOptional, boolean inferNameFromJsonData, AdditionalData additionalData, Set<String> fieldsOnlyForRequiredList) {
    }

    public record IncludedFieldContext(Map<String, RecordFieldSymbol> recordFieldMap, String recordName, TypeSymbol typeInclusion, Map.Entry<String, RecordFieldSymbol> includedRecordField, RecordFieldSymbol recordFieldSymbol, RecordFieldSymbol includedRecordFieldValue) {
    }

    public record RecordTypeInfo(String name, RecordTypeSymbol typeSymbol) {
    }
}

