/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.ReadOnlyTypeMapper;
import io.ballerina.openapi.service.mapper.type.SimpleTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Objects;

public class ReferenceTypeMapper
extends AbstractTypeMapper {
    public ReferenceTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        TypeReferenceTypeSymbol referredType = (TypeReferenceTypeSymbol)this.typeSymbol.typeDescriptor();
        Schema schema = ReferenceTypeMapper.getSchema(referredType, components, this.additionalData);
        if (Objects.nonNull(schema)) {
            schema.description(this.description);
        }
        return schema;
    }

    public static Schema getSchema(TypeReferenceTypeSymbol typeSymbol, Components components, AdditionalData additionalData) {
        if (ReferenceTypeMapper.isBuiltInSubTypes(typeSymbol)) {
            return SimpleTypeMapper.getTypeSchema(typeSymbol.typeDescriptor(), additionalData);
        }
        if (!AbstractTypeMapper.hasMapping(components, (TypeSymbol)typeSymbol)) {
            TypeMapperImpl.createComponentMapping(typeSymbol, components, additionalData);
            if (!AbstractTypeMapper.hasFullMapping(components, (TypeSymbol)typeSymbol)) {
                return null;
            }
        }
        return new ObjectSchema().$ref(MapperCommonUtils.getTypeName((TypeSymbol)typeSymbol));
    }

    public static boolean isBuiltInSubTypes(TypeReferenceTypeSymbol typeSymbol) {
        TypeSymbol referredType = typeSymbol.typeDescriptor();
        return switch (referredType.typeKind()) {
            case TypeDescKind.INT_SIGNED8, TypeDescKind.INT_SIGNED16, TypeDescKind.INT_SIGNED32, TypeDescKind.INT_UNSIGNED8, TypeDescKind.INT_UNSIGNED16, TypeDescKind.INT_UNSIGNED32, TypeDescKind.XML_COMMENT, TypeDescKind.XML_ELEMENT, TypeDescKind.XML_PROCESSING_INSTRUCTION, TypeDescKind.XML_TEXT, TypeDescKind.STRING_CHAR -> true;
            default -> false;
        };
    }

    public static TypeSymbol getReferredType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
            TypeSymbol referencedType = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            if (referencedType.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                return ReferenceTypeMapper.getReferredType(referencedType);
            }
            return referencedType;
        }
        if (typeSymbol.typeKind().equals((Object)TypeDescKind.INTERSECTION)) {
            TypeSymbol effectiveType = ReadOnlyTypeMapper.getEffectiveType((IntersectionTypeSymbol)typeSymbol);
            if (Objects.isNull(effectiveType)) {
                return null;
            }
            return ReferenceTypeMapper.getReferredType(effectiveType);
        }
        return typeSymbol;
    }

    public static IntersectionTypeSymbol getReferredIntersectionType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
            TypeSymbol referencedType = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            if (referencedType.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                return ReferenceTypeMapper.getReferredIntersectionType(referencedType);
            }
            if (referencedType.typeKind().equals((Object)TypeDescKind.INTERSECTION)) {
                return (IntersectionTypeSymbol)referencedType;
            }
            return null;
        }
        if (typeSymbol.typeKind().equals((Object)TypeDescKind.INTERSECTION)) {
            return (IntersectionTypeSymbol)typeSymbol;
        }
        return null;
    }
}

