/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDeclaration;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDefinition;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;

public class MapperCommonUtils {
    private static final SyntaxKind[] validExpressionKind = new SyntaxKind[]{SyntaxKind.STRING_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.MAPPING_CONSTRUCTOR, SyntaxKind.UNARY_EXPRESSION};

    public static String generateRelativePath(ResourceFunction resourceFunction) {
        StringBuilder relativePath = new StringBuilder();
        relativePath.append("/");
        if (!resourceFunction.relativeResourcePath().isEmpty()) {
            for (Node node : resourceFunction.relativeResourcePath()) {
                if (node instanceof ResourcePathParameterNode) {
                    ResourcePathParameterNode pathNode = (ResourcePathParameterNode)node;
                    relativePath.append("{");
                    relativePath.append(pathNode.paramName().get());
                    relativePath.append("}");
                    continue;
                }
                if (resourceFunction.relativeResourcePath().size() == 1 && node.toString().trim().equals(".")) {
                    return relativePath.toString();
                }
                relativePath.append(node.toString().trim());
            }
        }
        return relativePath.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getOperationId(ResourceFunction resourceFunction) {
        String relativePath = MapperCommonUtils.generateRelativePath(resourceFunction);
        String cleanResourcePath = MapperCommonUtils.unescapeIdentifier(relativePath);
        String resName = (resourceFunction.functionName() + "_" + cleanResourcePath).replace("{}", "_");
        if (cleanResourcePath.equals("/")) {
            resName = resourceFunction.functionName();
        }
        if (resName.matches("\\b[0-9]*\\b")) {
            return resName;
        }
        String[] split = resName.split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
        StringBuilder validName = new StringBuilder();
        for (String string : split) {
            void var9_9;
            if (string.isBlank()) continue;
            if (split.length > 1) {
                String string2 = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1).toLowerCase(Locale.ENGLISH);
            }
            validName.append((String)var9_9);
        }
        resName = validName.toString();
        return resName.substring(0, 1).toLowerCase(Locale.ENGLISH) + resName.substring(1);
    }

    public static Optional<String> extractServiceAnnotationDetails(NodeList<AnnotationNode> annotations, String annotationReference, String annotationField) {
        for (AnnotationNode annotation : annotations) {
            List<String> expressionNode = MapperCommonUtils.extractAnnotationFieldDetails(annotationReference, annotationField, annotation, null);
            if (expressionNode.isEmpty()) continue;
            return Optional.of(expressionNode.get(0));
        }
        return Optional.empty();
    }

    public static List<String> extractAnnotationFieldDetails(String annotationReference, String annotationField, AnnotationNode annotation, SemanticModel semanticModel) {
        ArrayList<String> mediaTypes = new ArrayList<String>();
        Node annotReference = annotation.annotReference();
        if (annotReference.toString().trim().equals(annotationReference) && annotation.annotValue().isPresent()) {
            MappingConstructorExpressionNode listOfAnnotValue = (MappingConstructorExpressionNode)annotation.annotValue().get();
            for (MappingFieldNode field : listOfAnnotValue.fields()) {
                SpecificFieldNode fieldNode = (SpecificFieldNode)field;
                if (!fieldNode.fieldName().toString().trim().equals(annotationField) || fieldNode.valueExpr().isEmpty()) continue;
                ExpressionNode expressionNode = (ExpressionNode)fieldNode.valueExpr().get();
                if (expressionNode instanceof ListConstructorExpressionNode) {
                    SeparatedNodeList mimeList = ((ListConstructorExpressionNode)expressionNode).expressions();
                    for (Object mime : mimeList) {
                        if (!(mime instanceof BasicLiteralNode)) continue;
                        mediaTypes.add(((BasicLiteralNode)mime).literalToken().text().trim().replaceAll("\"", ""));
                    }
                    continue;
                }
                if (expressionNode instanceof QualifiedNameReferenceNode) {
                    QualifiedNameReferenceNode moduleRef = (QualifiedNameReferenceNode)expressionNode;
                    if (semanticModel != null) {
                        Optional refSymbol = semanticModel.symbol((Node)moduleRef);
                        if (!refSymbol.isPresent() || ((Symbol)refSymbol.get()).kind() != SymbolKind.CONSTANT || !((ConstantSymbol)refSymbol.get()).resolvedValue().isPresent()) continue;
                        String mediaType = (String)((ConstantSymbol)refSymbol.get()).resolvedValue().get();
                        mediaTypes.add(mediaType.replaceAll("\"", ""));
                        continue;
                    }
                }
                mediaTypes.add(expressionNode.toString().trim().replaceAll("\"", ""));
            }
        }
        return mediaTypes;
    }

    public static OASResult parseOpenAPIFile(String definitionURI) {
        ExceptionDiagnostic diagnostic;
        ExceptionDiagnostic diagnostic2;
        ArrayList<OpenAPIMapperDiagnostic> diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();
        Path contractPath = Paths.get(definitionURI, new String[0]);
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setResolveFully(true);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            diagnostic2 = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_110, new String[0]);
            diagnostics.add(diagnostic2);
        }
        if (!(definitionURI.endsWith(".yaml") || definitionURI.endsWith(".json") || definitionURI.endsWith(".yml"))) {
            diagnostic2 = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_110, new String[0]);
            diagnostics.add(diagnostic2);
        }
        String openAPIFileContent = null;
        try {
            openAPIFileContent = Files.readString(contractPath);
        }
        catch (IOException e) {
            diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_108, e.toString());
            diagnostics.add(diagnostic);
        }
        SwaggerParseResult parseResult = new OpenAPIV3Parser().readContents(openAPIFileContent, null, parseOptions);
        if (!parseResult.getMessages().isEmpty()) {
            diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_112, new String[0]);
            diagnostics.add(diagnostic);
            return new OASResult(null, diagnostics);
        }
        OpenAPI api = parseResult.getOpenAPI();
        return new OASResult(api, diagnostics);
    }

    public static String normalizeTitle(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        String[] urlPaths = serviceName.replaceFirst("/", "").split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
        StringBuilder stringBuilder = new StringBuilder();
        String title = serviceName;
        if (urlPaths.length > 1) {
            for (String path : urlPaths) {
                if (path.isBlank()) continue;
                stringBuilder.append(path.substring(0, 1).toUpperCase(Locale.ENGLISH));
                stringBuilder.append(path.substring(1));
                stringBuilder.append(" ");
            }
            title = stringBuilder.toString().trim();
        } else if (urlPaths.length == 1 && !urlPaths[0].isBlank()) {
            stringBuilder.append(urlPaths[0].substring(0, 1).toUpperCase(Locale.ENGLISH));
            stringBuilder.append(urlPaths[0].substring(1));
            title = stringBuilder.toString().trim();
        }
        return title;
    }

    public static boolean isHttpService(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Optional serviceSymbol = semanticModel.symbol((Node)serviceNode);
        if (serviceSymbol.isEmpty()) {
            return false;
        }
        ServiceDeclarationSymbol serviceNodeSymbol = (ServiceDeclarationSymbol)serviceSymbol.get();
        List listenerTypes = serviceNodeSymbol.listenerTypes();
        for (TypeSymbol listenerType : listenerTypes) {
            if (!MapperCommonUtils.isHttpListener(listenerType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHttpServiceContract(Node typeNode, SemanticModel semanticModel) {
        Object t;
        Object t2;
        ObjectTypeDescriptorNode serviceObjType;
        if (!(typeNode instanceof ObjectTypeDescriptorNode) || !MapperCommonUtils.isServiceObjectType(serviceObjType = (ObjectTypeDescriptorNode)typeNode)) {
            return false;
        }
        Optional serviceObjSymbol = semanticModel.symbol((Node)serviceObjType.parent());
        if (serviceObjSymbol.isEmpty() || !((t2 = serviceObjSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceObjTypeDef = (TypeDefinitionSymbol)t2;
        Optional serviceContractType = semanticModel.types().getTypeByName("ballerina", "http", "", "ServiceContract");
        if (serviceContractType.isEmpty() || !((t = serviceContractType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceContractTypeDef = (TypeDefinitionSymbol)t;
        return serviceObjTypeDef.typeDescriptor().subtypeOf(serviceContractTypeDef.typeDescriptor());
    }

    private static boolean isServiceObjectType(ObjectTypeDescriptorNode typeNode) {
        return typeNode.objectTypeQualifiers().stream().anyMatch(qualifier -> qualifier.kind().equals((Object)SyntaxKind.SERVICE_KEYWORD));
    }

    private static boolean isHttpListener(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> MapperCommonUtils.isHttpModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return MapperCommonUtils.isHttpModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }

    private static boolean isHttpModule(ModuleSymbol moduleSymbol) {
        if (moduleSymbol.getName().isPresent()) {
            return "http".equals(moduleSymbol.getName().get()) && "ballerina".equals(moduleSymbol.id().orgName());
        }
        return false;
    }

    public static String getOpenApiFileName(String servicePath, String serviceName, boolean isJson) {
        Object openAPIFileName;
        if (serviceName.isBlank() || serviceName.equals("/") || serviceName.startsWith("/-")) {
            String[] fileName = serviceName.split("/");
            openAPIFileName = fileName.length > 0 && !serviceName.isBlank() ? FilenameUtils.removeExtension((String)servicePath) + fileName[1] : FilenameUtils.removeExtension((String)servicePath);
        } else if (serviceName.startsWith("-")) {
            openAPIFileName = FilenameUtils.removeExtension((String)servicePath) + serviceName;
        } else {
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            openAPIFileName = serviceName.replaceAll("/", "_");
        }
        return MapperCommonUtils.getNormalizedFileName((String)openAPIFileName) + "_openapi" + (isJson ? ".json" : ".yaml");
    }

    public static String getNormalizedFileName(String openAPIFileName) {
        String[] splitNames = openAPIFileName.split("[^a-zA-Z0-9]");
        if (splitNames.length > 0) {
            return Arrays.stream(splitNames).filter(namePart -> !namePart.isBlank()).collect(Collectors.joining("_"));
        }
        return openAPIFileName;
    }

    public static boolean containErrors(List<Diagnostic> diagnostics) {
        return diagnostics != null && diagnostics.stream().anyMatch(diagnostic -> diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR);
    }

    public static String unescapeIdentifier(String parameterName) {
        String unescapedParamName = IdentifierUtils.unescapeBallerina((String)parameterName);
        return unescapedParamName.replaceAll("\\\\", "").replaceAll("'", "");
    }

    public static String getHeaderName(ParameterNode parameterNode, String defaultName) {
        return MapperCommonUtils.getParamName("http:Header", parameterNode, defaultName);
    }

    public static String getQueryName(ParameterNode parameterNode, String defaultName) {
        return MapperCommonUtils.getParamName("http:Query", parameterNode, defaultName);
    }

    public static String getParamName(String paramTypeName, ParameterNode parameterNode, String defaultName) {
        NodeList annotations = null;
        if (parameterNode instanceof RequiredParameterNode) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            annotations = requiredParameterNode.annotations();
        } else if (parameterNode instanceof DefaultableParameterNode) {
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
            annotations = defaultableParameterNode.annotations();
        }
        if (Objects.isNull(annotations) || annotations.isEmpty()) {
            return defaultName;
        }
        for (AnnotationNode annotation : annotations) {
            String valueExpression;
            if (!annotation.annotReference().toString().trim().equals(paramTypeName) || !Objects.nonNull(valueExpression = MapperCommonUtils.getNameFromParamAnnotation(annotation))) continue;
            return valueExpression;
        }
        return defaultName;
    }

    private static String getNameFromParamAnnotation(AnnotationNode annotation) {
        Optional annotationRecord = annotation.annotValue();
        if (annotationRecord.isEmpty()) {
            return null;
        }
        SeparatedNodeList fields = ((MappingConstructorExpressionNode)annotationRecord.get()).fields();
        for (MappingFieldNode field : fields) {
            ExpressionNode valueExpression;
            Optional expressionNode;
            SpecificFieldNode specificFieldNode;
            if (!(field instanceof SpecificFieldNode) || !(specificFieldNode = (SpecificFieldNode)field).fieldName().toString().trim().equals("name") || !(expressionNode = specificFieldNode.valueExpr()).isPresent() || !(valueExpression = (ExpressionNode)expressionNode.get()).kind().equals((Object)SyntaxKind.STRING_LITERAL)) continue;
            return valueExpression.toString().trim().replaceAll("\"", "");
        }
        return null;
    }

    public static String getTypeDescription(TypeReferenceTypeSymbol typeSymbol) {
        Optional documentation;
        Symbol definition = typeSymbol.definition();
        if (definition instanceof Documentable && (documentation = ((Documentable)definition).documentation()).isPresent() && ((Documentation)documentation.get()).description().isPresent()) {
            return ((String)((Documentation)documentation.get()).description().get()).trim();
        }
        return null;
    }

    public static String getRecordFieldTypeDescription(RecordFieldSymbol typeSymbol) {
        Optional documentation = typeSymbol.documentation();
        if (documentation.isPresent() && ((Documentation)documentation.get()).description().isPresent()) {
            return ((String)((Documentation)documentation.get()).description().get()).trim();
        }
        return null;
    }

    public static String getTypeName(TypeSymbol typeSymbol) {
        String typeName = typeSymbol.getName().orElse(typeSymbol.signature());
        return MapperCommonUtils.unescapeIdentifier(typeName);
    }

    public static Object parseBalSimpleLiteral(String literal) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            return mapper.readValue(literal, Object.class);
        }
        catch (JsonProcessingException e) {
            return literal;
        }
    }

    public static boolean isNotSimpleValueLiteralKind(SyntaxKind valueExpressionKind) {
        return Arrays.stream(validExpressionKind).noneMatch(syntaxKind -> syntaxKind == valueExpressionKind);
    }

    public static Optional<AnnotationNode> getResourceConfigAnnotation(ResourceFunction resourceFunction) {
        Optional<MetadataNode> metadata = resourceFunction.metadata();
        if (metadata.isEmpty()) {
            return Optional.empty();
        }
        MetadataNode metaData = metadata.get();
        NodeList annotations = metaData.annotations();
        return annotations.stream().filter(ann -> "http:ResourceConfig".equals(ann.annotReference().toString().trim())).findFirst();
    }

    public static Optional<String> getValueForAnnotationFields(AnnotationNode resourceConfigAnnotation, String fieldName) {
        return resourceConfigAnnotation.annotValue().map(MappingConstructorExpressionNode::fields).flatMap(fields -> fields.stream().filter(fld -> fld instanceof SpecificFieldNode).map(fld -> (SpecificFieldNode)fld).filter(fld -> fieldName.equals(fld.fieldName().toString().trim())).findFirst()).flatMap(SpecificFieldNode::valueExpr).map(en -> en.toString().trim());
    }

    public static Optional<ResourceFunction> getResourceFunction(Node function) {
        SyntaxKind kind = function.kind();
        if (kind.equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)) {
            return Optional.of(new ResourceFunctionDefinition((FunctionDefinitionNode)function));
        }
        if (kind.equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION)) {
            return Optional.of(new ResourceFunctionDeclaration((MethodDeclarationNode)function));
        }
        return Optional.empty();
    }

    public static Optional<Object> getConstantValues(Optional<Symbol> symbol) {
        ConstantSymbol constantSymbol;
        Object constValue;
        Symbol symbol2;
        if (symbol.isPresent() && (symbol2 = symbol.get()) instanceof ConstantSymbol && (constValue = (constantSymbol = (ConstantSymbol)symbol2).constValue()) instanceof ConstantValue) {
            ConstantValue value = (ConstantValue)constValue;
            return Optional.of(value.value());
        }
        return Optional.empty();
    }

    public static Node getTypeDescriptor(TypeDefinitionNode typeDefinitionNode) {
        Node node = typeDefinitionNode.typeDescriptor();
        if (node instanceof DistinctTypeDescriptorNode) {
            DistinctTypeDescriptorNode distinctTypeDescriptorNode = (DistinctTypeDescriptorNode)node;
            return distinctTypeDescriptorNode.typeDescriptor();
        }
        return node;
    }

    public static String getNameFromAnnotation(String packageName, String annotationName, String annotationFieldName, SemanticModel semanticModel, String defaultName, RecordFieldSymbol recordField) {
        Object value;
        Optional<String> name;
        Optional<AnnotationAttachmentSymbol> annotationAttachment = MapperCommonUtils.getAnnotationAttachment(packageName, annotationName, semanticModel, recordField.annotAttachments());
        if (annotationAttachment.isPresent() && annotationAttachment.get().isConstAnnotation() && annotationAttachment.get().attachmentValue().isPresent() && (name = MapperCommonUtils.getNameFromValue(annotationFieldName, value = ((ConstantValue)annotationAttachment.get().attachmentValue().get()).value())).isPresent()) {
            return name.get();
        }
        return defaultName;
    }

    private static Optional<AnnotationAttachmentSymbol> getAnnotationAttachment(String packageName, String annotationName, SemanticModel semanticModel, List<AnnotationAttachmentSymbol> annotations) {
        return annotations.stream().filter(annotAttachment -> MapperCommonUtils.isMatchingAnnotation(packageName, annotationName, semanticModel, annotAttachment)).findFirst();
    }

    private static boolean isMatchingAnnotation(String packageName, String annotationName, SemanticModel semanticModel, AnnotationAttachmentSymbol annotAttachment) {
        Object t;
        if (annotAttachment.typeDescriptor().typeDescriptor().isEmpty()) {
            return false;
        }
        Optional exampleValueSymbol = semanticModel.types().getTypeByName("ballerina", packageName, "", annotationName);
        if (exampleValueSymbol.isEmpty() || !((t = exampleValueSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceContractInfoType = (TypeDefinitionSymbol)t;
        return ((TypeSymbol)annotAttachment.typeDescriptor().typeDescriptor().get()).subtypeOf(serviceContractInfoType.typeDescriptor());
    }

    private static Optional<String> getNameFromValue(String annotationFieldName, Object value) {
        ConstantValue constantName;
        Object object;
        if (value instanceof ConstantValue) {
            ConstantValue constantNameValue = (ConstantValue)value;
            value = constantNameValue.value();
        } else if (value instanceof BLangConstantValue) {
            BLangConstantValue constantNameValue = (BLangConstantValue)value;
            value = constantNameValue.value;
        }
        if (!(value instanceof HashMap)) {
            return Optional.empty();
        }
        HashMap nameMap = (HashMap)value;
        Object name = nameMap.get(annotationFieldName);
        if (Objects.isNull(name) || !(name instanceof ConstantValue) || !((object = (constantName = (ConstantValue)name).value()) instanceof String)) {
            return Optional.empty();
        }
        String nameFromAnnotation = (String)object;
        return Optional.of(nameFromAnnotation);
    }

    public static class NullLocation
    implements Location {
        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)"", (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }
}

