/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.response.DefaultResponseMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MediaTypeUtils {
    private static final String JSON_PATTERN = "^(application|text)\\/(.*[.+-]|)json$";
    private static final String XML_PATTERN = "^(application|text)\\/(.*[.+-]|)xml$";
    private static final String TEXT_PATTERN = "^(text)\\/(.*[.+-]|)plain$";
    private static final String OCTET_STREAM_PATTERN = "^(application)\\/(.*[.+-]|)octet-stream$";
    private final SemanticModel semanticModel;
    private final TypeSymbol structuredType;
    private final TypeSymbol byteArrayType;
    private final TypeSymbol basicTypesWithoutString;
    private static MediaTypeUtils mediaTypeUtils = null;

    private MediaTypeUtils(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        MapTypeSymbol mapOfAnydata = semanticModel.types().builder().MAP_TYPE.withTypeParam(semanticModel.types().ANYDATA).build();
        TableTypeSymbol tableOfAnydataMap = semanticModel.types().builder().TABLE_TYPE.withRowType((TypeSymbol)mapOfAnydata).build();
        TupleTypeSymbol tupleOfAnydata = semanticModel.types().builder().TUPLE_TYPE.withRestType(semanticModel.types().ANYDATA).build();
        UnionTypeSymbol structuredUnion = semanticModel.types().builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{mapOfAnydata, tableOfAnydataMap, tupleOfAnydata}).build();
        ArrayTypeSymbol structuredArray = semanticModel.types().builder().ARRAY_TYPE.withType((TypeSymbol)structuredUnion).build();
        this.structuredType = semanticModel.types().builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{mapOfAnydata, tableOfAnydataMap, tupleOfAnydata, structuredArray}).build();
        this.byteArrayType = semanticModel.types().builder().ARRAY_TYPE.withType(semanticModel.types().BYTE).build();
        this.basicTypesWithoutString = semanticModel.types().builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{semanticModel.types().BOOLEAN, semanticModel.types().INT, semanticModel.types().FLOAT, semanticModel.types().DECIMAL}).build();
    }

    public static synchronized MediaTypeUtils getInstance(SemanticModel semanticModel) {
        if (Objects.isNull(mediaTypeUtils) || !MediaTypeUtils.mediaTypeUtils.semanticModel.equals((Object)semanticModel)) {
            mediaTypeUtils = new MediaTypeUtils(semanticModel);
        }
        return mediaTypeUtils;
    }

    public String getMediaTypeFromType(TypeSymbol typeSymbol, String prefix, List<String> allowedMediaTypes) {
        String mediaType;
        if (typeSymbol.subtypeOf(this.semanticModel.types().STRING)) {
            mediaType = MediaTypeUtils.getCompatibleMediaType(allowedMediaTypes, TEXT_PATTERN, "text/plain");
        } else if (typeSymbol.subtypeOf(this.semanticModel.types().XML)) {
            mediaType = MediaTypeUtils.getCompatibleMediaType(allowedMediaTypes, XML_PATTERN, "application/xml");
        } else if (typeSymbol.subtypeOf(this.byteArrayType)) {
            mediaType = MediaTypeUtils.getCompatibleMediaType(allowedMediaTypes, OCTET_STREAM_PATTERN, "application/octet-stream");
        } else {
            if (DefaultResponseMapper.isSubTypeOfHttpResponse(typeSymbol, this.semanticModel)) {
                return "*/*";
            }
            mediaType = MediaTypeUtils.getCompatibleMediaType(allowedMediaTypes, JSON_PATTERN, "application/json");
        }
        return MediaTypeUtils.addMediaTypePrefix(mediaType, prefix);
    }

    private static String addMediaTypePrefix(String mediaType, String prefix) {
        if (prefix.trim().isEmpty() || mediaType.equals("*/*")) {
            return mediaType;
        }
        String[] mediaTypeParts = mediaType.split("/");
        if (mediaTypeParts.length == 2) {
            return mediaTypeParts[0] + "/" + prefix + "+" + mediaTypeParts[1];
        }
        return mediaType;
    }

    private static String getCompatibleMediaType(List<String> allowedMediaTypes, String pattern, String defaultMediaType) {
        if (Objects.isNull(allowedMediaTypes) || allowedMediaTypes.isEmpty()) {
            return defaultMediaType;
        }
        if (allowedMediaTypes.size() == 1) {
            return allowedMediaTypes.get(0);
        }
        for (String mediaType : allowedMediaTypes) {
            if (!mediaType.matches(pattern)) continue;
            return mediaType;
        }
        return defaultMediaType;
    }

    public boolean isSameMediaType(TypeSymbol typeSymbol) {
        if (typeSymbol.subtypeOf(this.semanticModel.types().STRING) || typeSymbol.subtypeOf(this.semanticModel.types().XML) || typeSymbol.subtypeOf(this.byteArrayType) || typeSymbol.subtypeOf(this.basicTypesWithoutString)) {
            return true;
        }
        return this.isStructuredType(typeSymbol);
    }

    private boolean isStructuredType(TypeSymbol typeSymbol) {
        return typeSymbol.subtypeOf(this.structuredType);
    }

    public static Optional<String> extractCustomMediaType(ResourceFunction functionDefNode) {
        MetadataNode metadataNode;
        NodeList annotations;
        Optional<MetadataNode> serviceMetadata = functionDefNode.parentMetaData();
        if (serviceMetadata.isPresent() && !(annotations = (metadataNode = serviceMetadata.get()).annotations()).isEmpty()) {
            return MapperCommonUtils.extractServiceAnnotationDetails((NodeList<AnnotationNode>)annotations, "http:ServiceConfig", "mediaTypeSubtypePrefix");
        }
        return Optional.empty();
    }
}

