/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public enum HttpDiagnostic {
    HTTP_101("HTTP_101", "remote methods are not allowed in http:Service", DiagnosticSeverity.ERROR),
    HTTP_102("HTTP_102", "invalid resource method return type: expected 'anydata|http:Response|http:StatusCodeResponse|stream<http:SseEvent, error?>|stream<http:SseEvent, error>|error', but found '%s'", DiagnosticSeverity.ERROR),
    HTTP_104("HTTP_104", "invalid annotation type on param '%s': expected one of the following types: 'http:Payload', 'http:CallerInfo', 'http:Header', 'http:Query'", DiagnosticSeverity.ERROR),
    HTTP_105("HTTP_105", "invalid resource parameter '%s'", DiagnosticSeverity.ERROR),
    HTTP_106("HTTP_106", "invalid resource parameter type: '%s'", DiagnosticSeverity.ERROR),
    HTTP_107("HTTP_107", "invalid payload parameter type: '%s'", DiagnosticSeverity.ERROR),
    HTTP_108("HTTP_108", "invalid multiple resource parameter annotations for '%s': expected one of the following types: 'http:Payload', 'http:CallerInfo', 'http:Header', 'http:Query'", DiagnosticSeverity.ERROR),
    HTTP_109("HTTP_109", "invalid type of header param '%s': expected one of the following types is expected: 'string','int','float','decimal','boolean', an array of the above types or a record which consists of the above types", DiagnosticSeverity.ERROR),
    HTTP_110("HTTP_110", "invalid union type of header param '%s': expected one of the 'string','int','float','decimal','boolean' types, an array of the above types or a record which consists of the above types can only be union with '()'. Eg: string|() or string[]|()", DiagnosticSeverity.ERROR),
    HTTP_111("HTTP_111", "invalid type of caller param '%s': expected 'http:Caller'", DiagnosticSeverity.ERROR),
    HTTP_112("HTTP_112", "invalid type of query param '%s': expected one of the 'string', 'int', 'float', 'boolean', 'decimal', 'map<anydata>' types or the array types of them", DiagnosticSeverity.ERROR),
    HTTP_113("HTTP_113", "invalid union type of query param '%s': 'string', 'int', 'float', 'boolean', 'decimal', 'map<anydata>' type or the array types of them can only be union with '()'. Eg: string? or int[]?", DiagnosticSeverity.ERROR),
    HTTP_114("HTTP_114", "incompatible respond method argument type : expected '%s' according to the 'http:CallerInfo' annotation", DiagnosticSeverity.ERROR),
    HTTP_115("HTTP_115", "invalid multiple 'http:Caller' parameter: '%s'", DiagnosticSeverity.ERROR),
    HTTP_116("HTTP_116", "invalid multiple 'http:Request' parameter: '%s'", DiagnosticSeverity.ERROR),
    HTTP_117("HTTP_117", "invalid multiple 'http:Headers' parameter: '%s'", DiagnosticSeverity.ERROR),
    HTTP_118("HTTP_118", "invalid resource method return type: can not use 'http:Caller' and return '%s' from a resource : expected 'error' or nil", DiagnosticSeverity.ERROR),
    HTTP_119("HTTP_119", "invalid media-type subtype prefix: subtype prefix should not have suffix '%s'", DiagnosticSeverity.ERROR),
    HTTP_120("HTTP_120", "invalid media-type subtype '%s'", DiagnosticSeverity.ERROR),
    HTTP_121("HTTP_121", "invalid multiple 'http:RequestContext' parameter: '%s'", DiagnosticSeverity.ERROR),
    HTTP_122("HTTP_122", "invalid multiple 'error' parameter: '%s'", DiagnosticSeverity.ERROR),
    HTTP_123("HTTP_123", "invalid multiple interceptor type reference: '%s'", DiagnosticSeverity.ERROR),
    HTTP_124("HTTP_124", "invalid multiple interceptor resource functions", DiagnosticSeverity.ERROR),
    HTTP_125("HTTP_125", "invalid annotation '%s': annotations are not supported for interceptor resource functions", DiagnosticSeverity.ERROR),
    HTTP_126("HTTP_126", "invalid interceptor resource method return type: expected 'anydata|http:Response|http:StatusCodeResponse|http:NextService|error?', but found '%s'", DiagnosticSeverity.ERROR),
    HTTP_127("HTTP_127", "invalid interceptor resource path: expected default resource path: '[string... path]', but found '%s'", DiagnosticSeverity.ERROR),
    HTTP_128("HTTP_128", "invalid interceptor resource method: expected default resource method: 'default', but found '%s'", DiagnosticSeverity.ERROR),
    HTTP_129("HTTP_129", "invalid usage of payload annotation for a non entity body resource : '%s'. Use an accessor that supports entity body", DiagnosticSeverity.ERROR),
    HTTP_130("HTTP_130", "invalid usage of cache annotation with return type : '%s'. Cache annotation only supports return types of anydata and SuccessStatusCodeResponse", DiagnosticSeverity.ERROR),
    HTTP_131("HTTP_131", "invalid usage of payload annotation with return type : '%s'", DiagnosticSeverity.ERROR),
    HTTP_132("HTTP_132", "%s must have a resource method", DiagnosticSeverity.ERROR),
    HTTP_133("HTTP_133", "invalid intersection type : '%s'. Only readonly type is allowed", DiagnosticSeverity.ERROR),
    HTTP_134("HTTP_134", "'readonly' intersection type is not allowed for parameter '%s' of the type '%s'", DiagnosticSeverity.ERROR),
    HTTP_135("HTTP_135", "%s must have the remote method : '%s'", DiagnosticSeverity.ERROR),
    HTTP_136("HTTP_136", "resource function is not allowed in %s", DiagnosticSeverity.ERROR),
    HTTP_137("HTTP_137", "remote function is not allowed in %s", DiagnosticSeverity.ERROR),
    HTTP_138("HTTP_138", "invalid remote function : '%s'. %s can have only '%s' remote function", DiagnosticSeverity.ERROR),
    HTTP_139("HTTP_139", "invalid multiple 'http:Response' parameter: '%s'", DiagnosticSeverity.ERROR),
    HTTP_140("HTTP_140", "invalid parameter type: '%s' in '%s' remote method", DiagnosticSeverity.ERROR),
    HTTP_141("HTTP_141", "invalid interceptor remote method return type: expected 'anydata|http:Response|http:StatusCodeResponse|http:NextService|error?', but found '%s'", DiagnosticSeverity.ERROR),
    HTTP_142("HTTP_142", "return type annotation is not supported in interceptor service", DiagnosticSeverity.ERROR),
    HTTP_143("HTTP_143", "%s function should have the mandatory parameter 'error'", DiagnosticSeverity.ERROR),
    HTTP_144("HTTP_144", "rest fields are not allowed for header binding records. Use 'http:Headers' type to access all headers", DiagnosticSeverity.ERROR),
    HTTP_145("HTTP_145", "invalid resource path parameter '%s': expected one of the 'string','int','float','decimal','boolean' types or a rest parameter with one of the above types", DiagnosticSeverity.ERROR),
    HTTP_146("HTTP_146", "resource link name: '%s' conflicts with the path. Resource names can be reused only when the resources have the same path", DiagnosticSeverity.ERROR),
    HTTP_147("HTTP_147", "duplicate link relation: '%s'. Resource only supports unique relations", DiagnosticSeverity.ERROR),
    HTTP_148("HTTP_148", "cannot find resource with resource link name: '%s'", DiagnosticSeverity.ERROR),
    HTTP_149("HTTP_149", "cannot resolve linked resource without method", DiagnosticSeverity.ERROR),
    HTTP_150("HTTP_150", "cannot find '%s' resource with resource link name: '%s'", DiagnosticSeverity.ERROR),
    HTTP_151("HTTP_151", "ambiguous types for parameter '%s' and '%s'. Use annotations to avoid ambiguity", DiagnosticSeverity.ERROR),
    HTTP_152("HTTP_152", "invalid union type for default payload param: '%s'. Use basic structured anydata types", DiagnosticSeverity.ERROR),
    HTTP_153("HTTP_153", "'http:ServiceConfig' annotation is not allowed for service declaration implemented via the 'http:ServiceContract' type. The HTTP annotations are inferred from the service contract type", DiagnosticSeverity.ERROR),
    HTTP_154("HTTP_154", "base path not allowed in the service declaration which is implemented via the 'http:ServiceContract' type. The base path is inferred from the service contract type", DiagnosticSeverity.ERROR),
    HTTP_155("HTTP_155", "configuring base path in the 'http:ServiceConfig' annotation is not allowed for non service contract types", DiagnosticSeverity.ERROR),
    HTTP_156("HTTP_156", "invalid service type descriptor found in 'http:ServiceConfig' annotation. Expected service type: '%s' but found: '%s'", DiagnosticSeverity.ERROR),
    HTTP_157("HTTP_157", "'serviceType' is not allowed in the service which is not implemented via the 'http:ServiceContract' type", DiagnosticSeverity.ERROR),
    HTTP_158("HTTP_158", "resource function which is not defined in the service contract type: '%s', is not allowed", DiagnosticSeverity.ERROR),
    HTTP_159("HTTP_159", "'http:ResourceConfig' annotation is not allowed for resource function implemented via the 'http:ServiceContract' type. The HTTP annotations are inferred from the service contract type", DiagnosticSeverity.ERROR),
    HTTP_160("HTTP_160", "'%s' annotation is not allowed for resource function implemented via the 'http:ServiceContract' type. The HTTP annotations are inferred from the service contract type", DiagnosticSeverity.ERROR),
    HTTP_WARNING_101("HTTP_WARNING_101", "generated open-api definition is empty due to the errors in the generation", DiagnosticSeverity.WARNING),
    HTTP_WARNING_102("HTTP_WARNING_102", "The openapi definition is overridden by the `embed: true` option", DiagnosticSeverity.WARNING),
    HTTP_HINT_101("HTTP_HINT_101", "Payload annotation can be added", DiagnosticSeverity.INTERNAL),
    HTTP_HINT_102("HTTP_HINT_102", "Header annotation can be added", DiagnosticSeverity.INTERNAL),
    HTTP_HINT_103("HTTP_HINT_103", "Response content-type can be added", DiagnosticSeverity.INTERNAL),
    HTTP_HINT_104("HTTP_HINT_104", "Response cache configuration can be added", DiagnosticSeverity.INTERNAL),
    HTTP_HINT_105("HTTP_HINT_105", "Service contract: '%s', can be implemented", DiagnosticSeverity.INTERNAL);

    private final String code;
    private final String message;
    private final DiagnosticSeverity severity;

    private HttpDiagnostic(String code, String message, DiagnosticSeverity severity) {
        this.code = code;
        this.message = message;
        this.severity = severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }
}

