/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.stdlib.http.compiler.LinkedResource;
import io.ballerina.stdlib.http.compiler.LinkedToResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinksMetaData {
    Map<String, List<LinkedResource>> linkedResourcesMap = new HashMap<String, List<LinkedResource>>();
    List<Map<String, LinkedToResource>> linkedToResourceMaps = new ArrayList<Map<String, LinkedToResource>>();
    boolean nameRefObjsAvailable = false;

    public Map<String, List<LinkedResource>> getLinkedResourcesMap() {
        return this.linkedResourcesMap;
    }

    public List<Map<String, LinkedToResource>> getLinkedToResourceMaps() {
        return this.linkedToResourceMaps;
    }

    public boolean hasNameReferenceObjects() {
        return this.nameRefObjsAvailable;
    }

    public void markNameRefObjsAvailable() {
        this.nameRefObjsAvailable = true;
    }

    public boolean isValidLinkedResource(String resourceName, String path) {
        List<LinkedResource> linkedResources;
        Iterator<LinkedResource> iterator;
        if (this.linkedResourcesMap.containsKey(resourceName) && (iterator = (linkedResources = this.linkedResourcesMap.get(resourceName)).iterator()).hasNext()) {
            LinkedResource linkedResource = iterator.next();
            return linkedResource.getPath().equals(path);
        }
        return true;
    }

    public void addLinkedResource(String resourceName, String path, String method) {
        if (this.linkedResourcesMap.containsKey(resourceName)) {
            List<LinkedResource> linkedResources = this.linkedResourcesMap.get(resourceName);
            linkedResources.add(new LinkedResource(path, method));
        } else {
            ArrayList<LinkedResource> linkedResources = new ArrayList<LinkedResource>();
            linkedResources.add(new LinkedResource(path, method));
            this.linkedResourcesMap.put(resourceName, linkedResources);
        }
    }

    public void addLinkedToResourceMap(Map<String, LinkedToResource> linkedToResourceMap) {
        this.linkedToResourceMaps.add(linkedToResourceMap);
    }
}

