/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.OASGenerationMetaInfo;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.model.ServiceDeclaration;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.utils.CodegenUtils;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OpenAPISpecGenerator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static boolean isErrorPrinted = false;
    private static final String OAS_PATH_SEPARATOR = "/";
    private static final String OPENAPI = "openapi";
    private static final String UNDERSCORE = "_";

    static void setIsWarningPrinted() {
        isErrorPrinted = true;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Module currentModule;
        ModuleId moduleId = context.moduleId();
        DocumentId documentId = context.documentId();
        Module module = currentModule = context.currentPackage() != null ? context.currentPackage().module(moduleId) : null;
        if (moduleId != null && documentId != null && currentModule != null && currentModule.testDocumentIds() != null && currentModule.testDocumentIds().contains(documentId)) {
            return;
        }
        SemanticModel semanticModel = context.semanticModel();
        SyntaxTree syntaxTree = context.syntaxTree();
        Package currentPackage = context.currentPackage();
        Project project = currentPackage.project();
        BuildOptions buildOptions = project.buildOptions();
        if (!buildOptions.exportOpenAPI()) {
            return;
        }
        boolean hasErrors = context.compilation().diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (hasErrors) {
            if (!isErrorPrinted) {
                OpenAPISpecGenerator.setIsWarningPrinted();
                PrintStream outStream = System.out;
                outStream.println("openapi contract generation is skipped because of the following compilation error(s) in the ballerina package:");
            }
            return;
        }
        Path outPath = project.targetDir();
        Optional path = currentPackage.project().documentPath(context.documentId());
        Path inputPath = path.orElse(null);
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)context.node();
        HashMap<Integer, String> services = new HashMap<Integer, String>();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (MapperCommonUtils.containErrors((List)semanticModel.diagnostics())) {
            diagnostics.addAll(semanticModel.diagnostics());
        } else {
            Optional serviceSymbol = semanticModel.symbol((Node)serviceNode);
            if (serviceSymbol.isPresent() && serviceSymbol.get() instanceof ServiceDeclarationSymbol) {
                OpenAPISpecGenerator.extractServiceNodes((ModulePartNode)syntaxTree.rootNode(), services, semanticModel);
                OASGenerationMetaInfo.OASGenerationMetaInfoBuilder builder = new OASGenerationMetaInfo.OASGenerationMetaInfoBuilder();
                ServiceDeclaration service = new ServiceDeclaration(serviceNode, semanticModel);
                builder.setServiceNode((ServiceNode)service).setSemanticModel(semanticModel).setOpenApiFileName((String)services.get(((Symbol)serviceSymbol.get()).hashCode())).setBallerinaFilePath(inputPath).setProject(project);
                OASResult oasResult = ServiceToOpenAPIMapper.generateOAS((OASGenerationMetaInfo)builder.build());
                oasResult.setServiceName(this.constructFileName(syntaxTree, services, (Symbol)serviceSymbol.get()));
                this.writeOpenAPIYaml(outPath, oasResult, diagnostics);
            }
        }
        if (!diagnostics.isEmpty()) {
            for (Diagnostic diagnostic : diagnostics) {
                context.reportDiagnostic(diagnostic);
            }
        }
    }

    private String constructFileName(SyntaxTree syntaxTree, Map<Integer, String> services, Symbol serviceSymbol) {
        String fileName = MapperCommonUtils.getNormalizedFileName((String)services.get(serviceSymbol.hashCode()));
        String balFileName = syntaxTree.filePath().replaceAll(OAS_PATH_SEPARATOR, UNDERSCORE).split("\\.")[0];
        if (fileName.equals(OAS_PATH_SEPARATOR)) {
            return balFileName + "_openapi.yaml";
        }
        if (fileName.contains("-") && fileName.split("-")[0].equals(OAS_PATH_SEPARATOR) || fileName.isBlank()) {
            return balFileName + UNDERSCORE + serviceSymbol.hashCode() + "_openapi.yaml";
        }
        return fileName + "_openapi.yaml";
    }

    private void writeOpenAPIYaml(Path outPath, OASResult oasResult, List<Diagnostic> diagnostics) {
        if (oasResult.getYaml().isPresent()) {
            try {
                Files.createDirectories(Paths.get(String.valueOf(outPath) + "/openapi", new String[0]), new FileAttribute[0]);
                String serviceName = oasResult.getServiceName();
                String fileName = CodegenUtils.resolveContractFileName((Path)outPath.resolve(OPENAPI), (String)serviceName, (Boolean)false);
                CodegenUtils.writeFile((Path)outPath.resolve("openapi/" + fileName), (String)((String)oasResult.getYaml().get()));
            }
            catch (IOException e) {
                ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_108, new String[]{e.toString()});
                diagnostics.add(OpenAPISpecGenerator.getDiagnostics((OpenAPIMapperDiagnostic)diagnostic));
            }
        }
        if (!oasResult.getDiagnostics().isEmpty()) {
            for (ExceptionDiagnostic diagnostic : oasResult.getDiagnostics()) {
                diagnostics.add(OpenAPISpecGenerator.getDiagnostics((OpenAPIMapperDiagnostic)diagnostic));
            }
        }
    }

    private static void extractServiceNodes(ModulePartNode modulePartNode, Map<Integer, String> services, SemanticModel semanticModel) {
        ArrayList<String> allServices = new ArrayList<String>();
        for (Node node : modulePartNode.members()) {
            ServiceDeclarationNode serviceNode;
            Optional serviceSymbol;
            SyntaxKind syntaxKind = node.kind();
            if (!syntaxKind.equals((Object)SyntaxKind.SERVICE_DECLARATION) || !(serviceSymbol = semanticModel.symbol((Node)(serviceNode = (ServiceDeclarationNode)node))).isPresent() || !(serviceSymbol.get() instanceof ServiceDeclarationSymbol)) continue;
            String service = new ServiceDeclaration(serviceNode, semanticModel).absoluteResourcePath();
            Object updateServiceName = service;
            if (allServices.contains(service)) {
                updateServiceName = service + "-" + ((Symbol)serviceSymbol.get()).hashCode();
            } else {
                allServices.add(service);
            }
            services.put(((Symbol)serviceSymbol.get()).hashCode(), (String)updateServiceName);
        }
    }

    public static Diagnostic getDiagnostics(OpenAPIMapperDiagnostic diagnostic) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnostic.getCode(), diagnostic.getMessage(), diagnostic.getDiagnosticSeverity());
        Location location = diagnostic.getLocation().orElse(new NullLocation());
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
    }

    private static class NullLocation
    implements Location {
        private NullLocation() {
        }

        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)"", (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }
}

