/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.codemodifier.payload;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.stdlib.http.compiler.HttpCompilerPluginUtil;
import io.ballerina.stdlib.http.compiler.HttpServiceValidator;
import io.ballerina.stdlib.http.compiler.ResourceFunction;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDeclaration;
import io.ballerina.stdlib.http.compiler.ResourceFunctionDefinition;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.PayloadParamContext;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.ResourcePayloadParamContext;
import io.ballerina.stdlib.http.compiler.codemodifier.payload.context.ServicePayloadParamContext;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class PayloadAnnotationModifierTask
implements ModifierTask<SourceModifierContext> {
    private final Map<DocumentId, PayloadParamContext> documentContextMap;

    public PayloadAnnotationModifierTask(Map<DocumentId, PayloadParamContext> documentContextMap) {
        this.documentContextMap = documentContextMap;
    }

    public void modify(SourceModifierContext modifierContext) {
        boolean erroneousCompilation = modifierContext.compilation().diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        for (Map.Entry<DocumentId, PayloadParamContext> entry : this.documentContextMap.entrySet()) {
            DocumentId documentId = entry.getKey();
            PayloadParamContext documentContext = entry.getValue();
            this.modifyPayloadParam(modifierContext, documentId, documentContext);
        }
    }

    private void modifyPayloadParam(SourceModifierContext modifierContext, DocumentId documentId, PayloadParamContext documentContext) {
        ModuleId moduleId = documentId.moduleId();
        Module currentModule = modifierContext.currentPackage().module(moduleId);
        Document currentDoc = currentModule.document(documentId);
        ModulePartNode rootNode = (ModulePartNode)currentDoc.syntaxTree().rootNode();
        NodeList<ModuleMemberDeclarationNode> newMembers = this.updateMemberNodes((NodeList<ModuleMemberDeclarationNode>)rootNode.members(), documentContext);
        ModulePartNode newModulePart = rootNode.modify(rootNode.imports(), newMembers, rootNode.eofToken());
        SyntaxTree updatedSyntaxTree = currentDoc.syntaxTree().modifyWith((Node)newModulePart);
        TextDocument textDocument = updatedSyntaxTree.textDocument();
        if (currentModule.documentIds().contains(documentId)) {
            modifierContext.modifySourceFile(textDocument, documentId);
        } else {
            modifierContext.modifyTestSourceFile(textDocument, documentId);
        }
    }

    private NodeList<ModuleMemberDeclarationNode> updateMemberNodes(NodeList<ModuleMemberDeclarationNode> oldMembers, PayloadParamContext documentContext) {
        ArrayList<Object> updatedMembers = new ArrayList<Object>();
        for (ModuleMemberDeclarationNode memberNode : oldMembers) {
            NodeList members;
            int serviceId;
            if (memberNode.kind() == SyntaxKind.SERVICE_DECLARATION && !HttpServiceValidator.isServiceContractImplementation(documentContext.getContext().semanticModel(), (ServiceDeclarationNode)memberNode)) {
                ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)memberNode;
                serviceId = serviceNode.hashCode();
                members = serviceNode.members();
            } else if (memberNode.kind() == SyntaxKind.CLASS_DEFINITION) {
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)memberNode;
                serviceId = classDefinitionNode.hashCode();
                members = classDefinitionNode.members();
            } else if (memberNode.kind() == SyntaxKind.TYPE_DEFINITION && HttpCompilerPluginUtil.isHttpServiceType(documentContext.getContext().semanticModel(), ((TypeDefinitionNode)memberNode).typeDescriptor())) {
                ObjectTypeDescriptorNode serviceTypeDesNode = (ObjectTypeDescriptorNode)((TypeDefinitionNode)memberNode).typeDescriptor();
                serviceId = serviceTypeDesNode.hashCode();
                members = serviceTypeDesNode.members();
            } else {
                updatedMembers.add(memberNode);
                continue;
            }
            if (!documentContext.containsService(serviceId)) {
                updatedMembers.add(memberNode);
                continue;
            }
            ServicePayloadParamContext serviceContext = documentContext.getServiceContext(serviceId);
            ArrayList<Node> resourceMembers = new ArrayList<Node>();
            for (Node member : members) {
                ResourceFunction resourceFunctionNode;
                if (member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                    resourceFunctionNode = new ResourceFunctionDefinition((FunctionDefinitionNode)member);
                } else if (member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DECLARATION) {
                    resourceFunctionNode = new ResourceFunctionDeclaration((MethodDeclarationNode)member);
                } else {
                    resourceMembers.add(member);
                    continue;
                }
                int resourceId = member.hashCode();
                if (!serviceContext.containsResource(resourceId)) {
                    resourceMembers.add(member);
                    continue;
                }
                ResourcePayloadParamContext resourceContext = serviceContext.getResourceContext(resourceId);
                FunctionSignatureNode functionSignatureNode = resourceFunctionNode.functionSignature();
                SeparatedNodeList parameterNodes = functionSignatureNode.parameters();
                ArrayList<Object> newParameterNodes = new ArrayList<Object>();
                int index = 0;
                for (ParameterNode parameterNode : parameterNodes) {
                    if (index++ != resourceContext.getIndex()) {
                        newParameterNodes.add(parameterNode);
                        newParameterNodes.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                        continue;
                    }
                    RequiredParameterNode param = (RequiredParameterNode)parameterNode;
                    AnnotationNode payloadAnnotation = this.getHttpPayloadAnnotation();
                    NodeList annotations = param.annotations();
                    if (Objects.isNull(annotations)) {
                        annotations = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
                    }
                    NodeList updatedAnnotations = annotations.add((Node)payloadAnnotation);
                    RequiredParameterNode.RequiredParameterNodeModifier paramModifier = param.modify();
                    paramModifier.withAnnotations(updatedAnnotations);
                    RequiredParameterNode updatedParam = paramModifier.apply();
                    newParameterNodes.add(updatedParam);
                    newParameterNodes.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                }
                if (newParameterNodes.size() > 1) {
                    newParameterNodes.remove(newParameterNodes.size() - 1);
                }
                FunctionSignatureNode.FunctionSignatureNodeModifier signatureModifier = functionSignatureNode.modify();
                SeparatedNodeList separatedNodeList = AbstractNodeFactory.createSeparatedNodeList(new ArrayList(newParameterNodes));
                signatureModifier.withParameters(separatedNodeList);
                FunctionSignatureNode updatedFunctionNode = signatureModifier.apply();
                Node updatedResourceNode = resourceFunctionNode.modifyWithSignature(updatedFunctionNode);
                resourceMembers.add(updatedResourceNode);
            }
            NodeList resourceNodeList = AbstractNodeFactory.createNodeList(resourceMembers);
            if (memberNode instanceof ServiceDeclarationNode) {
                ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)memberNode;
                ServiceDeclarationNode.ServiceDeclarationNodeModifier serviceDeclarationNodeModifier = serviceNode.modify();
                ServiceDeclarationNode updatedServiceDeclarationNode = serviceDeclarationNodeModifier.withMembers(resourceNodeList).apply();
                updatedMembers.add(updatedServiceDeclarationNode);
                continue;
            }
            if (memberNode instanceof ClassDefinitionNode) {
                ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)memberNode;
                ClassDefinitionNode.ClassDefinitionNodeModifier classDefinitionNodeModifier = classDefinitionNode.modify();
                ClassDefinitionNode updatedClassDefinitionNode = classDefinitionNodeModifier.withMembers(resourceNodeList).apply();
                updatedMembers.add(updatedClassDefinitionNode);
                continue;
            }
            TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)memberNode;
            ObjectTypeDescriptorNode objectTypeDescriptorNode = (ObjectTypeDescriptorNode)typeDefinitionNode.typeDescriptor();
            ObjectTypeDescriptorNode.ObjectTypeDescriptorNodeModifier objectTypeDescriptorNodeModifier = objectTypeDescriptorNode.modify();
            ObjectTypeDescriptorNode updatedObjectTypeDescriptorNode = objectTypeDescriptorNodeModifier.withMembers(resourceNodeList).apply();
            TypeDefinitionNode.TypeDefinitionNodeModifier typeDefinitionNodeModifier = typeDefinitionNode.modify();
            TypeDefinitionNode updatedTypeDefinitionNode = typeDefinitionNodeModifier.withTypeDescriptor((Node)updatedObjectTypeDescriptorNode).apply();
            updatedMembers.add(updatedTypeDefinitionNode);
        }
        return AbstractNodeFactory.createNodeList(updatedMembers);
    }

    private AnnotationNode getHttpPayloadAnnotation() {
        String payloadIdentifierString = "http" + SyntaxKind.COLON_TOKEN.stringValue() + "Payload ";
        IdentifierToken identifierToken = NodeFactory.createIdentifierToken((String)payloadIdentifierString);
        SimpleNameReferenceNode nameReferenceNode = NodeFactory.createSimpleNameReferenceNode((Token)identifierToken);
        Token atToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN);
        return NodeFactory.createAnnotationNode((Token)atToken, (Node)nameReferenceNode, null);
    }
}

