/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer;

import io.ballerina.scan.Rule;
import io.ballerina.scan.RuleKind;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.RuleFactory;

public enum HttpRule {
    AVOID_DEFAULT_RESOURCE_ACCESSOR(RuleFactory.createRule(1, "Avoid allowing default resource accessor", RuleKind.VULNERABILITY)),
    AVOID_PERMISSIVE_CORS(RuleFactory.createRule(2, "Avoid permissive Cross-Origin Resource Sharing", RuleKind.VULNERABILITY)),
    AVOID_TRAVERSING_ATTACKS(RuleFactory.createRule(3, "Server-side requests should not be vulnerable to traversing attacks", RuleKind.VULNERABILITY)),
    AVOID_UNSECURE_REDIRECTIONS(RuleFactory.createRule(4, "HTTP request redirections should not be open to forging attacks", RuleKind.VULNERABILITY));

    private final Rule rule;

    private HttpRule(Rule rule) {
        this.rule = rule;
    }

    public int getId() {
        return this.rule.numericId();
    }

    public String getDescription() {
        return this.rule.description();
    }

    public String toString() {
        return "{\"id\":" + this.getId() + ", \"kind\":\"" + String.valueOf(this.rule.kind()) + "\", \"description\" : \"" + this.rule.description() + "\"}";
    }
}

