/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules;

import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpResourceRuleContext;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpStaticAnalysisUtils;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.HttpResourceRule;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class AvoidDefaultResourceAccessorRule
implements HttpResourceRule {
    @Override
    public void analyze(HttpResourceRuleContext context) {
        Optional resourceMethodOptional = context.resourceMethodSymbol().getName();
        if (resourceMethodOptional.isPresent() && "default".equalsIgnoreCase(HttpStaticAnalysisUtils.unescapeIdentifier((String)resourceMethodOptional.get()))) {
            NodeLocation accessorLocation = context.resourceFunction().functionName().location();
            context.reporter().reportIssue(context.document(), (Location)accessorLocation, this.getRuleId());
        }
    }

    @Override
    public int getRuleId() {
        return HttpRule.AVOID_DEFAULT_RESOURCE_ACCESSOR.getId();
    }
}

