/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules;

import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpResourceRuleContext;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpRule;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.HttpStaticAnalysisUtils;
import io.ballerina.stdlib.http.compiler.staticcodeanalyzer.resourcerules.HttpResourceRule;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public class AvoidTraversingAttacksRule
implements HttpResourceRule {
    @Override
    public void analyze(HttpResourceRuleContext context) {
        List<ClientResourceAccessActionNode> clientResourceActionNodes = context.functionBodyExpressions().stream().filter(exprNodeInfo -> exprNodeInfo.expression() instanceof ClientResourceAccessActionNode).map(exprNodeInfo -> (ClientResourceAccessActionNode)exprNodeInfo.expression()).toList();
        for (ClientResourceAccessActionNode clientResourceActionNode : clientResourceActionNodes) {
            this.analyzeClientResourceAccess(clientResourceActionNode, context);
        }
    }

    @Override
    public int getRuleId() {
        return HttpRule.AVOID_TRAVERSING_ATTACKS.getId();
    }

    @Override
    public boolean isApplicable(HttpResourceRuleContext context) {
        return !context.resourceParamNames().isEmpty() && !context.functionBodyExpressions().isEmpty();
    }

    private void analyzeClientResourceAccess(ClientResourceAccessActionNode clientResourceActionNode, HttpResourceRuleContext context) {
        SeparatedNodeList resourceAccessPaths = clientResourceActionNode.resourceAccessPath();
        for (Node resourceAccessPath : resourceAccessPaths) {
            ComputedResourceAccessSegmentNode computedResourceAccessSegment;
            ExpressionNode expression;
            Optional<String> usedParamName;
            if (!(resourceAccessPath instanceof ComputedResourceAccessSegmentNode) || !(usedParamName = HttpStaticAnalysisUtils.getUsedParamName(expression = (computedResourceAccessSegment = (ComputedResourceAccessSegmentNode)resourceAccessPath).expression())).isPresent() || !context.resourceParamNames().contains(usedParamName.get())) continue;
            context.reporter().reportIssue(context.document(), (Location)computedResourceAccessSegment.location(), this.getRuleId());
        }
    }
}

