/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.compiler;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.tcp.compiler.CompilationErrors;
import io.ballerina.stdlib.tcp.compiler.ReturnStatementNodeVisitor;
import io.ballerina.stdlib.tcp.compiler.TcpConnectionServiceValidator;
import io.ballerina.stdlib.tcp.compiler.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public class TcpServiceValidator {
    private SyntaxNodeAnalysisContext ctx;

    public TcpServiceValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        this.ctx = syntaxNodeAnalysisContext;
    }

    public void validate() {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)this.ctx.node();
        boolean hasRemoteService = serviceDeclarationNode.members().stream().anyMatch(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
        if (serviceDeclarationNode.members().isEmpty() || !hasRemoteService) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo("TCP_106", "Template generation for empty service", DiagnosticSeverity.INTERNAL);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)serviceDeclarationNode.location(), (Object[])new Object[0]));
        }
        serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).forEach(node -> {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            String functionName = functionDefinitionNode.functionName().toString();
            if (Utils.hasRemoteKeyword(functionDefinitionNode) && !Utils.equals(functionName, "onConnect")) {
                this.reportInvalidFunction(functionDefinitionNode);
            } else if (Utils.equals(functionName, "onConnect")) {
                ReturnStatementNodeVisitor returnStatementNodeVisitor = new ReturnStatementNodeVisitor();
                functionDefinitionNode.accept((NodeVisitor)returnStatementNodeVisitor);
                for (ReturnStatementNode returnStatementNode : returnStatementNodeVisitor.getReturnStatementNodes()) {
                    TypeSymbol symbol;
                    ExpressionNode expressionNode = (ExpressionNode)returnStatementNode.expression().get();
                    if (!(expressionNode instanceof ExplicitNewExpressionNode) || (symbol = (TypeSymbol)this.ctx.semanticModel().type((Node)expressionNode).get()).typeKind() != TypeDescKind.TYPE_REFERENCE) continue;
                    TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)symbol;
                    ClassSymbol classSymbol = (ClassSymbol)typeReferenceTypeSymbol.typeDescriptor();
                    TcpConnectionServiceValidator tcpConnectionServiceValidator = new TcpConnectionServiceValidator(this.ctx, classSymbol);
                    tcpConnectionServiceValidator.validate();
                }
            }
        });
    }

    private void reportInvalidFunction(FunctionDefinitionNode functionDefinitionNode) {
        Utils.reportDiagnostics(this.ctx, CompilationErrors.FUNCTION_0_NOT_ACCEPTED_BY_THE_SERVICE, (Location)functionDefinitionNode.location(), functionDefinitionNode.functionName().toString());
    }
}

