/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.flowmodelgenerator.core.AvailableNodesGenerator;
import io.ballerina.flowmodelgenerator.core.CopilotContextGenerator;
import io.ballerina.flowmodelgenerator.core.DeleteNodeHandler;
import io.ballerina.flowmodelgenerator.core.EnclosedNodeFinder;
import io.ballerina.flowmodelgenerator.core.ErrorHandlerGenerator;
import io.ballerina.flowmodelgenerator.core.ModelGenerator;
import io.ballerina.flowmodelgenerator.core.NodeTemplateGenerator;
import io.ballerina.flowmodelgenerator.core.OpenApiServiceGenerator;
import io.ballerina.flowmodelgenerator.core.SourceGenerator;
import io.ballerina.flowmodelgenerator.core.SuggestedComponentService;
import io.ballerina.flowmodelgenerator.core.SuggestedModelGenerator;
import io.ballerina.flowmodelgenerator.core.analyzers.function.ModuleNodeAnalyzer;
import io.ballerina.flowmodelgenerator.core.search.SearchCommand;
import io.ballerina.flowmodelgenerator.core.utils.FileSystemUtils;
import io.ballerina.flowmodelgenerator.extension.request.ComponentDeleteRequest;
import io.ballerina.flowmodelgenerator.extension.request.CopilotContextRequest;
import io.ballerina.flowmodelgenerator.extension.request.EnclosedFuncDefRequest;
import io.ballerina.flowmodelgenerator.extension.request.FilePathRequest;
import io.ballerina.flowmodelgenerator.extension.request.FlowModelAvailableNodesRequest;
import io.ballerina.flowmodelgenerator.extension.request.FlowModelGeneratorRequest;
import io.ballerina.flowmodelgenerator.extension.request.FlowModelNodeTemplateRequest;
import io.ballerina.flowmodelgenerator.extension.request.FlowModelSourceGeneratorRequest;
import io.ballerina.flowmodelgenerator.extension.request.FlowModelSuggestedGenerationRequest;
import io.ballerina.flowmodelgenerator.extension.request.FlowNodeDeleteRequest;
import io.ballerina.flowmodelgenerator.extension.request.FunctionDefinitionRequest;
import io.ballerina.flowmodelgenerator.extension.request.OpenAPIServiceGenerationRequest;
import io.ballerina.flowmodelgenerator.extension.request.SearchRequest;
import io.ballerina.flowmodelgenerator.extension.request.ServiceFieldNodesRequest;
import io.ballerina.flowmodelgenerator.extension.request.SuggestedComponentRequest;
import io.ballerina.flowmodelgenerator.extension.response.ComponentDeleteResponse;
import io.ballerina.flowmodelgenerator.extension.response.CopilotContextResponse;
import io.ballerina.flowmodelgenerator.extension.response.EnclosedFuncDefResponse;
import io.ballerina.flowmodelgenerator.extension.response.FlowModelAvailableNodesResponse;
import io.ballerina.flowmodelgenerator.extension.response.FlowModelGeneratorResponse;
import io.ballerina.flowmodelgenerator.extension.response.FlowModelNodeTemplateResponse;
import io.ballerina.flowmodelgenerator.extension.response.FlowModelSourceGeneratorResponse;
import io.ballerina.flowmodelgenerator.extension.response.FlowNodeDeleteResponse;
import io.ballerina.flowmodelgenerator.extension.response.FunctionDefinitionResponse;
import io.ballerina.flowmodelgenerator.extension.response.OpenApiServiceGenerationResponse;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="flowDesignService")
public class FlowModelGeneratorService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;
    private LSClientLogger lsClientLogger;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.workspaceManager = workspaceManager;
        this.lsClientLogger = LSClientLogger.getInstance((LanguageServerContext)serverContext);
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<FlowModelGeneratorResponse> getFlowModel(FlowModelGeneratorRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelGeneratorResponse response = new FlowModelGeneratorResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                Path projectPath = this.workspaceManager.projectRoot(filePath);
                Optional<Document> dataMappingsDoc = this.getDocumentFromFile(projectPath, "data_mappings.bal");
                Optional<Document> functionsDoc = this.getDocumentFromFile(projectPath, "functions.bal");
                ModelGenerator modelGenerator = new ModelGenerator(project, (SemanticModel)semanticModel.get(), filePath);
                response.setFlowDesignModel(modelGenerator.getFlowModel((Document)document.get(), request.lineRange(), (Document)dataMappingsDoc.orElse(null), (Document)functionsDoc.orElse(null)));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelGeneratorResponse> getSuggestedFlowModel(FlowModelSuggestedGenerationRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelGeneratorResponse response = new FlowModelGeneratorResponse();
            try {
                Optional<Object> newFunctionsDoc;
                Optional<Object> newDataMappingsDoc;
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                Path projectPath = this.workspaceManager.projectRoot(filePath);
                Optional<Document> dataMappingsDoc = this.getDocumentFromFile(projectPath, "data_mappings.bal");
                Optional<Document> functionsDoc = this.getDocumentFromFile(projectPath, "functions.bal");
                ModelGenerator modelGenerator = new ModelGenerator(project, (SemanticModel)semanticModel.get(), filePath);
                JsonElement oldFlowModel = modelGenerator.getFlowModel((Document)document.get(), request.lineRange(), (Document)dataMappingsDoc.orElse(null), (Document)functionsDoc.orElse(null));
                Project newProject = project.duplicate();
                DocumentId documentId = newProject.documentId(filePath);
                Module newModule = newProject.currentPackage().module(documentId.moduleId());
                SemanticModel newSemanticModel = PackageUtil.getCompilation((Project)newProject).getSemanticModel(newModule.moduleId());
                Document newDocument = newModule.document(documentId);
                if (newSemanticModel == null || newDocument == null) {
                    return response;
                }
                try {
                    DocumentId dataMappingDocId = newProject.documentId(projectPath.resolve("data_mappings.bal"));
                    Module dataMappingModule = newProject.currentPackage().module(dataMappingDocId.moduleId());
                    newDataMappingsDoc = Optional.of(dataMappingModule.document(dataMappingDocId));
                    DocumentId functionsDocId = newProject.documentId(projectPath.resolve("functions.bal"));
                    Module functionsModule = newProject.currentPackage().module(functionsDocId.moduleId());
                    newFunctionsDoc = Optional.of(functionsModule.document(functionsDocId));
                }
                catch (Throwable e) {
                    newDataMappingsDoc = Optional.empty();
                    newFunctionsDoc = Optional.empty();
                }
                TextDocument textDocument = newDocument.textDocument();
                int textPosition = textDocument.textPositionFrom(request.position());
                TextEdit textEdit = TextEdit.from((TextRange)TextRange.from((int)textPosition, (int)0), (String)request.text());
                TextDocument newTextDocument = textDocument.apply(TextDocumentChange.from((TextEdit[])List.of(textEdit).toArray(new TextEdit[0])));
                Document newDoc = newDocument.modify().withContent(String.join((CharSequence)System.lineSeparator(), newTextDocument.textLines())).apply();
                int end = textDocument.textPositionFrom(request.endLine());
                LineRange endLineRange = LineRange.from((String)request.lineRange().fileName(), (LinePosition)request.lineRange().startLine(), (LinePosition)newTextDocument.linePositionFrom(end + request.text().length()));
                ModelGenerator suggestedModelGenerator = new ModelGenerator(newProject, PackageUtil.getCompilation((Project)newProject).getSemanticModel(newDoc.module().moduleId()), filePath);
                JsonElement newFlowModel = suggestedModelGenerator.getFlowModel(newDoc, endLineRange, (Document)newDataMappingsDoc.orElse(null), (Document)newFunctionsDoc.orElse(null));
                LinePosition endPosition = newTextDocument.linePositionFrom(textPosition + request.text().length());
                LineRange newLineRange = LineRange.from((String)FlowModelGeneratorService.getRelativePath(projectPath, filePath), (LinePosition)request.position(), (LinePosition)endPosition);
                JsonArray newNodes = newFlowModel.getAsJsonObject().getAsJsonArray("nodes");
                SuggestedModelGenerator suggestedNodesGenerator = new SuggestedModelGenerator(newDoc, newLineRange, newSemanticModel);
                suggestedNodesGenerator.markSuggestedNodes(newNodes, 1);
                if (!suggestedNodesGenerator.hasSuggestedNodes()) {
                    newFlowModel.getAsJsonObject().add("nodes", (JsonElement)new JsonArray());
                }
                response.setFlowDesignModel(newFlowModel);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<JsonObject> getSuggestedComponents(SuggestedComponentRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject response = new JsonObject();
            try {
                String fileContent = request.content();
                Path tempDir = Files.createTempDirectory("single-file-project", new FileAttribute[0]);
                Path tempFilePath = tempDir.resolve("file.bal");
                Files.writeString(tempFilePath, (CharSequence)fileContent, new OpenOption[0]);
                SuggestedComponentService suggestedComponentService = new SuggestedComponentService();
                Project project = this.workspaceManager.loadProject(tempFilePath);
                return suggestedComponentService.getPackageComponent(project);
            }
            catch (Throwable e) {
                return response;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelSourceGeneratorResponse> getSourceCode(FlowModelSourceGeneratorRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelSourceGeneratorResponse response = new FlowModelSourceGeneratorResponse();
            try {
                SourceGenerator sourceGenerator = new SourceGenerator(this.workspaceManager, Path.of(request.filePath(), new String[0]));
                response.setTextEdits(sourceGenerator.toSourceCode(request.flowNode(), this.lsClientLogger));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelAvailableNodesResponse> getAvailableNodes(FlowModelAvailableNodesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelAvailableNodesResponse response = new FlowModelAvailableNodesResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                AvailableNodesGenerator availableNodesGenerator = new AvailableNodesGenerator((SemanticModel)semanticModel.get(), (Document)document.get(), project.currentPackage());
                response.setCategories(availableNodesGenerator.getAvailableNodes(request.position()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelNodeTemplateResponse> getNodeTemplate(FlowModelNodeTemplateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelNodeTemplateResponse response = new FlowModelNodeTemplateResponse();
            try {
                NodeTemplateGenerator generator = new NodeTemplateGenerator(this.lsClientLogger);
                Path filePath = Path.of(request.filePath(), new String[0]);
                JsonElement nodeTemplate = generator.getNodeTemplate(this.workspaceManager, filePath, request.position(), request.id());
                response.setFlowNode(nodeTemplate);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelGeneratorResponse> getModuleNodes(FilePathRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelGeneratorResponse response = new FlowModelGeneratorResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                SemanticModel semanticModel = FileSystemUtils.getSemanticModel((WorkspaceManager)this.workspaceManager, (Path)filePath);
                ModelGenerator modelGenerator = new ModelGenerator(project, semanticModel, filePath);
                response.setFlowDesignModel(modelGenerator.getModuleNodes());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelGeneratorResponse> getServiceNodes(ServiceFieldNodesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelGeneratorResponse response = new FlowModelGeneratorResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                SemanticModel semanticModel = FileSystemUtils.getSemanticModel((WorkspaceManager)this.workspaceManager, (Path)filePath);
                ModelGenerator modelGenerator = new ModelGenerator(project, semanticModel, filePath);
                response.setFlowDesignModel(modelGenerator.getServiceFieldNodes(request.linePosition()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<CopilotContextResponse> getCopilotContext(CopilotContextRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            CopilotContextResponse response = new CopilotContextResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                CopilotContextGenerator connectorGenerator = new CopilotContextGenerator(this.workspaceManager, filePath, request.position());
                connectorGenerator.generate();
                response.setPrefix(connectorGenerator.prefix());
                response.setSuffix(connectorGenerator.suffix());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    @Deprecated
    public CompletableFuture<FlowNodeDeleteResponse> deleteFlowNode(FlowNodeDeleteRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowNodeDeleteResponse response = new FlowNodeDeleteResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                DeleteNodeHandler deleteNodeHandler = new DeleteNodeHandler(request.flowNode(), filePath);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                response.setTextEdits(deleteNodeHandler.getTextEditsToDeletedNode((Document)document.get(), project));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<ComponentDeleteResponse> deleteComponent(ComponentDeleteRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ComponentDeleteResponse response = new ComponentDeleteResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                response.setTextEdits(DeleteNodeHandler.getTextEditsToDeletedNode((JsonElement)request.component(), (Path)filePath, (Document)((Document)document.get()), (Project)project));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<OpenApiServiceGenerationResponse> generateServiceFromOpenApiContract(OpenAPIServiceGenerationRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            OpenApiServiceGenerationResponse response = new OpenApiServiceGenerationResponse();
            try {
                Path openApiContractPath = Path.of(request.openApiContractPath(), new String[0]);
                Path projectPath = Path.of(request.projectPath(), new String[0]);
                OpenApiServiceGenerator openApiServiceGenerator = new OpenApiServiceGenerator(openApiContractPath, projectPath, this.workspaceManager);
                response.setTextEdits(openApiServiceGenerator.generateService(request.name(), request.listeners()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelSourceGeneratorResponse> addErrorHandler(FilePathRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelSourceGeneratorResponse response = new FlowModelSourceGeneratorResponse();
            try {
                ErrorHandlerGenerator errorHandlerGenerator = new ErrorHandlerGenerator(this.workspaceManager, Path.of(request.filePath(), new String[0]));
                response.setTextEdits(errorHandlerGenerator.getTextEdits());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<EnclosedFuncDefResponse> getEnclosedFunctionDef(EnclosedFuncDefRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            EnclosedFuncDefResponse response = new EnclosedFuncDefResponse();
            try {
                Path path = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(path);
                Optional document = this.workspaceManager.document(path);
                if (document.isEmpty()) {
                    return response;
                }
                EnclosedNodeFinder enclosedNodeFinder = new EnclosedNodeFinder((Document)document.get(), request.position(), request.findClass());
                LineRange enclosedRange = enclosedNodeFinder.findEnclosedNode();
                response.setFilePath(project.sourceRoot().resolve(enclosedRange.fileName()).toString());
                response.setStartLine(enclosedRange.startLine());
                response.setEndLine(enclosedRange.endLine());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FunctionDefinitionResponse> functionDefinition(FunctionDefinitionRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FunctionDefinitionResponse response = new FunctionDefinitionResponse();
            try {
                Path projectPath = Path.of(request.projectPath(), new String[0]);
                Project project = this.workspaceManager.loadProject(projectPath);
                Path documentPath = project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? projectPath : projectPath.resolve(request.fileName());
                Optional optDocument = this.workspaceManager.document(documentPath);
                Optional optSemanticModel = this.workspaceManager.semanticModel(documentPath);
                if (optDocument.isEmpty() || optSemanticModel.isEmpty()) {
                    return response;
                }
                Document document = (Document)optDocument.get();
                ModuleNodeAnalyzer moduleNodeAnalyzer = new ModuleNodeAnalyzer(ModuleInfo.from((ModuleDescriptor)document.module().descriptor()), (SemanticModel)optSemanticModel.get());
                ModulePartNode rootNode = (ModulePartNode)document.syntaxTree().rootNode();
                Optional function = moduleNodeAnalyzer.findFunction(rootNode, request.functionName());
                function.ifPresent(response::setFunctionDefinition);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<FlowModelAvailableNodesResponse> search(SearchRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FlowModelAvailableNodesResponse response = new FlowModelAvailableNodesResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                SearchCommand.Kind searchKind = SearchCommand.Kind.valueOf((String)request.searchKind());
                LineRange position = request.position();
                if (request.position() != null) {
                    position = LineRange.from((String)Optional.ofNullable(filePath.getFileName()).map(Path::toString).orElse(""), (LinePosition)request.position().startLine(), (LinePosition)request.position().endLine());
                }
                Path projectPath = this.workspaceManager.projectRoot(filePath);
                Optional<Document> functionsDoc = this.getDocumentFromFile(projectPath, "functions.bal");
                SearchCommand command = SearchCommand.from((SearchCommand.Kind)searchKind, (Project)project, (LineRange)position, request.queryMap(), (Document)functionsDoc.orElse(null));
                response.setCategories(command.execute());
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    private static String getRelativePath(Path projectPath, Path filePath) {
        if (projectPath == null || filePath == null) {
            return "";
        }
        if (projectPath.equals(filePath)) {
            Path fileName = filePath.getFileName();
            return fileName != null ? fileName.toString() : "";
        }
        Path relativePath = projectPath.relativize(filePath);
        return relativePath.toString();
    }

    private Optional<Document> getDocumentFromFile(Path projectPath, String fileName) {
        try {
            return this.workspaceManager.document(projectPath.resolve(fileName));
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }
}

