/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import io.ballerina.flowmodelgenerator.core.TypesManager;
import io.ballerina.flowmodelgenerator.core.converters.XMLToRecordConverter;
import io.ballerina.flowmodelgenerator.core.utils.FileSystemUtils;
import io.ballerina.flowmodelgenerator.extension.request.XMLToRecordRequest;
import io.ballerina.flowmodelgenerator.extension.response.XMLToRecordResponse;
import io.ballerina.projects.Document;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="xmlToRecordTypes")
public class XMLToRecordConverterService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        super.init(langServer, workspaceManager);
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<XMLToRecordResponse> convert(XMLToRecordRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            XMLToRecordResponse response = new XMLToRecordResponse();
            String xmlValue = request.getXmlValue();
            boolean isRecordTypeDesc = request.getIsRecordTypeDesc();
            boolean isClosed = request.getIsClosed();
            boolean forceFormatRecordFields = request.getForceFormatRecordFields();
            String textFieldName = request.getTextFieldName();
            boolean withNameSpace = request.getIsWithNameSpace();
            boolean withoutAttributes = request.getWithoutAttributes();
            boolean withoutAttributeAnnot = request.getWithoutAttributeAnnot();
            String prefix = request.getPrefix();
            try {
                Path filePath = Path.of(request.getFilePath(), new String[0]);
                FileSystemUtils.createFileIfNotExists((WorkspaceManager)this.workspaceManager, (Path)filePath);
                Document document = FileSystemUtils.getDocument((WorkspaceManager)this.workspaceManager, (Path)filePath);
                TypesManager typesManager = new TypesManager(document);
                XMLToRecordConverter converter = new XMLToRecordConverter(document.module().project(), document, typesManager);
                response.setTypes(converter.convert(xmlValue, isRecordTypeDesc, isClosed, forceFormatRecordFields, textFieldName, withNameSpace, withoutAttributes, withoutAttributeAnnot, prefix));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    public String getName() {
        return "jsonToRecordTypes";
    }
}

