/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.schema.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.graphql.schema.diagnostic.DiagnosticMessages;
import io.ballerina.graphql.schema.exception.SchemaFileGenerationException;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.utils.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public final class Utils {
    private Utils() {
    }

    public static boolean isGraphqlService(ServiceDeclarationNode node, SemanticModel semanticModel) {
        if (semanticModel.symbol((Node)node).isEmpty()) {
            return false;
        }
        if (((Symbol)semanticModel.symbol((Node)node).get()).kind() != SymbolKind.SERVICE_DECLARATION) {
            return false;
        }
        ServiceDeclarationSymbol symbol = (ServiceDeclarationSymbol)semanticModel.symbol((Node)node).get();
        return io.ballerina.stdlib.graphql.commons.utils.Utils.hasGraphqlListener((ServiceDeclarationSymbol)symbol);
    }

    public static String getServiceBasePath(ServiceDeclarationNode serviceDefinition) {
        StringBuilder currentServiceName = new StringBuilder();
        NodeList serviceNameNodes = serviceDefinition.absoluteResourcePath();
        for (Node serviceBasedPathNode : serviceNameNodes) {
            currentServiceName.append(TypeUtils.removeEscapeCharacter((String)serviceBasedPathNode.toString()));
        }
        return Utils.formatBasePath(currentServiceName.toString().trim());
    }

    public static String getSchemaString(ServiceDeclarationNode node) throws SchemaFileGenerationException {
        if (node.metadata().isPresent() && !((MetadataNode)node.metadata().get()).annotations().isEmpty()) {
            MappingConstructorExpressionNode annotationValue = Utils.getAnnotationValue((MetadataNode)node.metadata().get());
            return Utils.getSchemaStringFieldFromValue(annotationValue);
        }
        throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_102, null, "Annotation is missing in GraphQL service");
    }

    public static String getSchemaString(ObjectConstructorExpressionNode node) throws SchemaFileGenerationException {
        if (!node.annotations().isEmpty()) {
            for (AnnotationNode annotationNode : node.annotations()) {
                if (!Utils.isGraphqlServiceConfig(annotationNode) || !annotationNode.annotValue().isPresent()) continue;
                return Utils.getSchemaStringFieldFromValue((MappingConstructorExpressionNode)annotationNode.annotValue().get());
            }
        }
        throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_102, null, "Annotation is missing in GraphQL service");
    }

    private static MappingConstructorExpressionNode getAnnotationValue(MetadataNode metadataNode) throws SchemaFileGenerationException {
        for (AnnotationNode annotationNode : metadataNode.annotations()) {
            if (!Utils.isGraphqlServiceConfig(annotationNode) || !annotationNode.annotValue().isPresent()) continue;
            return (MappingConstructorExpressionNode)annotationNode.annotValue().get();
        }
        throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_102, null, "GraphQL SchemaConfig annotation is missing");
    }

    private static String getSchemaStringFieldFromValue(MappingConstructorExpressionNode annotationValue) throws SchemaFileGenerationException {
        SeparatedNodeList existingFields = annotationValue.fields();
        for (MappingFieldNode field : existingFields) {
            if (!field.children().get(0).toString().contains("schemaString")) continue;
            String schemaString = field.children().get(2).toString();
            return schemaString.substring(1, schemaString.length() - 1);
        }
        throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_102, null, "'schemaString' field is missing in GraphQL ServiceConfig");
    }

    private static boolean isGraphqlServiceConfig(AnnotationNode annotationNode) {
        if (annotationNode.annotReference().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        QualifiedNameReferenceNode referenceNode = (QualifiedNameReferenceNode)annotationNode.annotReference();
        if (!"graphql".equals(referenceNode.modulePrefix().text())) {
            return false;
        }
        return "ServiceConfig".equals(referenceNode.identifier().text());
    }

    public static String getSdlFileName(String servicePath, String serviceName) {
        Object sdlFileName;
        if (serviceName.isBlank()) {
            sdlFileName = FilenameUtils.removeExtension((String)servicePath);
        } else if (serviceName.startsWith(".")) {
            sdlFileName = FilenameUtils.removeExtension((String)servicePath) + serviceName;
        } else {
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            sdlFileName = serviceName.replaceAll("/", "_");
        }
        sdlFileName = Utils.getNormalizedFileName((String)sdlFileName);
        return String.join((CharSequence)"", new CharSequence[]{"schema", "_", sdlFileName, ".graphql"});
    }

    public static String getNormalizedFileName(String sdlFileName) {
        String[] splitNames = sdlFileName.split("[^a-zA-Z0-9]");
        if (splitNames.length > 0) {
            return Arrays.stream(splitNames).filter(namePart -> !namePart.isBlank()).collect(Collectors.joining("_"));
        }
        return sdlFileName;
    }

    public static String formatBasePath(String basePath) {
        if (basePath.equals("/")) {
            return "";
        }
        return basePath;
    }

    public static Schema getDecodedSchema(String schemaString) throws SchemaFileGenerationException {
        if (schemaString == null || schemaString.isBlank() || schemaString.isEmpty()) {
            throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_102, null, "Invalid schema string found");
        }
        byte[] decodedString = Base64.getDecoder().decode(schemaString.getBytes(StandardCharsets.UTF_8));
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(decodedString);
            ObjectInputStream inputStream = new ObjectInputStream(byteStream);
            return (Schema)inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_102, null, "Cannot read decoded schema string");
        }
    }

    public static String resolveSchemaFileName(Path outPath, String schemaName) {
        File[] listFiles;
        if (outPath != null && Files.exists(outPath, new LinkOption[0]) && (listFiles = new File(String.valueOf(outPath)).listFiles()) != null) {
            schemaName = Utils.checkAvailabilityOfGivenName(schemaName, listFiles);
        }
        return schemaName;
    }

    private static String checkAvailabilityOfGivenName(String schemaName, File[] listFiles) {
        for (File file : listFiles) {
            String userInput;
            if (System.console() == null || !file.getName().equals(schemaName) || Objects.equals((userInput = System.console().readLine("There is already a file named '" + file.getName() + "' in the target location. Do you want to overwrite the file? [y/N] ", new Object[0])).toLowerCase(Locale.ENGLISH), "y")) continue;
            schemaName = Utils.setGeneratedFileName(listFiles, schemaName);
        }
        return schemaName;
    }

    private static String setGeneratedFileName(File[] listFiles, String fileName) {
        int duplicateCount = 0;
        for (File listFile : listFiles) {
            String listFileName = listFile.getName();
            if (!listFileName.contains(".") || listFileName.split("\\.").length < 2 || !listFileName.split("\\.")[0].equals(fileName.split("\\.")[0])) continue;
            ++duplicateCount;
        }
        return fileName.split("\\.")[0] + "." + duplicateCount + "." + fileName.split("\\.")[1];
    }

    public static void writeFile(Path filePath, String content) throws SchemaFileGenerationException {
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
        catch (IOException e) {
            throw new SchemaFileGenerationException(DiagnosticMessages.SDL_SCHEMA_103, null, e.getMessage());
        }
    }

    public static void createOutputDirectory(Path outputPath) {
        File outputDir = new File(outputPath.toString());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
    }
}

