/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ai.np.compilerplugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.projects.Document;
import java.util.Optional;

class AllowedConstructValidator
extends NodeVisitor {
    private static final String BALLERINA = "ballerina";
    private static final String BALLERINAX = "ballerinax";
    private SemanticModel semanticModel;
    private Optional<Document> document;
    private final JsonArray diagnostics = new JsonArray();
    private final String packageOrgName;

    public AllowedConstructValidator(SemanticModel semanticModel, Optional<Document> document, String packageOrgName) {
        this.semanticModel = semanticModel;
        this.document = document;
        this.packageOrgName = packageOrgName;
    }

    protected JsonArray checkCodeGenerationDiagnostics(ModulePartNode modulePartNode) {
        this.visit(modulePartNode);
        return this.diagnostics;
    }

    public void visit(ModulePartNode modulePartNode) {
        super.visitSyntaxNode((Node)modulePartNode);
    }

    public void visit(ImportDeclarationNode importDeclarationNode) {
        importDeclarationNode.orgName().ifPresent(importOrgNameNode -> {
            String orgName = importOrgNameNode.orgName().text();
            if (this.packageOrgName.equals(orgName)) {
                return;
            }
            if (!orgName.startsWith(BALLERINA) && !orgName.startsWith(BALLERINAX)) {
                this.diagnostics.add((JsonElement)this.addExternalImportDiagnostic(importDeclarationNode));
            }
        });
    }

    public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
        this.semanticModel.symbol(this.document.get(), simpleNameReferenceNode.location().lineRange().startLine()).ifPresent(symbol -> this.addDiagnosticsForVariableReference((Symbol)symbol, (Node)simpleNameReferenceNode.name()));
    }

    public void visit(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        this.semanticModel.symbol(this.document.get(), qualifiedNameReferenceNode.identifier().location().lineRange().startLine()).ifPresent(symbol -> this.addDiagnosticsForVariableReference((Symbol)symbol, (Node)qualifiedNameReferenceNode));
    }

    private boolean isConfigVariable(Symbol symbol) {
        VariableSymbol variableSymbol;
        return symbol instanceof VariableSymbol && (variableSymbol = (VariableSymbol)symbol).qualifiers().stream().anyMatch(qualifier -> qualifier == Qualifier.CONFIGURABLE);
    }

    private void addModuleVariableReferencesDiagnostics(Node node) {
        JsonObject diagnostic = new JsonObject();
        NodeLocation location = node.location();
        diagnostic.addProperty("message", this.constructDiagnosticMessage("ERROR [%s:(%s:%s,%s:%s)] Module level variables cannot be used inside the generated code. (found: '%s')", node.toSourceCode(), node.location()));
        this.diagnostics.add((JsonElement)diagnostic);
    }

    private void addConfigVariableReferencesDiagnostics(Node node) {
        JsonObject diagnostic = new JsonObject();
        diagnostic.addProperty("message", this.constructDiagnosticMessage("ERROR [%s:(%s:%s,%s:%s)] Configurable variables cannot be accessed in generated code, found: '%s'", node.toSourceCode(), node.location()));
        this.diagnostics.add((JsonElement)diagnostic);
    }

    private String constructDiagnosticMessage(String message, String sourceCode, NodeLocation location) {
        return String.format(message, this.document.get().name(), location.lineRange().startLine().line(), location.lineRange().startLine().offset(), location.lineRange().endLine().line(), location.lineRange().endLine().offset(), sourceCode);
    }

    private JsonObject addExternalImportDiagnostic(ImportDeclarationNode importNode) {
        JsonObject diagnostic = new JsonObject();
        NodeLocation location = importNode.location();
        diagnostic.addProperty("message", String.format("ERROR [%s:(%s:%s,%s:%s)] Disallowed import detected: '%s', only imports from 'ballerina', 'ballerinax', and the user's organization are allowed.", this.document.get().name(), location.lineRange().startLine().line(), location.lineRange().startLine().offset(), location.lineRange().endLine().line(), location.lineRange().endLine().offset(), importNode.toSourceCode()));
        return diagnostic;
    }

    private boolean isModuleLevelSymbol(Symbol symbol) {
        return this.semanticModel.moduleSymbols().contains(symbol);
    }

    private void addDiagnosticsForVariableReference(Symbol symbol, Node node) {
        if (!(symbol instanceof VariableSymbol)) {
            return;
        }
        VariableSymbol variableSymbol = (VariableSymbol)symbol;
        if (this.isConfigVariable((Symbol)variableSymbol)) {
            this.addConfigVariableReferencesDiagnostics(node);
            return;
        }
        if (this.isModuleLevelSymbol(symbol)) {
            this.addModuleVariableReferencesDiagnostics(node);
        }
    }
}

