/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ai.np.compilerplugin;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;

class Commons {
    static final String BALLERINA_ORG_NAME = "ballerina";
    static final String AI_MODULE_NAME = "ai";
    static final String CODE_ANNOTATION = "code";
    static final String BAL_EXT = ".bal";
    static final String FILE_PATH = "filePath";
    static final String CONTENT = "content";

    private Commons() {
    }

    static boolean isCodeAnnotation(AnnotationNode annotationNode, SemanticModel semanticModel) {
        QualifiedNameReferenceNode qualifiedNameReferenceNode;
        Node node = annotationNode.annotReference();
        if (!(node instanceof QualifiedNameReferenceNode) || !CODE_ANNOTATION.equals((qualifiedNameReferenceNode = (QualifiedNameReferenceNode)node).identifier().text())) {
            return false;
        }
        return Commons.isLangNaturalModule((ModuleSymbol)((Symbol)semanticModel.symbol(node).get()).getModule().get());
    }

    static boolean isLangNaturalModule(ModuleSymbol moduleSymbol) {
        ModuleID moduleId = moduleSymbol.id();
        return BALLERINA_ORG_NAME.equals(moduleId.orgName()) && "lang.natural".equals(moduleId.moduleName());
    }
}

