/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ai.np.compilerplugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ByteArrayLiteralNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryActionNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionalExpressionNode;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.HashSet;

class ConstantExpressionValidator
extends NodeVisitor {
    private final JsonArray constantExpressionDiagnostics = new JsonArray();
    private final Document document;

    public ConstantExpressionValidator(Document document) {
        this.document = document;
    }

    protected JsonArray checkNonConstExpressions(Node node) {
        this.visitSyntaxNode(node);
        return this.filterUniqueMessages(this.constantExpressionDiagnostics);
    }

    private void addConstantReferencesDiagnostics(Node node) {
        JsonObject diagnostic = new JsonObject();
        diagnostic.addProperty("message", this.constructDiagnosticMessage(node));
        this.constantExpressionDiagnostics.add((JsonElement)diagnostic);
    }

    public void visit(AnnotAccessExpressionNode annotAccessExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)annotAccessExpressionNode);
    }

    public void visit(BasicLiteralNode basicLiteralNode) {
    }

    public void visit(BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode) {
    }

    public void visit(BinaryExpressionNode binaryExpressionNode) {
        this.visitSyntaxNode(binaryExpressionNode.lhsExpr());
        this.visitSyntaxNode(binaryExpressionNode.rhsExpr());
    }

    public void visit(BracedExpressionNode bracedExpressionNode) {
        this.visitSyntaxNode((Node)bracedExpressionNode.expression());
    }

    public void visit(ByteArrayLiteralNode byteArrayLiteralNode) {
        byteArrayLiteralNode.content().ifPresent(content -> this.visit((Token)content));
    }

    public void visit(CheckExpressionNode checkExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)checkExpressionNode);
    }

    public void visit(ConditionalExpressionNode conditionalExpressionNode) {
        this.visitSyntaxNode((Node)conditionalExpressionNode.lhsExpression());
        this.visitSyntaxNode((Node)conditionalExpressionNode.middleExpression());
        this.visitSyntaxNode((Node)conditionalExpressionNode.endExpression());
    }

    public void visit(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)errorConstructorExpressionNode);
    }

    public void visit(ExplicitAnonymousFunctionExpressionNode explicitAnonymousFunctionExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)explicitAnonymousFunctionExpressionNode);
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)explicitNewExpressionNode);
    }

    public void visit(FieldAccessExpressionNode fieldAccessExpressionNode) {
        this.visitSyntaxNode((Node)fieldAccessExpressionNode.expression());
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)functionCallExpressionNode);
    }

    public void visit(ImplicitAnonymousFunctionExpressionNode implicitAnonymousFunctionExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)implicitAnonymousFunctionExpressionNode);
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)implicitNewExpressionNode);
    }

    public void visit(IndexedExpressionNode indexedExpressionNode) {
        this.visitSyntaxNode((Node)indexedExpressionNode.containerExpression());
        indexedExpressionNode.keyExpression().forEach(node -> this.visitSyntaxNode((Node)node));
    }

    public void visit(LetExpressionNode letExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)letExpressionNode);
    }

    public void visit(ListConstructorExpressionNode listConstructorExpressionNode) {
        listConstructorExpressionNode.expressions().forEach(exp -> this.visitSyntaxNode((Node)exp));
    }

    public void visit(MappingConstructorExpressionNode mappingConstructorExpressionNode) {
        mappingConstructorExpressionNode.fields().forEach(field -> this.visitSyntaxNode((Node)field));
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        this.visitSyntaxNode((Node)methodCallExpressionNode.expression());
        methodCallExpressionNode.arguments().forEach(arg -> this.visitSyntaxNode((Node)arg));
    }

    public void visit(SimpleNameReferenceNode nameReferenceNode) {
        this.addConstantReferencesDiagnostics((Node)nameReferenceNode);
    }

    public void visit(QualifiedNameReferenceNode nameReferenceNode) {
        this.addConstantReferencesDiagnostics((Node)nameReferenceNode);
    }

    public void visit(NaturalExpressionNode naturalExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)naturalExpressionNode);
    }

    public void visit(NilLiteralNode nilLiteralNode) {
    }

    public void visit(ObjectConstructorExpressionNode objectConstructorExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)objectConstructorExpressionNode);
    }

    public void visit(OptionalFieldAccessExpressionNode optionalFieldAccessExpressionNode) {
        this.visitSyntaxNode((Node)optionalFieldAccessExpressionNode.expression());
        this.visitSyntaxNode((Node)optionalFieldAccessExpressionNode.fieldName());
    }

    public void visit(QueryExpressionNode queryExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)queryExpressionNode);
    }

    public void visit(QueryActionNode queryActionNode) {
        this.addConstantReferencesDiagnostics((Node)queryActionNode);
    }

    public void visit(TableConstructorExpressionNode tableConstructorExpressionNode) {
        tableConstructorExpressionNode.keySpecifier().ifPresent(node -> this.visitSyntaxNode((Node)node));
        tableConstructorExpressionNode.rows().forEach(row -> this.visitSyntaxNode((Node)row));
    }

    public void visit(TemplateExpressionNode templateExpressionNode) {
        templateExpressionNode.content().forEach(node -> {
            if (node instanceof InterpolationNode) {
                InterpolationNode interpolationNode = (InterpolationNode)node;
                this.visitSyntaxNode((Node)interpolationNode.expression());
            }
        });
    }

    public void visit(TransactionalExpressionNode transactionalExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)transactionalExpressionNode);
    }

    public void visit(TrapExpressionNode trapExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)trapExpressionNode);
    }

    public void visit(TypeCastExpressionNode typeCastExpressionNode) {
        this.visitSyntaxNode((Node)typeCastExpressionNode.expression());
    }

    public void visit(TypeofExpressionNode typeofExpressionNode) {
        this.visitSyntaxNode((Node)typeofExpressionNode.expression());
    }

    public void visit(TypeTestExpressionNode typeTestExpressionNode) {
        this.visitSyntaxNode((Node)typeTestExpressionNode.expression());
    }

    public void visit(UnaryExpressionNode unaryExpressionNode) {
        this.visitSyntaxNode((Node)unaryExpressionNode.expression());
    }

    public void visit(XMLFilterExpressionNode xmlFilterExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)xmlFilterExpressionNode);
    }

    public void visit(XMLStepExpressionNode xmlStepExpressionNode) {
        this.addConstantReferencesDiagnostics((Node)xmlStepExpressionNode);
    }

    public void visit(ExpressionNode expressionNode) {
        super.visitSyntaxNode((Node)expressionNode);
    }

    public void visitSyntaxNode(Node node) {
        if (node instanceof ExpressionNode) {
            node.accept((NodeVisitor)this);
            return;
        }
        super.visitSyntaxNode(node);
    }

    private JsonArray filterUniqueMessages(JsonArray originalArray) {
        if (originalArray.isEmpty()) {
            return originalArray;
        }
        HashSet<String> seenMessages = new HashSet<String>();
        JsonArray uniqueArray = new JsonArray();
        for (JsonElement elem : originalArray) {
            JsonObject obj = elem.getAsJsonObject();
            String message = obj.getAsJsonPrimitive("message").getAsString();
            if (!seenMessages.add(message)) continue;
            uniqueArray.add((JsonElement)obj);
        }
        return uniqueArray;
    }

    private String constructDiagnosticMessage(Node node) {
        LineRange lineRange = node.location().lineRange();
        LinePosition startLine = lineRange.startLine();
        LinePosition endLine = lineRange.endLine();
        return String.format("ERROR [%s:(%s:%s,%s:%s)] Generated code should only contain constant expressions, found: '%s'", this.document.name(), startLine.line(), startLine.offset(), endLine.line(), endLine.offset(), node.toSourceCode());
    }
}

