/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ai.np.compilerplugin;

import io.ballerina.lib.ai.np.compilerplugin.CodeModifier;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;

class DiagnosticLog {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("diagnostics", Locale.getDefault());
    private static final String ERROR_PREFIX = "error";

    DiagnosticLog() {
    }

    static void reportError(SyntaxNodeAnalysisContext ctx, CodeModifier.AnalysisData analysisData, Location location, DiagnosticCode diagnosticsCode, Object ... args) {
        String errorMessage = MESSAGES.getString("error." + diagnosticsCode.getMessage());
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticsCode.getCode(), errorMessage, DiagnosticSeverity.ERROR);
        analysisData.analysisTaskErrored = true;
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, Collections.emptyList(), (Object[])args));
    }

    static enum DiagnosticCode {
        CODE_GEN_WITH_CODE_ANNOT_NOT_SUPPORTED_IN_SINGLE_BAL_FILE_MODE("NP_ERROR_003", "code.gen.with.code.annot.not.supported.in.single.bal.file.mode"),
        NON_JSON_EXPECTED_TYPE_NOT_YET_SUPPORTED("NP_ERROR_023", "non.json.expected.type.not.yet.supported");

        private final String code;
        private final String message;

        private DiagnosticCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

